package com.chenyang.nse.bussiness.service.info.impl;

import com.chenyang.nse.bussiness.dao.core.EngineDao;
import com.chenyang.nse.bussiness.dao.table.core.TCoreDatasystemDao;
import com.chenyang.nse.bussiness.dao.table.core.TCoreDatasystemengineDao;
import com.chenyang.nse.bussiness.dao.table.core.TCoreEngineDao;
import com.chenyang.nse.bussiness.dao.table.core.masking.TCoreMaskingRuleinfoDao;
import com.chenyang.nse.bussiness.dao.table.core.maskingself.TCoreMaskingselfFileDao;
import com.chenyang.nse.bussiness.dao.table.core.maskingself.TCoreMaskingselfFilecolumnDao;
import com.chenyang.nse.bussiness.dao.table.core.maskingself.TCoreMaskingselfTableDao;
import com.chenyang.nse.bussiness.dao.table.core.maskingself.TCoreMaskingselfTablecolumnDao;
import com.chenyang.nse.bussiness.dao.table.core.maskingself.TCoreMaskingselfTaskDao;
import com.chenyang.nse.bussiness.dao.table.core.temporary.TCoreMonitorTemporaryDao;
import com.chenyang.nse.bussiness.engine.infa.InfoProperty;
import com.chenyang.nse.bussiness.engine.infa.basic.xmlbean.FOLDER;
import com.chenyang.nse.bussiness.engine.infa.basic.xmlbean.POWERMART;
import com.chenyang.nse.bussiness.engine.infa.basic.xmlbean.REPOSITORY;
import com.chenyang.nse.bussiness.engine.infa.powercenter961.isomerdata.MakeIsomerUtil;
import com.chenyang.nse.bussiness.engine.infa.powercenter961.maskdata.ParamBean;
import com.chenyang.nse.bussiness.engine.infa.powercenter961.pubbean.CommonBean;
import com.chenyang.nse.bussiness.engine.infa.powercenter961.pubbean.FlatFileBean;
import com.chenyang.nse.bussiness.engine.infa.powercenter961.pubbean.MappingPramaBean;
import com.chenyang.nse.bussiness.engine.infa.powercenter961.pubbean.MappletMakeDatabean;
import com.chenyang.nse.bussiness.engine.infa.powercenter961.pubbean.ModifyImportFile;
import com.chenyang.nse.bussiness.engine.infa.powercenter961.pubbean.SourceBean;
import com.chenyang.nse.bussiness.engine.infa.powercenter961.pubbean.TargetBean;
import com.chenyang.nse.bussiness.engine.infa.powercenter961.pubtool.InfoExecUtil;
import com.chenyang.nse.bussiness.engine.infa.powercenter961.pubtool.ToObjutil;
import com.chenyang.nse.bussiness.entity.info.CreateSelfUpdateXmlData;
import com.chenyang.nse.bussiness.entity.info.CreateSelfXmlData;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreDatasystem;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreDatasystemengine;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreEngine;
import com.chenyang.nse.bussiness.entity.orm.table.core.masking.TCoreMaskingRuleinfo;
import com.chenyang.nse.bussiness.entity.orm.table.core.maskingself.TCoreMaskingselfFile;
import com.chenyang.nse.bussiness.entity.orm.table.core.maskingself.TCoreMaskingselfFilecolumn;
import com.chenyang.nse.bussiness.entity.orm.table.core.maskingself.TCoreMaskingselfTable;
import com.chenyang.nse.bussiness.entity.orm.table.core.maskingself.TCoreMaskingselfTablecolumn;
import com.chenyang.nse.bussiness.entity.orm.table.core.maskingself.TCoreMaskingselfTask;
import com.chenyang.nse.bussiness.entity.orm.table.core.temporary.TCoreMonitorTemporary;
import com.chenyang.nse.bussiness.service.info.InfoSelfService;
import com.chenyang.nse.bussiness.service.info.tool.InfoSelfTool;
import com.chenyang.nse.bussiness.tools.io.FileTool;
import com.chenyang.nse.bussiness.tools.object.ObjectTool;
import com.chenyang.nse.bussiness.tools.string.AesTool;
import com.chenyang.nse.bussiness.tools.string.StringTool;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@EnableAsync
@Service
@Transactional
public class InfoSelfServiceImpl implements InfoSelfService {
   @Autowired
   private TCoreMaskingselfTaskDao tCoreMaskingselfTaskDao;
   @Autowired
   private TCoreMaskingselfTableDao tCoreMaskingselfTableDao;
   @Autowired
   private TCoreMaskingselfTablecolumnDao tCoreMaskingselfTablecolumnDao;
   @Autowired
   private TCoreDatasystemDao tCoreDatasystemDao;
   @Autowired
   private TCoreEngineDao tCoreEngineDao;
   @Autowired
   private EngineDao engineDao;
   @Autowired
   private TCoreMaskingselfFileDao tCoreMaskingselfFileDao;
   @Autowired
   private TCoreMaskingselfFilecolumnDao tCoreMaskingselfFilecolumnDao;
   @Autowired
   private TCoreDatasystemengineDao tCoreDatasystemengineDao;
   @Autowired
   private TCoreMaskingRuleinfoDao tCoreMaskingRuleinfoDao;
   @Autowired
   private InfoSelfTool infoselfTool;
   @Autowired
   private ToObjutil toObj;
   @Autowired
   private TCoreMonitorTemporaryDao tCoreMonitorTemporaryDao;

   public void generateTask(TCoreMaskingselfTask task, String userid) throws Exception {
      List<TCoreMaskingselfTable> tlist = this.tCoreMaskingselfTableDao.queryAll(new Criterion[]{Restrictions.eq("taskid", task.getId()), Restrictions.eq("datadirection", "0")});
      if (task.getInserttype().equals("0")) {
         for(TCoreMaskingselfTable tCoreMaskingTable : tlist) {
            CreateSelfXmlData csxd = this.getXmlData(task, tCoreMaskingTable.getMappingkey(), userid);
            MakeIsomerUtil.isomerMasking(csxd.getParamBean(), csxd.getInfoProperty(), csxd.getSourceBean(), csxd.getTargetBean(), csxd.getMapplet(), csxd.getParamList(), "false", "self");
            boolean bool = this.importMapping(task.getId(), csxd.getSourceBean().getSo_name());
            if (!bool) {
               throw new Exception();
            }
         }
      } else {
         for(TCoreMaskingselfTable tCoreMaskingTable : tlist) {
            CreateSelfUpdateXmlData csuxd = this.getUpdateXml(task, tCoreMaskingTable.getMappingkey(), userid);
            MakeIsomerUtil.isomerMasking(csuxd.getParamBean(), csuxd.getInfoProperty(), csuxd.getSourceBean(), csuxd.getTargetBean(), csuxd.getMapplet(), csuxd.getParamList(), "false", "self");
            boolean bool = this.importMapping(task.getId(), csuxd.getSourceBean().getSo_name());
            if (!bool) {
               throw new Exception();
            }
         }
      }

   }

   private CreateSelfXmlData getXmlData(TCoreMaskingselfTask task, String mappingkey, String userid) {
      TCoreEngine tengine = (TCoreEngine)this.tCoreEngineDao.get(task.getEngineid());
      Map<String, Object> map = this.engineDao.queryEnginePropertyKeyValue(tengine.getId());
      InfoProperty info = (InfoProperty)ObjectTool.getObjectByMap(InfoProperty.class, map);
      TCoreMaskingselfTable tentity = (TCoreMaskingselfTable)this.tCoreMaskingselfTableDao.queryUnique(new Criterion[]{Restrictions.eq("taskid", task.getId()), Restrictions.eq("mappingkey", mappingkey), Restrictions.eq("datadirection", "0")});
      TCoreMaskingselfFile tfile = (TCoreMaskingselfFile)this.tCoreMaskingselfFileDao.queryUnique(new Criterion[]{Restrictions.eq("taskid", task.getId()), Restrictions.eq("mappingkey", mappingkey)});
      ParamBean par_bean = new ParamBean();
      new SourceBean();
      TargetBean tar_bean = new TargetBean();
      List<MappletMakeDatabean> mapplet = new ArrayList();
      List<MappingPramaBean> paramList = null;
      TCoreDatasystem datasource = (TCoreDatasystem)this.tCoreDatasystemDao.get(tentity.getDatasystemid());
      TCoreDatasystem datasystem = (TCoreDatasystem)this.tCoreDatasystemDao.get(tentity.getDatasystemid());
      SourceBean sou_bean = new SourceBean();
      sou_bean.setSo_name(tentity.getTablename());
      sou_bean.setSo_ownname("");
      sou_bean.setBusinessname("");
      sou_bean.setFiledirect("Direct");
      sou_bean.setDatabasetype(datasource.getDbtype());
      sou_bean.setConnectmode(datasource.getConnectmode());
      this.getDatasystemEngine(datasource.getId(), task.getEngineid());
      if ("MYSQL".equals(datasource.getDbtype())) {
         sou_bean.setLinkname(datasource.getDblinkname());
         sou_bean.setDbdname(datasource.getDblinkname());
      } else if ("MSSQLSERVER".equals(datasource.getDbtype())) {
         sou_bean.setLinkname(datasource.getDblinkname());
         sou_bean.setDbdname(datasource.getDblinkname());
      } else if ("INFORMIX".equals(datasource.getDbtype())) {
         sou_bean.setLinkname(datasource.getDblinkname());
         sou_bean.setDbdname(datasource.getDblinkname());
      } else if ("SYBASE".equals(datasource.getDbtype())) {
         sou_bean.setLinkname(datasource.getDblinkname());
         sou_bean.setDbdname(datasource.getDblinkname());
      } else if (datasource.getConnectmode().equals("0")) {
         sou_bean.setLinkname(datasource.getDblinkname());
         sou_bean.setDbdname(datasource.getDblinkname());
      } else {
         sou_bean.setLinkname(datasource.getDblinkname());
         sou_bean.setDbdname(datasource.getDblinkname());
      }

      sou_bean.setVersionnumber("1");
      sou_bean.setObjectversion("1");
      sou_bean.setDescripion("");
      sou_bean.setSourceownername(tentity.getDbschema());
      tar_bean.setTar_name("f_" + tentity.getTablename());
      tar_bean.setBusinessname("");
      tar_bean.setConstraint("");
      tar_bean.setDatabasetype("Flat File");
      tar_bean.setVersionnumber("1");
      tar_bean.setObjectversion("1");
      tar_bean.setDescripion("");
      tar_bean.setFileparam("1");
      FlatFileBean flatfile = new FlatFileBean();
      if ("utf-8".equalsIgnoreCase(datasystem.getPagecode())) {
         flatfile.setCodepage("UTF-8");
      } else if ("GBK".equalsIgnoreCase(datasystem.getPagecode())) {
         flatfile.setCodepage("ms936");
      }

      flatfile.setSkiprows("0");
      flatfile.setDelimited("YES");
      flatfile.setDelimiters("||");
      flatfile.setMultidelimitersasand("YES");
      flatfile.setQuote_character("DOUBLE");
      flatfile.setRowdelimiter("0");
      flatfile.setEscape_character("");
      flatfile.setKeepescapechar("NO");
      tar_bean.setFilebean(flatfile);
      List<TCoreMaskingselfFilecolumn> filecolumnlist = this.tCoreMaskingselfFilecolumnDao.queryAll(Order.asc("columnindex"), new Criterion[]{Restrictions.eq("fileid", tfile.getId())});
      CommonBean cb = new CommonBean();
      List<String> keytype = new ArrayList();
      List<String> nameList = new ArrayList();
      List<String> typeList = new ArrayList();
      List<String> lengthList = new ArrayList();
      List<String> precisionList = new ArrayList();
      List<String> scalelist = new ArrayList();
      CommonBean tcb = new CommonBean();
      List<String> tkeytype = new ArrayList();
      List<String> tnameList = new ArrayList();
      List<String> ttypeList = new ArrayList();
      List<String> tlengthList = new ArrayList();
      List<String> tprecisionList = new ArrayList();
      List<String> tscalelist = new ArrayList();
      List<String> formatlist = new ArrayList();

      for(TCoreMaskingselfFilecolumn ckj : filecolumnlist) {
         tnameList.add(ckj.getColumnname());
         ttypeList.add(ckj.getColumntype());
         tlengthList.add(ckj.getColumnaccuracy());
         tscalelist.add(ckj.getColumndecimal());
         tprecisionList.add(ckj.getColumnaccuracy());
         if (ckj.getKeytype().equals("YES")) {
            tkeytype.add("PRIMARY KEY");
         } else {
            tkeytype.add("NOT A KEY");
         }

         if ("datetime".equalsIgnoreCase(ckj.getColumnname())) {
            formatlist.add("F  29 YYYY-MM-DD");
         } else {
            formatlist.add("");
         }

         tcb.setKeytype(tkeytype);
         tcb.setLengthList(tlengthList);
         tcb.setNameList(tnameList);
         tcb.setPrecisionList(tprecisionList);
         tcb.setScalelist(tscalelist);
         tcb.setTypeList(ttypeList);
         tcb.setDateformatlist(formatlist);
         tar_bean.setCb(tcb);
         TCoreMaskingselfTablecolumn tablecolumn = (TCoreMaskingselfTablecolumn)this.tCoreMaskingselfTablecolumnDao.queryUnique(new Criterion[]{Restrictions.eq("mappingkey", ckj.getMappingkey()), Restrictions.eq("datadirection", "0"), Restrictions.eq("taskid", task.getId())});
         if ("NUMBER".equalsIgnoreCase(tablecolumn.getColumntype()) && !"-127".equals(tablecolumn.getColumnscale())) {
            typeList.add("number(p,s)");
         } else {
            typeList.add(tablecolumn.getColumntype());
         }

         nameList.add(tablecolumn.getColumnname());
         lengthList.add(tablecolumn.getColumnlength());
         scalelist.add(tablecolumn.getColumnscale());
         precisionList.add(tablecolumn.getColumnlength());
         if ("1".equals(tablecolumn.getPrimarykey())) {
            keytype.add("PRIMARY KEY");
         } else {
            keytype.add("NOT A KEY");
         }

         cb.setKeytype(keytype);
         cb.setLengthList(lengthList);
         cb.setNameList(nameList);
         cb.setPrecisionList(precisionList);
         cb.setScalelist(scalelist);
         cb.setTypeList(typeList);
         if (StringUtils.isNotBlank(tablecolumn.getRuleid())) {
            TCoreMaskingRuleinfo rule = (TCoreMaskingRuleinfo)this.tCoreMaskingRuleinfoDao.queryUnique(new Criterion[]{Restrictions.eq("ruleid", tablecolumn.getRuleid())});
            if (rule != null) {
               mapplet.add(new MappletMakeDatabean(tablecolumn.getColumnname(), rule.getMappletname(), ckj.getColumnname()));
            }
         }

         sou_bean.setCb(cb);
      }

      par_bean.setTaskname(task.getTaskname());
      par_bean.setFoldername(task.getFdname());
      par_bean.setOwner("");
      par_bean.setGroup("");
      par_bean.setParam_path("");
      par_bean.setPower_repository_version("184.93");
      par_bean.setCodepage("UTF-8");
      par_bean.setRepository_version("184");
      FileTool.createFolder(info.getXmldir() + File.separator + "tempfile");
      FileTool.createFile(info.getXmldir() + File.separator + "tempfile" + File.separator + "f_" + tentity.getTablename() + ".txt");
      tar_bean.setFilename("f_" + tentity.getTablename() + ".txt");
      tar_bean.setFilepath(info.getXmldir() + File.separator + "tempfile" + File.separator);
      tar_bean.setInserttype("insert");
      tar_bean.setTranctype("YES");
      TCoreDatasystem repdata = (TCoreDatasystem)this.tCoreDatasystemDao.get(info.getDatasystemid());
      if ("ORACLE".equals(repdata.getDbtype())) {
         par_bean.setRepository_dbtype("Oracle");
      } else if ("DB2".equals(repdata.getDbtype())) {
         par_bean.setRepository_dbtype("Db2");
      }

      par_bean.setShard("NOTSHARED");
      CreateSelfXmlData csxd = new CreateSelfXmlData();
      csxd.setParamBean(par_bean);
      csxd.setInfoProperty(info);
      csxd.setSourceBean(sou_bean);
      csxd.setTargetBean(tar_bean);
      csxd.setMapplet(mapplet);
      csxd.setParamList(paramList);
      csxd.setMaskingSelfFile(tfile);
      return csxd;
   }

   public boolean importMapping(String taskid, String filename) {
      TCoreMaskingselfTask task = (TCoreMaskingselfTask)this.tCoreMaskingselfTaskDao.get(taskid);
      TCoreEngine tengine = (TCoreEngine)this.tCoreEngineDao.get(task.getEngineid());
      Map<String, Object> map = this.engineDao.queryEnginePropertyKeyValue(tengine.getId());
      InfoProperty engine = (InfoProperty)ObjectTool.getObjectByMap(InfoProperty.class, map);
      String con_file = InfoServiceImpl.class.getResource("/").getPath().replaceAll("%20", " ") + "infofile" + File.separator + "con_import.xml";
      File file = new File(con_file);
      ModifyImportFile mi = new ModifyImportFile();

      try {
         String path = engine.getXmldir() + File.separator + "masking_self" + File.separator + task.getTaskname() + File.separator + filename + ".xml";
         List<String> filelist = FileTool.getPathFile(path);
         InputStream is = new FileInputStream(path);
         BufferedReader tBufferedReader = new BufferedReader(new InputStreamReader(is));
         int k = 0;
         StringBuffer tStringBuffer = new StringBuffer();
         new String("");

         String sTempOneLine;
         while((sTempOneLine = tBufferedReader.readLine()) != null) {
            ++k;
            if (k == 2) {
               tStringBuffer.append("");
            } else {
               tStringBuffer.append(sTempOneLine);
            }
         }

         ToObjutil var10000 = this.toObj;
         Object obj = ToObjutil.unmarshalmo("com.chenyang.nse.bussiness.engine.infa.basic.xmlbean", tStringBuffer.toString());
         POWERMART powermart = (POWERMART)obj;
         REPOSITORY pre = (REPOSITORY)powermart.getREPOSITORY().get(0);
         FOLDER folder = (FOLDER)pre.getFOLDER().get(0);
         ModifyImportFile.updateConfigFileXML("TARGETFOLDERNAME", file, task.getFdname());
         ModifyImportFile.updateConfigFileXML("SOURCEFOLDERNAME", file, folder.getNAME());
         ModifyImportFile.updateConfigFileXML("TARGETREPOSITORYNAME", file, engine.getRepository());
         ModifyImportFile.updateConfigFileXML("SOURCEREPOSITORYNAME", file, pre.getNAME());
         System.out.println("++++++++start+++++++++++");
         InfoExecUtil.executImport(engine.getPmrepexepath(), path, file.toString(), engine.getXmldir() + File.separator + "log_file" + File.separator + "log.txt");
         System.out.println("++++++++end+++++++++++");
      } catch (Exception e) {
         e.printStackTrace();
         return false;
      }

      return Boolean.TRUE;
   }

   public TCoreDatasystemengine getDatasystemEngine(String datasystemid, String engineid) {
      TCoreEngine tengine = (TCoreEngine)this.tCoreEngineDao.get(engineid);
      Map<String, Object> map = this.engineDao.queryEnginePropertyKeyValue(tengine.getId());
      InfoProperty engine = (InfoProperty)ObjectTool.getObjectByMap(InfoProperty.class, map);
      List<TCoreDatasystemengine> list = this.tCoreDatasystemengineDao.queryAll(new Criterion[]{Restrictions.eq("datasystemid", datasystemid), Restrictions.eq("engineid", engineid)});
      if (list != null && list.size() > 0) {
         return (TCoreDatasystemengine)list.get(0);
      } else {
         TCoreDatasystem datasystem = (TCoreDatasystem)this.tCoreDatasystemDao.get(datasystemid);
         TCoreDatasystemengine datasystemEngine = new TCoreDatasystemengine();
         datasystemEngine.setDatasystemid(datasystemid);
         datasystemEngine.setEngineid(engineid);
         datasystemEngine.setId(StringTool.getTablePrimaryKey());
         datasystemEngine.setDblinkname(datasystem.getSysname());
         this.tCoreDatasystemengineDao.save(datasystemEngine);
         datasystemEngine = (TCoreDatasystemengine)this.tCoreDatasystemengineDao.get(datasystemEngine.getId());

         try {
            if ("UTF-8".equals(datasystem.getPagecode())) {
               if (datasystem.getConnectmode().equals("0")) {
                  InfoExecUtil.createDb(engine.getPmrepexepath(), datasystem.getDbtype(), datasystem.getUsername(), "1".equals(datasystem.getFlag()) ? AesTool.decrypt(datasystem.getPassword(), "ghca") : datasystem.getPassword(), datasystem.getDblinkname(), datasystem.getDblinkname(), "UTF-8");
               } else {
                  InfoExecUtil.createDb(engine.getPmrepexepath(), "ODBC", datasystem.getUsername(), "1".equals(datasystem.getFlag()) ? AesTool.decrypt(datasystem.getPassword(), "ghca") : datasystem.getPassword(), datasystem.getDblinkname(), datasystem.getDblinkname(), "UTF-8");
               }
            } else if (datasystem.getConnectmode().equals("0")) {
               InfoExecUtil.createDb(engine.getPmrepexepath(), datasystem.getDbtype(), datasystem.getUsername(), "1".equals(datasystem.getFlag()) ? AesTool.decrypt(datasystem.getPassword(), "ghca") : datasystem.getPassword(), datasystem.getDblinkname(), datasystem.getDblinkname(), "MS936");
            } else {
               InfoExecUtil.createDb(engine.getPmrepexepath(), "ODBC", datasystem.getUsername(), "1".equals(datasystem.getFlag()) ? AesTool.decrypt(datasystem.getPassword(), "ghca") : datasystem.getPassword(), datasystem.getDblinkname(), datasystem.getDblinkname(), "MS936");
            }
         } catch (Exception e) {
            e.printStackTrace();
         }

         return datasystemEngine;
      }
   }

   public boolean executeTask(String taskid, String userid) {
      TCoreMaskingselfTask task = (TCoreMaskingselfTask)this.tCoreMaskingselfTaskDao.get(taskid);
      if (task == null) {
         return false;
      } else {
         List<TCoreMaskingselfTable> tlist = this.tCoreMaskingselfTableDao.queryAll(new Criterion[]{Restrictions.eq("taskid", task.getId()), Restrictions.eq("datadirection", "0")});
         if (task.getInserttype().equals("0")) {
            for(TCoreMaskingselfTable tCoreMaskingTable : tlist) {
               CreateSelfXmlData csxd = this.getXmlData(task, tCoreMaskingTable.getMappingkey(), userid);
               this.infoselfTool.execInsertTaskBtoF(task, csxd.getSourceBean().getSo_name(), csxd.getMaskingSelfFile().getId(), userid);

               try {
                  Thread.sleep(1000L);
               } catch (InterruptedException e) {
                  e.printStackTrace();
               }
            }
         } else {
            for(TCoreMaskingselfTable tCoreMaskingTable : tlist) {
               CreateSelfUpdateXmlData csuxd = this.getUpdateXml(task, tCoreMaskingTable.getMappingkey(), userid);
               String name = csuxd.getSourceBean().getSo_name();
               this.infoselfTool.executeTaskMasking(task, name, userid);
               TCoreMonitorTemporary temporay = new TCoreMonitorTemporary();
               temporay.setCreatetime(new Date());
               TargetBean tar_bean = csuxd.getTargetBean();
               temporay.setTargetname(tar_bean.getTar_name());
               temporay.setSourcename(tar_bean.getTar_name());
               temporay.setTaskid(task.getId());
               temporay.setType("原表脱敏");
               SourceBean sou_bean = csuxd.getSourceBean();
               temporay.setWfname(sou_bean.getSo_name());
               this.tCoreMonitorTemporaryDao.save(temporay);
            }
         }

         return true;
      }
   }

   public CreateSelfUpdateXmlData getUpdateXml(TCoreMaskingselfTask task, String mappingkey, String userid) {
      TCoreEngine tengine = (TCoreEngine)this.tCoreEngineDao.get(task.getEngineid());
      Map<String, Object> map = this.engineDao.queryEnginePropertyKeyValue(tengine.getId());
      InfoProperty info = (InfoProperty)ObjectTool.getObjectByMap(InfoProperty.class, map);
      TCoreMaskingselfTable table = (TCoreMaskingselfTable)this.tCoreMaskingselfTableDao.queryAll(new Criterion[]{Restrictions.eq("mappingkey", mappingkey)}).get(0);
      ParamBean par_bean = new ParamBean();
      SourceBean sou_bean = new SourceBean();
      TargetBean tar_bean = new TargetBean();
      List<MappletMakeDatabean> mapplet = new ArrayList();
      List<MappingPramaBean> paramList = null;
      TCoreDatasystem data = (TCoreDatasystem)this.tCoreDatasystemDao.get(table.getDatasystemid());
      this.getDatasystemEngine(data.getId(), task.getEngineid());
      sou_bean.setSo_name(table.getTablename());
      sou_bean.setSo_ownname("");
      sou_bean.setBusinessname("");
      sou_bean.setFiledirect("Direct");
      sou_bean.setConnectmode(data.getConnectmode());
      sou_bean.setDatabasetype(data.getDbtype());
      sou_bean.setLinkname(data.getDblinkname());
      sou_bean.setDbdname(data.getDblinkname());
      sou_bean.setObjectversion("1");
      sou_bean.setDescripion("");
      sou_bean.setSourceownername(table.getDbschema());
      tar_bean.setLinkname(data.getDblinkname());
      tar_bean.setDbdname(data.getDblinkname());
      tar_bean.setLinkname(data.getDblinkname());
      tar_bean.setDbdname(data.getDblinkname());
      tar_bean.setConnectmode(data.getConnectmode());
      tar_bean.setTar_name(table.getTablename());
      tar_bean.setBusinessname("");
      tar_bean.setConstraint("");
      tar_bean.setDatabasetype(data.getDbtype());
      tar_bean.setVersionnumber("1");
      tar_bean.setObjectversion("1");
      tar_bean.setDescripion("");
      tar_bean.setTargetownername(table.getDbschema());
      List<TCoreMaskingselfTablecolumn> sourceColumn = this.tCoreMaskingselfTablecolumnDao.queryAll(new Criterion[]{Restrictions.eq("tableid", table.getId())});
      CommonBean cb = new CommonBean();
      List<String> keytype = new ArrayList();
      List<String> nameList = new ArrayList();
      List<String> typeList = new ArrayList();
      List<String> lengthList = new ArrayList();
      List<String> precisionList = new ArrayList();
      List<String> scalelist = new ArrayList();
      CommonBean tcb = new CommonBean();
      List<String> tkeytype = new ArrayList();
      List<String> tnameList = new ArrayList();
      List<String> ttypeList = new ArrayList();
      List<String> tlengthList = new ArrayList();
      List<String> tprecisionList = new ArrayList();
      List<String> tscalelist = new ArrayList();

      for(TCoreMaskingselfTablecolumn column : sourceColumn) {
         if ("1".equals(column.getPrimarykey())) {
            keytype.add("PRIMARY KEY");
         } else {
            keytype.add("NOT A KEY");
         }

         if ("NUMBER".equalsIgnoreCase(column.getColumntype()) && !"-127".equals(column.getColumnscale())) {
            typeList.add("number(p,s)");
         } else {
            typeList.add(column.getColumntype());
         }

         nameList.add(column.getColumnname());
         lengthList.add(column.getColumnlength());
         scalelist.add(column.getColumnscale());
         precisionList.add(column.getColumnlength());
         cb.setKeytype(keytype);
         cb.setLengthList(lengthList);
         cb.setNameList(nameList);
         cb.setPrecisionList(precisionList);
         cb.setScalelist(scalelist);
         cb.setTypeList(typeList);
         TCoreMaskingselfTablecolumn targetColumn = (TCoreMaskingselfTablecolumn)this.tCoreMaskingselfTablecolumnDao.queryAll(new Criterion[]{Restrictions.eq("mappingkey", column.getMappingkey())}).get(0);
         if ("1".equals(targetColumn.getPrimarykey())) {
            tkeytype.add("PRIMARY KEY");
         } else {
            tkeytype.add("NOT A KEY");
         }

         if ("NUMBER".equalsIgnoreCase(targetColumn.getColumntype()) && !"-127".equals(targetColumn.getColumnscale())) {
            ttypeList.add("number(p,s)");
         } else {
            ttypeList.add(targetColumn.getColumntype());
         }

         tnameList.add(targetColumn.getColumnname());
         tlengthList.add(targetColumn.getColumnlength());
         tscalelist.add(targetColumn.getColumnscale());
         tprecisionList.add(targetColumn.getColumnlength());
         if (column.getRuleid() != null && !"".equals(column.getRuleid())) {
            TCoreMaskingRuleinfo rule = (TCoreMaskingRuleinfo)this.tCoreMaskingRuleinfoDao.queryUnique(new Criterion[]{Restrictions.eq("ruleid", column.getRuleid())});
            if (rule != null) {
               mapplet.add(new MappletMakeDatabean(column.getColumnname(), rule.getMappletname(), targetColumn.getColumnname()));
            }
         }

         tcb.setKeytype(tkeytype);
         tcb.setLengthList(tlengthList);
         tcb.setNameList(tnameList);
         tcb.setPrecisionList(tprecisionList);
         tcb.setScalelist(tscalelist);
         tcb.setTypeList(ttypeList);
      }

      sou_bean.setCb(cb);
      tar_bean.setCb(tcb);
      tar_bean.setInserttype("update");
      par_bean.setTaskname(task.getTaskname());
      par_bean.setFoldername(task.getFdname());
      par_bean.setOwner("");
      par_bean.setGroup("");
      par_bean.setParam_path("");
      par_bean.setPower_repository_version("184.93");
      par_bean.setCodepage("UTF-8");
      par_bean.setRepository_version("184");
      TCoreDatasystem repdata = (TCoreDatasystem)this.tCoreDatasystemDao.get(info.getDatasystemid());
      if ("ORACLE".equals(repdata.getDbtype())) {
         par_bean.setRepository_dbtype("Oracle");
      } else if ("DB2".equals(repdata.getDbtype())) {
         par_bean.setRepository_dbtype("Db2");
      }

      par_bean.setShard("NOTSHARED");
      CreateSelfUpdateXmlData csuxd = new CreateSelfUpdateXmlData();
      csuxd.setParamBean(par_bean);
      csuxd.setSourceBean(sou_bean);
      csuxd.setInfoProperty(info);
      csuxd.setTargetBean(tar_bean);
      csuxd.setMapplet(mapplet);
      csuxd.setParamList(paramList);
      return csuxd;
   }
}
