package com.chenyang.nse.bussiness.tools.dataprocess.hive;

import com.chenyang.nse.bussiness.config.PropertiesLoaderUtils;
import com.chenyang.nse.bussiness.dao.table.core.encryption.TCoreJiaMiJieMiJinDuDao;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreDatasystem;
import com.chenyang.nse.bussiness.entity.orm.table.core.encryption.ColumnPrimaryKeyInfo;
import com.chenyang.nse.bussiness.entity.vo.strategy.ColumnInfoVO;
import com.chenyang.nse.bussiness.service.core.encryption.TCoreEncryptionService;
import com.chenyang.nse.bussiness.service.core.encryption.impl.TCoreEncryptionContext;
import com.chenyang.nse.bussiness.tools.dataprocess.ApplicationContextProvider;
import com.chenyang.nse.bussiness.tools.dataprocess.EncTaskStateContainer;
import com.chenyang.nse.bussiness.tools.dataprocess.EncTaskTracker;
import com.chenyang.nse.bussiness.tools.dataprocess.hive.hdfs.TableInfo;
import com.chenyang.nse.bussiness.tools.dataprocess.hive.hdfs.operator.HdfsOperator;
import com.chenyang.nse.bussiness.tools.jdbc.JdbcTool;
import com.chenyang.nse.bussiness.tools.logger.LoggerBuilder;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class HdfsRemoveLoadingTask extends HdfsBase implements Runnable {
   private List<ColumnInfoVO> allColumn;
   private List<com.chenyang.nse.bussiness.entity.vo.maskingtask.ColumnInfoVO> allColumnList;
   List<ColumnPrimaryKeyInfo> columnPrimaryKeyInfoList;
   Properties props = new Properties();
   private boolean isReload;
   EncTaskStateContainer container;

   public HdfsRemoveLoadingTask(String projectId, String dataSystemId, TCoreDatasystem tCoreDatasystem, String schema, String tableName, String[] primaryKeys, List<ColumnInfoVO> columnInfoList, List<ColumnPrimaryKeyInfo> columnPrimaryKeyInfoList, List<com.chenyang.nse.bussiness.entity.vo.maskingtask.ColumnInfoVO> allColumnList) {
      this.projectId = projectId;
      this.dataSystemId = dataSystemId;
      this.tCoreDatasystem = tCoreDatasystem;
      this.schema = schema;
      this.tableName = tableName;
      this.columnInfoList = columnInfoList;
      this.columnPrimaryKeyInfoList = columnPrimaryKeyInfoList;
      this.allColumnList = allColumnList;
      this.isReload = this.isReload;

      try {
         this.props = PropertiesLoaderUtils.loadAllProperties("config.properties");
      } catch (IOException e) {
         e.printStackTrace();
      }

      this.container = EncTaskTracker.instance().container();
      this.container.add(projectId, schema, tableName, columnInfoList);
      EncTaskTracker.instance().register(this.container);
   }

   public void run() {
      try {
         this.runTask();
      } finally {
         EncTaskTracker.instance().over(this.container.getTask());
      }

   }

   public Map<String, Object> runTask() {
      this.isEncryption = false;
      this.initState();
      String loggerPath = System.getProperty("user.dir") + File.separator + "encryprocesslog" + File.separator + this.projectId + File.separator + this.dataSystemId;
      this.encryptionlogger = (new LoggerBuilder()).getLogger(loggerPath, this.schema + "." + this.tableName);
      Thread.currentThread().setName("pool-" + this.tableName + "-thread");
      this.encryptionlogger.info("启动执行线程！！");
      this.tCoreJiaMiJieMiJinDuDao = (TCoreJiaMiJieMiJinDuDao)ApplicationContextProvider.getBean(TCoreJiaMiJieMiJinDuDao.class);
      this.tCoreEncryptionService = (TCoreEncryptionService)ApplicationContextProvider.getBean(TCoreEncryptionContext.class);
      this.connection = JdbcTool.getConnection(this.tCoreDatasystem);
      this.table = new TableInfo();
      this.table.tableName = this.tableName;
      this.table.cols = JdbcTool.getAllColumnInfo(this.connection, this.schema, this.tableName);
      this.table.format = JdbcTool.queryHdfsFileInfoForTDH(this.connection, this.schema, this.tableName);
      HdfsOperator.HdfsType type = HdfsOperator.HdfsType.webHdfs;
      this.hdfs = HdfsOperator.createHdfsOperator(type, this.connection, new Properties(), this.table);
      this.hdfs.setLogger(this.encryptionlogger);
      boolean encFlag = false;
      this.logBegin();
      Map<String, Object> msgs = this.beginExecute();
      String error = (String)msgs.get("error");
      if (error != null && error.length() > 0) {
         encFlag = true;
      }

      for(ColumnInfoVO columnInfo : this.columnInfoList) {
         try {
            this.hdfs.prepare(this.schema, this.tableName);
            this.files = this.hdfs.listFiles(this.schema, this.tableName, (String)null);
         } catch (Exception e) {
            this.logEncDecColumnFailed(columnInfo.getColumnName());
            String action = this.isEncryption ? "加密" : "解密";
            this.encryptionlogger.error(action + "表" + this.schema + "." + this.tableName + "失败，枚举HDFS文件异常：" + e);
            e.printStackTrace();
            return new HashMap();
         }

         msgs = this.execute(columnInfo.getColumnName());
         error = (String)msgs.get("error");
         if (error != null && error.length() > 0) {
            encFlag = true;
            this.logEncDecColumnFailed(columnInfo.getColumnName());
         } else {
            this.logEncDecColumnSuccess(columnInfo.getColumnName());
         }
      }

      if (!encFlag) {
         this.logEncDecSuccess();
      }

      return new HashMap();
   }
}
