package com.chenyang.nse.bussiness.tools.dmp;

import ch.ethz.ssh2.Connection;
import ch.ethz.ssh2.Session;
import com.chenyang.nse.bussiness.config.PropertiesLoaderUtils;
import com.chenyang.nse.bussiness.entity.vo.maskingtask.ColumnInfoVO;
import com.chenyang.nse.bussiness.tools.command.CommandTool;
import com.chenyang.nse.bussiness.tools.datatime.DateTime1Tool;
import com.chenyang.nse.bussiness.tools.io.FileTool;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class MultipleDmpDpTool {
   public static final int arraySize = 10000;
   public static final int INT_READ_LINE_CNT = 5000;
   public static final int READ_LINE_OA_CNT = 5000;
   public static final String STR_DATA_SEPARATOR = "#_#";

   public static byte[] readDataByLineNum(List<String> dmpPathList, int startLine, int endLine) {
      String pathStr = "";

      for(int i = 0; i < dmpPathList.size(); ++i) {
         pathStr = pathStr + (String)dmpPathList.get(i) + " ";
      }

      pathStr = pathStr.substring(0, pathStr.length() - 1);
      String cmdStr = "sed -n '" + startLine + "," + endLine + "p' " + pathStr;
      byte[] reBtyebufArr = remoteRunCmd(cmdStr);
      return reBtyebufArr;
   }

   public static byte[] remoteRunCmd(String cmd) {
      String hostname = "127.0.0.1";
      String username = "infa";
      String password = "infa";
      byte[] btyebufArr = new byte[10000];
      Connection conn = new Connection(hostname);
      byte[] in_b = null;
      Session sess = null;

      try {
         conn.connect();
         boolean isAuthenticated = conn.authenticateWithPassword(username, password);
         if (!isAuthenticated) {
            throw new IOException("Authentication failed.");
         }

         sess = conn.openSession();
         sess.execCommand(cmd);
         InputStream in = sess.getStdout();
         int num = 0;
         ByteArrayOutputStream swapStream = new ByteArrayOutputStream();

         int rc;
         for(rc = 0; (rc = in.read(btyebufArr, 0, 10000)) > 0; btyebufArr = new byte[10000]) {
            swapStream.write(btyebufArr, 0, rc);
         }

         in_b = swapStream.toByteArray();
      } catch (IOException e) {
         e.printStackTrace();
      } finally {
         sess.close();
         conn.close();
      }

      return in_b;
   }

   public static byte[] remoteRunCmd11(String cmd) {
      byte[] btyebufArr = new byte[10000];
      byte[] in_b = null;
      InputStream in = null;

      try {
         Process process = null;
         process = Runtime.getRuntime().exec(cmd);
         in = process.getInputStream();
         ByteArrayOutputStream swapStream = new ByteArrayOutputStream();
         int rc = 0;

         while((rc = in.read(btyebufArr, 0, 10000)) > 0) {
            swapStream.write(btyebufArr, 0, rc);
         }

         in_b = swapStream.toByteArray();
         in.close();
      } catch (Exception e) {
         e.printStackTrace(System.err);
      } finally {
         try {
            in.close();
         } catch (IOException e) {
            e.printStackTrace();
         }

      }

      return in_b;
   }

   private static StringBuffer parsingDataByLine(List<String> colTypeList, String contents10, String split, String doubleQuotationFlg) {
      StringBuffer sb = new StringBuffer();
      String sourcequoteCharacter = "2";
      if (!"1".equals(doubleQuotationFlg)) {
         sourcequoteCharacter = "";
      } else if ("2".equals(sourcequoteCharacter)) {
         sourcequoteCharacter = "\"";
      } else if ("1".equals(sourcequoteCharacter)) {
         sourcequoteCharacter = "'";
      } else {
         sourcequoteCharacter = "";
      }

      String dataSeparator = "#_#";

      try {
         String[] content_sz = contents10.split(split);
         Integer[] intLineArr = new Integer[content_sz.length];

         for(int i = 0; i < content_sz.length; ++i) {
            intLineArr[i] = Integer.valueOf(content_sz[i]);
         }

         int content_length = intLineArr.length;
         int point = 0;
         int colIndex = 0;
         int colStartcnt = 0;

         for(String pkStr = ""; point < content_length; ++point) {
            if (colStartcnt == 0) {
               if (!content_sz[point].equals("255")) {
                  int zd_length = 0;
                  if (content_sz[point].equals("254")) {
                     zd_length = DmpCommonTool.binary16_10(DmpCommonTool.intToHex(intLineArr[point + 1]) + DmpCommonTool.intToHex(intLineArr[point + 2]));
                     colStartcnt = 1;
                     point += 3;
                  } else {
                     zd_length = intLineArr[point];
                     ++point;
                  }

                  colStartcnt = zd_length;
                  List<Integer> intColList = new ArrayList();

                  for(int j = point; j < point + zd_length; ++j) {
                     if (j >= intLineArr.length) {
                        System.out.println(">>>>>>>>>>>>>>>");
                     }

                     intColList.add(intLineArr[j]);
                  }

                  String colType = (String)colTypeList.get(colIndex);
                  colType = colType.trim();
                  sb.append(sourcequoteCharacter);
                  if (!colType.equalsIgnoreCase("VARCHAR2") && !colType.equalsIgnoreCase("CHAR")) {
                     if (!colType.equalsIgnoreCase("NVARCHAR2") && !colType.equalsIgnoreCase("NCHAR")) {
                        if (!colType.equals("NUMBER") && !colType.equalsIgnoreCase("float")) {
                           if (colType.equals("LONG")) {
                              sb.append(lNumberParsing(intColList));
                           } else if (colType.equals("DATE")) {
                              sb.append(dateParsing(intColList));
                           } else if (colType.equalsIgnoreCase("TIMESTAMP")) {
                              List<Integer> subColList1 = intColList.subList(0, 7);
                              String dateStr = dateParsing(subColList1);
                              List<Integer> subColList2 = intColList.subList(7, intColList.size());
                              if (null != subColList2 && subColList2.size() > 0) {
                                 String content16MsPart = "";

                                 for(int i = 0; i < subColList2.size(); ++i) {
                                    content16MsPart = content16MsPart + Integer.toHexString((Integer)subColList2.get(i));
                                 }

                                 int intStr = DmpCommonTool.binary16_10(content16MsPart);
                                 dateStr = dateStr + "." + intStr;
                              }

                              sb.append(dateStr);
                           }
                        } else {
                           if (intColList.size() == 1 && !"128".equals(((Integer)intColList.get(0)).toString())) {
                              System.out.println(">>>>>>>>>>>>>>>>>>>>>>>>>>>");
                           }

                           if ("49".equals(intColList.get(0))) {
                              System.out.println(">>>>>>>>>>>>>>>>>>>>>>>>>>>");
                           }

                           sb.append(numberParsing(intColList));
                        }
                     } else {
                        sb.append(nStringToGbk(intColList));
                     }
                  } else {
                     sb.append(stringToGbk(intColList));
                  }

                  sb.append(sourcequoteCharacter);
                  sb.append(dataSeparator);
               } else {
                  sb.append(dataSeparator);
                  colStartcnt = 1;
               }

               ++colIndex;
            }

            --colStartcnt;
         }

         sb.append("\r\n");
         return sb;
      } catch (Exception e) {
         e.printStackTrace();
         sb = new StringBuffer();
         return sb;
      } finally {
         ;
      }
   }

   private static String stringToGbk(List<Integer> intColLst) {
      String result = "";

      try {
         byte[] byteArr = new byte[intColLst.size()];

         for(int i = 0; i < intColLst.size(); ++i) {
            byteArr[i] = (byte)((Integer)intColLst.get(i) & 255);
         }

         result = new String(byteArr, "gbk");
      } catch (UnsupportedEncodingException e) {
         e.printStackTrace();
      }

      return result;
   }

   private static String nStringToGbk(List<Integer> intColLst) {
      String result = "";
      int j = 0;

      try {
         if (0 == (Integer)intColLst.get(0)) {
            byte[] byteArr = new byte[intColLst.size() / 2];

            for(int i = 0; i < intColLst.size(); ++i) {
               if (i % 2 != 0) {
                  byteArr[j] = (byte)((Integer)intColLst.get(i) & 255);
                  ++j;
               }
            }

            result = new String(byteArr, "gbk");
         } else {
            byte[] byteArr = new byte[intColLst.size()];

            for(int i = 0; i < intColLst.size(); ++i) {
               byteArr[i] = (byte)((Integer)intColLst.get(i) & 255);
            }

            result = new String(byteArr, "utf-16");
         }
      } catch (UnsupportedEncodingException e) {
         e.printStackTrace();
      }

      return result;
   }

   private static String dateParsing(List<Integer> intColLst) {
      String datefmt = "yyyy-MM-dd HH:mm:ss";
      Calendar calendar = Calendar.getInstance();
      int[] date = new int[6];
      String reStr = "";

      for(int i = 0; i < intColLst.size(); ++i) {
         int sz = (Integer)intColLst.get(i);
         if (i == 0 || i == 1) {
            sz -= 100;
         }

         reStr = reStr + String.format("%02d", sz);
         if (i != 0) {
            date[i - 1] = Integer.parseInt(reStr);
            reStr = "";
         }
      }

      calendar.set(date[0], date[1] - 1, date[2], date[3] - 1, date[4] - 1, date[5] - 1);
      SimpleDateFormat sdf = new SimpleDateFormat(datefmt);
      String dateStr = sdf.format(calendar.getTime());
      return dateStr;
   }

   private static String numberParsing(List<Integer> intColLst) {
      String reInt = "";

      try {
         int prefixNum = (Integer)intColLst.get(0);
         int ws = prefixNum - 192;
         if (ws >= 0) {
            int idx = prefixNum - 193;
            intColLst.remove(0);

            while(intColLst.size() < idx + 1) {
               intColLst.add(1);
            }

            BigDecimal reDouble = new BigDecimal(0);

            for(int i = 0; i < intColLst.size(); ++i) {
               int codeInt = (Integer)intColLst.get(i);
               double codedouble = (double)(codeInt - 1) * Math.pow((double)100.0F, (double)idx);
               BigDecimal bg = new BigDecimal(codedouble);
               if (idx < 0) {
                  bg = bg.setScale(idx * 2 * -1, RoundingMode.HALF_DOWN);
               }

               reDouble = reDouble.add(bg);
               --idx;
            }

            reInt = DmpCommonTool.subZeroAndDot(String.valueOf(reDouble));
         } else if (ws < 0) {
            if (1 == intColLst.size() && "128".equals(((Integer)intColLst.get(0)).toString())) {
               reInt = "0";
            } else if (1 == intColLst.size() && "30".equals(((Integer)intColLst.get(0)).toString())) {
               reInt = "";
            } else {
               int idx = 62 - (Integer)intColLst.get(0);
               if (intColLst.size() == 1) {
                  System.out.println(">>>>>>>>>>>>>>>>>>>>>>>>>>>>");
               }

               intColLst.remove(intColLst.size() - 1);
               intColLst.remove(0);

               while(intColLst.size() < idx + 1) {
                  intColLst.add(101);
               }

               BigDecimal reDouble = new BigDecimal(0);

               for(int i = 0; i < intColLst.size(); ++i) {
                  int codeInt = (Integer)intColLst.get(i);
                  double codedouble = (double)(codeInt - 101) * Math.pow((double)100.0F, (double)idx);
                  BigDecimal bg = new BigDecimal(codedouble);
                  if (idx < 0) {
                     bg = bg.setScale(idx * 2 * -1, RoundingMode.HALF_DOWN);
                  }

                  reDouble = reDouble.add(bg);
                  --idx;
               }

               reInt = DmpCommonTool.subZeroAndDot(String.valueOf(reDouble));
            }
         }
      } catch (Exception e) {
         e.printStackTrace();
      }

      return reInt;
   }

   private static String lNumberParsing(List<Integer> intColLst) {
      String reInt = "";
      int prefixNum = (Integer)intColLst.get(0);
      if (prefixNum == 45) {
         reInt = "-";

         for(int i = 1; i < intColLst.size(); ++i) {
            reInt = reInt + ((Integer)intColLst.get(i) - 48);
         }
      } else {
         for(int i = 0; i < intColLst.size(); ++i) {
            reInt = reInt + ((Integer)intColLst.get(i) - 48);
         }
      }

      return reInt;
   }

   private static TableStructureInfo getTableStructureInfo(List<String> dmpFilePathList, String tableName) {
      TableStructureInfo tableStructureInfo = null;
      new ArrayList();
      new ArrayList();
      new ArrayList();
      new ArrayList();
      new ArrayList();
      new ArrayList();

      try {
         for(int i = 0; i < dmpFilePathList.size(); ++i) {
            String dmpFilePath = (String)dmpFilePathList.get(i);
            File file = new File(dmpFilePath);
            BufferedInputStream fis = new BufferedInputStream(new FileInputStream(file));
            String sourceFileEncoding = "UTF-8";
            BufferedReader reader = new BufferedReader(new InputStreamReader(fis), 5000);
            String line = "";
            int createTableSqlLineCnt = 0;
            StringBuffer createTableSqlStrBuffer = new StringBuffer();

            while((line = reader.readLine()) != null) {
               int rowsetIndex = line.indexOf("<ROWSET>");
               if (rowsetIndex >= 0) {
                  createTableSqlLineCnt = 3;
                  createTableSqlStrBuffer = new StringBuffer();
               }

               if (createTableSqlLineCnt > 0) {
                  createTableSqlStrBuffer.append(line);
                  if (1 == createTableSqlLineCnt) {
                     String createTableSqlStr = createTableSqlStrBuffer.toString();
                     int createTableSqlStrStartIndex = createTableSqlStr.indexOf("<ROWSET>");
                     int createTableSqlStrEndIndex = createTableSqlStr.indexOf("</ROWSET>") + "</ROWSET>".length();
                     createTableSqlStr = createTableSqlStr.substring(createTableSqlStrStartIndex, createTableSqlStrEndIndex);
                     int tableNameStartIndex = createTableSqlStr.indexOf("<NAME>") + 6;
                     int tableNameEndIndex = createTableSqlStr.indexOf("</NAME>");
                     String tableNameStr = createTableSqlStr.substring(tableNameStartIndex, tableNameEndIndex);
                     if (tableName.equals(tableNameStr)) {
                        tableStructureInfo = readStringXml(createTableSqlStr);
                        break;
                     }
                  }

                  --createTableSqlLineCnt;
               }
            }
         }
      } catch (Exception e) {
         e.printStackTrace();
      }

      return tableStructureInfo;
   }

   public static List<String> getAllTableNameList(List<String> dmpFilePathList) {
      List<String> tableNameList = new ArrayList();
      new ArrayList();
      new ArrayList();
      new ArrayList();
      new ArrayList();
      new ArrayList();

      try {
         for(int i = 0; i < dmpFilePathList.size(); ++i) {
            String dmpFilePath = (String)dmpFilePathList.get(i);
            File file = new File(dmpFilePath);
            BufferedInputStream fis = new BufferedInputStream(new FileInputStream(file));
            String sourceFileEncoding = "UTF-8";
            BufferedReader reader = new BufferedReader(new InputStreamReader(fis), 5000);
            String line = "";
            int createTableSqlLineCnt = 0;
            StringBuffer createTableSqlStrBuffer = new StringBuffer();

            while((line = reader.readLine()) != null) {
               line = new String(line.getBytes("ISO-8859-1"), "GBK");
               int rowsetIndex = line.indexOf("<ROWSET>");
               if (rowsetIndex >= 0) {
                  createTableSqlLineCnt = 3;
                  createTableSqlStrBuffer = new StringBuffer();
               }

               if (createTableSqlLineCnt > 0) {
                  createTableSqlStrBuffer.append(line);
                  if (1 == createTableSqlLineCnt) {
                     String createTableSqlStr = createTableSqlStrBuffer.toString();
                     int createTableSqlStrStartIndex = createTableSqlStr.indexOf("<ROWSET>");
                     int createTableSqlStrEndIndex = createTableSqlStr.indexOf("</ROWSET>") + "</ROWSET>".length();
                     createTableSqlStr = createTableSqlStr.substring(createTableSqlStrStartIndex, createTableSqlStrEndIndex);
                     int tableNameStartIndex = createTableSqlStr.indexOf("<NAME>") + 6;
                     int tableNameEndIndex = createTableSqlStr.indexOf("</NAME>");
                     String tableNameStr = createTableSqlStr.substring(tableNameStartIndex, tableNameEndIndex);
                     tableNameList.add(tableNameStr);
                  }

                  --createTableSqlLineCnt;
               }
            }
         }
      } catch (Exception e) {
         e.printStackTrace();
      }

      return tableNameList;
   }

   public static Map<String, Object> getAllTableinfo(List<String> dmpFilePathList) {
      System.out.println(">>>>>>>>>>>>>>获取表结构信息 getAllTableinfo start");
      Date startDate = new Date();
      TableStructureInfo tableStructureInfo = null;
      String preTableName = "";
      Map<String, Object> reTableInfoMap = new HashMap();
      List<TableStructureInfo> tableStructureInfoList = new ArrayList();
      Map<String, String> tableDataLineNumMap = new HashMap();
      List<Integer> dmpFileTotalLineNumList = new ArrayList();
      int lineNum = 1;
      String isNewFile = "0";

      try {
         for(int i = 0; i < dmpFilePathList.size(); ++i) {
            isNewFile = "1";
            String dmpFilePath = (String)dmpFilePathList.get(i);
            System.out.println(">>>cur dmpFilePath is:" + dmpFilePath);
            FileReader fr = new FileReader(dmpFilePath);
            int createTableSqlLineCnt = 0;
            StringBuffer createTableSqlStrBuffer = new StringBuffer();
            DmpBufferedReader reader = new DmpBufferedReader(fr);

            String line;
            for(line = ""; (line = reader.ReadLine()) != null; ++lineNum) {
               if (line.contains("TEXPORT") && "1".equals(isNewFile)) {
                  return null;
               }

               isNewFile = "0";
               int rowsetIndex = line.indexOf("<ROWSET>");
               if (rowsetIndex >= 0) {
                  createTableSqlLineCnt = 3;
                  createTableSqlStrBuffer = new StringBuffer();
               }

               if (createTableSqlLineCnt > 0) {
                  createTableSqlStrBuffer.append(line);
                  if (1 == createTableSqlLineCnt) {
                     String createTableSqlStr = createTableSqlStrBuffer.toString();
                     int createTableSqlStrStartIndex = createTableSqlStr.indexOf("<ROWSET>");
                     int createTableSqlStrEndIndex = createTableSqlStr.indexOf("</ROWSET>") + "</ROWSET>".length();
                     createTableSqlStr = createTableSqlStr.substring(createTableSqlStrStartIndex, createTableSqlStrEndIndex);
                     int tableNameStartIndex = createTableSqlStr.indexOf("<NAME>") + 6;
                     int tableNameEndIndex = createTableSqlStr.indexOf("</NAME>");
                     String tableNameStr = createTableSqlStr.substring(tableNameStartIndex, tableNameEndIndex);
                     System.out.println(">>>have read tablename is:" + tableNameStr);
                     if (StringUtils.isNotBlank(preTableName) && null != tableDataLineNumMap.get(preTableName) && ((String)tableDataLineNumMap.get(preTableName)).indexOf("#_#") < 0) {
                        tableDataLineNumMap.put(preTableName, (String)tableDataLineNumMap.get(preTableName) + "#_#" + dmpFilePath + "$_$" + lineNum);
                     }

                     if (!tableDataLineNumMap.containsKey(tableNameStr)) {
                        tableStructureInfo = readStringXml(createTableSqlStr);
                        tableStructureInfoList.add(tableStructureInfo);
                        tableDataLineNumMap.put(tableNameStr, String.valueOf(dmpFilePath + "$_$" + lineNum));
                        preTableName = tableNameStr;
                     }
                  }

                  --createTableSqlLineCnt;
               }
            }

            dmpFileTotalLineNumList.add(lineNum - 1);
         }

         tableStructureInfoList.remove(tableStructureInfoList.size() - 1);
         reTableInfoMap.put("lineNumKey", tableDataLineNumMap);
         reTableInfoMap.put("tableStructureInfoList", tableStructureInfoList);
         reTableInfoMap.put("dmpFileTotalLineNumList", dmpFileTotalLineNumList);
      } catch (Exception e) {
         e.printStackTrace();
      }

      Date endDate = new Date();
      long useTime = DateTime1Tool.dateBetween(startDate, endDate);
      System.out.println(">>>>>>>>>>>>>>getAllTableinfo useTime:" + useTime + "毫秒");
      System.out.println(">>>>>>>>>>>>>>获取表结构信息 getAllTableinfo end");
      return reTableInfoMap;
   }

   private static List<TableStructureInfo> createTableSql(List<String> dmpFilePathList) {
      List<TableStructureInfo> tableStructureList = new ArrayList();
      List<String> createTableSqlList = new ArrayList();
      new ArrayList();
      new ArrayList();
      new ArrayList();
      new ArrayList();

      try {
         for(int i = 0; i < dmpFilePathList.size(); ++i) {
            String dmpFilePath = (String)dmpFilePathList.get(i);
            File file = new File(dmpFilePath);
            BufferedInputStream fis = new BufferedInputStream(new FileInputStream(file));
            String sourceFileEncoding = "UTF-8";
            LineNumberReader reader = new LineNumberReader(new InputStreamReader(fis), 5000);
            String line = "";
            int lineNum = 0;
            int createTableSqlLineCnt = 0;
            StringBuffer createTableSqlStrBuffer = new StringBuffer();

            while((line = reader.readLine()) != null) {
               ++lineNum;
               int rowsetIndex = line.indexOf("<ROWSET>");
               if (rowsetIndex >= 0) {
                  createTableSqlLineCnt = 3;
                  createTableSqlStrBuffer = new StringBuffer();
               }

               if (createTableSqlLineCnt > 0) {
                  createTableSqlStrBuffer.append(line);
                  if (1 == createTableSqlLineCnt) {
                     String createTableSqlStr = createTableSqlStrBuffer.toString();
                     int createTableSqlStrStartIndex = createTableSqlStr.indexOf("<ROWSET>");
                     int createTableSqlStrEndIndex = createTableSqlStr.indexOf("</ROWSET>") + "</ROWSET>".length();
                     createTableSqlStr = createTableSqlStr.substring(createTableSqlStrStartIndex, createTableSqlStrEndIndex);
                     createTableSqlList.add(createTableSqlStr);
                  }

                  --createTableSqlLineCnt;
               }
            }
         }

         if (createTableSqlList.size() > 0) {
            createTableSqlList.remove(createTableSqlList.size() - 1);
         }

         for(int i = 0; i < createTableSqlList.size(); ++i) {
            String xmlStr = (String)createTableSqlList.get(i);
            TableStructureInfo tableStructureInfo = readStringXml(xmlStr);
            tableStructureList.add(tableStructureInfo);
         }
      } catch (Exception e) {
         e.printStackTrace();
      }

      return tableStructureList;
   }

   public static TableStructureInfo readStringXml(String xmlStr) {
      Document doc = null;
      TableStructureInfo tableStructureInfo = new TableStructureInfo();

      try {
         doc = DocumentHelper.parseText(xmlStr);
         Element root = doc.getRootElement();
         Element row = root.element("ROW");
         Element strmtable_t = row.element("STRMTABLE_T");
         Element ownernameElt = strmtable_t.element("OWNER_NAME");
         Element tablenameElt = strmtable_t.element("NAME");
         String tablename = tablenameElt.getText();
         Element col_list = strmtable_t.element("COL_LIST");
         List<Element> colList = col_list.elements("COL_LIST_ITEM");
         tableStructureInfo.setOwnername(ownernameElt.getText());
         tableStructureInfo.setTablename(tablename);
         List<ColumnInfoVO> columnInfoLst = new ArrayList();
         if (null != colList && colList.size() > 0) {
            for(int i = 0; i < colList.size(); ++i) {
               Element colItem = (Element)colList.get(i);
               String columnname = colItem.element("NAME").getText();
               String not_null = colItem.element("NOT_NULL").getText();
               String type_num = colItem.element("TYPE_NUM").getText();
               String length = colItem.element("LENGTH").getText();
               String charlength = colItem.element("CHARLENGTH").getText();
               String scale = "";
               String typename = "";
               if ("1".equals(type_num)) {
                  if (length.equals(charlength)) {
                     typename = "VARCHAR2";
                  } else {
                     typename = "NVARCHAR2";
                  }
               } else if ("96".equals(type_num)) {
                  if (length.equals(charlength)) {
                     typename = "CHAR";
                  } else {
                     typename = "NCHAR";
                  }
               } else if ("2".equals(type_num)) {
                  typename = "NUMBER";
               } else if ("12".equals(type_num)) {
                  typename = "DATE";
               } else if ("180".equals(type_num)) {
                  typename = "TIMESTAMP";
               } else if ("8".equals(type_num)) {
                  typename = "LONG";
               } else if ("100".equals(type_num)) {
                  typename = "BINARY_FLOAT";
               }

               if (!"NUMBER".equals(typename) && !"TIMESTAMP".equals(typename)) {
                  if ("NVARCHAR2".equals(typename) || "NCHAR".equals(typename)) {
                     length = charlength;
                  }
               } else {
                  if (null != colItem.element("SCALE")) {
                     scale = colItem.element("SCALE").getText();
                  }

                  if (null != colItem.element("PRECISION_NUM")) {
                     length = colItem.element("PRECISION_NUM").getText();
                  } else {
                     length = "38";
                  }
               }

               ColumnInfoVO columnInfo = new ColumnInfoVO();
               columnInfo.setTablename(tablename);
               columnInfo.setColumnname(columnname);
               columnInfo.setTypename(typename);
               columnInfo.setColumnsize(length == null ? "" : length);
               columnInfo.setDecimaldigits(scale == null ? "" : scale);
               columnInfo.setMaskingruleid("");
               columnInfo.setMaskingrulename("");
               columnInfo.setRegextype("");
               columnInfo.setTargettypename("");
               columnInfo.setRemarks("");
               columnInfoLst.add(columnInfo);
            }
         }

         tableStructureInfo.setColInfoLst(columnInfoLst);
      } catch (Exception e) {
         e.printStackTrace();
      }

      return tableStructureInfo;
   }

   private static List<String> getTypeNameListByTableName(TableStructureInfo tableStructureInfo) {
      if (null == tableStructureInfo) {
         return null;
      } else {
         List<String> typeNameLst = new ArrayList();
         List<ColumnInfoVO> columnInfoList = tableStructureInfo.getColInfoLst();

         for(int j = 0; j < columnInfoList.size(); ++j) {
            typeNameLst.add(((ColumnInfoVO)columnInfoList.get(j)).getTypename());
         }

         return typeNameLst;
      }
   }

   public static void createPipeFile(String taskname, String tablename) {
      Properties props = new Properties();

      try {
         props = PropertiesLoaderUtils.loadAllProperties("config.properties");
      } catch (IOException e) {
         e.printStackTrace();
      }

      String path = props.getProperty("dmp_exp_table_file_path");
      String pipeFilePath = path + taskname + "/";
      FileTool.createFolder(pipeFilePath);
      String pipeFileName = tablename + ".pipe";
      String rmPipeFileCmd = "rm -f " + pipeFilePath + pipeFileName;
      String mkrPipeFileCmd = "mkfifo " + pipeFilePath + pipeFileName;
      CommandTool.command(rmPipeFileCmd);
      CommandTool.command(mkrPipeFileCmd);
      CommandTool.command("chmod -R 777 " + pipeFilePath + pipeFileName);
   }

   public static void prasingDataByTableName(List<String> dmpFilePathList, String taskname, String tablenamePar, Map<String, Object> tableInfoMap) {
      System.out.println(">>>>>>>>>>>>>>>>>>>>>>>>>exec new DMP func");
      if (null != tableInfoMap && null != dmpFilePathList && dmpFilePathList.size() != 0) {
         Properties props = new Properties();

         try {
            props = PropertiesLoaderUtils.loadAllProperties("config.properties");
         } catch (IOException e) {
            e.printStackTrace();
         }

         List<TableStructureInfo> tableStructureInfoList = (List)tableInfoMap.get("tableStructureInfoList");

         for(int i = 0; i < tableStructureInfoList.size(); ++i) {
            String tablename = ((TableStructureInfo)tableStructureInfoList.get(i)).getTablename();
            if (tablenamePar.equals(tablename)) {
               List<String> colTypeList = getTypeNameListByTableName((TableStructureInfo)tableStructureInfoList.get(i));
               String dataStartMark = "";
               if (colTypeList.contains("LONG")) {
                  dataStartMark = "0C";
               } else {
                  dataStartMark = "3C";
               }

               Map<String, String> tableDataLineNumMap = (Map)tableInfoMap.get("lineNumKey");
               List<Integer> dmpFileTotalLineNumList = (List)tableInfoMap.get("dmpFileTotalLineNumList");

               try {
                  String path = props.getProperty("dmp_exp_table_file_path");
                  String pipeFilePath = path + taskname + "/";
                  String pipeFileName = tablename + ".pipe";
                  FileOutputStream os = new FileOutputStream(pipeFilePath + pipeFileName);
                  Writer writer = new OutputStreamWriter(os, "utf-8");
                  BufferedWriter bufferedWriter = new BufferedWriter(writer);
                  String LineNum = (String)tableDataLineNumMap.get(tablename);
                  String[] LineNums = LineNum.split("#_#");
                  String[] startLineArr = LineNums[0].split("\\$_\\$");
                  String[] endLineArr = LineNums[1].split("\\$_\\$");
                  int startLine = Integer.parseInt(startLineArr[1]);
                  int endLine = Integer.parseInt(endLineArr[1]);
                  byte[] btyebufArr = null;
                  int preEndLineReal = startLine;
                  String isFinishFlg = "0";
                  String nextDmpStartMark = "0";
                  int nextCnt = 0;
                  boolean issys = false;
                  String finishFlg = "0";
                  int colCnt = 0;
                  int curLineReadedColCnt = 0;
                  StringBuffer sb = new StringBuffer();

                  for(int j = 0; j < dmpFileTotalLineNumList.size(); ++j) {
                     int nextDmpHeadIndex = 0;
                     Integer dmpCnt = (Integer)dmpFileTotalLineNumList.get(j);
                     if ("0".equals(isFinishFlg) && startLine < dmpCnt) {
                        if (dmpCnt < endLine) {
                           int endLineReal = dmpCnt;
                           btyebufArr = readDataByLineNum(dmpFilePathList, preEndLineReal, endLineReal);
                           preEndLineReal = endLineReal + 1;
                           ++nextCnt;
                        } else {
                           btyebufArr = readDataByLineNum(dmpFilePathList, preEndLineReal, endLine);
                           isFinishFlg = "1";
                           ++nextCnt;
                        }

                        if (nextCnt > 1) {
                           nextDmpStartMark = "1";
                        }

                        int curDmpFileByteIndex = 0;
                        int btyebufArrIndex = 0;
                        int lineStartIndex = 0;
                        String lastbuf16 = "";
                        String createTableEndMark = "0";
                        String buf16Str6 = "";
                        int doubleCodeCnt = 0;
                        String doubleCodeStr = "";
                        String invalidDmpFlg = "0";
                        String nextDmpStartMonitorData = "0";
                        int curLineColCnt = 0;
                        long starttime = (new Date()).getTime();

                        while(curDmpFileByteIndex < btyebufArr.length) {
                           byte bufbyte = btyebufArr[btyebufArrIndex];
                           String buf10 = DmpCommonTool.toInt(bufbyte);
                           String buf16 = DmpCommonTool.toHex(bufbyte);
                           if (!issys) {
                              buf16Str6 = buf16Str6 + buf16;
                              if (buf16Str6.length() > 12) {
                                 buf16Str6 = buf16Str6.substring(2);
                              }

                              if ("3C2F524F5753".equals(buf16Str6) && "0".equals(createTableEndMark)) {
                                 createTableEndMark = "1";
                              }

                              if ("1".equals(createTableEndMark) && !issys && dataStartMark.equals(buf16)) {
                                 issys = true;
                                 createTableEndMark = "0";
                              }
                           }

                           if (issys) {
                              if ("1".equals(nextDmpStartMark)) {
                                 if (nextDmpHeadIndex == 4095 && "0".equals(nextDmpStartMonitorData)) {
                                    nextDmpStartMonitorData = "1";
                                 }

                                 ++nextDmpHeadIndex;
                                 if ("1".equals(nextDmpStartMonitorData) && !buf16.equals("00") && lastbuf16.equals("00")) {
                                    String nextbuf16 = DmpCommonTool.toHex(btyebufArr[btyebufArrIndex + 1]);
                                    String next2buf16 = DmpCommonTool.toHex(btyebufArr[btyebufArrIndex + 2]);
                                    String next3buf16 = DmpCommonTool.toHex(btyebufArr[btyebufArrIndex + 3]);
                                    if ("4B".equals(buf16) && "47".equals(nextbuf16) && "43".equals(next2buf16) && "80".equals(next3buf16)) {
                                       invalidDmpFlg = "1";
                                       break;
                                    }

                                    nextDmpStartMark = "0";
                                    nextDmpStartMonitorData = "0";
                                 }
                              }

                              if ("0".equals(nextDmpStartMark)) {
                                 if (lineStartIndex > 0) {
                                    if (lineStartIndex == 1) {
                                       curLineColCnt = Integer.valueOf(buf10);
                                       curLineReadedColCnt = curLineColCnt;
                                    }

                                    --lineStartIndex;
                                 } else if (buf16.equals(dataStartMark) && colCnt == 0 && doubleCodeCnt == 0 && curLineReadedColCnt == 0) {
                                    lineStartIndex = 3;
                                    if ("0C".equals(dataStartMark)) {
                                       lineStartIndex = 1;
                                    }

                                    if (StringUtils.isNotBlank(sb.toString())) {
                                       String sbInt = sb.toString().substring(0, sb.length() - 1);
                                       if (curLineColCnt < colTypeList.size()) {
                                          int fillLen = colTypeList.size() - curLineColCnt;

                                          for(int n = 0; n < fillLen; ++n) {
                                             sbInt = sbInt + ",255";
                                          }
                                       }

                                       StringBuffer writebuf = parsingDataByLine(colTypeList, sbInt, ",", "1");
                                       bufferedWriter.write(writebuf.toString());
                                    }

                                    sb = new StringBuffer();
                                 } else if (buf16.equals("00") && lastbuf16.equals("00")) {
                                    String sbInt = sb.toString().substring(0, sb.length() - 3);
                                    if (curLineColCnt < colTypeList.size()) {
                                       int fillLen = colTypeList.size() - curLineColCnt;

                                       for(int n = 0; n < fillLen; ++n) {
                                          sbInt = sbInt + ",255";
                                       }
                                    }

                                    if (StringUtils.isNotBlank(sbInt)) {
                                       StringBuffer writebuf = parsingDataByLine(colTypeList, sbInt, ",", "1");
                                       bufferedWriter.write(writebuf.toString());
                                       sb = new StringBuffer();
                                    }

                                    finishFlg = "1";
                                 } else {
                                    if (colCnt == 0) {
                                       if (buf10.equals("254")) {
                                          doubleCodeCnt = 2;
                                       } else if (doubleCodeCnt > 0) {
                                          doubleCodeStr = doubleCodeStr + DmpCommonTool.intToHex(Integer.valueOf(buf10));
                                          --doubleCodeCnt;
                                       } else {
                                          if (StringUtils.isNotBlank(doubleCodeStr)) {
                                             colCnt = DmpCommonTool.binary16_10(doubleCodeStr);
                                             doubleCodeStr = "";
                                          } else if ("FF".equals(buf16)) {
                                             colCnt = 0;
                                          } else {
                                             colCnt = Integer.valueOf(buf10);
                                          }

                                          --curLineReadedColCnt;
                                       }
                                    } else {
                                       --colCnt;
                                    }

                                    sb.append(buf10).append(",");
                                 }
                              }
                           }

                           lastbuf16 = buf16;
                           ++curDmpFileByteIndex;
                           ++btyebufArrIndex;
                           if ("1".equals(finishFlg)) {
                              bufferedWriter.flush();
                              bufferedWriter.close();
                              break;
                           }
                        }

                        long endtime = (new Date()).getTime();
                        System.out.println("第" + j + "个DMP文件，按字节分析数据占用时间:" + (endtime - starttime) + "毫秒");
                     }
                  }
               } catch (Exception e) {
                  e.printStackTrace();
               }
            }
         }

      }
   }

   public static Map<String, List<List<Object>>> prasingDataByTableNameByRowNum(List<String> dmpFilePathList, Map<String, Object> tableInfoMap, List<String> selectTableList, Long parMaxCnt) {
      if (null != tableInfoMap && null != dmpFilePathList && dmpFilePathList.size() != 0 && tableInfoMap.size() != 0) {
         Date startDate = new Date();
         Map<String, List<List<Object>>> reDataLstMap = new HashMap();
         new ArrayList();
         new Properties();

         try {
            Properties props = PropertiesLoaderUtils.loadAllProperties("config.properties");
         } catch (IOException e) {
            e.printStackTrace();
         }

         Map<String, String> selectTableMap = new HashMap();

         for(int i = 0; i < selectTableList.size(); ++i) {
            selectTableMap.put(selectTableList.get(i), "");
         }

         List<TableStructureInfo> tableStructureInfoList = (List)tableInfoMap.get("tableStructureInfoList");
         Map<String, String> tableDataLineNumMap = (Map)tableInfoMap.get("lineNumKey");
         List<Integer> dmpFileTotalLineNumList = (List)tableInfoMap.get("dmpFileTotalLineNumList");

         for(int i = 0; i < tableStructureInfoList.size(); ++i) {
            List<List<Object>> reDataLst = new ArrayList();
            String tablename = ((TableStructureInfo)tableStructureInfoList.get(i)).getTablename();
            if (selectTableMap.containsKey(tablename)) {
               int colCnt = 0;
               int curLineReadedColCnt = 0;
               System.out.println(">>>>have read tablename data is :" + tablename);
               Long maxCnt = parMaxCnt;
               List<String> colTypeList = getTypeNameListByTableName((TableStructureInfo)tableStructureInfoList.get(i));
               String LineNum = (String)tableDataLineNumMap.get(tablename);
               String[] LineNums = LineNum.split("#_#");
               String[] startLineArr = LineNums[0].split("\\$_\\$");
               String[] endLineArr = LineNums[1].split("\\$_\\$");
               int startLine = Integer.parseInt(startLineArr[1]);
               int endLine = Integer.parseInt(endLineArr[1]);
               byte[] btyebufArr = null;
               int preEndLineReal = startLine;
               String isCurTableDataLastFinishFlg = "0";
               String nextDmpStartMark = "0";
               int nextCnt = 0;
               boolean issys = false;
               String finishFlg = "0";

               for(int j = 0; j < dmpFileTotalLineNumList.size() && !"1".equals(isCurTableDataLastFinishFlg) && !"1".equals(finishFlg); ++j) {
                  int nextDmpHeadIndex = 0;
                  Integer dmpCnt = (Integer)dmpFileTotalLineNumList.get(j);
                  if (startLine < dmpCnt) {
                     int endLineReal;
                     if (dmpCnt < endLine) {
                        endLineReal = dmpCnt;
                     } else {
                        endLineReal = endLine;
                        isCurTableDataLastFinishFlg = "1";
                     }

                     int execCnt = (endLineReal - preEndLineReal + 1) / 5000;
                     int lastTimeLineNum = 0;
                     if (execCnt <= 0) {
                        btyebufArr = readDataByLineNum(dmpFilePathList, preEndLineReal, endLineReal);
                     } else {
                        btyebufArr = readDataByLineNum(dmpFilePathList, preEndLineReal, preEndLineReal + 5000);
                        lastTimeLineNum = (endLine - startLine) % 5000;
                     }

                     if (nextCnt >= 1) {
                        nextDmpStartMark = "1";
                     }

                     ++nextCnt;
                     int btyebufArrIndex = 0;
                     StringBuffer sb = new StringBuffer();
                     int lineStartIndex = 0;
                     String lastbuf16 = "";
                     String createTableEndMark = "0";
                     String buf16Str6 = "";
                     int doubleCodeCnt = 0;
                     String doubleCodeStr = "";
                     String invalidDmpFlg = "0";
                     String nextDmpStartMonitorData = "0";
                     int curLineColCnt = 0;

                     for(int hasExecCnt = 1; btyebufArrIndex <= btyebufArr.length; ++btyebufArrIndex) {
                        if (btyebufArrIndex >= btyebufArr.length) {
                           if (hasExecCnt < execCnt) {
                              btyebufArr = readDataByLineNum(dmpFilePathList, preEndLineReal + 5000 * hasExecCnt + 1, preEndLineReal + 5000 * (hasExecCnt + 1));
                              btyebufArrIndex = 0;
                           } else if (lastTimeLineNum != 0) {
                              btyebufArr = readDataByLineNum(dmpFilePathList, preEndLineReal + 5000 * hasExecCnt + 1, endLine);
                              btyebufArrIndex = 0;
                           }

                           ++hasExecCnt;
                        }

                        byte bufbyte = btyebufArr[btyebufArrIndex];
                        String buf10 = DmpCommonTool.toInt(bufbyte);
                        String buf16 = DmpCommonTool.toHex(bufbyte);
                        buf16Str6 = buf16Str6 + buf16;
                        if (buf16Str6.length() > 12) {
                           buf16Str6 = buf16Str6.substring(2);
                        }

                        if (!issys) {
                           if ("3C2F524F5753".equals(buf16Str6) && "0".equals(createTableEndMark)) {
                              createTableEndMark = "1";
                           }

                           if ("1".equals(createTableEndMark) && !issys && "3C".equals(buf16)) {
                              issys = true;
                              createTableEndMark = "0";
                           }
                        }

                        if (issys) {
                           if ("1".equals(nextDmpStartMark)) {
                              if (nextDmpHeadIndex == 4095 && "0".equals(nextDmpStartMonitorData)) {
                                 nextDmpStartMonitorData = "1";
                              }

                              ++nextDmpHeadIndex;
                              if ("1".equals(nextDmpStartMonitorData) && !buf16.equals("00") && lastbuf16.equals("00")) {
                                 String nextbuf16 = DmpCommonTool.toHex(btyebufArr[btyebufArrIndex + 1]);
                                 String next2buf16 = DmpCommonTool.toHex(btyebufArr[btyebufArrIndex + 2]);
                                 String next3buf16 = DmpCommonTool.toHex(btyebufArr[btyebufArrIndex + 3]);
                                 if ("4B".equals(buf16) && "47".equals(nextbuf16) && "43".equals(next2buf16) && "80".equals(next3buf16)) {
                                    invalidDmpFlg = "1";
                                 } else {
                                    nextDmpStartMark = "0";
                                 }

                                 nextDmpStartMonitorData = "0";
                              }
                           }

                           if ("0".equals(nextDmpStartMark)) {
                              if (lineStartIndex > 0) {
                                 if (lineStartIndex == 1) {
                                    curLineColCnt = Integer.valueOf(buf10);
                                    curLineReadedColCnt = curLineColCnt;
                                 }

                                 --lineStartIndex;
                              } else if (buf16.equals("3C") && colCnt == 0 && doubleCodeCnt == 0 && curLineReadedColCnt == 0) {
                                 lineStartIndex = 3;
                                 if (StringUtils.isNotBlank(sb.toString())) {
                                    String sbInt = sb.toString().substring(0, sb.length() - 1);
                                    if (curLineColCnt < colTypeList.size()) {
                                       int fillLen = colTypeList.size() - curLineColCnt;

                                       for(int n = 0; n < fillLen; ++n) {
                                          sbInt = sbInt + ",255";
                                       }
                                    }

                                    StringBuffer writebuf = parsingDataByLine(colTypeList, sbInt, ",", "");
                                    if (maxCnt <= 0L) {
                                       finishFlg = "1";
                                       break;
                                    }

                                    if (null != writebuf && writebuf.length() > 0 && !"1".equals(finishFlg)) {
                                       String writebufStr = writebuf.toString();
                                       String[] writebufStrArr = writebufStr.split("#_#");
                                       List<Object> list = Arrays.asList(writebufStrArr);
                                       List<Object> arrList = new ArrayList(list);
                                       arrList.remove(arrList.size() - 1);
                                       reDataLst.add(arrList);
                                    }

                                    maxCnt = maxCnt - 1L;
                                 }

                                 sb = new StringBuffer();
                              } else {
                                 if (buf16.equals("00") && lastbuf16.equals("00")) {
                                    String sbInt = sb.toString().substring(0, sb.length() - 3);
                                    if (curLineColCnt < colTypeList.size()) {
                                       int fillLen = colTypeList.size() - curLineColCnt;

                                       for(int n = 0; n < fillLen; ++n) {
                                          sbInt = sbInt + ",255";
                                       }
                                    }

                                    if (StringUtils.isNotBlank(sbInt)) {
                                       StringBuffer writebuf = parsingDataByLine(colTypeList, sbInt, ",", "");
                                       if (maxCnt <= 0L) {
                                          finishFlg = "1";
                                          break;
                                       }

                                       if (null != writebuf && writebuf.length() > 0 && !"1".equals(finishFlg)) {
                                          String writebufStr = writebuf.toString();
                                          String[] writebufStrArr = writebufStr.split("#_#");
                                          List<Object> list = Arrays.asList(writebufStrArr);
                                          List<Object> arrList = new ArrayList(list);
                                          arrList.remove(arrList.size() - 1);
                                          reDataLst.add(arrList);
                                       }

                                       maxCnt = maxCnt - 1L;
                                       new StringBuffer();
                                    }

                                    finishFlg = "1";
                                    break;
                                 }

                                 if (colCnt == 0) {
                                    if (buf10.equals("254")) {
                                       doubleCodeCnt = 2;
                                    } else if (doubleCodeCnt > 0) {
                                       doubleCodeStr = doubleCodeStr + DmpCommonTool.intToHex(Integer.valueOf(buf10));
                                       --doubleCodeCnt;
                                    } else {
                                       if (StringUtils.isNotBlank(doubleCodeStr)) {
                                          colCnt = DmpCommonTool.binary16_10(doubleCodeStr);
                                          doubleCodeStr = "";
                                       } else if ("FF".equals(buf16)) {
                                          colCnt = 0;
                                       } else {
                                          colCnt = Integer.valueOf(buf10);
                                       }

                                       --curLineReadedColCnt;
                                    }
                                 } else {
                                    --colCnt;
                                 }

                                 sb.append(buf10).append(",");
                              }
                           }
                        }

                        lastbuf16 = buf16;
                     }

                     if (dmpCnt < endLine) {
                        preEndLineReal = endLineReal + 1;
                     }
                  }
               }

               reDataLstMap.put(tablename, reDataLst);
            }
         }

         Date endDate = new Date();
         long useTime = DateTime1Tool.dateBetween(startDate, endDate);
         System.out.println(">>>>>>>>>>>>>>解析DMP数据：prasingDataByTableNameByRowNum useTime:" + useTime + "毫秒");
         return reDataLstMap;
      } else {
         return null;
      }
   }

   public static List<List<Object>> prasingNotConfirmDataByTableNameByRowNum(List<String> dmpFilePathList, String tablename, Long maxCnt, List<String> notConfirmColLst, Map<String, Object> tableInfoMap) {
      if (null != tablename && null != notConfirmColLst && 0 != notConfirmColLst.size()) {
         Map<String, String> notConfirmMap = new HashMap();

         for(int i = 0; i < notConfirmColLst.size(); ++i) {
            String notConfirmColName = (String)notConfirmColLst.get(i);
            notConfirmMap.put(notConfirmColName, "");
         }

         List<String> selectTableList = new ArrayList();
         selectTableList.add(tablename);
         Map<String, List<List<Object>>> reDataMap = prasingDataByTableNameByRowNum(dmpFilePathList, tableInfoMap, selectTableList, maxCnt);
         List<List<Object>> reDataLst = (List)reDataMap.get(tablename);
         List<TableStructureInfo> tableStructureInfoList = (List)tableInfoMap.get("tableStructureInfoList");
         Map<String, TableStructureInfo> tableStructureInfoMap = new HashMap();

         for(int i = 0; i < tableStructureInfoList.size(); ++i) {
            tableStructureInfoMap.put(((TableStructureInfo)tableStructureInfoList.get(i)).getTablename(), tableStructureInfoList.get(i));
         }

         List<ColumnInfoVO> colInfoList = ((TableStructureInfo)tableStructureInfoMap.get(tablename)).getColInfoLst();

         for(int i = 0; i < reDataLst.size(); ++i) {
            List<Object> objLst = (List)reDataLst.get(i);

            for(int j = objLst.size() - 1; j >= 0; --j) {
               String columnname = ((ColumnInfoVO)colInfoList.get(j)).getColumnname();
               if (!notConfirmMap.containsKey(columnname)) {
                  objLst.remove(j);
               }
            }
         }

         return reDataLst;
      } else {
         return null;
      }
   }

   public static void main(String[] args) {
      new Properties();

      try {
         Properties props = PropertiesLoaderUtils.loadAllProperties("config.properties");
      } catch (IOException e) {
         e.printStackTrace();
      }

      List<String> locdmpFilePathList = new ArrayList();
      List<String> dmpFilePathList = new ArrayList();

      for(int i = 0; i < 3; ++i) {
         String numStr = String.format("%02d", i + 1);
         String dmpFilePath = "TESTDP_" + numStr + ".DMP";
         locdmpFilePathList.add("D:/work/Masking_Engine/dmp/DMP解析数据类型调研/" + dmpFilePath);
         dmpFilePathList.add("/data/infa_dmp_source/" + dmpFilePath);
      }

      Map<String, Object> tableInfoMap = getAllTableinfo(locdmpFilePathList);
      long starttime = (new Date()).getTime();
      long endtime = (new Date()).getTime();
      System.out.println("截取记录耗时:" + (endtime - starttime) + "毫秒");
      List<String> selectTableList = new ArrayList();
      selectTableList.add("IP_INVPTY103");
      prasingDataByTableName(locdmpFilePathList, "191016140654_dmp2dmptest3", "IP_INVPTY104", tableInfoMap);
      List<String> tablenameList = new ArrayList();
      tablenameList.add("IP_INVPTY");
   }

   public static void test(String str) {
      String[] strArr = str.split(",");
      List<Integer> intColList = new ArrayList();

      for(int i = 0; i < strArr.length; ++i) {
         int int10 = DmpCommonTool.binary16_10(strArr[i]);
         intColList.add(int10);
      }

      String reStr = stringToGbk(intColList);
      System.out.println("reStr:" + reStr);
   }

   public static String dmpNum(String num) {
      int len = num.length();
      if (len % 2 != 0) {
         num = "0" + num;
      }

      char[] numChrArr = num.toCharArray();
      String reCode = "";
      String codeBuf = "";

      for(int i = numChrArr.length - 1; i >= 0; i -= 2) {
         String buf = numChrArr[i - 1] + String.valueOf(numChrArr[i]);
         int bufInt = Integer.valueOf(buf);
         ++bufInt;
         codeBuf = String.format("%02x", bufInt);
         reCode = codeBuf + reCode;
      }

      String preHexCode = DmpCommonTool.intToHex((numChrArr.length - 2) / 2 + 193);
      reCode = preHexCode + reCode;
      System.out.println("数字：" + num + "通过dmp转为code：  " + reCode);
      return reCode;
   }
}
