package com.chenyang.nse.bussiness.tools.jdbc;

import com.chenyang.nse.bussiness.config.PropertiesLoaderUtils;
import com.chenyang.nse.bussiness.tools.command.CommandTool;
import com.chenyang.nse.bussiness.tools.io.FileTool;
import com.chenyang.nse.bussiness.tools.xml.XmlTool;
import java.io.File;
import java.util.Map;
import java.util.Properties;

public class SybaseBcpTableTool {
   public static void createBcpInScript(Map<String, String> map) {
      try {
         new Properties();
         Properties e = PropertiesLoaderUtils.loadAllProperties("config.properties");
         String loadTableColSplit = XmlTool.getFileValue("SYBASE/db-targetdelimiter");
         String errorLog = e.get("bcp_table_sybase_error_log_target").toString();
         FileTool.createFolder(errorLog);
         String tarPageCode = "";
         if ("GBK".equals(map.get("pagecode"))) {
            tarPageCode = "cp936";
         } else if ("UTF-8".equals(map.get("pagecode"))) {
            tarPageCode = "utf8";
         } else {
            tarPageCode = (String)map.get("pagecode");
         }

         String bcpSh = "#!/bin/sh \nbcp_r " + (String)map.get("database") + "." + (String)map.get("dbschema") + "." + (String)map.get("tablename") + " in " + File.separator + "data" + File.separator + "infa_sybase" + File.separator + "target" + File.separator + (String)map.get("taskname") + File.separator + (String)map.get("tablename") + ".pipe -c -t \"" + loadTableColSplit + "\" -e " + errorLog + "error_out_" + (String)map.get("tablename") + ".log -S " + (String)map.get("servername") + " -U " + (String)map.get("user") + " -P " + (String)map.get("pwd") + " -J " + tarPageCode + " -Y";
         System.out.println(">>>>>>>bcpsh:" + bcpSh);
         FileTool.clearFileContent((String)map.get("path"));
         FileTool.writeContentToFile((String)map.get("path"), bcpSh);
         System.out.println(">>>>>>>path is :" + (String)map.get("path"));
         CommandTool.command("chmod -R 777 " + (String)map.get("path"));
      } catch (Exception e) {
         e.printStackTrace();
      }

   }

   public static void createBcpOutScript(Map<String, String> map) {
      try {
         new Properties();
         Properties e = PropertiesLoaderUtils.loadAllProperties("config.properties");
         String errorLog = e.get("bcp_table_sybase_error_log_source").toString();
         String loadTableColSplit = XmlTool.getFileValue("SYBASE/db-sourcedelimiter");
         String charset = "";
         if (((String)map.get("charset")).equals("GBK")) {
            charset = "cp936";
         } else if (((String)map.get("charset")).equals("UTF-8")) {
            charset = "utf8";
         } else {
            charset = (String)map.get("charset");
         }

         FileTool.createFolder(errorLog);
         String bcpSh = "#!/bin/sh \nbcp " + (String)map.get("database") + "." + (String)map.get("dbschema") + ".v_" + (String)map.get("tablename") + " out " + File.separator + "data" + File.separator + "infa_sybase" + File.separator + "source" + File.separator + (String)map.get("taskname") + File.separator + (String)map.get("tablename") + ".pipe -c -t \"" + loadTableColSplit + "\" -e " + errorLog + "error_out_" + (String)map.get("tablename") + ".log -S " + (String)map.get("servername") + " -U " + (String)map.get("user") + " -P " + (String)map.get("pwd") + " -J " + charset + " -Y";
         System.out.println(">>>>>>>sybase_bcp_out_sh:" + bcpSh);
         FileTool.clearFileContent((String)map.get("path"));
         FileTool.writeContentToFile((String)map.get("path"), bcpSh);
         System.out.println(">>>>>>>path is :" + (String)map.get("path"));
         CommandTool.command("chmod -R 777 " + (String)map.get("path"));
      } catch (Exception e) {
         e.printStackTrace();
      }

   }
}
