package com.chenyang.nse.bussiness.tools.system;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class SysUtils {
   public static void main(String[] args) throws Exception {
      System.out.println("CPU利用率：" + cpuUsage());
      System.out.println("内存占用率：" + memoryUsage());
      System.out.println("磁盘空间占用率：" + getDiskUsage());
   }

   public static double cpuUsage() {
      InputStream is = null;
      InputStreamReader isr = null;
      BufferedReader brStat = null;
      StringTokenizer tokenStat = null;

      try {
         Process process = Runtime.getRuntime().exec("top -b -n 1");
         is = process.getInputStream();
         isr = new InputStreamReader(is);
         brStat = new BufferedReader(isr);
         brStat.readLine();
         brStat.readLine();
         tokenStat = new StringTokenizer(brStat.readLine());
         tokenStat.nextToken();
         tokenStat.nextToken();
         tokenStat.nextToken();
         tokenStat.nextToken();
         tokenStat.nextToken();
         tokenStat.nextToken();
         tokenStat.nextToken();
         String cpuUsage = tokenStat.nextToken();
         System.out.println("CPU idle : " + cpuUsage);
         Double usage = new Double(cpuUsage);
         usage = (double)(100.0F - usage.floatValue());
         BigDecimal b1 = new BigDecimal(usage);
         usage = b1.setScale(2, 4).doubleValue();
         return usage;
      } catch (Exception var8) {
         return (double)0.0F;
      }
   }

   public static double memoryUsage() {
      Map<String, Object> map = new HashMap();
      InputStreamReader inputs = null;
      BufferedReader buffer = null;

      try {
         inputs = new InputStreamReader(new FileInputStream("/proc/meminfo"));
         buffer = new BufferedReader(inputs);
         String line = "";

         while(true) {
            line = buffer.readLine();
            if (line == null) {
               long memTotal = Long.parseLong(map.get("MemTotal").toString());
               long memFree = Long.parseLong(map.get("MemFree").toString());
               long memused = memTotal - memFree;
               long buffers = Long.parseLong(map.get("Buffers").toString());
               long cached = Long.parseLong(map.get("Cached").toString());
               double usage = (double)(memused - buffers - cached) / (double)memTotal * (double)100.0F;
               BigDecimal b1 = new BigDecimal(usage);
               usage = b1.setScale(2, 4).doubleValue();
               double var17 = usage;
               return var17;
            }

            int beginIndex = 0;
            int endIndex = line.indexOf(":");
            if (endIndex != -1) {
               String key = line.substring(beginIndex, endIndex);
               beginIndex = endIndex + 1;
               endIndex = line.length();
               String memory = line.substring(beginIndex, endIndex);
               String value = memory.replace("kB", "").trim();
               map.put(key, value);
            }
         }
      } catch (Exception e) {
         e.printStackTrace();
      } finally {
         try {
            buffer.close();
            inputs.close();
         } catch (Exception e2) {
            e2.printStackTrace();
         }

      }

      return (double)0.0F;
   }

   public static double getDiskUsage() throws Exception {
      double totalHD = (double)0.0F;
      double usedHD = (double)0.0F;
      Runtime rt = Runtime.getRuntime();
      Process p = rt.exec("df -hl");
      BufferedReader in = null;

      try {
         in = new BufferedReader(new InputStreamReader(p.getInputStream()));
         String str = null;
         String[] strArray = null;

         while((str = in.readLine()) != null) {
            int m = 0;
            strArray = str.split(" ");

            for(String tmp : strArray) {
               if (tmp.trim().length() != 0) {
                  ++m;
                  if (tmp.indexOf("G") != -1) {
                     if (m == 2 && !tmp.equals("") && !tmp.equals("0")) {
                        totalHD += Double.parseDouble(tmp.substring(0, tmp.length() - 1)) * (double)1024.0F;
                     }

                     if (m == 3 && !tmp.equals("none") && !tmp.equals("0")) {
                        usedHD += Double.parseDouble(tmp.substring(0, tmp.length() - 1)) * (double)1024.0F;
                     }
                  }

                  if (tmp.indexOf("M") != -1) {
                     if (m == 2 && !tmp.equals("") && !tmp.equals("0")) {
                        totalHD += Double.parseDouble(tmp.substring(0, tmp.length() - 1));
                     }

                     if (m == 3 && !tmp.equals("none") && !tmp.equals("0")) {
                        usedHD += Double.parseDouble(tmp.substring(0, tmp.length() - 1));
                     }
                  }
               }
            }
         }

         double precent = usedHD / totalHD * (double)100.0F;
         BigDecimal b1 = new BigDecimal(precent);
         precent = b1.setScale(2, 4).doubleValue();
         double var24 = precent;
         return var24;
      } catch (Exception var17) {
      } finally {
         in.close();
      }

      return (double)0.0F;
   }

   public static Map<?, ?> cpuinfo() {
      InputStreamReader inputs = null;
      BufferedReader buffer = null;
      Map<String, Object> map = new HashMap();

      try {
         inputs = new InputStreamReader(new FileInputStream("/proc/stat"));
         buffer = new BufferedReader(inputs);
         String line = "";

         while(true) {
            line = buffer.readLine();
            if (line == null) {
               break;
            }

            if (line.startsWith("cpu")) {
               StringTokenizer tokenizer = new StringTokenizer(line);
               List<String> temp = new ArrayList();

               while(tokenizer.hasMoreElements()) {
                  String value = tokenizer.nextToken();
                  temp.add(value);
               }

               map.put("user", temp.get(1));
               map.put("nice", temp.get(2));
               map.put("system", temp.get(3));
               map.put("idle", temp.get(4));
               map.put("iowait", temp.get(5));
               map.put("irq", temp.get(6));
               map.put("softirq", temp.get(7));
               map.put("stealstolen", temp.get(8));
               break;
            }
         }
      } catch (Exception e) {
         e.printStackTrace();
      } finally {
         try {
            buffer.close();
            inputs.close();
         } catch (Exception e2) {
            e2.printStackTrace();
         }

      }

      return map;
   }
}
