package com.chenyang.nse.bussiness.webtools.tools.string;

import java.security.MessageDigest;
import java.util.*;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class StringTool {
   private static final String[] hexDigits = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "a", "b", "c", "d", "e", "f"};
   private static final String[] splitArray = new String[]{"*", "^", ":", "|", ".", "\\"};

   public static String generatePassword(String inputString) {
      return encodeByMD5(inputString);
   }

   public static String getTablePrimaryKey() {
      String uuid = UUID.randomUUID().toString().replace("-", "");
      return uuid;
   }

   private static String encodeByMD5(String originString) {
      if (originString != null) {
         try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] results = md.digest(originString.getBytes());
            String resultString = byteArrayToHexString(results);
            return resultString.toUpperCase();
         } catch (Exception var4) {
         }
      }

      return null;
   }

   private static String byteArrayToHexString(byte[] b) {
      StringBuffer resultSb = new StringBuffer();

      for(int i = 0; i < b.length; ++i) {
         resultSb.append(byteToHexString(b[i]));
      }

      return resultSb.toString();
   }

   private static String byteToHexString(byte b) {
      int n = b;
      if (b < 0) {
         n = 256 + b;
      }

      int d1 = n / 16;
      int d2 = n % 16;
      return hexDigits[d1] + hexDigits[d2];
   }

   public static String charTransfor(String s) {
      String str = null;
      switch (s) {
         case ".":
            str = "u002E";
            break;
         case "$":
            str = "u0024";
            break;
         case "^":
            str = "u005E";
            break;
         case "{":
            str = "u007B";
            break;
         case "[":
            str = "u005B";
            break;
         case "(":
            str = "u0028";
            break;
         case "|":
            str = "\\|";
            break;
         case ")":
            str = "u0029";
            break;
         case "*":
            str = "u002A";
            break;
         case "+":
            str = "u002B";
            break;
         case "?":
            str = "u003F";
      }

      return str != null ? str : s;
   }

   public static String stringToAscii(String str) {
      char[] chars = str.toCharArray();
      System.out.println("\n\n汉字 ASCII\n----------------------");

      for(int i = 0; i < chars.length; ++i) {
         System.out.println(" " + chars[i] + " " + chars[i]);
      }

      return null;
   }

   public static boolean emptyOrNull(String str) {
      return str != null && !"".equals(str) ? Boolean.FALSE : Boolean.TRUE;
   }

   public static List<Integer> getSubStringIndex(String str, String substring) {
      int length = substring.length();
      if (length == 0) {
         return null;
      } else {
         List<Integer> list = new ArrayList();
         int index = 0;

         for(int i = 0; i < str.length(); index = i++) {
            String temp = str.substring(index, index + length);
            if (temp.equals(substring)) {
               list.add(index);
               i += length;
            }
         }

         return list;
      }
   }

   public static List<String> widthSpliter(String inputString, int byteLength) {
      List list = null;
      int length = inputString.length();
      int size = length / byteLength;

      for(int i = 0; i < size; ++i) {
         if (list == null) {
            list = new ArrayList();
         }

         String substring = inputString.substring(i * byteLength, i * byteLength + byteLength);
         list.add(substring);
      }

      return list;
   }

   public static List<String> charSpliter(String inputString, String ch) {
      String[] array = StringUtils.split(inputString, ch);
      List<String> list = Arrays.asList(array);
      return list;
   }

   public static List<String> charSpliter(String inputString, String ch, String seria) {
      List<String> list = new ArrayList();
      if (inputString.indexOf(ch) < 0) {
         list.add(inputString);
         return list;
      } else if ("0".equals(seria)) {
         String[] array = StringUtils.splitPreserveAllTokens(inputString, ch);
         list = Arrays.asList(array);
         return list;
      } else if ("1".equals(seria)) {
         if (inputString.indexOf(ch) == 0) {
            list.add(0, "");
         }

         String[] array = StringUtils.splitByWholeSeparator(inputString, ch);
         list.addAll(Arrays.asList(array));
         return list;
      } else {
         return list;
      }
   }

   public static List<String> StringSpliter(String inputString, String ch, String multi) {
      List<String> list = new ArrayList();
      if ("0".equals(multi)) {
         String[] array = StringUtils.splitPreserveAllTokens(inputString, ch);
         list = Arrays.asList(array);
         return list;
      } else if ("1".equals(multi)) {
         char[] c = ch.toCharArray();
         String temp = "";

         for(int i = 0; i < c.length; ++i) {
            temp = temp + (String.valueOf(c[i]).equals("|") ? "\\|" : String.valueOf(c[i]));
         }

         String[] array = inputString.split(temp);
         list = Arrays.asList(array);
         return list;
      } else {
         return list;
      }
   }

   public static List<String> widthSpliter(String str, String w) {
      List<String> list = new ArrayList();
      String[] width = w.split(",");
      int start = 0;

      for(int i = 0; i < width.length; ++i) {
         int end = Integer.valueOf(width[i]);
         list.add(str.substring(start, end));
         start = end;
      }

      return list;
   }

   public static List<String> widthSpliter(String str, List<String> w) {
      StringBuffer sb = new StringBuffer();
      int temp = 0;

      for(int i = 0; i < w.size(); ++i) {
         if (i == 0) {
            sb.append(String.valueOf(Integer.valueOf((String)w.get(i))));
            temp = Integer.valueOf((String)w.get(i));
         } else {
            sb.append(",");
            temp += Integer.valueOf((String)w.get(i));
            sb.append(String.valueOf(temp));
         }
      }

      return widthSpliter(str, sb.toString());
   }

   public static List<List<String>> widthSpliter(List<String> str, List<String> w) {
      List<List<String>> list = new ArrayList();

      for(String item : str) {
         List<String> temp = widthSpliter(item.replace(" ", ""), w);
         list.add(temp);
      }

      List<List<String>> result = new ArrayList();

      for(int i = 0; i < w.size(); ++i) {
         List<String> temp = new ArrayList();

         for(List<String> item : list) {
            temp.add(item.get(i));
         }

         result.add(temp);
      }

      return result;
   }

   public static int substringNumbers(String str, String substring) {
      if (str.indexOf(substring) == -1) {
         return 0;
      } else if (str.indexOf(substring) != -1) {
         String uuid = UUID.randomUUID().toString().replaceAll("-", "");
         String s = str.replaceAll(substring, uuid);
         String[] arr = s.split(uuid);
         return arr.length - 1;
      } else {
         return 0;
      }
   }

   public static List<String> splitString(String str, char split) {
      List<String> list = new ArrayList();
      int index = 0;

      for(int i = 0; i < str.length(); ++i) {
         if (str.charAt(i) == split) {
            list.add(str.substring(index, i));
            index = i + 1;
         }
      }

      list.add(str.substring(index, str.length()));
      return list;
   }

   public static List<List<String>> splitString(List<String> str, String split, int num) {
      List<List<String>> list = new ArrayList();
      List<List<String>> result = new ArrayList();

      for(String item : str) {
         List<String> temp = splitString(item, split, false);
         if (temp.size() == num) {
            list.add(temp);
         }
      }

      int size = 0;

      try {
         size = ((List)list.get(0)).size();
      } catch (Exception e) {
         System.out.println("系统分析的字段和设置的字段数对应不上");
         e.printStackTrace();
      }

      for(int i = 0; i < size; ++i) {
         List<String> temp = new ArrayList();

         for(List<String> item : list) {
            temp.add(item.get(i));
         }

         result.add(temp);
      }

      return result;
   }

   public static List<List<String>> splitString(List<String> str, String split, int num, String quotecharacter) throws Exception {
      List<List<String>> list = new ArrayList();
      List<List<String>> result = new ArrayList();

      for(String item : str) {
         List<String> temp = splitString(item, split, false);
         if (temp.size() == num) {
            if ("double".equals(quotecharacter)) {
               List<String> templist = new ArrayList();

               for(String tempstr : temp) {
                  tempstr = tempstr.replace("\"", "");
                  templist.add(tempstr);
               }

               list.add(templist);
            } else if (!"single".equals(quotecharacter)) {
               list.add(temp);
            } else {
               List<String> templist = new ArrayList();

               for(String tempstr : temp) {
                  tempstr = tempstr.replace("'", "");
                  templist.add(tempstr);
               }

               list.add(templist);
            }
         }
      }

      int size = 0;
      size = ((List)list.get(0)).size();

      for(int i = 0; i < size; ++i) {
         List<String> temp = new ArrayList();

         for(List<String> item : list) {
            temp.add(item.get(i));
         }

         result.add(temp);
      }

      return result;
   }

   public static List<String> splitString(String str, String split, boolean group) {
      List<String> list = new ArrayList();
      int index = 0;
      if (group) {
         for(int i = 0; i < str.length() && split.length() + i <= str.length(); ++i) {
            StringBuffer ac = new StringBuffer();

            for(int j = 0; j < split.length(); ++j) {
               if (!isLetterDigitOrChinese(split.substring(j, j + 1))) {
                  ac.append("\\");
               }

               ac.append(split.substring(j, j + 1));
            }

            String[] arr = str.split(ac.toString());
            list = Arrays.asList(arr);
         }
      } else {
         char[] c = split.toCharArray();
         Arrays.sort(c);

         for(int i = 0; i < str.length(); ++i) {
            if (Arrays.binarySearch(c, str.charAt(i)) >= 0) {
               list.add(str.substring(index, i));
               index = i + 1;
            }
         }

         list.add(str.substring(index, str.length()));
      }

      return list;
   }

   public static List<String> splitString(String str, String split, boolean group, String escape) {
      if (escape != null && !"".equals(escape)) {
         List<String> list = new ArrayList();
         int index = 0;
         if (group) {
            for(int i = 0; i < str.length() && split.length() + i <= str.length(); ++i) {
               StringBuffer ac = new StringBuffer();

               for(int j = 0; j < split.length(); ++j) {
                  if (!isLetterDigitOrChinese(split.substring(j, j + 1))) {
                     ac.append("\\");
                  }

                  ac.append(split.substring(j, j + 1));
               }

               String[] arr = str.split(ac.toString());
               list = Arrays.asList(arr);
            }
         } else {
            char[] c = split.toCharArray();
            Arrays.sort(c);

            for(int i = 0; i < str.length(); ++i) {
               if (i > 0) {
                  String last = str.substring(i - 1, i);
                  if (last.equals(escape)) {
                     continue;
                  }
               }

               if (Arrays.binarySearch(c, str.charAt(i)) >= 0) {
                  list.add(str.substring(index, i));
                  index = i + 1;
               }
            }

            list.add(str.substring(index, str.length()));
         }

         return list;
      } else {
         return splitString(str, split, group);
      }
   }

   public static boolean isLetterDigitOrChinese(String str) {
      String regex = "^[a-z0-9A-Z一-龥]+$";
      return str.matches(regex);
   }

   public static List<String> splitString(String str, String split, boolean group, String escape, String limit) {
      if (limit != null && !"".equals(limit)) {
         List<Integer> indexlist = getSubStringIndex(str, limit);
         List<String> list = new ArrayList();
         int index = 0;
         if (group) {
            for(int i = 0; i < str.length() && split.length() + i <= str.length(); ++i) {
               str = str.replace(escape, "");
               StringBuffer ac = new StringBuffer();

               for(int j = 0; j < split.length(); ++j) {
                  ac.append(Arrays.asList(splitArray).contains(split.substring(j, j + 1)) ? "\\" + split.substring(j, j + 1) : split.substring(j, j + 1));
               }

               String[] arr = str.split(ac.toString());
               list = Arrays.asList(arr);
            }

            str.split(limit);
         } else {
            char[] c = split.toCharArray();
            Arrays.sort(c);

            for(int i = 0; i < str.length(); ++i) {
               if (i > 0) {
                  String last = str.substring(i - 1, i);
                  if (last.equals(escape)) {
                     continue;
                  }
               }

               if (Arrays.binarySearch(c, str.charAt(i)) >= 0 && !checkLimit(i, indexlist)) {
                  list.add(str.substring(index, i));
                  index = i + 1;
               }
            }

            list.add(str.substring(index, str.length()));
         }

         List<String> list1 = new ArrayList();
         new ArrayList();
         String pin = "";
         if (!"".equals(split)) {
            for(String s1 : list) {
               if (!"".equals(escape)) {
                  s1 = s1.replace(escape, "");
               }

               if (countInnerStr(s1, limit) == 1) {
                  pin = pin + s1 + split;
                  if (countInnerStr(pin, limit) == 2) {
                     pin = pin.substring(0, pin.length() - split.length());
                     list1.add(pin);
                     pin = "";
                  }
               } else {
                  list1.add(s1);
               }
            }
         } else {
            list1 = list;
         }

         return list1;
      } else {
         return splitString(str, split, group, escape);
      }
   }

   public static boolean checkLimit(int index, List<Integer> indexlist) {
      boolean result = false;

      for(int i = 0; i < indexlist.size(); ++i) {
         if (index > (Integer)indexlist.get(i) && index < (Integer)indexlist.get(i + 1)) {
            result = true;
            break;
         }

         ++i;
      }

      return result;
   }

   public static List<String> toUpperCaseList(List<String> list) {
      List<String> newlist = new ArrayList();

      for(String str : list) {
         newlist.add(str.toUpperCase());
      }

      return newlist;
   }

   public static void main(String[] args) {
      String str = "abc,十分士大夫,dsdddfsddsd";
      str = "\"a\",\"a,b\"";
      str = "\"a\",,,\"a,b\"";
      str = "\"aaaaa\",\"a,,,,,b\",\"ab\"\"\"";
      String limit = "\"";
      String split = ",";
      String[] dataArr = str.split(limit);
      List<String> list = Arrays.asList(dataArr);
      List<String> list1 = new ArrayList();

      for(int i = 0; i < list.size(); ++i) {
         list1.add(list.get(i));
      }

      for(int i = 0; i < list1.size(); ++i) {
         if (split.equals(list1.get(i))) {
            list1.remove(i);
            --i;
         } else if ((split + split).equals(list1.get(i))) {
            list1.remove(i);
            --i;
         } else {
            System.out.println((String)list1.get(i));
         }
      }

   }

   public static String delparentheses(String type) {
      if (type.indexOf("(") == -1) {
         if (StringUtils.isNotBlank(type)) {
            type = type.trim();
         }

         return type;
      } else {
         type = type.indexOf("(") == -1 ? type : type.substring(0, type.indexOf("(")) + type.substring(type.indexOf(")") + 1, type.length());
         return delparentheses(type);
      }
   }

   public static Boolean columnnameLikeMethod(String name, String columnname) {
      String eColumnname = columnname.replace("%", "");
      if (columnname.contains("%")) {
         if (columnname.endsWith("%") && columnname.startsWith("%")) {
            return name.contains(eColumnname);
         }

         if (columnname.endsWith("%")) {
            return name.startsWith(eColumnname);
         }

         if (columnname.startsWith("%")) {
            return name.endsWith(eColumnname);
         }
      }

      return name.contains(eColumnname);
   }

   public static String[] arraySort(String[] input) {
      for(int i = 0; i < input.length - 1; ++i) {
         for(int j = 0; j < input.length - i - 1; ++j) {
            if (input[j].compareTo(input[j + 1]) > 0) {
               String temp = input[j];
               input[j] = input[j + 1];
               input[j + 1] = temp;
            }
         }
      }

      return input;
   }

   public static int countInnerStr(String str, String patternStr) {
      int count = 0;
      Pattern r = Pattern.compile(patternStr);

      for(Matcher m = r.matcher(str); m.find(); ++count) {
      }

      return count;
   }

   public static String toStringHex(String s) {
      byte[] baKeyword = new byte[s.length() / 2];

      for(int i = 0; i < baKeyword.length; ++i) {
         try {
            baKeyword[i] = (byte)(255 & Integer.parseInt(s.substring(i * 2, i * 2 + 2), 16));
         } catch (Exception e) {
            e.printStackTrace();
         }
      }

      try {
         s = new String(baKeyword, "utf-8");
      } catch (Exception e1) {
         e1.printStackTrace();
      }

      return s;
   }

   public static void mapCopy(Map paramsMap, Map resultMap) {
      if (resultMap == null)
         resultMap = new HashMap<>();
      if (paramsMap == null)
         return;
      Iterator<Map.Entry> it = paramsMap.entrySet().iterator();
      while (it.hasNext()) {
         Map.Entry entry = it.next();
         Object key = entry.getKey();
         resultMap.put(key, (paramsMap.get(key) != null) ? paramsMap.get(key) : "");
      }
   }
}
