package com.chenyang.nse.bussiness.controller.core.config;

import com.chenyang.nse.bussiness.config.PropertiesLoaderUtils;
import com.chenyang.nse.bussiness.dao.PageInfo;
import com.chenyang.nse.bussiness.entity.cache.LoginUser;
import com.chenyang.nse.bussiness.entity.orm.table.core.config.TcoreBaseConfig;
import com.chenyang.nse.bussiness.entity.vo.ComboboxVO;
import com.chenyang.nse.bussiness.entity.vo.DataGridVO;
import com.chenyang.nse.bussiness.service.core.PropertiesEditService;
import com.chenyang.nse.bussiness.service.core.config.BaseConfigService;
import com.chenyang.nse.bussiness.tools.io.FileTool;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.dom4j.DocumentException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping({"/core/config"})
public class BaseConfigController {
   public static final String USER_NAME = "admin";
   @Autowired
   private PropertiesEditService propertiesEditService;
   @Autowired
   private BaseConfigService baseConfigService;

   @RequestMapping
   public String index(HttpServletRequest request, HttpServletResponse response, Model model, Integer pageCurr) {
      LoginUser loginUser = (LoginUser)request.getSession().getAttribute("loginUser");
      String username = loginUser.getTsysUser().getUsername();
      boolean u = false;
      if (username != null && "admin".equals(username)) {
         u = true;
      } else {
         u = false;
      }

      model.addAttribute("loginUser111", u);
      return "core/config/configlist";
   }

   @RequestMapping({"/getUser"})
   @ResponseBody
   public boolean getUser(HttpServletRequest request, HttpServletResponse response, Model model, Integer pageCurr) {
      LoginUser loginUser = (LoginUser)request.getSession().getAttribute("loginUser");
      String username = loginUser.getTsysUser().getUsername();
      return username != null && "admin".equals(username);
   }

   @RequestMapping({"/configList"})
   @ResponseBody
   public DataGridVO<TcoreBaseConfig> configList(Integer page, Integer rows, PageInfo pageInfo, String groupName, String categoryName, HttpServletRequest request, HttpServletResponse response, Model model, Integer pageCurr) {
      pageInfo.setPageno(page);
      pageInfo.setPagesize(rows);
      List<TcoreBaseConfig> list = this.baseConfigService.getConfigList(pageInfo, groupName, categoryName);
      DataGridVO<TcoreBaseConfig> vo = new DataGridVO<TcoreBaseConfig>(pageInfo.getCount(), list);
      return vo;
   }

   @ResponseBody
   @RequestMapping({"/getConfigById"})
   public TcoreBaseConfig getConfigById(String id, HttpServletRequest request, HttpServletResponse response, Model model) {
      return this.baseConfigService.getConfigById(id);
   }

   @RequestMapping({"/addConfig"})
   @ResponseBody
   public void addConfig(String id, String configName, String configNote, String configValue, int isEffectiveImmediately, String groupName, String categoryName, HttpServletRequest request, HttpServletResponse response, Model model, Integer pageCurr) {
      TcoreBaseConfig tcoreBaseConfig = new TcoreBaseConfig();
      if (id != null) {
         tcoreBaseConfig = this.baseConfigService.getConfigById(id);
      }

      tcoreBaseConfig.setConfig_value(configValue);
      tcoreBaseConfig.setUpdate_time(new Date());
      tcoreBaseConfig.setGroup_name(groupName);
      tcoreBaseConfig.setConfig_note(configNote);
      tcoreBaseConfig.setConfig_name(configName);
      tcoreBaseConfig.setCategory_name(categoryName);
      tcoreBaseConfig.setIs_effective_immediately(isEffectiveImmediately);
      if (id == null) {
         tcoreBaseConfig.setConfig_demo(configValue);
         tcoreBaseConfig.setCreate_time(new Date());
         this.baseConfigService.addConfig(tcoreBaseConfig);
      } else {
         tcoreBaseConfig.setCategory_name(categoryName);
         tcoreBaseConfig.setId(id);
         this.baseConfigService.updateConfig(tcoreBaseConfig);
         if (tcoreBaseConfig.getCategory_name().equals("数据库配置") && tcoreBaseConfig.getConfig_name().indexOf("db-") == 0) {
            try {
               FileTool.updateXml(tcoreBaseConfig.getGroup_name().toUpperCase() + "/" + tcoreBaseConfig.getConfig_name(), tcoreBaseConfig.getConfig_value());
            } catch (IOException | DocumentException e) {
               ((Exception)e).printStackTrace();
            }
         } else {
            try {
               FileTool.updateProperties(tcoreBaseConfig.getConfig_name(), tcoreBaseConfig.getConfig_value());
            } catch (IOException e) {
               e.printStackTrace();
            }
         }
      }

   }

   @RequestMapping({"/reduction"})
   @ResponseBody
   public void reduction(String id) {
      new TcoreBaseConfig();
      TcoreBaseConfig tcoreBaseConfig = this.baseConfigService.getConfigById(id);
      tcoreBaseConfig.setConfig_value(tcoreBaseConfig.getConfig_demo());
      this.baseConfigService.updateConfig(tcoreBaseConfig);
      if (tcoreBaseConfig.getCategory_name().equals("数据库配置") && tcoreBaseConfig.getConfig_name().indexOf("db-") == 0) {
         try {
            FileTool.updateXml(tcoreBaseConfig.getGroup_name().toUpperCase() + "/" + tcoreBaseConfig.getConfig_name(), tcoreBaseConfig.getConfig_value());
         } catch (IOException | DocumentException e) {
            ((Exception)e).printStackTrace();
         }
      } else {
         try {
            FileTool.updateProperties(tcoreBaseConfig.getConfig_name(), tcoreBaseConfig.getConfig_value());
         } catch (IOException e) {
            e.printStackTrace();
         }
      }

   }

   @RequestMapping({"/getCategoryNameList"})
   @ResponseBody
   public List<ComboboxVO> getCategoryNameList(HttpServletRequest request, HttpServletResponse response, Model model, Integer pageCurr) {
      List<String> list = this.baseConfigService.getCategoryNameList();
      List<ComboboxVO> result = new ArrayList();

      for(int i = 0; i < list.size(); ++i) {
         result.add(new ComboboxVO((String)list.get(i)));
      }

      return result;
   }

   @RequestMapping({"/getGroupNameList"})
   @ResponseBody
   public List<ComboboxVO> getGroupNameList(String categoryId, HttpServletRequest request, HttpServletResponse response, Model model, Integer pageCurr) {
      List<String> list = this.baseConfigService.getGroupNameList(categoryId);
      List<ComboboxVO> result = new ArrayList();
      result.add(new ComboboxVO("全部"));

      for(int i = 0; i < list.size(); ++i) {
         result.add(new ComboboxVO((String)list.get(i)));
      }

      return result;
   }

   @RequestMapping({"/removeConfig"})
   @ResponseBody
   public String removeConfig(String categoryName, String categoryId, HttpServletRequest request, HttpServletResponse response, Model model, Integer pageCurr) {
      this.baseConfigService.removeConfigById(categoryId);
      String configCnt = this.baseConfigService.getConfigCnt(categoryName);
      return configCnt;
   }

   @RequestMapping({"/getValueToConfig"})
   @ResponseBody
   public boolean getValueToConfig(String configName, String configValue, HttpServletRequest request, HttpServletResponse response, Model model) {
      new Properties();
      boolean result = false;

      try {
         Properties props = PropertiesLoaderUtils.loadAllProperties("config.properties");
         String property = props.getProperty(configName);
         if (configValue.equalsIgnoreCase(property)) {
            result = true;
         } else {
            result = false;
         }
      } catch (IOException e) {
         e.printStackTrace();
      }

      return result;
   }
}
