package com.chenyang.nse.bussiness.controller.console;

import com.chenyang.nse.bussiness.entity.orm.table.base.TBaseRole;
import com.chenyang.nse.bussiness.entity.orm.table.console.TConsolePrivilege;
import com.chenyang.nse.bussiness.enumeration.Eprivilege;
import com.chenyang.nse.bussiness.service.console.PrivilegeService;
import com.chenyang.nse.bussiness.service.console.RoleService;
import java.util.Arrays;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping({"/console/privilege"})
public class PrivilegeController {
   @Autowired
   private PrivilegeService privilegeService;
   @Autowired
   private RoleService roleService;

   @RequestMapping
   public String index(HttpServletRequest request, HttpServletResponse response, Model model) {
      List<TBaseRole> rolelist = this.roleService.queryRoleByFlag("1");
      List<Eprivilege> privilegelist = Arrays.asList(Eprivilege.values());
      model.addAttribute("rolelist", rolelist);
      model.addAttribute("privilegelist", privilegelist);
      return "console/privilege";
   }

   @RequestMapping({"/save"})
   @ResponseBody
   public void save(String roleId, @RequestParam(value = "privileges[]",required = false) List<String> privileges, HttpServletRequest request, HttpServletResponse response, Model model) {
      this.privilegeService.save(roleId, privileges);
   }

   @RequestMapping({"/queryPrivilegeByRoleId"})
   @ResponseBody
   public List<TConsolePrivilege> queryPrivilegeByRoleId(String roleId, HttpServletRequest request, HttpServletResponse response, Model model) {
      List<TConsolePrivilege> list = this.privilegeService.queryPrivilegeByRoleId(roleId);
      return list;
   }
}
