package com.chenyang.nse.bussiness.controller.core;

import com.chenyang.nse.bussiness.commmon.json.RespHelper;
import com.chenyang.nse.bussiness.commmon.json.Response;
import com.chenyang.nse.bussiness.entity.orm.table.core.notice.SyslogInfomation;
import com.chenyang.nse.bussiness.service.core.SysLogService;
import com.chenyang.nse.bussiness.tools.login.CommonUtils;
import com.chenyang.nse.bussiness.tools.msg.MesUtil;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping({"/core/syslog"})
public class SysLogController {
   private static Logger logger = LoggerFactory.getLogger(ControlledAssetController.class);
   @Autowired
   private SysLogService sysLogService;
   private static final Logger ddmauditLogger = LoggerFactory.getLogger("ddmauditLogger");
   private static final Logger operationLogger = LoggerFactory.getLogger("operationLogger");

   @RequestMapping({"/queryAll"})
   @ResponseBody
   public Response query(@RequestParam Map<String, String> params, HttpServletRequest request, HttpServletResponse response, Model model) {
      List<SyslogInfomation> list = this.sysLogService.queryAll();
      ddmauditLogger.info(MesUtil.getMsg("DDM_01902", new String[]{CommonUtils.loginUsername(), CommonUtils.loginUsername()}));
      return RespHelper.successResp(list);
   }

   @RequestMapping({"/initEdit"})
   @ResponseBody
   public Response<SyslogInfomation> initControlledAsset(@RequestParam Map<String, String> params) {
      String id = String.valueOf(params.get("id"));
      ddmauditLogger.info(MesUtil.getMsg("DDM_01904", new String[]{CommonUtils.loginUsername(), CommonUtils.loginUsername()}));
      if (id != null && id.toString().length() != 0) {
         SyslogInfomation email = this.sysLogService.initSyslog(id);
         return RespHelper.<SyslogInfomation>successResp(email);
      } else {
         return RespHelper.<SyslogInfomation>paramErrResp();
      }
   }

   @PostMapping({"/add"})
   @ResponseBody
   public Response<SyslogInfomation> addControlledAsset(@RequestBody SyslogInfomation syslogInfomation, HttpServletRequest request) {
      if (StringUtils.isBlank(syslogInfomation.getId())) {
         ddmauditLogger.info(MesUtil.getMsg("DDM_01904", new String[]{CommonUtils.loginUsername(), syslogInfomation.getHostname()}));
      } else {
         ddmauditLogger.info(MesUtil.getMsg("DDM_01903", new String[]{CommonUtils.loginUsername(), syslogInfomation.getHostname()}));
      }

      this.sysLogService.addSyslog(syslogInfomation);
      return RespHelper.<SyslogInfomation>successResp(syslogInfomation);
   }

   @PostMapping({"/del"})
   @ResponseBody
   public Response remove(@RequestBody Map<String, Object> params, HttpServletRequest request, HttpServletResponse response, Model model) {
      String id = (String)params.get("id");
      String name = (String)params.get("hostname");
      ddmauditLogger.info(MesUtil.getMsg("DDM_01905", new String[]{CommonUtils.loginUsername(), name}));
      this.sysLogService.remove(id);
      return RespHelper.successResp();
   }
}
