package com.chenyang.nse.bussiness.controller.core;

import com.chenyang.nse.bussiness.dao.PageInfo;
import com.chenyang.nse.bussiness.entity.vo.DataGridVO;
import com.chenyang.nse.bussiness.entity.vo.ResultVO;
import com.chenyang.nse.bussiness.entity.vo.TreeGridVO;
import com.chenyang.nse.bussiness.service.core.SystemParameterService;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping({"/core/systemparameter"})
public class SystemParameterController {
   @Autowired
   private SystemParameterService systemParameterService;

   @RequestMapping
   public String index(HttpServletRequest request, HttpServletResponse response, Model model) {
      return "core/systemparameter/systemparameter";
   }

   @RequestMapping({"/querysystemparameter"})
   @ResponseBody
   public DataGridVO<Map<String, Object>> querysystemparameter(Integer page, Integer rows) {
      PageInfo pageInfo = new PageInfo();
      pageInfo.setPageno(page);
      pageInfo.setPagesize(rows);
      List<Map<String, Object>> list = this.systemParameterService.querySystemParameter(pageInfo);
      return new DataGridVO<Map<String, Object>>(pageInfo.getCount(), list);
   }

   @RequestMapping({"/querydir"})
   @ResponseBody
   public List<TreeGridVO> querydir(String parentid, String path) {
      return this.systemParameterService.queryDir(parentid, path);
   }

   @RequestMapping({"/addsystemparameter"})
   @ResponseBody
   public void addsystemparameter(@RequestParam Map<String, String> map) {
      this.systemParameterService.addSystemParameter(map);
   }

   @RequestMapping({"/removesystemparameter"})
   @ResponseBody
   public void removesystemparameter(String id) {
      this.systemParameterService.removeSystemParameter(id);
   }

   @RequestMapping({"/repeatname"})
   @ResponseBody
   public ResultVO repeatname(String parametername) {
      return this.systemParameterService.repeatName(parametername);
   }
}
