package com.chenyang.nse.bussiness.controller.core;

import com.chenyang.nse.bussiness.commmon.json.RespHelper;
import com.chenyang.nse.bussiness.commmon.json.Response;
import com.chenyang.nse.bussiness.config.HibernateConfig;
import com.chenyang.nse.bussiness.config.PropertiesLoaderUtils;
import com.chenyang.nse.bussiness.dao.PageInfo;
import com.chenyang.nse.bussiness.dao.table.core.dataproject.TCoreDiscoverySysdataDao;
import com.chenyang.nse.bussiness.entity.orm.table.console.TConsoleSearchregex;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreDatasystem;
import com.chenyang.nse.bussiness.entity.orm.table.core.dataproject.TCoreDiscoverySysdata;
import com.chenyang.nse.bussiness.entity.orm.table.core.dataproject.TCoreProjectAllrule;
import com.chenyang.nse.bussiness.entity.orm.table.core.dataproject.TCoreProjectFile;
import com.chenyang.nse.bussiness.entity.orm.table.core.discovery.TcoreDiscoveryDataResult;
import com.chenyang.nse.bussiness.entity.orm.table.core.discovery.TcoreDiscoveryResult;
import com.chenyang.nse.bussiness.entity.orm.table.core.discovery.TcoreDiscoveryTask;
import com.chenyang.nse.bussiness.entity.vo.DataGridVO;
import com.chenyang.nse.bussiness.entity.vo.DiscoveryResultVO;
import com.chenyang.nse.bussiness.entity.vo.datascope.RqSaveEditionParamsVO;
import com.chenyang.nse.bussiness.service.console.SearchRegexService;
import com.chenyang.nse.bussiness.service.core.DataSystemService;
import com.chenyang.nse.bussiness.service.core.TdataDiscoveryResultService;
import com.chenyang.nse.bussiness.service.core.TdataDiscoveryService;
import com.chenyang.nse.bussiness.tools.login.CommonUtils;
import com.chenyang.nse.bussiness.tools.msg.MesUtil;
import com.chenyang.nse.bussiness.tools.object.ObjectTool;
import com.chenyang.nse.bussiness.tools.office.ExcelTool;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@Controller
@RequestMapping({"/core/tdiscoverresult"})
public class TdiscoverResultController {
   @Autowired
   private TdataDiscoveryResultService tdataDiscoveryResultService;
   @Autowired
   private DataSystemService dataSystemService;
   @Autowired
   private TdataDiscoveryService tdataDiscoveryService;
   @Autowired
   private SearchRegexService searchRegexService;
   @Autowired
   private TCoreDiscoverySysdataDao tCoreDiscoverySysdataDao;

   @RequestMapping
   public String index(HttpServletRequest request, HttpServletResponse response, Model model) {
      String id = request.getParameter("id");
      String resultid = request.getParameter("resultid");
      String taskid = request.getParameter("taskid");
      model.addAttribute("id", id);
      model.addAttribute("resultid", resultid);
      model.addAttribute("taskid", taskid);
      TcoreDiscoveryTask tcoreDiscoveryTask = this.tdataDiscoveryService.queryTaskByid(taskid);
      String discoverytype = tcoreDiscoveryTask.getDiscoverytype();
      if (!"1".equals(discoverytype) && !"3".equals(discoverytype)) {
         if ("4".equals(discoverytype)) {
            return "core/dataproject/discoverytask/discoverytask_result_nosql";
         } else {
            List<TCoreProjectFile> tCoreProjectFile = this.tdataDiscoveryService.queryTaskBytaskid(taskid);
            String isknowstructure = ((TCoreProjectFile)tCoreProjectFile.get(0)).getIsknowstructure();
            return "know".equals(isknowstructure) ? "core/dataproject/discoverytask/discoverytask_result" : "core/dataproject/discoverytask/discoverytask_result2";
         }
      } else {
         return "core/dataproject/discoverytask/discoverytask_result";
      }
   }

   @ResponseBody
   @RequestMapping({"/findFileStructure"})
   public String findFileStructure(HttpServletRequest request, HttpServletResponse response, Model model) {
      String taskid = request.getParameter("taskid");
      List<TCoreProjectFile> tCoreProjectFile = this.tdataDiscoveryService.queryTaskBytaskid(taskid);
      String isknowstructure = "";
      if (tCoreProjectFile.size() > 0) {
         isknowstructure = ((TCoreProjectFile)tCoreProjectFile.get(0)).getIsknowstructure();
      }

      return isknowstructure;
   }

   @ResponseBody
   @GetMapping({"/getdiscoverresultreport"})
   public Response getDiscoverResultReport(@RequestParam String taskid, HttpServletRequest request, HttpServletResponse response, Model model) {
      TcoreDiscoveryDataResult obj = this.tdataDiscoveryResultService.getDiscoverResultReport(taskid);
      return RespHelper.successResp(obj);
   }

   @ResponseBody
   @RequestMapping({"/discoverresultsearch"})
   public void discoverResultSearch(DiscoveryResultVO obj1, HttpServletRequest request, HttpServletResponse response, Model model) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
      List<TCoreDiscoverySysdata> list = this.tdataDiscoveryResultService.discoverResultTable(obj1);
      this.tdataDiscoveryResultService.clearT();
      this.tdataDiscoveryResultService.saveSysdataTable(list);
   }

   @ResponseBody
   @PostMapping({"/query"})
   public Response queryResult(@RequestBody Map<String, Object> params) throws InvocationTargetException, IllegalAccessException {
      String taskid = (String)params.get("taskid");
      Integer page = (Integer)params.get("page");
      Integer rows = (Integer)params.get("rows");
      String tablename = (String)params.get("resultid");
      DiscoveryResultVO discoveryResultVO = (DiscoveryResultVO)ObjectTool.getObjectByMap(DiscoveryResultVO.class, (Map)params.get("filter"));
      List<TCoreDiscoverySysdata> sysdatalist = this.tdataDiscoveryResultService.discoverResultTable(discoveryResultVO);
      this.tdataDiscoveryResultService.clearT();
      if (HibernateConfig.PEIZHIKUDBTYPE.equals("3")) {
         for(TCoreDiscoverySysdata tCoreDiscoverySysdata : sysdatalist) {
            this.tCoreDiscoverySysdataDao.save(tCoreDiscoverySysdata);
         }
      } else {
         this.tdataDiscoveryResultService.saveSysdataTable(sysdatalist);
      }

      long a = System.currentTimeMillis();
      List<TCoreDiscoverySysdata> list = this.tdataDiscoveryResultService.discoverResultPage((page - 1) * rows, rows);
      long b = System.currentTimeMillis();
      List<TcoreDiscoveryResult> list1 = new ArrayList();

      for(TCoreDiscoverySysdata t : list) {
         int cou = 0;
         TcoreDiscoveryResult vo = new TcoreDiscoveryResult();
         vo.setId(UUID.randomUUID().toString());
         vo.setTfields(t.getTschemas() + "." + t.getTtables());
         String issensitive = discoveryResultVO.getIssensitive();
         String checksure = discoveryResultVO.getChecksure();
         String nfield = discoveryResultVO.getNfield();
         List<TcoreDiscoveryResult> ll = this.tdataDiscoveryResultService.getPageDataResult(tablename, t.getTschemas(), t.getTtables(), nfield);
         if (!ll.isEmpty()) {
            for(int i = 0; i < ll.size(); ++i) {
               if (((TcoreDiscoveryResult)ll.get(i)).getDataarea_id() != null && !"".equals(((TcoreDiscoveryResult)ll.get(i)).getDataarea_id())) {
                  ++cou;
               } else if ("1".equals(issensitive)) {
                  ll.remove(i);
                  --i;
               }

               if (i > -1) {
                  if ("1".equals(((TcoreDiscoveryResult)ll.get(i)).getIssure())) {
                     if ("0".equals(checksure)) {
                        ll.remove(i);
                        --i;
                     }
                  } else if ("1".equals(checksure)) {
                     ll.remove(i);
                     --i;
                  }
               }
            }
         }

         vo.setDataarea_name(cou + "个敏感数据");
         vo.setChildren(ll);
         list1.add(vo);
      }

      long c = System.currentTimeMillis();
      Long con = (long)this.tdataDiscoveryResultService.queryAll().size();
      PageInfo pageInfo = new PageInfo();
      pageInfo.setPageno(page);
      pageInfo.setPagesize(rows);
      pageInfo.setCount(con);
      long d = System.currentTimeMillis();
      return RespHelper.updateResp(pageInfo, list1);
   }

   @ResponseBody
   @RequestMapping({"/discoverresulttable"})
   public DataGridVO<TcoreDiscoveryResult> discoverResultTable(String tablename1, String issensitive, String checksure, String nfield, Integer page, Integer rows, HttpServletRequest request, HttpServletResponse response, Model model) {
      long a = System.currentTimeMillis();
      List<TCoreDiscoverySysdata> list = this.tdataDiscoveryResultService.discoverResultPage((page - 1) * rows, rows);
      long b = System.currentTimeMillis();
      List<TcoreDiscoveryResult> list1 = new ArrayList();

      for(TCoreDiscoverySysdata t : list) {
         int cou = 0;
         TcoreDiscoveryResult vo = new TcoreDiscoveryResult();
         vo.setId(UUID.randomUUID().toString());
         vo.setTfields(t.getTschemas() + "." + t.getTtables());
         List<TcoreDiscoveryResult> ll = this.tdataDiscoveryResultService.getPageDataResult(tablename1, t.getTschemas(), t.getTtables(), nfield);
         if (!ll.isEmpty()) {
            for(int i = 0; i < ll.size(); ++i) {
               if (((TcoreDiscoveryResult)ll.get(i)).getDataarea_id() != null && !"".equals(((TcoreDiscoveryResult)ll.get(i)).getDataarea_id())) {
                  ++cou;
               } else if ("1".equals(issensitive)) {
                  ll.remove(i);
                  --i;
               }

               if (i > -1) {
                  if ("1".equals(((TcoreDiscoveryResult)ll.get(i)).getIssure())) {
                     if ("0".equals(checksure)) {
                        ll.remove(i);
                        --i;
                     }
                  } else if ("1".equals(checksure)) {
                     ll.remove(i);
                     --i;
                  }
               }

               if (i > -1 && !"".equals(nfield) && null != nfield && !((TcoreDiscoveryResult)ll.get(i)).getTfields().toLowerCase().contains(nfield.toLowerCase())) {
                  ll.remove(i);
                  --i;
               }
            }
         }

         vo.setDataarea_name(cou + "个敏感数据");
         vo.setChildren(ll);
         list1.add(vo);
      }

      long c = System.currentTimeMillis();
      Long con = this.tdataDiscoveryResultService.getPageDataCount();
      DataGridVO<TcoreDiscoveryResult> v = new DataGridVO<TcoreDiscoveryResult>(con, list1);
      long d = System.currentTimeMillis();
      System.out.println(a + "!" + b + "!" + c + "!" + d);
      return v;
   }

   @ResponseBody
   @RequestMapping({"/discoverresultFile"})
   public DataGridVO<TcoreDiscoveryResult> discoverresultFile(PageInfo pageInfo, String dataArea1, Integer structStr1, String nschema1, String tablename1, String issensitive, String checksure, String nfield, Integer page, Integer rows, HttpServletRequest request, HttpServletResponse response, Model model) {
      pageInfo.setPageno(page);
      pageInfo.setPagesize(rows);
      List<TcoreDiscoveryResult> list = this.tdataDiscoveryResultService.getPageDataResultfile(pageInfo, dataArea1, tablename1, nschema1, nfield, String.valueOf(structStr1), checksure, issensitive);
      DataGridVO<TcoreDiscoveryResult> v = new DataGridVO<TcoreDiscoveryResult>(pageInfo.getCount(), list);
      return v;
   }

   @ResponseBody
   @RequestMapping({"/findFileContent"})
   public String findFileContent(String id, String tablename) {
      String fileContent = this.tdataDiscoveryResultService.getFileContent(id, tablename);
      return fileContent;
   }

   @ResponseBody
   @PostMapping({"/discoverresultsure"})
   public Response makeDiscoverResultSure(@RequestBody Map<String, Object> params, HttpServletRequest request, HttpServletResponse response, Model model) {
      DiscoveryResultVO discoveryResultVO = (DiscoveryResultVO)ObjectTool.getObjectByMap(DiscoveryResultVO.class, (Map)params.get("filter"));
      String resultid = (String)params.get("resultid");
      discoveryResultVO.setTablename(resultid);
      String tableid = (String)params.get("tableid");
      if (tableid != null && !"".equals(tableid)) {
         this.tdataDiscoveryResultService.makeDiscoverResultSure(discoveryResultVO, tableid);
      } else {
         this.tdataDiscoveryResultService.makeDiscoverResultSureAll(discoveryResultVO);
      }

      return RespHelper.successResp();
   }

   @ResponseBody
   @PostMapping({"/discoverchangerule"})
   public Response discoverChangeRule(@RequestBody Map<String, Object> params, HttpServletRequest request, HttpServletResponse response, Model model) {
      DiscoveryResultVO discoveryResultVO = (DiscoveryResultVO)ObjectTool.getObjectByMap(DiscoveryResultVO.class, (Map)params.get("filter"));
      String resultid = (String)params.get("resultid");
      discoveryResultVO.setTablename(resultid);
      String tableid = (String)params.get("tableid");
      if (tableid != null && !"".equals(tableid)) {
         this.tdataDiscoveryResultService.discoverChangeRule(discoveryResultVO, tableid);
      } else {
         this.tdataDiscoveryResultService.discoverChangeRuleAll(discoveryResultVO);
      }

      return RespHelper.successResp();
   }

   @ResponseBody
   @RequestMapping({"/discoverdelerule"})
   public Response discoverDeleRule(@RequestBody Map<String, Object> params, HttpServletRequest request, HttpServletResponse response, Model model) {
      DiscoveryResultVO discoveryResultVO = (DiscoveryResultVO)ObjectTool.getObjectByMap(DiscoveryResultVO.class, (Map)params.get("filter"));
      String resultid = (String)params.get("resultid");
      discoveryResultVO.setTablename(resultid);
      String tableid = (String)params.get("tableid");
      if (tableid != null && !"".equals(tableid)) {
         this.tdataDiscoveryResultService.discoverDeleRule(discoveryResultVO, tableid);
      } else {
         this.tdataDiscoveryResultService.discoverDeleRuleAll(discoveryResultVO);
      }

      return RespHelper.successResp();
   }

   @ResponseBody
   @RequestMapping({"/getarearule"})
   public Response getAreaRule(String project_id, String rulename, HttpServletRequest request, HttpServletResponse response, Model model) {
      List<TCoreProjectAllrule> list = this.tdataDiscoveryResultService.selectDataAreaHas(project_id);
      if (!StringUtils.isEmpty(rulename)) {
         list = (List)list.stream().filter((e) -> e.getDataareaname().contains(rulename)).collect(Collectors.toList());
      }

      for(int i = 0; i < list.size(); ++i) {
         List<TCoreProjectAllrule> tCoreProjectAllrules = this.tdataDiscoveryResultService.getRuledis(project_id, ((TCoreProjectAllrule)list.get(i)).getDataarea_id());
         List<TConsoleSearchregex> regexlist = new ArrayList();

         for(TCoreProjectAllrule coreProjectAllrule : tCoreProjectAllrules) {
            TConsoleSearchregex tConsoleSearchregex = new TConsoleSearchregex();
            List<TConsoleSearchregex> tConsoleSearchregexes = null;
            tConsoleSearchregexes = this.searchRegexService.initEditRegex(coreProjectAllrule.getRule_id());
            if (tConsoleSearchregexes.size() > 0) {
               tConsoleSearchregex = (TConsoleSearchregex)tConsoleSearchregexes.get(0);
            }

            regexlist.add(tConsoleSearchregex);
         }

         ((TCoreProjectAllrule)list.get(i)).setRegexlist(regexlist);
      }

      return RespHelper.successResp(list);
   }

   @ResponseBody
   @RequestMapping({"/getsensitiverule"})
   public List<TCoreProjectAllrule> getSensitiveRule(String project_id, String dataarea_id, HttpServletRequest request, HttpServletResponse response, Model model) {
      List<TCoreProjectAllrule> list = this.tdataDiscoveryResultService.selectDataAreaFindRule(project_id, dataarea_id);
      return list;
   }

   @ResponseBody
   @PostMapping({"/saveedition"})
   public Response saveEdition(@RequestBody RqSaveEditionParamsVO vo) {
      String versionname = vo.getVersionname();
      String taskid = vo.getTaskid();
      String flag = vo.getFlag();
      String resultid = vo.getResultid();
      String version = vo.getVersion();
      String projectid = vo.getProjectid();
      DiscoveryResultVO obj = new DiscoveryResultVO();
      obj.setTablename(resultid);
      obj.setNschema(vo.getSchemaname());
      obj.setNtable(vo.getTablename());
      Properties props = new Properties();

      try {
         props = PropertiesLoaderUtils.loadAllProperties("config.properties");
      } catch (IOException e) {
         e.printStackTrace();
      }

      String url = "";
      if ("task_version".equals(version)) {
         url = props.getProperty("TaskVersion") + taskid;
      } else if ("project_version".equals(version)) {
         url = props.getProperty("ProjectVersion") + projectid;
      } else if ("all_version".equals(version)) {
         url = props.getProperty("AllVersion");
      } else if ("custom_version".equals(version)) {
         url = props.getProperty("CustomVersion");
      }

      String createtime = String.valueOf(System.currentTimeMillis() / 1000L);
      File file = new File(url);
      if (!file.exists()) {
         file.mkdirs();
      }

      File[] files = file.listFiles();
      if (files.length > 0 && "task_version".equals(version)) {
         Object[] exist = Arrays.stream(files).filter((x) -> x.getName().substring(0, x.getName().lastIndexOf("_", x.getName().lastIndexOf("_") - 1)).equals(versionname)).toArray();
         if (exist.length > 0 && "0".equals(flag)) {
            return RespHelper.createResp(false, "POP_00025", MesUtil.getMsg("POP_00025", new String[0]));
         }

         if (files.length >= 3) {
            long time1 = files[0].lastModified();
            int l = 0;

            for(int i = 0; i < files.length; ++i) {
               long time = files[i].lastModified();
               if (time < time1) {
                  time1 = time;
                  l = i;
               }
            }

            if (exist.length == 0) {
               files[l].delete();
            } else {
               ((File)exist[0]).delete();
            }
         } else if (exist.length > 0) {
            ((File)exist[0]).delete();
         }
      }

      String filename = versionname + "_" + createtime + "_" + CommonUtils.loginUsername();
      url = url + File.separator + filename + ".txt";
      if (!"task_version".equals(version)) {
         List<TcoreDiscoveryResult> resultTableInfo = this.tdataDiscoveryResultService.getResultTableInfo(obj);
         Set<String> set = new HashSet();

         for(TcoreDiscoveryResult tcoreDiscoveryResult : resultTableInfo) {
            String tdatasystem_id = tcoreDiscoveryResult.getTdatasystem_id();
            String tschemas = tcoreDiscoveryResult.getTschemas();
            String ttables = tcoreDiscoveryResult.getTtables();
            set.add(tdatasystem_id + "." + tschemas + "." + ttables);
         }

         if (files.length > 0) {
            if ("0".equals(flag)) {
               return RespHelper.createResp(false, "POP_00027", MesUtil.getMsg("POP_00027", new String[0]));
            }

            if ("1".equals(flag)) {
               BufferedReader reader = null;
               BufferedWriter bw = null;
               OutputStreamWriter fw = null;

               try {
                  System.out.println("以行为单位读取文件内容，一次读一整行：");
                  reader = new BufferedReader(new FileReader(files[0]));
                  File newfile = new File(url);
                  newfile.createNewFile();
                  fw = new OutputStreamWriter(new FileOutputStream(newfile, true), "GBK");
                  bw = new BufferedWriter(fw);
                  String tempString = null;

                  for(int line = 1; (tempString = reader.readLine()) != null; ++line) {
                     System.out.println(tempString);
                     String[] split = tempString.split(",");
                     String schemaname1 = split[0];
                     String tablename1 = split[1];
                     String datasouce1 = split[8];
                     boolean contains = set.contains(datasouce1 + "." + schemaname1 + "." + tablename1);
                     if (!contains) {
                        bw.write(tempString + "\r\n");
                     }
                  }

                  reader.close();
                  bw.flush();
                  bw.close();
                  fw.close();
               } catch (IOException e) {
                  e.printStackTrace();
               } finally {
                  if (reader != null) {
                     try {
                        reader.close();
                        bw.close();
                        fw.close();
                     } catch (IOException var37) {
                     }
                  }

               }
            }

            files[0].delete();
         }
      }

      this.tdataDiscoveryResultService.saveEdition(obj, url);
      return RespHelper.successResp();
   }

   @ResponseBody
   @PostMapping({"/initExecute"})
   public Response initExecute(@RequestBody Map<String, Object> params) {
      String taskid = (String)params.get("taskid");
      List<Map<String, String>> list = new ArrayList();
      String projectversion = "";
      String allversion = "";
      Properties props = new Properties();

      try {
         props = PropertiesLoaderUtils.loadAllProperties("config.properties");
      } catch (IOException e) {
         e.printStackTrace();
      }

      File taskfile = new File(props.getProperty("TaskVersion"));
      if (!taskfile.exists()) {
         taskfile.mkdirs();
      }

      taskfile = new File(props.getProperty("TaskVersion") + taskid);
      String str = "";
      if (taskfile.listFiles() != null) {
         File[] f = taskfile.listFiles();

         for(int i = 0; i < f.length; ++i) {
            Map<String, String> taskversionmap = new HashMap();
            str = f[i].getName().split("\\.txt")[0];
            String[] split = str.split("_");
            taskversionmap.put("versonname", split[0]);
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String sd = sdf.format(new Date(Long.parseLong(split[1] + "000")));
            taskversionmap.put("createtime", sd);
            taskversionmap.put("createuser", split[2]);
            list.add(taskversionmap);
         }
      }

      return RespHelper.successResp(list);
   }

   @ResponseBody
   @GetMapping({"/download"})
   public void download(@RequestParam("resultid") String filename, HttpServletRequest request, HttpServletResponse response) throws UnsupportedEncodingException {
      DiscoveryResultVO obj = new DiscoveryResultVO();
      obj.setTablename(filename);
      List<TcoreDiscoveryResult> list1 = this.tdataDiscoveryResultService.saveExcel(obj);
      TCoreDatasystem sys = this.dataSystemService.queryDataSystemById(null == ((TcoreDiscoveryResult)list1.get(0)).getTdatasystem_id() ? "" : ((TcoreDiscoveryResult)list1.get(0)).getTdatasystem_id());
      String userAgent = request.getHeader("User-Agent");
      Properties props = new Properties();

      try {
         props = PropertiesLoaderUtils.loadAllProperties("config.properties");
      } catch (IOException e) {
         e.printStackTrace();
      }

      String path1 = props.getProperty("discoveryResultDir");
      String fileName = obj.getTablename() + ".xlsx";
      File fileTarget = new File(path1);
      if (!fileTarget.exists()) {
         fileTarget.mkdirs();
      }

      String path = path1 + fileName;
      LinkedBlockingQueue<HashMap<String, String>> queue = new LinkedBlockingQueue();

      for(int i = 0; i < list1.size(); ++i) {
         try {
            HashMap<String, String> hashmap = new HashMap();
            hashmap.put("id", ((TcoreDiscoveryResult)list1.get(i)).getId());
            hashmap.put("dataarea_id", ((TcoreDiscoveryResult)list1.get(i)).getDataarea_id());
            hashmap.put("dataarea_name", ((TcoreDiscoveryResult)list1.get(i)).getDataarea_name());
            hashmap.put("issure", ((TcoreDiscoveryResult)list1.get(i)).getIssure());
            hashmap.put("sensitive_id", ((TcoreDiscoveryResult)list1.get(i)).getSensitive_id());
            hashmap.put("sensitive_name", ((TcoreDiscoveryResult)list1.get(i)).getSensitive_name());
            hashmap.put("tdatasystem_id", ((TcoreDiscoveryResult)list1.get(i)).getTdatasystem_id());
            hashmap.put("teffe_sampling", ((TcoreDiscoveryResult)list1.get(i)).getTeffe_sampling());
            hashmap.put("tfields", ((TcoreDiscoveryResult)list1.get(i)).getTfields());
            hashmap.put("tmatching", ((TcoreDiscoveryResult)list1.get(i)).getTmatching());
            hashmap.put("tsampling", ((TcoreDiscoveryResult)list1.get(i)).getTsampling());
            hashmap.put("tschemas", ((TcoreDiscoveryResult)list1.get(i)).getTschemas());
            hashmap.put("ttables", ((TcoreDiscoveryResult)list1.get(i)).getTtables());
            hashmap.put("tdatasystem_name", null == sys ? "" : sys.getSysname());
            queue.put(hashmap);
         } catch (InterruptedException e) {
            e.printStackTrace();
         }
      }

      Map<String, String> titlevalue = new LinkedHashMap();
      titlevalue.put("id", "id");
      titlevalue.put("数据源ID", "tdatasystem_id");
      titlevalue.put("数据源", "tdatasystem_name");
      titlevalue.put("SCHEMA", "tschemas");
      titlevalue.put("表名", "ttables");
      titlevalue.put("字段", "tfields");
      titlevalue.put("数据域ID", "dataarea_id");
      titlevalue.put("数据域", "dataarea_name");
      titlevalue.put("脱敏规则ID", "sensitive_id");
      titlevalue.put("发现规则", "sensitive_name");
      titlevalue.put("是否确认", "issure");
      titlevalue.put("采样数", "tsampling");
      titlevalue.put("有效采样数", "teffe_sampling");
      titlevalue.put("匹配率", "tmatching");
      List<Integer> columnWidthList = new ArrayList();
      columnWidthList.add(-100);
      columnWidthList.add(-100);
      columnWidthList.add(6000);
      columnWidthList.add(6000);
      columnWidthList.add(6000);
      columnWidthList.add(6000);
      columnWidthList.add(-100);
      columnWidthList.add(6000);
      columnWidthList.add(-100);
      columnWidthList.add(7000);
      columnWidthList.add(2200);
      columnWidthList.add(2200);
      columnWidthList.add(3000);
      columnWidthList.add(2200);

      try {
         ExcelTool.generateExcel(path, queue, titlevalue, columnWidthList, (List)null);
         String name = "";
         if (!userAgent.contains("MSIE") && !userAgent.contains("Trident")) {
            name = new String(obj.getTablename().getBytes("UTF-8"), "ISO-8859-1") + ".xlsx";
         } else {
            name = URLEncoder.encode(obj.getTablename() + ".xlsx", "UTF-8");
         }

         response.setCharacterEncoding("utf-8");
         response.setContentType("multipart/form-data");
         response.setHeader("Content-Disposition", "attachment;fileName=" + name);
         InputStream inputStream = new FileInputStream(new File(path));
         OutputStream os = response.getOutputStream();
         byte[] b = new byte[2048];

         int length;
         while((length = inputStream.read(b)) > 0) {
            os.write(b, 0, length);
         }

         os.close();
         inputStream.close();
      } catch (Exception e) {
         e.printStackTrace();
      }

   }

   @ResponseBody
   @RequestMapping({"/saveexcel"})
   public void saveExcel(DiscoveryResultVO obj, HttpServletRequest request, HttpServletResponse response, Model model) {
      List<TcoreDiscoveryResult> list1 = this.tdataDiscoveryResultService.saveExcel(obj);
      TCoreDatasystem sys = this.dataSystemService.queryDataSystemById(null == ((TcoreDiscoveryResult)list1.get(0)).getTdatasystem_id() ? "" : ((TcoreDiscoveryResult)list1.get(0)).getTdatasystem_id());
      String userAgent = request.getHeader("User-Agent");
      Properties props = new Properties();

      try {
         props = PropertiesLoaderUtils.loadAllProperties("config.properties");
      } catch (IOException e) {
         e.printStackTrace();
      }

      String path1 = props.getProperty("discoveryResultDir");
      String fileName = obj.getTablename() + ".xlsx";
      File fileTarget = new File(path1);
      if (!fileTarget.exists()) {
         fileTarget.mkdirs();
      }

      String path = path1 + fileName;
      LinkedBlockingQueue<HashMap<String, String>> queue = new LinkedBlockingQueue();

      for(int i = 0; i < list1.size(); ++i) {
         try {
            HashMap<String, String> hashmap = new HashMap();
            hashmap.put("id", ((TcoreDiscoveryResult)list1.get(i)).getId());
            hashmap.put("dataarea_id", ((TcoreDiscoveryResult)list1.get(i)).getDataarea_id());
            hashmap.put("dataarea_name", ((TcoreDiscoveryResult)list1.get(i)).getDataarea_name());
            hashmap.put("issure", ((TcoreDiscoveryResult)list1.get(i)).getIssure());
            hashmap.put("sensitive_id", ((TcoreDiscoveryResult)list1.get(i)).getSensitive_id());
            hashmap.put("sensitive_name", ((TcoreDiscoveryResult)list1.get(i)).getSensitive_name());
            hashmap.put("tdatasystem_id", ((TcoreDiscoveryResult)list1.get(i)).getTdatasystem_id());
            hashmap.put("teffe_sampling", ((TcoreDiscoveryResult)list1.get(i)).getTeffe_sampling());
            hashmap.put("tfields", ((TcoreDiscoveryResult)list1.get(i)).getTfields());
            hashmap.put("tmatching", ((TcoreDiscoveryResult)list1.get(i)).getTmatching());
            hashmap.put("tsampling", ((TcoreDiscoveryResult)list1.get(i)).getTsampling());
            hashmap.put("tschemas", ((TcoreDiscoveryResult)list1.get(i)).getTschemas());
            hashmap.put("ttables", ((TcoreDiscoveryResult)list1.get(i)).getTtables());
            hashmap.put("tdatasystem_name", null == sys ? "" : sys.getSysname());
            queue.put(hashmap);
         } catch (InterruptedException e) {
            e.printStackTrace();
         }
      }

      for(TcoreDiscoveryResult var26 : list1) {
         ;
      }

      Map<String, String> titlevalue = new LinkedHashMap();
      titlevalue.put("id", "id");
      titlevalue.put("数据源ID", "tdatasystem_id");
      titlevalue.put("数据源名称", "tdatasystem_name");
      titlevalue.put("用户", "tschemas");
      titlevalue.put("表名", "ttables");
      titlevalue.put("字段", "tfields");
      titlevalue.put("数据域ID", "dataarea_id");
      titlevalue.put("数据域名称", "dataarea_name");
      titlevalue.put("敏感规则ID", "sensitive_id");
      titlevalue.put("敏感规则名称", "sensitive_name");
      titlevalue.put("是否确认", "issure");
      titlevalue.put("采样数", "tsampling");
      titlevalue.put("有效采样数", "teffe_sampling");
      titlevalue.put("匹配率", "tmatching");
      List<Integer> columnWidthList = new ArrayList();
      columnWidthList.add(-100);
      columnWidthList.add(-100);
      columnWidthList.add(6000);
      columnWidthList.add(6000);
      columnWidthList.add(6000);
      columnWidthList.add(6000);
      columnWidthList.add(-100);
      columnWidthList.add(6000);
      columnWidthList.add(-100);
      columnWidthList.add(7000);
      columnWidthList.add(2200);
      columnWidthList.add(2200);
      columnWidthList.add(3000);
      columnWidthList.add(2200);

      try {
         ExcelTool.generateExcel(path, queue, titlevalue, columnWidthList, (List)null);
         String name = "";
         if (!userAgent.contains("MSIE") && !userAgent.contains("Trident")) {
            name = new String(obj.getTablename().getBytes("UTF-8"), "ISO-8859-1") + ".xlsx";
         } else {
            name = URLEncoder.encode(obj.getTablename() + ".xlsx", "UTF-8");
         }

         response.setCharacterEncoding("utf-8");
         response.setContentType("multipart/form-data");
         response.setHeader("Content-Disposition", "attachment;fileName=" + name);
         InputStream inputStream = new FileInputStream(new File(path));
         OutputStream os = response.getOutputStream();
         byte[] b = new byte[2048];

         int length;
         while((length = inputStream.read(b)) > 0) {
            os.write(b, 0, length);
         }

         os.close();
         inputStream.close();
      } catch (Exception e) {
         e.printStackTrace();
      }

   }

   @ResponseBody
   @PostMapping({"/importdata"})
   public Response importData(HttpServletRequest request, HttpServletResponse response, @RequestParam("fileUpload") MultipartFile excelFile, @RequestParam("resultid") String resultid, Model model) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
      DiscoveryResultVO obj = new DiscoveryResultVO();
      obj.setTablename(resultid);
      InputStream in = null;
      String fileName = excelFile.getOriginalFilename();

      try {
         in = excelFile.getInputStream();
         Workbook wb = null;
         String fileType = fileName.substring(fileName.lastIndexOf("."));
         if (".xls".equals(fileType)) {
            wb = new HSSFWorkbook(in);
         } else if (".xlsx".equals(fileType)) {
            wb = new XSSFWorkbook(in);
         }

         Sheet sheet = wb.getSheetAt(0);
         int rowsNum = sheet.getLastRowNum();
         int num = 0;
         SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
         System.out.println("取文件时间：" + sdf.format(new Date()));
         long startTime = System.currentTimeMillis();
         List<TcoreDiscoveryResult> list1 = new ArrayList();
         Map<String, String> da = this.tdataDiscoveryResultService.getDataAreaAll();
         Map<String, String> fr = new HashMap();

         for(TConsoleSearchregex vo : this.searchRegexService.queryAllSearchRegex()) {
            fr.put(vo.getName(), vo.getId());
         }

         for(int i = 1; i < rowsNum + 1; ++i) {
            Row row = sheet.getRow(i);
            TcoreDiscoveryResult s = new TcoreDiscoveryResult();
            if (row != null) {
               s.setId(row.getCell(0).toString());
               s.setTdatasystem_id(row.getCell(1).toString());
               s.setTschemas(row.getCell(3).toString());
               s.setTtables(row.getCell(4).toString());
               s.setTfields(row.getCell(5).toString());
               if (!"".equals(row.getCell(7).toString()) && null == da.get(row.getCell(7).toString())) {
                  s.setDataarea_id("");
                  s.setDataarea_name("");
                  s.setSensitive_id("");
                  s.setSensitive_name("");
               } else {
                  s.setDataarea_id((String)da.get(row.getCell(7).toString()));
                  s.setDataarea_name(row.getCell(7).toString());
                  if (!"".equals(row.getCell(9).toString()) && null == fr.get(row.getCell(9).toString())) {
                     s.setSensitive_id("");
                     s.setSensitive_name("");
                  } else {
                     s.setSensitive_id((String)fr.get(row.getCell(9).toString()));
                     s.setSensitive_name(row.getCell(9).toString());
                  }
               }

               s.setIssure(row.getCell(10).toString().substring(0, 1));
               s.setTsampling(row.getCell(11).toString());
               s.setTeffe_sampling(row.getCell(12).toString());
               s.setTmatching(row.getCell(13).toString());
               list1.add(s);
            }
         }

         long endTime = System.currentTimeMillis();
         System.out.println("程序运行时间： " + (endTime - startTime) + "ms");
         this.tdataDiscoveryResultService.delTableData(obj);
         this.tdataDiscoveryResultService.saveTableData(obj, list1);
      } catch (IOException e) {
         e.printStackTrace();
      }

      return RespHelper.successResp();
   }

   @ResponseBody
   @PostMapping({"/showmatchrate"})
   public Response showmatchrate(@RequestBody Map<String, Object> params) throws IOException {
      String projectid = (String)params.get("projectid");
      String taskid = (String)params.get("taskid");
      String ttables = (String)params.get("ttables");
      String tfields = (String)params.get("tfields");
      String dataarea_name = (String)params.get("dataarea_name");
      HashMap<String, Object> map = new HashMap();
      List<String> listchrate1 = new ArrayList();
      List<String> listchrate2 = new ArrayList();
      Properties props = new Properties();

      try {
         props = PropertiesLoaderUtils.loadAllProperties("config.properties");
      } catch (IOException e) {
         e.printStackTrace();
      }

      String url = props.getProperty("rateDir");
      String dir = "";
      if (ttables.contains(":")) {
         dir = ttables.split(":")[1].replaceAll("\\\\", "-");
      } else if (ttables.contains("/")) {
         dir = ttables.replaceAll("/", "-");
      } else {
         dir = ttables;
      }

      String matchurl = url + "match" + File.separator + projectid + File.separator + taskid + File.separator + dir + File.separator + tfields + ".txt";
      String unmatchedurl = url + "unmatched" + File.separator + projectid + File.separator + taskid + File.separator + dir + File.separator + tfields + ".txt";
      File matchFile = new File(matchurl);
      File unmatchFile = new File(unmatchedurl);
      if (matchFile.exists()) {
         InputStreamReader matchISR = new InputStreamReader(new FileInputStream(matchFile), "GBK");
         BufferedReader matchBR = new BufferedReader(matchISR);
         String match = null;

         while((match = matchBR.readLine()) != null) {
            listchrate1.add(match);
         }

         matchBR.close();
      }

      if (unmatchFile.exists()) {
         InputStreamReader unmatchISR = new InputStreamReader(new FileInputStream(unmatchFile), "GBK");
         BufferedReader unmatchBR = new BufferedReader(unmatchISR);
         String unmatch = null;

         while((unmatch = unmatchBR.readLine()) != null) {
            listchrate2.add(unmatch);
         }

         unmatchBR.close();
      }

      map.put("matchurl", listchrate1);
      map.put("unmatchurl", listchrate2);
      map.put("ttables", ttables);
      map.put("dataarea_name", dataarea_name);
      return RespHelper.successResp(map);
   }

   @ResponseBody
   @RequestMapping({"/resetresultrun"})
   public void resetResultRun(String tablename, HttpServletRequest request, HttpServletResponse response, Model model) {
      this.tdataDiscoveryResultService.resetResultRun(tablename);
   }
}
