package com.chenyang.nse.bussiness.controller.core.dataproject;

import com.chenyang.nse.bussiness.dao.table.core.TCoreDatasystemDao;
import com.chenyang.nse.bussiness.entity.vo.ComboboxVO;
import com.chenyang.nse.bussiness.entity.vo.DBTableVO;
import com.chenyang.nse.bussiness.service.core.DataSystemService;
import com.chenyang.nse.bussiness.service.core.subset.NewsubsetService;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping({"/core/datasubset"})
public class TdataSubsetController {
   @Autowired
   private TCoreDatasystemDao tCoreDatasystemDao;
   @Autowired
   private DataSystemService dataSystemService;
   @Autowired
   private NewsubsetService subsetService;

   @RequestMapping
   public String index(HttpServletRequest request, HttpServletResponse response, Model model) {
      return "core/dataproject/datasubset/datasubset_list";
   }

   @RequestMapping({"/createtask"})
   public String createtask(String step, @RequestParam Map<String, String> map, HttpServletRequest request, HttpServletResponse response, Model model) {
      switch (step) {
         case "datasubset_one":
            this.datasubset_one(map, request, model);
            break;
         case "datasubset_two":
            model.addAttribute("taskname", map.get("taskname"));
            model.addAttribute("systemType", map.get("systemType"));
            model.addAttribute("systemID", map.get("systemID"));
            model.addAttribute("schema", map.get("schema"));
            model.addAttribute("selectTablename", map.get("selectTablename"));
            break;
         case "datasubset_three":
            model.addAttribute("taskname", map.get("taskname"));
            model.addAttribute("systemType", map.get("systemType"));
            model.addAttribute("systemID", map.get("systemID"));
            model.addAttribute("schema", map.get("schema"));
            model.addAttribute("selectTablename", map.get("selectTablename"));
            break;
         case "datasubset_four":
            this.datasubset_four(map, request, model);
      }

      return "core/dataproject/datasubset/" + step;
   }

   private void datasubset_four(Map<String, String> map, HttpServletRequest request, Model model) {
      this.subsetService.savaTable(map);
   }

   private void datasubset_one(Map<String, String> map, HttpServletRequest request, Model model) {
      String taskname = (String)map.get("taskname");
      model.addAttribute("taskname", taskname);
   }

   @RequestMapping({"/selectBytype"})
   @ResponseBody
   public List<ComboboxVO> selectBytype(String type, HttpServletRequest request, HttpServletResponse response, Model model) {
      List<ComboboxVO> selectBytype = this.tCoreDatasystemDao.selectBytype(type);
      return selectBytype;
   }

   @RequestMapping({"/selectDBtype"})
   @ResponseBody
   public List<ComboboxVO> selectDBtype(HttpServletRequest request, HttpServletResponse response, Model model) {
      List<ComboboxVO> selectBytype = this.tCoreDatasystemDao.selectDBtype();
      return selectBytype;
   }

   @RequestMapping({"/getTableLits"})
   @ResponseBody
   public List<DBTableVO> getTableLits(String schema, String schemaID, String tablename, HttpServletRequest request, HttpServletResponse response, Model model) {
      List<DBTableVO> list = null;
      if (null != tablename && !"".equals(tablename)) {
         list = this.dataSystemService.queryTablename(schemaID, schema, tablename);
      } else {
         list = this.dataSystemService.queryTablename(schemaID, schema, "");
      }

      return list;
   }
}
