package com.chenyang.nse.bussiness.dao.table.core.encryption;

import com.chenyang.nse.bussiness.config.HibernateConfig;
import com.chenyang.nse.bussiness.dao.BaseDao;
import com.chenyang.nse.bussiness.entity.orm.table.core.encryption.TCoreEncryption;
import com.chenyang.nse.bussiness.entity.vo.ComboboxVO;
import java.util.List;
import org.hibernate.transform.Transformers;
import org.springframework.stereotype.Repository;

@Repository
public class TCoreEncryptionDao extends BaseDao<TCoreEncryption, String> {
   public List<ComboboxVO> initEncryptionTypeList() {
      String sql = "SELECT d.value as value,d.value as text FROM t_console_dictionary d WHERE d.typecode = 22";
      if (HibernateConfig.PEIZHIKUDBTYPE.equals("1")) {
         sql = "SELECT d.value as value,d.value as text FROM t_console_dictionary d WHERE d.typecode = '22'";
      }

      if (HibernateConfig.PEIZHIKUDBTYPE.equals("2")) {
         sql = "SELECT d.value as \"value\",d.value as \"text\" FROM t_console_dictionary d WHERE d.typecode = '22'";
      }

      if (HibernateConfig.PEIZHIKUDBTYPE.equals("3")) {
         sql = "SELECT d.`value` as \"value\",d.`value` as \"text\" FROM t_console_dictionary d WHERE d.typecode = '22'";
      }

      return this.getSession().createNativeQuery(sql).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP).getResultList();
   }

   public List<TCoreEncryption> getProjectSecretKeys(String projectid) {
      String sql = "select distinct e.id as id, e.createtime as createtime, e.createuser as createuser, e.flag as flag, e.note as note,e.updatetime as updatetime, e.updateuser as updateuser,e.encryption_name as encryption_name, e.encryption_type as encryption_type from t_core_secretkey s join t_core_encryption_field f on s.id = f.encryption_secretKey_id join t_core_encryption e on e.id = s.encryption_id where f.projectid = '" + projectid + "'";
      if (HibernateConfig.PEIZHIKUDBTYPE.equals("2")) {
         sql = "select distinct e.id as id, e.createtime as createtime, e.createuser as createuser, e.flag as flag, e.note as note,e.updatetime as updatetime, e.updateuser as updateuser,e.encryption_name as encryption_name, e.encryption_type as encryption_type from encryption.t_core_secretkey s join encryption.t_core_encryption_field f on s.id = f.encryption_secretKey_id join encryption.t_core_encryption e on e.id = s.encryption_id where f.projectid = '" + projectid + "'";
      }

      if (HibernateConfig.PEIZHIKUDBTYPE.equals("3")) {
         sql = "select distinct e.id as \"id\", e.createtime as \"createtime\", e.createuser as \"createuser\", e.flag as \"flag\", e.note as \"note\",e.updatetime as \"updatetime\", e.updateuser as \"updateuser\",e.encryption_name as \"encryption_name\", e.encryption_type as \"encryption_type\" from t_core_secretkey s join t_core_encryption_field f on s.id = f.encryption_secretKey_id join t_core_encryption e on e.id = s.encryption_id where f.projectid = '" + projectid + "'";
      }

      List<TCoreEncryption> vo = this.getSession().createNativeQuery(sql).setResultTransformer(Transformers.aliasToBean(TCoreEncryption.class)).getResultList();
      return vo;
   }

   public List<TCoreEncryption> getExportEncryption() {
      String sql = "select distinct e.id as id, e.createtime as createtime, e.createuser as createuser, e.flag as flag, e.note as note,e.updatetime as updatetime, e.updateuser as updateuser,e.encryption_name as encryption_name, e.encryption_type as encryption_type from t_core_encryption e ";
      if (HibernateConfig.PEIZHIKUDBTYPE.equals("2")) {
         sql = "select distinct e.id as id, e.createtime as createtime, e.createuser as createuser, e.flag as flag, e.note as note,e.updatetime as updatetime, e.updateuser as updateuser,e.encryption_name as encryption_name, e.encryption_type as encryption_type from encryption.t_core_encryption e ";
      }

      if (HibernateConfig.PEIZHIKUDBTYPE.equals("3")) {
         sql = "select distinct e.id as \"id\", e.createtime as \"createtime\", e.createuser as \"createuser\", e.flag as \"flag\", e.note as \"note\",e.updatetime as \"updatetime\", e.updateuser as \"updateuser\",e.encryption_name as \"encryption_name\", e.encryption_type as \"encryption_type\" from t_core_encryption e ";
      }

      List<TCoreEncryption> vo = this.getSession().createNativeQuery(sql).setResultTransformer(Transformers.aliasToBean(TCoreEncryption.class)).getResultList();
      return vo;
   }
}
