package com.chenyang.nse.bussiness.dao.table.core.scheduler;

import com.chenyang.nse.bussiness.dao.BaseDao;
import com.chenyang.nse.bussiness.dao.PageInfo;
import com.chenyang.nse.bussiness.entity.orm.table.core.desensitizationtask.Desensitizationtask;
import com.chenyang.nse.bussiness.entity.orm.table.core.scheduler.TCoreSchedulerRules;
import com.chenyang.nse.bussiness.tools.xml.XmlTool;
import java.math.BigInteger;
import java.util.List;
import java.util.Map;
import org.hibernate.transform.Transformers;
import org.springframework.stereotype.Repository;

@Repository
public class TCoreSchedulerRulesDao extends BaseDao<TCoreSchedulerRules, String> {
   String sql = XmlTool.getSql("scheduler", "getEditUnSaveTask");

   public List<Desensitizationtask> getAddUnSaveTask(String projectid, String srname) {
      String sql = XmlTool.getSql("scheduler", "getAddUnSaveTask");
      List<Desensitizationtask> list = this.getSession().createNativeQuery(sql).setParameter("srname", "%" + srname + "%").setResultTransformer(Transformers.aliasToBean(Desensitizationtask.class)).getResultList();
      return list;
   }

   public List<TCoreSchedulerRules> repeatTaskName1(String srname, String projectid) {
      String sql = "select srname from t_core_scheduler_rules  where srname='" + srname + "'";
      List<TCoreSchedulerRules> list = this.getSession().createNativeQuery(sql).setResultTransformer(Transformers.aliasToBean(TCoreSchedulerRules.class)).getResultList();
      return list;
   }

   public List<Desensitizationtask> getEditUnSaveTask(String id, String projectid, String srname) {
      List<Desensitizationtask> list = null;
      list = this.getSession().createNativeQuery(this.sql).setParameter("id", id).setParameter("srname", "%" + srname + "%").setResultTransformer(Transformers.aliasToBean(Desensitizationtask.class)).getResultList();
      return list;
   }

   public List<Map<String, Object>> queryDispatchByProjectid(PageInfo pageInfo, String projectid) {
      String sql1 = "select count(1) from  t_core_scheduler_rules where  1 = 1 ";
      long count = (long)((BigInteger)this.getSession().createNativeQuery(sql1).getSingleResult()).intValue();
      pageInfo.setCount(count);
      String sql = "select id,projectid,createtime,updatetime,srname,rulevalidity,rulestype,expression,rulesday,ruleshour,rulesminute,xloptions,timebox,howtime,errormessage from  t_core_scheduler_rules where  1 =1 order by createtime desc";
      List<Map<String, Object>> list = this.getSession().createNativeQuery(sql).setFirstResult(pageInfo.getOffset()).setMaxResults(pageInfo.getPagesize()).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP).getResultList();
      return list;
   }

   public List<Map<String, Object>> queryDispatchNumber(String projectid) {
      String sql1 = "select count(1)  as s  from  t_core_scheduler_rules where  projectid ='" + projectid + "'";
      List<Map<String, Object>> vo = this.getSession().createNativeQuery(sql1).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP).getResultList();
      return vo;
   }

   public List<Map<String, Object>> queryMonitorNumber(String projectid) {
      String sql = XmlTool.getSql("getalltask", "selectMonitorCountByProjectid");
      List<Map<String, Object>> vo = this.getSession().createNativeQuery(sql).setParameter("projectid", projectid).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP).getResultList();
      return vo;
   }

   public List<Desensitizationtask> getallTask(String projectid) {
      String sql = XmlTool.getSql("scheduler", "getallTask");
      List<Desensitizationtask> list = this.getSession().createNativeQuery(sql).setParameter("projectid", projectid).setResultTransformer(Transformers.aliasToBean(Desensitizationtask.class)).getResultList();
      return list;
   }

   public void schedulerUpdate(TCoreSchedulerRules rules, String date1) {
      String sql = "update t_core_scheduler_rules set expression = '" + rules.getExpression() + "',projectid = '" + rules.getProjectid() + "',rulesday = '" + rules.getRulesday() + "',ruleshour = '" + rules.getRuleshour() + "',rulesminute = '" + rules.getRulesminute() + "',rulestype = '" + rules.getRulestype() + "',rulevalidity = '" + rules.getRulevalidity() + "',srname = '" + rules.getSrname() + "',howtime='" + rules.getHowtime() + "',timebox = '" + rules.getTimebox() + "',xloptions = '" + rules.getXloptions() + "',errormessage = '" + rules.getErrormessage() + "',createtime = '" + date1 + "'where id ='" + rules.getId() + "'";
      this.getSession().createNativeQuery(sql).executeUpdate();
   }

   public void saveerror(String ruleid, String errormessage) {
      String sql = "update t_core_scheduler_rules set errormessage = '" + errormessage + "'where id ='" + ruleid + "'";
      this.getSession().createNativeQuery(sql).executeUpdate();
   }
}
