package com.chenyang.nse.bussiness.entity.orm.table.console;

import com.chenyang.nse.bussiness.entity.orm.table.TBaseEntity;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

@Entity
@Table(
   name = "T_CONSOLE_DICTIONARYTYPE"
)
public class TConsoleDictionarytype extends TBaseEntity {
   @Column(
      length = 32
   )
   private String typecode;
   @Column(
      length = 64
   )
   private String typename;
   @Column(
      length = 255
   )
   private String remark;

   public String getTypecode() {
      return this.typecode;
   }

   public void setTypecode(String typecode) {
      this.typecode = typecode;
   }

   public String getTypename() {
      return this.typename;
   }

   public void setTypename(String typename) {
      this.typename = typename;
   }

   public String getRemark() {
      return this.remark;
   }

   public void setRemark(String remark) {
      this.remark = remark;
   }

   public String toString() {
      return "TConsoleDictionarytype [typecode=" + this.typecode + ", typename=" + this.typename + "]";
   }

   public int hashCode() {
      int prime = 31;
      int result = 1;
      result = 31 * result + (this.typecode == null ? 0 : this.typecode.hashCode());
      result = 31 * result + (this.typename == null ? 0 : this.typename.hashCode());
      return result;
   }

   public boolean equals(Object obj) {
      if (this == obj) {
         return true;
      } else if (obj == null) {
         return false;
      } else if (this.getClass() != obj.getClass()) {
         return false;
      } else {
         TConsoleDictionarytype other = (TConsoleDictionarytype)obj;
         if (this.typecode == null) {
            if (other.typecode != null) {
               return false;
            }
         } else if (!this.typecode.equals(other.typecode)) {
            return false;
         }

         if (this.typename == null) {
            if (other.typename != null) {
               return false;
            }
         } else if (!this.typename.equals(other.typename)) {
            return false;
         }

         return true;
      }
   }
}
