package com.chenyang.nse.bussiness.service.core;

import com.chenyang.nse.bussiness.dao.PageInfo;
import com.chenyang.nse.bussiness.entity.orm.table.base.TBaseUser;
import com.chenyang.nse.bussiness.entity.orm.table.base.TBaseUsersys;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreConfig;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreDatasourceSchema;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreDatasystem;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreDatasystemoracle;
import com.chenyang.nse.bussiness.entity.orm.table.core.dataproject.TCoreFileSysGroup;
import com.chenyang.nse.bussiness.entity.vo.ComboboxVO;
import com.chenyang.nse.bussiness.entity.vo.DBTableVO;
import com.chenyang.nse.bussiness.entity.vo.DataSourceAndTaskVO;
import com.chenyang.nse.bussiness.entity.vo.DataSystemConfig;
import com.chenyang.nse.bussiness.entity.vo.DataSystemVO;
import com.chenyang.nse.bussiness.entity.vo.TreeVO;
import com.chenyang.nse.bussiness.entity.vo.dataproject.DatasystemProjectdatasourceVO;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;

public interface DataSystemService {
   List<TCoreDatasystem> queryAll(String sysname, String ip, String dbtype, String userid);

   List<TreeVO> initTree(String flag, String code, String text, String parentid, String alias);

   List<TreeVO> initTreeSchema();

   List<TCoreDatasystem> queryAll();

   List<TCoreDatasystem> query(String flag);

   List<TCoreDatasystem> queryDataSystem(String flag, String istargetdb);

   List<TCoreDatasystem> query(List<String> flag, String dbType);

   List<TCoreDatasystem> query(List<String> flag, PageInfo pageInfo);

   List<TCoreDatasystem> queryExcludeId(String excludeId);

   TCoreDatasystem queryDataSystemById(String id);

   TCoreDatasystem queryDataSystemByCode(String code);

   TCoreDatasystem queryDataSystemBySysname(String sysname, String flag);

   void remove(String id);

   void save(TCoreConfig tCoreConfig, TCoreDatasystem datasource, String linkname, List<TBaseUser> users, List<TCoreDatasystemoracle> oracleIns);

   TCoreDatasystem getSubDataSystem(String parentid, String schema);

   void saveTableStructure(TCoreDatasystem datasource);

   Connection getConnectionByDataSystemId(String datasystemid);

   Connection getConnection(String datasystemid) throws SQLException, ClassNotFoundException, IOException;

   TCoreDatasystem queryDataMapSystem(String parentid, String schemaname);

   TCoreDatasystem queryDataSystem(String parentid, String schemaname, String flag);

   List<ComboboxVO> queryShemas(String dbType, String dataSystemId);

   List<ComboboxVO> queryshemas(String dbType, String dataSystemId) throws SQLException, ClassNotFoundException, IOException;

   List<TCoreDatasystem> querydatasource();

   List<Map<String, String>> querydatasource(String projectid, String discoverytype, String userid);

   List<TCoreDatasystem> querydataAllsource();

   List<DataSystemVO> queryDatasystemCrudByUserid(List<String> userid);

   List<TreeVO> inittree(String flag);

   void generateDataSystemTree();

   List<TreeVO> queryDataSystemTree();

   List<TreeVO> queryDataSystemTreeUser(String userid);

   void addDataSystemTreeBySystemId(String datasystemid);

   void removeDataSystemTreeBySystemId(String datasystemid);

   void addTableNodeToDataSystemTree(String datasystemid, String schema, String table);

   List<TBaseUsersys> queryTBaseUsersysByUserid(String userid);

   void synDataSystemTree();

   boolean issystemexist(String id);

   List<DBTableVO> queryTablename(String datasystemid, String schema);

   List<DBTableVO> queryTablename(String datasystemid, String schema, String tableNamePattern);

   Map<String, String> queryTableName(String datasystemid, String schema, String tableNamePattern);

   List<String> getAllTableNameList(String mutifile, String dmpFilePath, String dmptype, String tasknamereal);

   List<String> getAllTableNameLists(String mutifile, String dmpFilePath, String dmptype);

   List<ComboboxVO> queryByFlag(String flag);

   List<ComboboxVO> queryByFlagHadoop(String flag);

   List<ComboboxVO> queryByFlagNosql(String flag);

   List<DatasystemProjectdatasourceVO> queryByEditSort(String flag, String dbtype, PageInfo pageInfo);

   List<DatasystemProjectdatasourceVO> queryByCrud(String userid, String groupid, String flag, String dbtype, PageInfo pageInfo);

   DataSystemConfig queryByFlagById(String flag, String id);

   List<DataSourceAndTaskVO> queryDiscoverydate(PageInfo pageInfo, String sourceid);

   List<DataSourceAndTaskVO> queryDesensitizationtask(PageInfo pageInfo, String sourceid);

   List<ComboboxVO> getFileSysGroup(String id);

   void saveFileSysGroup(TCoreFileSysGroup obj);

   void removeFileSysGroup(String id);

   List<TCoreDatasystem> getname(String name);

   List<TCoreDatasystem> queryDataSystemEM(String flag, String istargetdb);

   List<TCoreDatasystem> querydatasourceds(String projectId);

   List<TCoreDatasystem> querydatasourceds(String projectId, String userId);

   List<ComboboxVO> queryByFlagKafka(String flag);

   List<String> queryView(String datasystemid, String schema);

   List<String> querySynonym(String datasystemid, String schema);

   Map<String, Object> getDataView(Map<String, Object> map);

   Map<String, Object> getHomePage(Map<String, Object> map);

   List<ComboboxVO> getSchemaList(String projectid, String dataSystemId);

   List<TCoreDatasourceSchema> querySchemas(String projectid, String dataSystemId);

   boolean checkUsedByProject(String datasystemid);

   boolean checkUsedByProject(String datasystemid, String projectId);

   int checkRepeatName(String sysname, String datasystemid);

   List<TCoreFileSysGroup> queryByGroupid(String groupid);
}
