package com.chenyang.nse.bussiness.service.core.impl;

import com.chenyang.nse.bussiness.config.PropertiesLoaderUtils;
import com.chenyang.nse.bussiness.dao.PageInfo;
import com.chenyang.nse.bussiness.dao.core.EngineDao;
import com.chenyang.nse.bussiness.dao.table.core.TCoreConfigDao;
import com.chenyang.nse.bussiness.dao.table.core.TCoreDatasystemDao;
import com.chenyang.nse.bussiness.dao.table.core.TCoreEngineDao;
import com.chenyang.nse.bussiness.dao.table.core.desensitizationtask.DesensitizationFileDao;
import com.chenyang.nse.bussiness.dao.table.core.desensitizationtask.DesensitizationMonitorDao;
import com.chenyang.nse.bussiness.dao.table.core.desensitizationtask.DesensitizationTablecolumnDao;
import com.chenyang.nse.bussiness.dao.table.core.desensitizationtask.DesensitizationsourceDao;
import com.chenyang.nse.bussiness.dao.table.core.desensitizationtask.DesensitizationtableDao;
import com.chenyang.nse.bussiness.dao.table.core.desensitizationtask.DesensitizationtargetDao;
import com.chenyang.nse.bussiness.dao.table.core.desensitizationtask.DesensitizationtaskDao;
import com.chenyang.nse.bussiness.dao.table.core.file.TCoreFileStructureDao;
import com.chenyang.nse.bussiness.dao.table.core.file.TCoreFileStructurespliterDao;
import com.chenyang.nse.bussiness.dao.table.core.masking.TCoreMaskingRuleinfoDao;
import com.chenyang.nse.bussiness.engine.infa.InfoProperty;
import com.chenyang.nse.bussiness.engine.infa.basic.webservice.LoginWebService;
import com.chenyang.nse.bussiness.engine.infa.basic.webservice.LogoutWebService;
import com.chenyang.nse.bussiness.engine.infa.basic.webservice.MultiGetSessionStatisticsWebService;
import com.chenyang.nse.bussiness.engine.infa.basic.webservice.SessionBean;
import com.chenyang.nse.bussiness.engine.infa.basic.webservice.StartWorkFlowWebService;
import com.chenyang.nse.bussiness.engine.infa.basic.wsclient.DIServiceInfo;
import com.chenyang.nse.bussiness.engine.infa.basic.wsclient.DataIntegrationInterface;
import com.chenyang.nse.bussiness.engine.infa.basic.wsclient.DataIntegrationService;
import com.chenyang.nse.bussiness.engine.infa.basic.wsclient.ETaskRunMode;
import com.chenyang.nse.bussiness.engine.infa.basic.wsclient.Fault;
import com.chenyang.nse.bussiness.engine.infa.basic.wsclient.SessionHeader;
import com.chenyang.nse.bussiness.engine.infa.basic.wsclient.TypeStartWorkflowExRequest;
import com.chenyang.nse.bussiness.engine.infa.basic.wsclient.TypeStartWorkflowExResponse;
import com.chenyang.nse.bussiness.engine.infa.basic.wsclient.WorkflowRequest;
import com.chenyang.nse.bussiness.engine.infa.powercenter961.pubbean.ModifyImportFile;
import com.chenyang.nse.bussiness.engine.infa.powercenter961.pubtool.InfoExecUtil;
import com.chenyang.nse.bussiness.engine.infa.powercenter961.pubtool.ToObjutil;
import com.chenyang.nse.bussiness.entity.cache.LoginUser;
import com.chenyang.nse.bussiness.entity.orm.table.base.TBaseUser;
import com.chenyang.nse.bussiness.entity.orm.table.console.TConsoleLog;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreConfig;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreDatasystem;
import com.chenyang.nse.bussiness.entity.orm.table.core.desensitizationtask.DesensitizationFile;
import com.chenyang.nse.bussiness.entity.orm.table.core.desensitizationtask.DesensitizationTable;
import com.chenyang.nse.bussiness.entity.orm.table.core.desensitizationtask.DesensitizationTablecolumn;
import com.chenyang.nse.bussiness.entity.orm.table.core.desensitizationtask.Desensitizationsource;
import com.chenyang.nse.bussiness.entity.orm.table.core.desensitizationtask.Desensitizationtarget;
import com.chenyang.nse.bussiness.entity.orm.table.core.desensitizationtask.Desensitizationtask;
import com.chenyang.nse.bussiness.entity.orm.table.core.discovery.TCoreFieldSensitiveMemory;
import com.chenyang.nse.bussiness.entity.orm.table.core.file.TCoreFileStructure;
import com.chenyang.nse.bussiness.entity.orm.table.core.file.TCoreFileStructurespliter;
import com.chenyang.nse.bussiness.entity.orm.table.core.masking.TCoreMaskingRuleinfo;
import com.chenyang.nse.bussiness.entity.redis.TCoreMaskingTaskTableInfo;
import com.chenyang.nse.bussiness.entity.vo.maskingtask.ColumnInfoVO;
import com.chenyang.nse.bussiness.enumeration.EdbType;
import com.chenyang.nse.bussiness.enumeration.datamapping.EdataMappingType;
import com.chenyang.nse.bussiness.service.console.DesensitizationDataMappingService;
import com.chenyang.nse.bussiness.service.console.OperationService;
import com.chenyang.nse.bussiness.service.core.DataSystemService;
import com.chenyang.nse.bussiness.service.core.DesensitizationtaskSerialService;
import com.chenyang.nse.bussiness.service.redis.RedisService;
import com.chenyang.nse.bussiness.thread.ExecuteParam;
import com.chenyang.nse.bussiness.tools.command.CommandTool;
import com.chenyang.nse.bussiness.tools.io.FileTool;
import com.chenyang.nse.bussiness.tools.jdbc.JdbcTool;
import com.chenyang.nse.bussiness.tools.jdbc.MysqlLoadTableTool;
import com.chenyang.nse.bussiness.tools.jdbc.SqlServerBcpTableTool;
import com.chenyang.nse.bussiness.tools.jdbc.SybaseBcpTableTool;
import com.chenyang.nse.bussiness.tools.jdbc.SybaseIQLoadTableTool;
import com.chenyang.nse.bussiness.tools.jdbc.TeradataLoadTableTool;
import com.chenyang.nse.bussiness.tools.jdbc.TeradataTool;
import com.chenyang.nse.bussiness.tools.net.FtpTool;
import com.chenyang.nse.bussiness.tools.net.SFTPUtil;
import com.chenyang.nse.bussiness.tools.object.ObjectTool;
import com.chenyang.nse.bussiness.tools.string.AesTool;
import com.chenyang.nse.bussiness.tools.xml.XmlTool;
import com.power.xml.entity.ColumnInfo;
import com.power.xml.entity.Config;
import com.power.xml.entity.FlatFile;
import com.power.xml.entity.Info;
import com.power.xml.entity.SourceInfo;
import com.power.xml.entity.TargetInfo;
import com.power.xml.entity.externalcall.DataBaseType;
import com.power.xml.external.PowerXml;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Repository;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import transdbf.transdbf;

@Service
@Repository
@EnableAsync
@Transactional
public class DesensitizationtaskSerialServiceImpl implements DesensitizationtaskSerialService {
   private static final String Link_character = "_";
   private static final String FILE_PATH = "/data/infa_file/";
   private static final boolean isteststate = false;
   private static Properties props = new Properties();
   @Autowired
   private TCoreEngineDao tCoreEngineDao;
   @Autowired
   private EngineDao engineDao;
   @Autowired
   private DesensitizationtaskDao desensitizationtaskDao;
   @Autowired
   private DesensitizationsourceDao desensitizationsourceDao;
   @Autowired
   private DesensitizationtargetDao desensitizationtargetDao;
   @Autowired
   private DesensitizationtableDao desensitizationTableDao;
   @Autowired
   private DesensitizationTablecolumnDao desensitizationTablecolumnDao;
   @Autowired
   private DesensitizationDataMappingService desensitizationdataMappingService;
   @Autowired
   private TCoreDatasystemDao tCoreDatasystemDao;
   @Autowired
   private TCoreMaskingRuleinfoDao tCoreMaskingRuleinfoDao;
   @Autowired
   private HttpServletRequest request;
   @Autowired
   private ToObjutil to;
   @Autowired
   private DataSystemService dataSystemService;
   @Autowired
   private ThreadPoolTaskExecutor taskExecutor;
   @Autowired
   private OperationService operationService;
   @Autowired
   private DesensitizationMonitorDao desensitizationMonitorDao;
   @Autowired
   private DesensitizationFileDao desensitizationFileDao;
   @Autowired
   private TCoreFileStructureDao tCoreFileStructureDao;
   @Autowired
   private TCoreFileStructurespliterDao tCoreFileStructurespliterDao;
   @Autowired
   private RedisService redisService;
   @Autowired
   private TCoreConfigDao tCoreConfigDao;

   public List<Desensitizationtask> queryTask(String taskname, PageInfo pageInfo) {
      List<Desensitizationtask> list = this.desensitizationtaskDao.queryByPageInfo(pageInfo, Order.desc("updatatime"), new Criterion[]{Restrictions.like("taskname", "%" + taskname + "%"), Restrictions.eq("flag", "1")});
      return list;
   }

   public void saveDesensitizationtask(String tasknamereal, Desensitizationtask desensitizationtask, LoginUser loginUser) {
      desensitizationtask = (Desensitizationtask)this.redisService.get(tasknamereal + "_" + desensitizationtask.getClass().getSimpleName());
      desensitizationtask.setCreatetime(new Date());
      desensitizationtask.setUpdatatime(new Date());
      TBaseUser user = loginUser.getTsysUser();
      desensitizationtask.setUserid(user.getId());
      desensitizationtask.setUsername(user.getUsername());
      this.desensitizationtaskDao.save(desensitizationtask);
   }

   public Desensitizationtarget saveDesensitizationtarget(String tasknamereal, String taskid, Desensitizationtarget desensitizationtarget, String state) {
      switch (state) {
         case "3":
            desensitizationtarget = (Desensitizationtarget)this.redisService.get(tasknamereal + "_" + desensitizationtarget.getClass().getSimpleName());
            if (desensitizationtarget != null) {
               desensitizationtarget.setTaskid(taskid);
               this.desensitizationtargetDao.save(desensitizationtarget);
            }
            break;
         case "2":
            desensitizationtarget = (Desensitizationtarget)this.desensitizationtargetDao.queryUnique(new Criterion[]{Restrictions.eq("taskid", taskid)});
      }

      return desensitizationtarget;
   }

   public Desensitizationsource saveDesensitizationsource(String tasknamereal, String taskid, Desensitizationsource desensitizationsource, String state) {
      switch (state) {
         case "3":
            desensitizationsource = (Desensitizationsource)this.redisService.get(tasknamereal + "_" + desensitizationsource.getClass().getSimpleName());
            if (desensitizationsource != null) {
               desensitizationsource.setTaskid(taskid);
               this.desensitizationsourceDao.save(desensitizationsource);
            }
            break;
         case "2":
            desensitizationsource = (Desensitizationsource)this.desensitizationsourceDao.queryUnique(new Criterion[]{Restrictions.eq("taskid", taskid)});
      }

      return desensitizationsource;
   }

   public DesensitizationFile saveDesensitizationFile(String tasknamereal, String taskid, DesensitizationFile desensitizationFile, String state) {
      switch (state) {
         case "3":
            desensitizationFile = (DesensitizationFile)this.redisService.get(tasknamereal + "_" + desensitizationFile.getClass().getSimpleName());
            if (desensitizationFile != null) {
               desensitizationFile.setTaskid(taskid);
               this.desensitizationFileDao.save(desensitizationFile);
            }
            break;
         case "2":
            desensitizationFile = (DesensitizationFile)this.desensitizationFileDao.queryUnique(new Criterion[]{Restrictions.eq("taskid", taskid)});
      }

      return desensitizationFile;
   }

   public void getDesensitizationTable(List<Map<String, String>> tCoreMaskingTaskTableList) {
      tCoreMaskingTaskTableList = (List)tCoreMaskingTaskTableList.stream().filter((s) -> "1".equals(s.get("status")) || "3".equals(s.get("status"))).collect(Collectors.toList());
   }

   public Map<String, String> EdataMappingType() {
      Map<String, String> map = new HashMap();

      for(EdataMappingType em : EdataMappingType.values()) {
         map.put(em.getName(), em.getFlag());
      }

      return map;
   }

   public Map<String, Object> saveDesensitizationTable(Desensitizationtask desensitizationtask, String taskid, List<DesensitizationTable> desensitizationTableList, Desensitizationsource desensitizationsource, Desensitizationtarget desensitizationtarget, List<Map<String, String>> tablelistmap, String state, DesensitizationFile desensitizationfile, Map<String, String> map_table_filterConditions, String tableNamesOrder) throws Exception {
      String save_state = "0";
      String tasknamereal = desensitizationtask.getTasknamereal();
      String mappletDir = props.getProperty("mappletDir");
      InfoProperty infoProperty = this.getInfoProperty();
      String xml_folder_path = "";
      String[] tableOrder = tableNamesOrder.split(",");
      xml_folder_path = infoProperty.getXmldir() + File.separator + "masking_task" + File.separator;
      String xml_file_path = xml_folder_path + tasknamereal + ".xml";
      Map<String, Object> map_xml = new HashMap();
      List<Info> infoList = new ArrayList();
      if (!FileTool.isFileExit(xml_folder_path)) {
         FileTool.createFolder(xml_folder_path);
      }

      TCoreDatasystem datasystemdesensitizationtarget = (TCoreDatasystem)this.tCoreDatasystemDao.get(desensitizationtarget.getDatasourceid());
      TCoreDatasystem datasystemdesensitizationsource = null;
      if (desensitizationsource.getDatasourceid() != null) {
         datasystemdesensitizationsource = (TCoreDatasystem)this.tCoreDatasystemDao.get(desensitizationsource.getDatasourceid());
      }

      String baseType = this.returnBaseType(datasystemdesensitizationtarget, datasystemdesensitizationsource);
      desensitizationtask.setTasktype(baseType);
      String getDbtype_t = datasystemdesensitizationtarget == null ? "FILE" : datasystemdesensitizationtarget.getDbtype();
      String getDbtype_s = datasystemdesensitizationsource == null ? "FILE" : datasystemdesensitizationsource.getDbtype();
      String targettype = "";
      String sourcetype = "";
      Boolean targetisfile = false;
      switch (getDbtype_t) {
         case "FILE":
            targettype = "FILE";
            break;
         case "FTP":
            targettype = "FILE";
            break;
         case "SFTP":
            targettype = "FILE";
            break;
         default:
            targettype = "DB";
      }

      switch (getDbtype_s) {
         case "FILE":
            sourcetype = "FILE";
            break;
         case "FTP":
            sourcetype = "FILE";
            break;
         case "SFTP":
            sourcetype = "FILE";
            break;
         default:
            sourcetype = "DB";
      }

      if ("FILE".equals(targettype)) {
         targetisfile = true;
      }

      Map<String, String> mapparam = new HashMap();
      mapparam.put("folderName", desensitizationtask.getFoldername());
      mapparam.put("execution_type_s", desensitizationsource.getExecution_type());
      mapparam.put("execution_type_t", desensitizationtarget.getExecution_type());
      mapparam.put("domainName", infoProperty.getDomainname());
      mapparam.put("mappletDir", mappletDir);
      mapparam.put("repository", infoProperty.getRepository());
      mapparam.put("xmlLocation", xml_file_path);
      mapparam.put("serverName", infoProperty.getInteservicename());
      mapparam.put("target_type", targettype);
      mapparam.put("source_type", sourcetype);
      mapparam.put("isrecover", desensitizationtask.getIsrecover());
      Config pwc_config = this.pwc_config(mapparam);
      switch (state) {
         case "2":
            this.desensitizationTableDao.remove(new Criterion[]{Restrictions.eq("taskid", taskid)});
            this.desensitizationTablecolumnDao.remove(new Criterion[]{Restrictions.eq("taskid", taskid)});
            this.updateTask(tasknamereal, "0");
         default:
            boolean issomedb = true;
            if (getDbtype_t.equals(getDbtype_s)) {
               issomedb = true;
            } else {
               issomedb = false;
            }

            Connection tconn = null;
            if (!targetisfile) {
               tconn = this.getConnectionByDataSystemId(datasystemdesensitizationtarget);
            }

            Map<String, String> datamap = this.EdataMappingType();
            List<Map<String, String>> map_t = this.desensitizationdataMappingService.getDatamappingInfo((String)datamap.get(targetisfile ? "FILESYSTEM" : datasystemdesensitizationtarget.getDbtype().toUpperCase()), "10");
            List<Map<String, String>> map_s = this.desensitizationdataMappingService.getDatamappingInfo((String)datamap.get("FILE".equals(sourcetype) ? "FILESYSTEM" : datasystemdesensitizationsource.getDbtype().toUpperCase()), "10");
            Map<String, String> data_rule = this.getDataRuleMap();
            Map<String, String> data_s = new HashMap();
            Map<String, Map<String, String>> data_t = new HashMap();
            Map<String, Map<String, String>> data_s_length = new HashMap();
            Map<String, Map<String, String>> data_t_length = new HashMap();
            Map<String, Map<String, String>> data_t_x_length = new HashMap();

            for(Map<String, String> map : map_s) {
               if ("1".equals(map.get("sourcedefault"))) {
                  data_s_length.put(((String)map.get("sourcefieldname")).toLowerCase(), map);
               }
            }

            for(Map<String, String> map : map_s) {
               if ("1".equals(map.get("sourcedefault"))) {
                  data_s.put(((String)map.get("sourcefieldname")).toLowerCase(), map.get("targetfieldname"));
               }
            }

            for(Map<String, String> map : map_t) {
               if (map.get("isdefault") != null && "1".equals(map.get("isdefault"))) {
                  data_t.put(map.get("targetfieldname"), map);
               }

               if ("1".equals(map.get("sourcedefault"))) {
                  data_t_length.put(((String)map.get("sourcefieldname")).toLowerCase(), map);
               }

               data_t_x_length.put((map.get("sourcefieldname") == null ? "" : (String)map.get("sourcefieldname")).toLowerCase() + (map.get("targetfieldname") == null ? "" : (String)map.get("targetfieldname")).toLowerCase(), map);
            }

            StringBuilder sb_sql_t = new StringBuilder();
            StringBuilder sb_sql_c = new StringBuilder();
            List<String> list_table = JdbcTool.sql_insert_q(new DesensitizationTable());
            list_table.add("id");
            list_table.add("note");
            String sb_sql_table = JdbcTool.sql_insert_z(list_table, "desensitization_table");
            sb_sql_t.append(sb_sql_table);
            List<String> list_column = JdbcTool.sql_insert_q(new DesensitizationTablecolumn());
            list_column.add("id");
            String sb_sql_column = JdbcTool.sql_insert_z(list_column, "desensitization_tablecolumn");
            sb_sql_c.append(sb_sql_column);
            int i = 0;
            this.redisService.set(tasknamereal + "_zcount", tablelistmap.size() + (tablelistmap.size() / 10 == 0 ? 1 : tablelistmap.size() / 10) + (tablelistmap.size() / 10 == 0 ? 1 : tablelistmap.size() / 10) + "");
            List<String> ttablenamelist = new ArrayList();
            if (!targetisfile) {
               ttablenamelist = JdbcTool.getAllTableName(tconn, desensitizationtarget.getDataschema());
            }

            for(Map<String, String> tCoreMaskingTaskTable : tablelistmap) {
               StringBuffer sql_all = new StringBuffer();
               sql_all.append("select ");
               boolean iskeycolumn = false;
               ++i;
               DesensitizationTable desensitizationTable = new DesensitizationTable();
               String tableName = (String)tCoreMaskingTaskTable.get("tableName");
               String status = (String)tCoreMaskingTaskTable.get("status");
               desensitizationTable.setStatus((String)tCoreMaskingTaskTable.get("status"));
               desensitizationTable.setTablename(tableName);
               desensitizationTable.setTaskid(taskid);
               desensitizationTable.setId(UUID.randomUUID().toString());
               desensitizationTable.setFilename(tCoreMaskingTaskTable.get("filename") != null ? (String)tCoreMaskingTaskTable.get("filename") + (String)tCoreMaskingTaskTable.get("extension") : "");
               desensitizationTable.setFilepath(tCoreMaskingTaskTable.get("filedir") != null ? (String)tCoreMaskingTaskTable.get("filedir") : "");
               desensitizationTable.setFilestructureid(tCoreMaskingTaskTable.get("structureid") != null ? (String)tCoreMaskingTaskTable.get("structureid") : "");
               desensitizationTable.setSqlFilter(map_table_filterConditions != null ? (map_table_filterConditions.get(tableName) != null ? ((String)map_table_filterConditions.get(tableName)).replaceAll("\"", "'") : "") : "");

               for(int j = 0; j < tableOrder.length; ++j) {
                  if (tableName.equals(tableOrder[j])) {
                     desensitizationTable.setNote(j + "");
                     break;
                  }
               }

               SourceInfo pwc_sourceInfo = new SourceInfo();
               TargetInfo pwc_targetInfo = new TargetInfo();
               List<ColumnInfo> sourcecolumnInfoList = new ArrayList();
               List<ColumnInfo> targetcolumnInfoList = new ArrayList();
               new ArrayList();
               List<TCoreMaskingTaskTableInfo> tCoreMaskingTaskTableInfoList = (List)this.redisService.get(tasknamereal + "_" + "TCoreMaskingTaskTableInfo_" + tableName);
               if (tCoreMaskingTaskTableInfoList == null) {
                  tCoreMaskingTaskTableInfoList = new ArrayList();
                  String sourceschema = desensitizationsource.getDataschema();
                  HashMap<String, TCoreFieldSensitiveMemory> map_rule = this.getTCoreFieldSensitiveMemory(tableName, sourceschema);
                  List<ColumnInfoVO> queryColumnInfo = this.queryColumnInfo(desensitizationsource.getDatasourceid(), desensitizationsource.getDataschema(), tableName);
                  int sortnum = 0;

                  for(ColumnInfoVO columnInfoVO : queryColumnInfo) {
                     ++sortnum;
                     String qualifierType = (String)data_s.get(columnInfoVO.getTypename().toLowerCase());
                     String source_hq = columnInfoVO.getTypename();
                     switch (getDbtype_s) {
                        case "MSSQLSERVER":
                           String source = JdbcTool.sqlServerTypeTran(columnInfoVO.getTypename(), columnInfoVO.getDatatype()).toLowerCase();
                           qualifierType = (String)data_s.get(source.toLowerCase());
                           columnInfoVO.setTypename(source);
                        default:
                           Map<String, String> maptarget = (Map)data_t.get(qualifierType);
                           if (maptarget == null) {
                              System.out.println("error:请取后台配置脱敏任务对应关系" + tableName + ":" + qualifierType + "_" + columnInfoVO.getTypename());
                           }

                           TCoreMaskingTaskTableInfo tCoreMaskingTaskTableInfo = this.gettCoreMaskingTaskTableInfoByInsert(source_hq, sortnum, issomedb, targetisfile, maptarget, map_rule, columnInfoVO);
                           if (issomedb) {
                              tCoreMaskingTaskTableInfo.setLengthruletype((String)((Map)data_s_length.get(tCoreMaskingTaskTableInfo.getSourceType().toLowerCase())).get("flag"));
                           }

                           if ("SYSDATE".equalsIgnoreCase(tCoreMaskingTaskTableInfo.getColumnName())) {
                              iskeycolumn = true;
                              sql_all.append(tableName + "." + tCoreMaskingTaskTableInfo.getColumnName() + " " + tCoreMaskingTaskTableInfo.getColumnName() + "1");
                              sql_all.append(",");
                           } else {
                              sql_all.append(tableName + "." + tCoreMaskingTaskTableInfo.getColumnName());
                              sql_all.append(",");
                           }

                           ColumnInfo pwc_columnInfo_source = this.getPwc_columnInfo_source(tCoreMaskingTaskTableInfo, qualifierType, data_rule, data_s, data_s_length, pwc_config);
                           sourcecolumnInfoList.add(pwc_columnInfo_source);
                           ColumnInfo pwc_columnInfo_target = this.getPwc_columnInfo_target(0, tCoreMaskingTaskTableInfo, qualifierType, data_rule, data_t, data_t_length, pwc_config, data_s, issomedb, targetisfile, data_t_x_length);
                           targetcolumnInfoList.add(pwc_columnInfo_target);
                           ((List)tCoreMaskingTaskTableInfoList).add(tCoreMaskingTaskTableInfo);
                     }
                  }
               } else {
                  int sortnum = 0;

                  for(TCoreMaskingTaskTableInfo tCoreMaskingTaskTableInfo : tCoreMaskingTaskTableInfoList) {
                     ++sortnum;
                     String qualifierType = (String)data_s.get(tCoreMaskingTaskTableInfo.getSourceType().toLowerCase());
                     String source_hq = tCoreMaskingTaskTableInfo.getSourceType();
                     switch (getDbtype_s) {
                        case "MSSQLSERVER":
                           List<ColumnInfoVO> queryColumnInfo = this.queryColumnInfo(desensitizationsource.getDatasourceid(), desensitizationsource.getDataschema(), tableName);
                           Map<String, String> mapdatatype = new HashMap();

                           for(ColumnInfoVO columnInfoVO : queryColumnInfo) {
                              mapdatatype.put(columnInfoVO.getColumnname(), columnInfoVO.getDatatype());
                           }

                           String source = JdbcTool.sqlServerTypeTran(tCoreMaskingTaskTableInfo.getSourceType(), (String)mapdatatype.get(tCoreMaskingTaskTableInfo.getColumnName()));
                           qualifierType = (String)data_s.get(source.toLowerCase());
                           source_hq = tCoreMaskingTaskTableInfo.getSourceType();
                           tCoreMaskingTaskTableInfo.setTruesearchType(source_hq);
                           tCoreMaskingTaskTableInfo.setSourceType(source);
                           break;
                        default:
                           source_hq = tCoreMaskingTaskTableInfo.getSourceType();
                           tCoreMaskingTaskTableInfo.setTruesearchType(source_hq);
                           tCoreMaskingTaskTableInfo.setSourceType(source_hq);
                     }

                     if (issomedb) {
                        tCoreMaskingTaskTableInfo.setTargetType(tCoreMaskingTaskTableInfo.getSourceType());
                     }

                     if (tCoreMaskingTaskTableInfo.getTargetType() == null) {
                        tCoreMaskingTaskTableInfo.setTargetType((String)((Map)data_t.get(qualifierType)).get("sourcefieldname"));
                     }

                     Map<String, String> maptarget = (Map)data_t_x_length.get(tCoreMaskingTaskTableInfo.getTargetType().toLowerCase() + qualifierType);
                     if (maptarget == null) {
                        System.out.println("error:请取后台配置脱敏任务对应关系" + tableName + ":" + qualifierType + "_" + tCoreMaskingTaskTableInfo.getSourceType());
                     }

                     tCoreMaskingTaskTableInfo = this.gettCoreMaskingTaskTableInfoByUpdate(sortnum, issomedb, targetisfile, maptarget, tCoreMaskingTaskTableInfo);
                     if ("SYSDATE".equalsIgnoreCase(tCoreMaskingTaskTableInfo.getColumnName())) {
                        iskeycolumn = true;
                        sql_all.append(tableName + "." + tCoreMaskingTaskTableInfo.getColumnName() + " " + tCoreMaskingTaskTableInfo.getColumnName() + "1");
                        sql_all.append(",");
                     } else {
                        sql_all.append(tableName + "." + tCoreMaskingTaskTableInfo.getColumnName());
                        sql_all.append(",");
                     }

                     ColumnInfo pwc_columnInfo_source = this.getPwc_columnInfo_source(tCoreMaskingTaskTableInfo, qualifierType, data_rule, data_s, data_s_length, pwc_config);
                     sourcecolumnInfoList.add(pwc_columnInfo_source);
                     ColumnInfo pwc_columnInfo_target = this.getPwc_columnInfo_target(1, tCoreMaskingTaskTableInfo, qualifierType, data_rule, data_t, data_t_length, pwc_config, data_s, issomedb, targetisfile, data_t_x_length);
                     targetcolumnInfoList.add(pwc_columnInfo_target);
                  }
               }

               sql_all.deleteCharAt(sql_all.length() - 1);
               sql_all.append(" from " + desensitizationsource.getDataschema() + "." + tableName);
               if (!targetisfile) {
                  boolean isNamesake = false;

                  for(String table : ttablenamelist) {
                     if (tableName.equalsIgnoreCase(table)) {
                        isNamesake = true;
                        break;
                     }
                  }

                  if ("isrebuild".equals(desensitizationtarget.getIsrebuild()) && isNamesake) {
                     JdbcTool.dropTable(tconn, desensitizationtarget.getDataschema(), tableName);
                     isNamesake = false;
                  }

                  if (!isNamesake) {
                     boolean isallownull = true;
                     if (getDbtype_t.equals("HIVE")) {
                        isallownull = false;
                     }

                     boolean ischar = false;
                     if (getDbtype_t.equals("ORACLE") && getDbtype_s.equals("ORACLE") && datasystemdesensitizationsource.getPagecode().equals("GBK") && datasystemdesensitizationtarget.getPagecode().equals("UTF-8")) {
                        ischar = true;
                     }

                     TCoreConfig tcoreConfig1 = (TCoreConfig)this.tCoreConfigDao.queryUnique(new Criterion[]{Restrictions.eq("datasystemid", desensitizationtarget.getDatasourceid())});
                     String sql = JdbcTool.getGenerateDDL_new(desensitizationtarget.getDataschema(), tableName, (List)tCoreMaskingTaskTableInfoList, isallownull, getDbtype_t, getDbtype_s, ischar, tcoreConfig1);
                     desensitizationTable.setCreate_sql(sql);
                     JdbcTool.createTable(tconn, sql);
                  }
               }

               sb_sql_t.append(JdbcTool.sql_insert_h(desensitizationTable, list_table));

               for(TCoreMaskingTaskTableInfo tCoreMaskingTaskTableInfo : tCoreMaskingTaskTableInfoList) {
                  DesensitizationTablecolumn desensitizationTablecolumn = this.getDesensitizationTablecolumn(tCoreMaskingTaskTableInfo, desensitizationTable.getId(), taskid);
                  sb_sql_c.append(JdbcTool.sql_insert_h(desensitizationTablecolumn, list_column));
               }

               String taskname = tasknamereal + "_" + tableName;
               pwc_sourceInfo.setColumnInfoList(sourcecolumnInfoList);
               pwc_sourceInfo.setConnectName(sourcetype.equals("FILE") ? "" : datasystemdesensitizationsource.getDblinkname());
               pwc_sourceInfo.setDataBaseType(sourcetype.equals("FILE") ? DataBaseType.FLATFILE : datasystemdesensitizationsource.getDbtype().toUpperCase());
               FlatFile sourceflatFile = new FlatFile();
               if (pwc_config.getReadMode() == 1) {
                  String key = desensitizationtask.getTasktype().split("to")[0];
                  new TCoreFileStructure();
                  new TCoreFileStructurespliter();
                  switch (key) {
                     case "FILE":
                        sourceflatFile = this.getflatFile(desensitizationTable, key);
                        break;
                     case "FTP":
                        sourceflatFile = this.getflatFile(desensitizationTable, key);
                        break;
                     case "SFTP":
                        sourceflatFile = this.getflatFile(desensitizationTable, key);
                        break;
                     default:
                        String pagecode = datasystemdesensitizationsource.getPagecode();
                        String dataBaseType = pwc_sourceInfo.getDataBaseType();
                        sourceflatFile = this.getflatFile("source", pagecode, dataBaseType, tableName, tasknamereal);
                  }
               }

               pwc_sourceInfo.setFlatFile(sourceflatFile);
               pwc_sourceInfo.setName(tableName);
               pwc_sourceInfo.setSchema(desensitizationsource.getDataschema());
               pwc_sourceInfo.setSqlFilter(desensitizationTable.getSqlFilter());
               if (iskeycolumn) {
                  pwc_sourceInfo.setSqlQuery(sql_all.toString());
               } else {
                  pwc_sourceInfo.setSqlQuery("");
               }

               pwc_targetInfo.setColumnInfoList(targetcolumnInfoList);
               if (!targetisfile) {
                  pwc_targetInfo.setConnectName(datasystemdesensitizationtarget.getDblinkname());
                  pwc_targetInfo.setDataBaseType(datasystemdesensitizationtarget.getDbtype().toUpperCase());
               } else {
                  pwc_targetInfo.setConnectName("");
                  pwc_targetInfo.setDataBaseType(DataBaseType.FLATFILE);
               }

               FlatFile targetflatFile = new FlatFile();
               if (pwc_config.getWriteMode() == 1) {
                  String pagecode, dataBaseType, key = desensitizationtask.getTasktype().split("to")[1];
                  switch (desensitizationtask.getTasktype().split("to")[1]) {
                     case "FILE":
                        targetflatFile = this.getflatFile(desensitizationfile, tableName, key);
                        break;
                     case "FTP":
                        targetflatFile = this.getflatFile(desensitizationfile, tableName, key);
                        break;
                     case "SFTP":
                        targetflatFile = this.getflatFile(desensitizationfile, tableName, key);
                        break;
                     default:
                        pagecode = datasystemdesensitizationtarget.getPagecode();
                        dataBaseType = pwc_targetInfo.getDataBaseType();
                        targetflatFile = this.getflatFile("target", pagecode, dataBaseType, tableName, tasknamereal);
                  }
               }

               pwc_targetInfo.setFlatFile(targetflatFile);
               pwc_targetInfo.setName(tableName);
               pwc_targetInfo.setSchema(desensitizationtarget.getDataschema());
               pwc_targetInfo.setIsTruncate(desensitizationtarget.getIsclear() != null && desensitizationtarget.getIsclear().equals("isclear") ? 1 : 0);
               HashMap<String, Integer> writeType = new HashMap();
               writeType.put("insertorupdate", 2);
               writeType.put("insert", 0);
               writeType.put("delete", 3);
               writeType.put("update", 1);
               if (desensitizationtarget.getInserttype() != null) {
                  pwc_targetInfo.setWriteType((Integer)writeType.get(desensitizationtarget.getInserttype()));
               }

               Info info = this.pwc_Info(pwc_sourceInfo, pwc_targetInfo, taskname);
               infoList.add(info);
               this.redisService.set(tasknamereal + "_ncount", i + "");
            }

            if (tconn != null) {
               tconn.close();
            }

            this.desensitizationTableDao.saveDesensitizationtable(sb_sql_t.deleteCharAt(sb_sql_t.length() - 1));
            this.desensitizationTablecolumnDao.saveDesensitizationTablecolumn(sb_sql_c.deleteCharAt(sb_sql_c.length() - 1));
            int pwc_state = PowerXml.generatePowerXml(infoList, pwc_config);
            map_xml.put("pwc_state", pwc_state == 1);
            i += tablelistmap.size() / 10 == 0 ? 1 : tablelistmap.size() / 10;
            this.redisService.set(tasknamereal + "_ncount", i + "");
            String con_file = DesensitizationtaskSerialServiceImpl.class.getResource("/").getPath().replaceAll("%20", " ") + "infofile" + File.separator + "con_import.xml";
            String foldername = desensitizationtask.getFoldername();
            String repository = infoProperty.getRepository();
            this.updateImportFile(con_file, foldername, repository);
            String importlog = InfoExecUtil.executImport(infoProperty.getPmrepexepath(), xml_file_path, con_file, infoProperty.getXmldir() + File.separator + "log.txt");
            map_xml.put("importlog", importlog.contains("已成功完成") || importlog.contains("successfully"));
            i += tablelistmap.size() / 10 == 0 ? 1 : tablelistmap.size() / 10;
            this.redisService.set(tasknamereal + "_ncount", i + "");
            map_xml.put("tasktype", desensitizationtask.getTasktype());
            return map_xml;
      }
   }

   public ColumnInfo getPwc_columnInfo_source(TCoreMaskingTaskTableInfo tCoreMaskingTaskTableInfo, String qualifierType, Map<String, String> data_rule, Map<String, String> data_s, Map<String, Map<String, String>> data_s_length, Config pwc_config) {
      ColumnInfo pwc_columnInfo_source = new ColumnInfo();
      pwc_columnInfo_source.setColumnName(tCoreMaskingTaskTableInfo.getColumnName());
      if ("SYSDATE".equalsIgnoreCase(pwc_columnInfo_source.getColumnName())) {
         pwc_columnInfo_source.setColumnName(tCoreMaskingTaskTableInfo.getColumnName() + "1");
      }

      pwc_columnInfo_source.setDataType(this.delparentheses(tCoreMaskingTaskTableInfo.getSourceType().toUpperCase()));
      pwc_columnInfo_source.setKeyType(tCoreMaskingTaskTableInfo.getIsPrimaryKey().equals("1") ? 1 : (tCoreMaskingTaskTableInfo.getIsForeignKey() != null ? (tCoreMaskingTaskTableInfo.getIsForeignKey().equals("1") ? 2 : 0) : 0));
      pwc_columnInfo_source.setMaskingRule((String)data_rule.get(tCoreMaskingTaskTableInfo.getRegexRuleId()));
      pwc_columnInfo_source.setNullable(pwc_columnInfo_source.getKeyType() != 0 ? 1 : 0);
      pwc_columnInfo_source.setQualifierType(qualifierType.toLowerCase());
      String sourcelength = (String)((Map)data_s_length.get(tCoreMaskingTaskTableInfo.getSourceType().toLowerCase())).get("sourcelength");
      String sourcescancale = (String)((Map)data_s_length.get(tCoreMaskingTaskTableInfo.getSourceType().toLowerCase())).get("sourcescancale");
      String pwcsqlength = (String)((Map)data_s_length.get(tCoreMaskingTaskTableInfo.getSourceType().toLowerCase())).get("pwcsqlength");
      String pwcsqscale = (String)((Map)data_s_length.get(tCoreMaskingTaskTableInfo.getSourceType().toLowerCase())).get("pwcsqscale");
      String pwcdateformat = (String)((Map)data_s_length.get(tCoreMaskingTaskTableInfo.getSourceType().toLowerCase())).get("pwcdateformat");
      pwc_columnInfo_source.setScale(sourcescancale != null && !sourcescancale.equals("") ? sourcescancale : tCoreMaskingTaskTableInfo.getColumnPrecision());
      pwc_columnInfo_source.setPrecision(sourcelength != null && !sourcelength.equals("") ? sourcelength : tCoreMaskingTaskTableInfo.getColumnLength());
      if (pwcsqlength != null && !pwcsqlength.equals("")) {
         pwc_columnInfo_source.setSqprecision(pwcsqlength);
         pwc_columnInfo_source.setSqscale(pwcsqscale);
      }

      if (pwcdateformat != null && !pwcdateformat.equals("") && pwc_config.getReadMode() == 1) {
         pwc_columnInfo_source.setDateTimeFormat(pwcdateformat);
      }

      return pwc_columnInfo_source;
   }

   public ColumnInfo getPwc_columnInfo_target(int type, TCoreMaskingTaskTableInfo tCoreMaskingTaskTableInfo, String qualifierType, Map<String, String> data_rule, Map<String, Map<String, String>> data_t, Map<String, Map<String, String>> data_t_length, Config pwc_config, Map<String, String> data_s, Boolean issomedb, Boolean targetisfile, Map<String, Map<String, String>> data_t_x_length) {
      ColumnInfo pwc_columnInfo_target = new ColumnInfo();
      String source = tCoreMaskingTaskTableInfo.getSourceType().toLowerCase();
      String pwc_type = (String)data_s.get(source);
      String targetype = "";
      String targetlength = "";
      String targetscancale = "";
      String targetpwcsqlength = "";
      String targetpwcsqscale = "";
      String targetpwcdateformat = "";
      if (type == 0) {
         targetype = ((String)((Map)data_t.get(pwc_type)).get("sourcefieldname")).toLowerCase();
         targetlength = (String)((Map)data_t_length.get(targetype)).get("sourcelength");
         targetscancale = (String)((Map)data_t_length.get(targetype)).get("sourcescancale");
         targetpwcsqlength = (String)((Map)data_t_length.get(targetype)).get("pwcsqlength");
         targetpwcsqscale = (String)((Map)data_t_length.get(targetype)).get("pwcsqscale");
         targetpwcdateformat = (String)((Map)data_t_length.get(targetype)).get("pwcdateformat");
      } else {
         targetype = tCoreMaskingTaskTableInfo.getTargetType().toLowerCase();
         targetlength = (String)((Map)data_t_x_length.get(targetype + pwc_type)).get("sourcelength");
         targetscancale = (String)((Map)data_t_x_length.get(targetype + pwc_type)).get("sourcescancale");
         targetpwcsqlength = (String)((Map)data_t_x_length.get(targetype + pwc_type)).get("pwcsqlength");
         targetpwcsqscale = (String)((Map)data_t_x_length.get(targetype + pwc_type)).get("pwcsqscale");
         targetpwcdateformat = (String)((Map)data_t_x_length.get(targetype + pwc_type)).get("pwcdateformat");
      }

      pwc_columnInfo_target.setColumnName(tCoreMaskingTaskTableInfo.getColumnName());
      if ("SYSDATE".equalsIgnoreCase(pwc_columnInfo_target.getColumnName())) {
         pwc_columnInfo_target.setColumnName(tCoreMaskingTaskTableInfo.getColumnName() + "1");
      }

      pwc_columnInfo_target.setDataType(this.delparentheses(targetype.toUpperCase()));
      pwc_columnInfo_target.setKeyType(tCoreMaskingTaskTableInfo.getIsPrimaryKey().equals("1") ? 1 : (tCoreMaskingTaskTableInfo.getIsForeignKey() != null ? (tCoreMaskingTaskTableInfo.getIsForeignKey().equals("1") ? 2 : 0) : 0));
      pwc_columnInfo_target.setMaskingRule((String)data_rule.get(tCoreMaskingTaskTableInfo.getRegexRuleId()));
      pwc_columnInfo_target.setNullable(pwc_columnInfo_target.getKeyType() != 0 ? 1 : 0);
      pwc_columnInfo_target.setQualifierType(qualifierType.toLowerCase());
      pwc_columnInfo_target.setScale(targetscancale != null && !targetscancale.equals("") ? targetscancale : tCoreMaskingTaskTableInfo.getColumnPrecision());
      pwc_columnInfo_target.setPrecision(targetlength != null && !targetlength.equals("") ? targetlength : tCoreMaskingTaskTableInfo.getColumnLength());
      if (pwc_columnInfo_target.getPrecision() == null || "".equals(pwc_columnInfo_target.getPrecision())) {
         pwc_columnInfo_target.setPrecision(tCoreMaskingTaskTableInfo.getColumnLength());
      }

      if (targetpwcsqlength != null && !targetpwcsqlength.equals("")) {
         pwc_columnInfo_target.setSqprecision(targetpwcsqlength);
         pwc_columnInfo_target.setSqscale(targetpwcsqscale);
      }

      if (targetpwcdateformat != null && !targetpwcdateformat.equals("") && pwc_config.getWriteMode() == 1) {
         pwc_columnInfo_target.setDateTimeFormat(targetpwcdateformat);
      }

      return pwc_columnInfo_target;
   }

   public TCoreMaskingTaskTableInfo gettCoreMaskingTaskTableInfoByUpdate(int sortnum, boolean issomedb, boolean targetisfile, Map<String, String> maptarget, TCoreMaskingTaskTableInfo tCoreMaskingTaskTableInfo) {
      tCoreMaskingTaskTableInfo.setSortnum(sortnum);
      tCoreMaskingTaskTableInfo.setTargetType(issomedb ? tCoreMaskingTaskTableInfo.getSourceType() : (String)maptarget.get("sourcefieldname"));
      tCoreMaskingTaskTableInfo.setTargetLength(!issomedb && !targetisfile ? (String)maptarget.get("targetlength") : tCoreMaskingTaskTableInfo.getColumnLength());
      tCoreMaskingTaskTableInfo.setTargetPrecision(!issomedb && !targetisfile ? (String)maptarget.get("targetdecimal") : tCoreMaskingTaskTableInfo.getColumnPrecision());
      tCoreMaskingTaskTableInfo.setLengthruletype((String)maptarget.get("flag"));
      tCoreMaskingTaskTableInfo.setIsnullable("");
      return tCoreMaskingTaskTableInfo;
   }

   public TCoreMaskingTaskTableInfo gettCoreMaskingTaskTableInfoByInsert(String source_hq, int sortnum, boolean issomedb, boolean isfile, Map<String, String> maptarget, HashMap<String, TCoreFieldSensitiveMemory> map, ColumnInfoVO columnInfoVO) {
      TCoreMaskingTaskTableInfo tCoreMaskingTaskTableInfo = new TCoreMaskingTaskTableInfo();
      tCoreMaskingTaskTableInfo.setTruesearchType(source_hq);
      tCoreMaskingTaskTableInfo.setSortnum(sortnum);
      tCoreMaskingTaskTableInfo.setIsPrimaryKey(columnInfoVO.getPrimarykey());
      tCoreMaskingTaskTableInfo.setIsForeignKey(columnInfoVO.getForeignkey());
      tCoreMaskingTaskTableInfo.setColumnName(columnInfoVO.getColumnname());
      tCoreMaskingTaskTableInfo.setSearchType(map.get(columnInfoVO.getColumnname()) == null ? "确认非敏感字段" : ((TCoreFieldSensitiveMemory)map.get(columnInfoVO.getColumnname())).getRegextype());
      tCoreMaskingTaskTableInfo.setSourceType(columnInfoVO.getTypename());
      tCoreMaskingTaskTableInfo.setTargetType(issomedb ? columnInfoVO.getTypename() : (String)maptarget.get("sourcefieldname"));
      tCoreMaskingTaskTableInfo.setTargetLength(!issomedb && !isfile ? (String)maptarget.get("targetlength") : columnInfoVO.getColumnsize());
      tCoreMaskingTaskTableInfo.setTargetPrecision(!issomedb && !isfile ? (String)maptarget.get("targetdecimal") : columnInfoVO.getDecimaldigits());
      tCoreMaskingTaskTableInfo.setLengthruletype((String)maptarget.get("flag"));
      tCoreMaskingTaskTableInfo.setColumnLength(columnInfoVO.getColumnsize());
      tCoreMaskingTaskTableInfo.setColumnPrecision(columnInfoVO.getDecimaldigits());
      tCoreMaskingTaskTableInfo.setRegexRuleId(map.get(columnInfoVO.getColumnname()) == null ? "" : ((TCoreFieldSensitiveMemory)map.get(columnInfoVO.getColumnname())).getRuleid());
      tCoreMaskingTaskTableInfo.setRegexRuleName(map.get(columnInfoVO.getColumnname()) == null ? "" : ((TCoreFieldSensitiveMemory)map.get(columnInfoVO.getColumnname())).getRuie());
      tCoreMaskingTaskTableInfo.setIsnullable("");
      return tCoreMaskingTaskTableInfo;
   }

   public void updateImportFile(String filepath, String foldername, String repository) throws Exception {
      File file = new File(filepath);
      ModifyImportFile mi = new ModifyImportFile();
      ModifyImportFile.updateConfigFileXML("TARGETFOLDERNAME", file, foldername);
      ModifyImportFile.updateConfigFileXML("SOURCEFOLDERNAME", file, foldername);
      ModifyImportFile.updateConfigFileXML("TARGETREPOSITORYNAME", file, repository);
      ModifyImportFile.updateConfigFileXML("SOURCEREPOSITORYNAME", file, repository);
   }

   @Async
   public Desensitizationtask savetask_info(String tasknamereal, Map<String, Object> map, String tableName) {
      String state = (String)map.get("state");
      System.out.println("state:" + state);
      new Desensitizationtask();
      Desensitizationtask desensitizationtask = (Desensitizationtask)this.desensitizationtaskDao.queryUnique(new Criterion[]{Restrictions.eq("tasknamereal", tasknamereal)});
      Desensitizationtarget desensitizationtarget = new Desensitizationtarget();
      desensitizationtarget = this.saveDesensitizationtarget(tasknamereal, desensitizationtask.getId(), desensitizationtarget, state);
      Desensitizationsource desensitizationsource = new Desensitizationsource();
      desensitizationsource = this.saveDesensitizationsource(tasknamereal, desensitizationtask.getId(), desensitizationsource, state);
      DesensitizationFile desensitizationfile = new DesensitizationFile();
      desensitizationfile = this.saveDesensitizationFile(tasknamereal, desensitizationtask.getId(), desensitizationfile, state);
      List<DesensitizationTable> desensitizationTable = new ArrayList();
      new ArrayList();
      Map<String, String> map_table_filterConditions = (Map)map.get("map_table_filterConditions");
      List<Map<String, String>> tCoreMaskingTaskTablemapList = (List)map.get("tableList");
      tCoreMaskingTaskTablemapList = (List)tCoreMaskingTaskTablemapList.stream().filter((s) -> "1".equals(s.get("status")) || "3".equals(s.get("status"))).collect(Collectors.toList());
      String save_state = "1";
      Map<String, Object> save_map = new HashMap();

      try {
         save_map = this.saveDesensitizationTable(desensitizationtask, desensitizationtask.getId(), desensitizationTable, desensitizationsource, desensitizationtarget, tCoreMaskingTaskTablemapList, state, desensitizationfile, map_table_filterConditions, tableName);
         save_state = "2";
      } catch (Exception e) {
         save_state = "1";
         e.printStackTrace();
         StringWriter sw = new StringWriter();
         e.printStackTrace(new PrintWriter(sw, true));
         String strs = sw.toString();
         System.out.println("--------------------------美丽的分割线----------------------");
         TConsoleLog record = new TConsoleLog();
         record.setNote(strs);
         record.setModule("新建脱敏任务+导入");
         record.setUser(desensitizationtask.getUsername());
         record.setLogno(tasknamereal);
         record.setOperationtime(new Date());
         this.operationService.add(record);
         System.out.println(strs);
         System.out.println("-------------------------美丽的收割线----------------------");
      }

      new ArrayList();
      String tasktype = (String)save_map.get("tasktype");
      Boolean pwc_state = (Boolean)save_map.get("pwc_state");
      Boolean importlog = (Boolean)save_map.get("importlog");
      if (pwc_state && importlog) {
         save_state = "2";
      } else {
         save_state = "1";
      }

      desensitizationtask.setTasktype(tasktype);
      desensitizationtask.setSave_state(save_state);
      desensitizationtask.setTaskstatus("0");
      this.desensitizationtaskDao.saveOrUpdate(desensitizationtask);
      this.updateTask(tasknamereal, save_state);
      return desensitizationtask;
   }

   public Connection getConnectionByDataSystemId(TCoreDatasystem datasystem) {
      String dbcode = datasystem.getDbtype();
      String ip = datasystem.getDbip();
      String port = datasystem.getDbport();
      String servername = datasystem.getDbservername();
      String server = datasystem.getServername();
      String url = "";
      switch (datasystem.getDbtype()) {
         case "INFORMIX":
            url = EdbType.getUrlByEdbcode(dbcode, ip, port, servername, server);
            break;
         case "TERADATA":
            url = EdbType.getUrlByEdbcode(dbcode, ip, port, servername, server, datasystem.getPagecode());
            break;
         default:
            url = EdbType.getUrlByEdbcode(dbcode, ip, port, servername);
      }

      String username = datasystem.getUsername();
      String password = "1".equals(datasystem.getFlag()) ? AesTool.decrypt(datasystem.getPassword(), "ghca") : datasystem.getPassword();
      String driver = EdbType.getEdbTypeByDbcode(dbcode).getDbdriver();
      Connection conn = JdbcTool.getConnection(driver, url, username, password);
      return conn;
   }

   public List<ColumnInfoVO> queryColumnInfo(String datasystemid, String schema, String tableName) {
      TCoreDatasystem datasystem = (TCoreDatasystem)this.tCoreDatasystemDao.get(datasystemid);
      if (datasystem == null) {
         return null;
      } else {
         Connection conn = this.getConnectionByDataSystemId(datasystem);
         List<ColumnInfoVO> list = JdbcTool.getColumnInfoVO(conn, schema, tableName);
         List<ColumnInfoVO> list1 = new ArrayList();
         if (datasystem.getDbtype().equals("SYBASE_IQ")) {
            for(ColumnInfoVO civ : list) {
               if (civ.getTypename().equals("varchar") || civ.getTypename().equals("char")) {
                  civ.setDecimaldigits("");
               }

               list1.add(civ);
            }
         }

         try {
            if (conn != null) {
               conn.close();
            }
         } catch (SQLException e) {
            e.printStackTrace();
         }

         return datasystem.getDbtype().equals("SYBASE_IQ") ? list1 : list;
      }
   }

   public String gettaskBytasknamereal(String tasknamereal) {
      Desensitizationtask desensitizationtask = (Desensitizationtask)this.desensitizationtaskDao.queryUnique(new Criterion[]{Restrictions.eq("tasknamereal", tasknamereal)});
      if (desensitizationtask != null) {
         return "2";
      } else {
         desensitizationtask = new Desensitizationtask();
         new LoginUser();
         LoginUser loginUser = (LoginUser)this.request.getSession().getAttribute("loginUser");
         desensitizationtask = (Desensitizationtask)this.redisService.get(tasknamereal + "_" + desensitizationtask.getClass().getSimpleName());
         desensitizationtask.setCreatetime(new Date());
         desensitizationtask.setUpdatatime(new Date());
         desensitizationtask.setSave_state("0");
         TBaseUser user = loginUser.getTsysUser();
         desensitizationtask.setUserid(user.getId());
         desensitizationtask.setUsername(user.getUsername());
         desensitizationtask.setFlag("1");
         this.desensitizationtaskDao.save(desensitizationtask);
         return "3";
      }
   }

   public Desensitizationsource querySourceInfo(String taskid) {
      return (Desensitizationsource)this.desensitizationsourceDao.queryUnique(new Criterion[]{Restrictions.eq("taskid", taskid)});
   }

   public Desensitizationtarget queryTargetInfo(String taskid) {
      return (Desensitizationtarget)this.desensitizationtargetDao.queryUnique(new Criterion[]{Restrictions.eq("taskid", taskid)});
   }

   public List<DesensitizationTable> queryTableList(String taskid) {
      return this.desensitizationTableDao.queryAll(new Criterion[]{Restrictions.eq("taskid", taskid)});
   }

   public DesensitizationTable queryTableByTableName(String taskid, String tableName) {
      return (DesensitizationTable)this.desensitizationTableDao.queryUnique(new Criterion[]{Restrictions.eq("taskid", taskid), Restrictions.eq("tablename", tableName)});
   }

   public Desensitizationtask queryTaskById(String taskid) {
      return (Desensitizationtask)this.desensitizationtaskDao.queryUnique(new Criterion[]{Restrictions.eq("id", taskid)});
   }

   public void removeTask(String taskid) {
      this.desensitizationtaskDao.removeById(taskid);
      this.desensitizationtargetDao.remove(new Criterion[]{Restrictions.eq("taskid", taskid)});
      this.desensitizationsourceDao.remove(new Criterion[]{Restrictions.eq("taskid", taskid)});
      this.desensitizationTableDao.remove(new Criterion[]{Restrictions.eq("taskid", taskid)});
      this.desensitizationTableDao.remove(new Criterion[]{Restrictions.eq("taskid", taskid)});
      this.desensitizationTablecolumnDao.remove(new Criterion[]{Restrictions.eq("taskid", taskid)});
   }

   public Info pwc_Info(SourceInfo sourceInfo, TargetInfo targetInfo, String taskname) {
      Info info = new Info();
      info.setSourceInfo(sourceInfo);
      info.setTargetInfo(targetInfo);
      info.setTaskname(taskname);
      return info;
   }

   public Config pwc_config(Map<String, String> mapparam) {
      Config config = new Config();
      int readMode = 0;
      int writeMode = 0;
      if (((String)mapparam.get("execution_type_s")).equals("normal")) {
         readMode = 0;
         if (((String)mapparam.get("execution_type_t")).equals("normal")) {
            writeMode = 0;
         } else {
            writeMode = 1;
         }
      } else {
         readMode = 1;
         if (((String)mapparam.get("execution_type_t")).equals("normal")) {
            writeMode = 0;
         } else {
            writeMode = 1;
         }
      }

      readMode = ((String)mapparam.get("source_type")).equals("FILE") ? 1 : readMode;
      writeMode = ((String)mapparam.get("target_type")).equals("FILE") ? 1 : writeMode;
      config.setDomainName((String)mapparam.get("domainName"));
      config.setFolderName((String)mapparam.get("folderName"));
      config.setMappletDir((String)mapparam.get("mappletDir"));
      config.setReadMode(readMode);
      config.setRepositoryName((String)mapparam.get("repository"));
      config.setServerName((String)mapparam.get("serverName"));
      config.setWriteMode(writeMode);
      config.setIsrecover(Integer.parseInt((String)mapparam.get("isrecover")));
      config.setXmlLocation((String)mapparam.get("xmlLocation"));
      return config;
   }

   public DesensitizationTablecolumn getDesensitizationTablecolumn(TCoreMaskingTaskTableInfo tCoreMaskingTaskTableInfo, String tableid, String taskid) {
      DesensitizationTablecolumn desensitizationTablecolumn = new DesensitizationTablecolumn();
      desensitizationTablecolumn.setColumnindex(0);
      desensitizationTablecolumn.setColumnlength(tCoreMaskingTaskTableInfo.getColumnLength());
      desensitizationTablecolumn.setColumnname(tCoreMaskingTaskTableInfo.getColumnName());
      desensitizationTablecolumn.setColumnscale(tCoreMaskingTaskTableInfo.getColumnPrecision());
      desensitizationTablecolumn.setColumntype(tCoreMaskingTaskTableInfo.getTruesearchType());
      desensitizationTablecolumn.setDatadirection(tCoreMaskingTaskTableInfo.getRemark());
      desensitizationTablecolumn.setId(UUID.randomUUID().toString());
      desensitizationTablecolumn.setJudgenull(tCoreMaskingTaskTableInfo.getIsnullable());
      desensitizationTablecolumn.setMappingkey("");
      desensitizationTablecolumn.setColumntartype(tCoreMaskingTaskTableInfo.getTargetType());
      desensitizationTablecolumn.setPrimarykey(tCoreMaskingTaskTableInfo.getIsPrimaryKey());
      desensitizationTablecolumn.setRegextype(tCoreMaskingTaskTableInfo.getRegexType());
      desensitizationTablecolumn.setRuleid(tCoreMaskingTaskTableInfo.getRegexRuleId());
      desensitizationTablecolumn.setRulename(tCoreMaskingTaskTableInfo.getRegexRuleName());
      desensitizationTablecolumn.setTableid(tableid);
      desensitizationTablecolumn.setTaskid(taskid);
      desensitizationTablecolumn.setSortnum(tCoreMaskingTaskTableInfo.getSortnum());
      return desensitizationTablecolumn;
   }

   public Desensitizationtarget queryTargetById(String taskid) {
      return (Desensitizationtarget)this.desensitizationtargetDao.queryUnique(new Criterion[]{Restrictions.eq("taskid", taskid)});
   }

   public InfoProperty getInfoProperty() {
      Map<String, Object> map = this.engineDao.queryEnginePropertyKeyValue(props.getProperty("engineid"));
      InfoProperty engine = (InfoProperty)ObjectTool.getObjectByMap(InfoProperty.class, map);
      return engine;
   }

   public List<Desensitizationtask> queryTaskList(String taskid) {
      List<Desensitizationtask> list = this.desensitizationtaskDao.queryAll(new Criterion[]{Restrictions.eq("id", taskid)});
      return list;
   }

   public int saveDesensitizationMonitor(StringBuilder sql) {
      return this.desensitizationMonitorDao.saveDesensitizationMonitor(sql);
   }

   @Async
   public void executeDB_pwc_FILE_batchwrite_DB(ExecuteParam executeParam) throws Exception {
      System.out.println(">>>>>>>>>>>>>>>>>DB_pwc_FILE_batchwrite_DB<<<<<<<<<<<<<<<<<<");
      Runtime rn = Runtime.getRuntime();
      List<DesensitizationTable> tableList = this.queryTableList(executeParam.getTaskid());
      Connection targetConn = this.dataSystemService.getConnectionByDataSystemId(executeParam.getDataTargetId());
      CountDownLatch countDownLatch = new CountDownLatch(tableList.size());
      TCoreDatasystem tCoreDatasystemTarget = this.dataSystemService.queryDataSystemById(executeParam.getDataTargetId());
      Map<String, List<DesensitizationTablecolumn>> map = new HashMap();

      for(DesensitizationTable desensitizationTable : tableList) {
         List<DesensitizationTable> list = this.desensitizationTableDao.queryAll(new Criterion[]{Restrictions.eq("tablename", desensitizationTable.getTablename()), Restrictions.eq("taskid", executeParam.getTaskid())});
         List<DesensitizationTablecolumn> desensitizationTablecolumnList = this.desensitizationTablecolumnDao.queryAll(Order.asc("sortnum"), new Criterion[]{Restrictions.eq("tableid", ((DesensitizationTable)list.get(0)).getId())});
         map.put(desensitizationTable.getTablename(), desensitizationTablecolumnList);
      }

      Desensitizationtask desensitizationTask = (Desensitizationtask)this.desensitizationtaskDao.get(executeParam.getTaskid());
      desensitizationTask.setTaskstatus("1");
      this.desensitizationtaskDao.saveOrUpdate(desensitizationTask);
      this.desensitizationtaskDao.getSession().getTransaction().commit();
      Collections.sort(tableList);

      for(DesensitizationTable desensitizationTable : tableList) {
         String sessionId = "";
         String status = "4";
         String workflowName = "wf_" + executeParam.getTaskNameReal() + "_" + desensitizationTable.getTablename();

         try {
            if ("startup".equals(props.getProperty("Forecast_Run_Time"))) {
               System.out.println("---进入启动预计运行时间方法！");
               String dataCount = "";
               dataCount = this.getDataCount(executeParam.getSourceDataSystem().getDbtype(), executeParam.getSourceDataSystem(), desensitizationTable, executeParam.getSourceSchemaName());
               System.out.println("数据源表" + desensitizationTable.getTablename() + "总行数：" + dataCount);
               this.redisService.set("dataCount:" + desensitizationTask.getTasknamereal() + "_" + desensitizationTable.getTablename(), dataCount);
               System.out.println("预计运行时间，key=dataCount:" + desensitizationTask.getTasknamereal() + "_" + desensitizationTable.getTablename() + "，dataCount=" + dataCount);
            }

            this.updateMonitorRunStatus(desensitizationTable.getTablename(), executeParam.getTableMap());
            System.out.println("~~~~~~~~~~~~~~~~~~~~~~~获取sessionId开始！");
            sessionId = LoginWebService.returnStatus(executeParam.getInfoProperty());
            System.out.println("获取sessionId结束！sessionId=" + sessionId + ",tableName=" + desensitizationTable.getTablename());
            System.out.println("删除主外键开始！tableName=" + desensitizationTable.getTablename());
            JdbcTool.delPrimaryForeignKeyAndIndex(targetConn, executeParam.getTargetSchemaName(), desensitizationTable.getTablename());
            System.out.println("创建执行脚本开始！tableName=" + desensitizationTable.getTablename());
            this.createScriptFiletotarget(executeParam, desensitizationTable, executeParam.getTargetDataSystem().getDbtype(), tCoreDatasystemTarget, (List)map.get(desensitizationTable.getTablename()), rn);
            System.out.println("调用启动工作流方法开始！tableName=" + desensitizationTable.getTablename());
            int runId = this.startWorkFlowEx(workflowName, executeParam.getInfoProperty(), executeParam.getFolderName(), sessionId);
            String dbType = executeParam.getTargetDataSystem().getDbtype();
            System.out.println("启动脚本开始！dbType=" + dbType + ",tableName=" + desensitizationTable.getTablename());
            if ("SYBASE_IQ".equals(dbType)) {
               CommandTool.commandRtn("/data/infa_sybaseiq/target/" + executeParam.getTaskNameReal() + "/" + desensitizationTable.getTablename() + ".sh /data/infa_sybaseiq/target/" + executeParam.getTaskNameReal() + "/" + desensitizationTable.getTablename() + ".pipe");
            } else if ("MSSQLSERVER".equals(dbType)) {
               CommandTool.command("chmod -R 777 /data/infa_sqlserver/");
               String completeStatus = this.workflowTaskCompleteMonitor(executeParam.getInfoProperty(), executeParam.getFolderName(), "wf_" + executeParam.getTaskNameReal() + "_" + desensitizationTable.getTablename(), sessionId);
               if ("1".equals(completeStatus)) {
                  CommandTool.commandRtn("/data/infa_sqlserver/target/" + executeParam.getTaskNameReal() + "/" + desensitizationTable.getTablename() + ".sh");
               }
            } else if ("SYBASE".equals(dbType)) {
               CommandTool.command("chmod -R 777 /data/infa_sybase/");
               CommandTool.commandRtn("/data/infa_sybase/target/" + executeParam.getTaskNameReal() + "/" + desensitizationTable.getTablename() + ".sh");
            } else if ("MYSQL".equals(dbType)) {
               CommandTool.commandRtn("/data/infa_mysqlload/target/" + executeParam.getTaskNameReal() + "/" + desensitizationTable.getTablename() + ".sh");
            } else if ("TERADATA".equals(dbType)) {
               CommandTool.commandRtn("/data/infa_teradata/target/" + executeParam.getTaskNameReal() + "/" + desensitizationTable.getTablename() + ".sh");
            }

            String completeStatus = "0";
            System.out.println("》》》》》》》》》》》》》》》runId=" + runId);
            if (runId >= 0) {
               completeStatus = this.workflowTaskCompleteMonitor(executeParam.getInfoProperty(), executeParam.getFolderName(), "wf_" + executeParam.getTaskNameReal() + "_" + desensitizationTable.getTablename(), sessionId);
            }

            if ("1".equals(completeStatus)) {
               System.out.println("表" + desensitizationTable.getTablename() + ",执行完成,通过阻塞方法！");
               SessionBean sessionBean = this.getLogForTaskMapping(executeParam.getFolderName(), executeParam.getInfoProperty(), executeParam.getTaskNameReal() + "_" + desensitizationTable.getTablename(), sessionId);
               System.out.println(">>>>>>>>>>>>>>>>>>>>>>>>>>status=" + sessionBean.getStatus());
               if ("SUCCEEDED".equals(sessionBean.getStatus())) {
                  status = "1";
               } else if ("FAILED".equals(sessionBean.getStatus())) {
                  status = "2";
               } else if ("STOPPED".equals(sessionBean.getStatus())) {
                  status = "3";
               } else {
                  status = "4";
               }

               System.out.println("执行更新监控表开始！tableName=" + desensitizationTable.getTablename());
               this.updateMonitor(desensitizationTable.getTablename(), executeParam.getTableMap(), status, runId);
            }

            LogoutWebService.returnStatus(sessionId, executeParam.getInfoProperty());
         } catch (Exception e) {
            e.printStackTrace();
         } finally {
            countDownLatch.countDown();
         }
      }

      try {
         System.out.println(">>>>>>>>>>>>>>>当前活动线程数：" + this.taskExecutor.getActiveCount());
         System.out.println(">>>>>>>>>>>>>>>剩余未执行完线程数：" + countDownLatch.getCount());
         countDownLatch.await();
         JdbcTool.closeConnection(targetConn);
         this.desensitizationtaskDao.getSession().getTransaction().begin();
         desensitizationTask.setTaskstatus("0");
         this.desensitizationtaskDao.saveOrUpdate(desensitizationTask);
         this.desensitizationtaskDao.getSession().getTransaction().commit();
         System.out.println(">>>>>>>>>>>>>>>任务已全部执行完成！同步表信息开始！");
         this.synTableParam(tableList, executeParam);
      } catch (Exception e) {
         e.printStackTrace();
      }

   }

   @Async
   public void executeFILE_pwc_FILE_batchwrite_DB(ExecuteParam executeParam) throws Exception {
      System.out.println(">>>>>>>>>>>>>>>>>FILE_pwc_FILE_batchwrite_DB<<<<<<<<<<<<<<<<<<");
      List<DesensitizationTable> tableList = this.queryTableList(executeParam.getTaskid());
      TCoreDatasystem tCoreDatasystemTarget = this.dataSystemService.queryDataSystemById(executeParam.getDataTargetId());
      Runtime rn = Runtime.getRuntime();
      Map<String, List<DesensitizationTablecolumn>> map = new HashMap();
      CountDownLatch countDownLatch = new CountDownLatch(tableList.size());

      for(DesensitizationTable desensitizationTable : tableList) {
         List<DesensitizationTable> list = this.desensitizationTableDao.queryAll(new Criterion[]{Restrictions.eq("tablename", desensitizationTable.getTablename()), Restrictions.eq("taskid", executeParam.getTaskid())});
         List<DesensitizationTablecolumn> desensitizationTablecolumnList = this.desensitizationTablecolumnDao.queryAll(Order.asc("sortnum"), new Criterion[]{Restrictions.eq("tableid", ((DesensitizationTable)list.get(0)).getId())});
         map.put(desensitizationTable.getTablename(), desensitizationTablecolumnList);
      }

      Desensitizationtask desensitizationTask = (Desensitizationtask)this.desensitizationtaskDao.get(executeParam.getTaskid());
      desensitizationTask.setTaskstatus("1");
      this.desensitizationtaskDao.saveOrUpdate(desensitizationTask);
      this.desensitizationtaskDao.getSession().getTransaction().commit();
      Collections.sort(tableList);

      for(DesensitizationTable desensitizationTable : tableList) {
         String sessionId = "";
         String status = "4";
         String workflowName = "wf_" + executeParam.getTaskNameReal() + "_" + desensitizationTable.getTablename();

         try {
            if ("startup".equals(props.getProperty("Forecast_Run_Time"))) {
               System.out.println("---进入启动预计运行时间方法！");
               String dataCount = "";
               LineNumberReader lineNumberReader = new LineNumberReader(new FileReader("/data/infa_file/" + executeParam.getSourceFileDir() + "/" + desensitizationTable.getFilename()));
               lineNumberReader.skip(Long.MAX_VALUE);
               int lineNumber = lineNumberReader.getLineNumber() + 1;
               dataCount = lineNumber + "";
               System.out.println("数据源表" + desensitizationTable.getTablename() + "总行数：" + dataCount);
               this.redisService.set("dataCount:" + desensitizationTask.getTasknamereal() + "_" + desensitizationTable.getTablename(), dataCount);
               System.out.println("预计运行时间，key=dataCount:" + desensitizationTask.getTasknamereal() + "_" + desensitizationTable.getTablename() + "，dataCount=" + dataCount);
            }

            this.updateMonitorRunStatus(desensitizationTable.getTablename(), executeParam.getTableMap());
            System.out.println("~~~~~~~~~~~~~~~~~~~~~~~获取sessionId开始！");
            sessionId = LoginWebService.returnStatus(executeParam.getInfoProperty());
            System.out.println("创建执行脚本开始！tableName=" + desensitizationTable.getTablename());
            this.createScriptFiletotarget(executeParam, desensitizationTable, executeParam.getTargetDataSystem().getDbtype(), tCoreDatasystemTarget, (List)map.get(desensitizationTable.getTablename()), rn);
            System.out.println("调用启动工作流方法开始！tableName=" + desensitizationTable.getTablename());
            int runId = this.startWorkFlowEx(workflowName, executeParam.getInfoProperty(), executeParam.getFolderName(), sessionId);
            String dbType = executeParam.getTargetDataSystem().getDbtype();
            System.out.println("启动脚本开始！dbType=" + dbType + ",tableName=" + desensitizationTable.getTablename());
            if ("SYBASE_IQ".equals(dbType)) {
               CommandTool.commandRtn("/data/infa_sybaseiq/target/" + executeParam.getTaskNameReal() + "/" + desensitizationTable.getTablename() + ".sh /data/infa_sybaseiq/target/" + executeParam.getTaskNameReal() + "/" + desensitizationTable.getTablename() + ".pipe");
            } else if ("MSSQLSERVER".equals(dbType)) {
               CommandTool.command("chmod -R 777 /data/infa_sqlserver/");
               String completeStatus = this.workflowTaskCompleteMonitor(executeParam.getInfoProperty(), executeParam.getFolderName(), "wf_" + executeParam.getTaskNameReal() + "_" + desensitizationTable.getTablename(), sessionId);
               if ("1".equals(completeStatus)) {
                  CommandTool.commandRtn("/data/infa_sqlserver/target/" + executeParam.getTaskNameReal() + "/" + desensitizationTable.getTablename() + ".sh");
               }
            } else if ("MYSQL".equals(dbType)) {
               System.out.println("执行目标的脚本");
               CommandTool.commandRtn("/data/infa_mysqlload/target/" + executeParam.getTaskNameReal() + "/" + desensitizationTable.getTablename() + ".sh");
               System.out.println("执行目标的脚本:完成");
            } else if ("TERADATA".equals(dbType)) {
               System.out.println("执行目标的脚本");
               CommandTool.commandRtn2("/data/infa_teradata/target/" + executeParam.getTaskNameReal() + "/" + desensitizationTable.getTablename() + ".sh");
               System.out.println("执行目标的脚本:完成");
            }

            String completeStatus = "0";
            if (runId >= 0) {
               completeStatus = this.workflowTaskCompleteMonitor(executeParam.getInfoProperty(), executeParam.getFolderName(), "wf_" + executeParam.getTaskNameReal() + "_" + desensitizationTable.getTablename(), sessionId);
            }

            if ("1".equals(completeStatus)) {
               System.out.println("表" + desensitizationTable.getTablename() + ",执行完成,通过阻塞方法！");
               SessionBean sessionBean = this.getLogForTaskMapping(executeParam.getFolderName(), executeParam.getInfoProperty(), executeParam.getTaskNameReal() + "_" + desensitizationTable.getTablename(), sessionId);
               System.out.println(">>>>>>>>>>>>>>>>>>>>>>>>>>status=" + sessionBean.getStatus());
               if ("SUCCEEDED".equals(sessionBean.getStatus())) {
                  status = "1";
               } else if ("FAILED".equals(sessionBean.getStatus())) {
                  status = "2";
               } else if ("STOPPED".equals(sessionBean.getStatus())) {
                  status = "3";
               } else {
                  status = "4";
               }

               System.out.println("执行更新监控表开始！tableName=" + desensitizationTable.getTablename());
               this.updateMonitor(desensitizationTable.getTablename(), executeParam.getTableMap(), status, runId);
            }

            LogoutWebService.returnStatus(sessionId, executeParam.getInfoProperty());
         } catch (Exception e) {
            e.printStackTrace();
         } finally {
            countDownLatch.countDown();
         }
      }

      try {
         System.out.println(">>>>>>>>>>>>>>>当前活动线程数：" + this.taskExecutor.getActiveCount());
         System.out.println(">>>>>>>>>>>>>>>剩余未执行完线程数：" + countDownLatch.getCount());
         countDownLatch.await();
         this.desensitizationtaskDao.getSession().getTransaction().begin();
         desensitizationTask.setTaskstatus("0");
         this.desensitizationtaskDao.saveOrUpdate(desensitizationTask);
         this.desensitizationtaskDao.getSession().getTransaction().commit();
      } catch (Exception e) {
         e.printStackTrace();
      }

   }

   @Async
   public void executeTaskNormal(ExecuteParam executeParam) throws Exception {
      System.out.println(">>>>>>>>>>>>>>>>>TaskNormal<<<<<<<<<<<<<<<<<<");
      List<DesensitizationTable> tableList = this.queryTableList(executeParam.getTaskid());
      CountDownLatch countDownLatch = new CountDownLatch(tableList.size());
      Desensitizationtask desensitizationTask = (Desensitizationtask)this.desensitizationtaskDao.get(executeParam.getTaskid());
      desensitizationTask.setTaskstatus("1");
      this.desensitizationtaskDao.saveOrUpdate(desensitizationTask);
      this.desensitizationtaskDao.getSession().getTransaction().commit();
      Collections.sort(tableList);

      for(DesensitizationTable desensitizationTable : tableList) {
         String sessionId = "";
         String status = "4";
         String workflowName = "wf_" + executeParam.getTaskNameReal() + "_" + desensitizationTable.getTablename();

         try {
            if ("startup".equals(props.getProperty("Forecast_Run_Time"))) {
               System.out.println("---进入启动预计运行时间方法！");
               String dataCount = "";
               String tasktype = desensitizationTask.getTasktype();
               if (!tasktype.startsWith("DB") && !tasktype.startsWith("HADOOP")) {
                  LineNumberReader lineNumberReader = new LineNumberReader(new FileReader("/data/infa_file/" + executeParam.getSourceFileDir() + "/" + desensitizationTable.getFilename()));
                  lineNumberReader.skip(Long.MAX_VALUE);
                  int lineNumber = lineNumberReader.getLineNumber() + 1;
                  dataCount = lineNumber + "";
                  System.out.println("数据源表" + desensitizationTable.getTablename() + "总行数：" + dataCount);
               } else {
                  dataCount = this.getDataCount(executeParam.getSourceDataSystem().getDbtype(), executeParam.getSourceDataSystem(), desensitizationTable, executeParam.getSourceSchemaName());
                  System.out.println("数据源表" + desensitizationTable.getTablename() + "总行数：" + dataCount);
               }

               this.redisService.set("dataCount:" + desensitizationTask.getTasknamereal() + "_" + desensitizationTable.getTablename(), dataCount);
               System.out.println("预计运行时间，key=dataCount:" + desensitizationTask.getTasknamereal() + "_" + desensitizationTable.getTablename() + "，dataCount=" + dataCount);
            }

            this.updateMonitorRunStatus(desensitizationTable.getTablename(), executeParam.getTableMap());
            System.out.println("~~~~~~~~~~~~~~~~~~~~~~~获取sessionId开始！");
            sessionId = LoginWebService.returnStatus(executeParam.getInfoProperty());
            System.out.println("调用启动工作流方法开始！tableName=" + desensitizationTable.getTablename());
            int runId = this.startWorkFlowEx(workflowName, executeParam.getInfoProperty(), executeParam.getFolderName(), sessionId);
            String completeStatus = "0";
            if (runId >= 0) {
               completeStatus = this.workflowTaskCompleteMonitor(executeParam.getInfoProperty(), executeParam.getFolderName(), "wf_" + executeParam.getTaskNameReal() + "_" + desensitizationTable.getTablename(), sessionId);
            }

            if ("1".equals(completeStatus)) {
               System.out.println("表" + desensitizationTable.getTablename() + ",执行完成,通过阻塞方法！");
               SessionBean sessionBean = this.getLogForTaskMapping(executeParam.getFolderName(), executeParam.getInfoProperty(), executeParam.getTaskNameReal() + "_" + desensitizationTable.getTablename(), sessionId);
               System.out.println(">>>>>>>>>>>>>>>>>>>>>>>>>>status=" + sessionBean.getStatus());
               if ("SUCCEEDED".equals(sessionBean.getStatus())) {
                  status = "1";
               } else if ("FAILED".equals(sessionBean.getStatus())) {
                  status = "2";
               } else if ("STOPPED".equals(sessionBean.getStatus())) {
                  status = "3";
               } else {
                  status = "4";
               }

               System.out.println("执行更新监控表开始！tableName=" + desensitizationTable.getTablename());
               this.updateMonitor(desensitizationTable.getTablename(), executeParam.getTableMap(), status, runId);
               if ("FTPtoDB".equals(desensitizationTask.getTasktype()) || "SFTPtoDB".equals(desensitizationTask.getTasktype())) {
                  System.out.println(">>>>>>>>>>>>>>>>>>>>上传类型为=" + desensitizationTask.getTasktype());
                  DesensitizationFile desensitizationFile = (DesensitizationFile)this.desensitizationFileDao.queryUnique(new Criterion[]{Restrictions.eq("taskid", desensitizationTask.getId())});
                  String[] typeSplit = desensitizationTask.getTasktype().split("to");
                  TCoreConfig tcoreConfig = (TCoreConfig)this.tCoreConfigDao.queryUnique(new Criterion[]{Restrictions.eq("datasystemid", executeParam.getDataSourceId())});
                  if (tcoreConfig != null) {
                     String fileDir = tcoreConfig.getLocaldir();
                     if (fileDir == null || fileDir.equals("")) {
                        fileDir = XmlTool.getFileValue(typeSplit[0] + "/localdir");
                     }

                     System.out.println("fileDir=" + fileDir);
                     File file = new File(fileDir + desensitizationTable.getFilename());
                     String username = desensitizationFile.getUsername();
                     String password = desensitizationFile.getUserpassword();
                     String host = desensitizationFile.getIp();
                     Integer port = Integer.parseInt(desensitizationFile.getPort());
                     if (desensitizationFile.getFiletype() == 2) {
                        System.out.println("上传文件类型为SFTP");
                        SFTPUtil sftp = new SFTPUtil(username, password, host, port);
                        SFTPUtil.login();
                        InputStream is = new FileInputStream(file);
                        sftp.upload(desensitizationFile.getFiledir(), desensitizationTable.getFilename(), is);
                        is.close();
                        sftp.logout();
                     } else if (desensitizationFile.getFiletype() == 1) {
                        System.out.println("上传文件类型为FTP");
                        InputStream is = new FileInputStream(file);
                        FtpTool.uploadFile(host, port, username, password, desensitizationFile.getFiledir(), desensitizationTable.getFilename(), is);
                        is.close();
                     }
                  }
               }
            }

            LogoutWebService.returnStatus(sessionId, executeParam.getInfoProperty());
         } catch (Exception e) {
            e.printStackTrace();
         } finally {
            countDownLatch.countDown();
         }
      }

      try {
         System.out.println(">>>>>>>>>>>>>>>当前活动线程数：" + this.taskExecutor.getActiveCount());
         System.out.println(">>>>>>>>>>>>>>>剩余未执行完线程数：" + countDownLatch.getCount());
         countDownLatch.await();
         this.desensitizationtaskDao.getSession().getTransaction().begin();
         desensitizationTask.setTaskstatus("0");
         this.desensitizationtaskDao.saveOrUpdate(desensitizationTask);
         this.desensitizationtaskDao.getSession().getTransaction().commit();
      } catch (Exception e) {
         e.printStackTrace();
      }

   }

   private void createScriptFiletotarget(ExecuteParam executeParam, DesensitizationTable desensitizationTable, String dbType, TCoreDatasystem tCoreDatasystemTarget, List<DesensitizationTablecolumn> desensitizationTablecolumnList, Runtime rn) throws Exception {
      String tableName = desensitizationTable.getTablename();
      TCoreConfig tcoreConfig = (TCoreConfig)this.tCoreConfigDao.queryUnique(new Criterion[]{Restrictions.eq("datasystemid", executeParam.getDataTargetId())});
      if (tcoreConfig != null) {
         String filepath = tcoreConfig.getFileDir();
         if (filepath == null || filepath.equals("")) {
            filepath = XmlTool.getFileValue(dbType + "/db-fileDir");
         }

         String type = "target";
         if ("SYBASE_IQ".equals(dbType)) {
            Process process = rn.exec("mkfifo " + filepath + type + File.separator + executeParam.getTaskNameReal() + File.separator + tableName + ".pipe");
            process.waitFor();
            Map<String, String> lm = new HashMap();
            lm.put("user", tCoreDatasystemTarget.getUsername());
            lm.put("pwd", "1".equals(tCoreDatasystemTarget.getFlag()) ? AesTool.decrypt(tCoreDatasystemTarget.getPassword(), "ghca") : tCoreDatasystemTarget.getPassword());
            lm.put("ip", tCoreDatasystemTarget.getDbip());
            lm.put("port", tCoreDatasystemTarget.getDbport());
            lm.put("table", tableName);
            lm.put("schema", executeParam.getTargetSchemaName());
            lm.put("path", filepath + type + File.separator + executeParam.getTaskNameReal() + File.separator + tableName + ".sh");
            String col = "";

            for(int i = 0; i < desensitizationTablecolumnList.size(); ++i) {
               if (i != desensitizationTablecolumnList.size() - 1) {
                  col = col + ((DesensitizationTablecolumn)desensitizationTablecolumnList.get(i)).getColumnname() + "|" + ((DesensitizationTablecolumn)desensitizationTablecolumnList.get(i)).getColumntartype() + ",";
               } else {
                  col = col + ((DesensitizationTablecolumn)desensitizationTablecolumnList.get(i)).getColumnname() + "|" + ((DesensitizationTablecolumn)desensitizationTablecolumnList.get(i)).getColumntartype();
               }
            }

            lm.put("lm", col);
            SybaseIQLoadTableTool.executeLoadTable(lm);
         } else if ("MSSQLSERVER".equals(dbType)) {
            FileTool.createFolder(filepath + type + File.separator + executeParam.getTaskNameReal() + File.separator);
            Map<String, String> bcpProperties = new HashMap();
            bcpProperties.put("user", tCoreDatasystemTarget.getUsername());
            bcpProperties.put("pwd", "1".equals(tCoreDatasystemTarget.getFlag()) ? AesTool.decrypt(tCoreDatasystemTarget.getPassword(), "ghca") : tCoreDatasystemTarget.getPassword());
            bcpProperties.put("ip", tCoreDatasystemTarget.getDbip());
            bcpProperties.put("dbschema", executeParam.getTargetSchemaName());
            bcpProperties.put("tablename", tableName);
            bcpProperties.put("database", tCoreDatasystemTarget.getDbservername());
            bcpProperties.put("taskname", executeParam.getTaskNameReal());
            bcpProperties.put("path", filepath + type + File.separator + executeParam.getTaskNameReal() + File.separator + tableName + ".sh");
            TCoreConfig tcoreConfig1 = (TCoreConfig)this.tCoreConfigDao.queryUnique(new Criterion[]{Restrictions.eq("datasystemid", executeParam.getDataSourceId())});
            SqlServerBcpTableTool.createBcpScript(bcpProperties, tcoreConfig1);
         } else if ("SYBASE".equals(dbType)) {
            FileTool.createFolder(filepath + type + File.separator + executeParam.getTaskNameReal() + File.separator);
            Map<String, String> bcpProperties = new HashMap();
            bcpProperties.put("user", tCoreDatasystemTarget.getUsername());
            bcpProperties.put("pwd", "1".equals(tCoreDatasystemTarget.getFlag()) ? AesTool.decrypt(tCoreDatasystemTarget.getPassword(), "ghca") : tCoreDatasystemTarget.getPassword());
            bcpProperties.put("ip", tCoreDatasystemTarget.getDbip());
            bcpProperties.put("servername", tCoreDatasystemTarget.getServername());
            bcpProperties.put("dbschema", executeParam.getTargetSchemaName());
            bcpProperties.put("tablename", tableName);
            bcpProperties.put("database", tCoreDatasystemTarget.getDbservername());
            bcpProperties.put("taskname", executeParam.getTaskNameReal());
            bcpProperties.put("pagecode", tCoreDatasystemTarget.getPagecode());
            bcpProperties.put("path", filepath + type + File.separator + executeParam.getTaskNameReal() + File.separator + tableName + ".sh");
            SybaseBcpTableTool.createBcpInScript(bcpProperties);
         } else if ("MYSQL".equals(dbType)) {
            String mysql_file_path = filepath + type + File.separator + executeParam.getTaskNameReal() + File.separator;
            if (!FileTool.isFileExit(mysql_file_path)) {
               FileTool.createFolder(mysql_file_path);
            }

            Map<String, String> mysqlloadparam = new HashMap();
            mysqlloadparam.put("username", tCoreDatasystemTarget.getUsername());
            mysqlloadparam.put("password", "1".equals(tCoreDatasystemTarget.getFlag()) ? AesTool.decrypt(tCoreDatasystemTarget.getPassword(), "ghca") : tCoreDatasystemTarget.getPassword());
            mysqlloadparam.put("hostname", tCoreDatasystemTarget.getDbip());
            mysqlloadparam.put("filepath", mysql_file_path + tableName + ".pipe");
            mysqlloadparam.put("path", mysql_file_path);
            mysqlloadparam.put("database", executeParam.getTargetSchemaName());
            mysqlloadparam.put("tablename", tableName);
            mysqlloadparam.put("taskname", executeParam.getTaskNameReal());
            mysqlloadparam.put("delimiter", props.getProperty("mysql_load_col_split"));
            CommandTool.command("mkfifo  " + mysql_file_path + tableName + ".pipe");
            MysqlLoadTableTool.executeLoadTable_new(mysqlloadparam);
         } else if ("TERADATA".equals(dbType)) {
            String teradata_file_path = filepath + type + File.separator + executeParam.getTaskNameReal() + File.separator;
            if (!FileTool.isFileExit(teradata_file_path)) {
               FileTool.createFolder(teradata_file_path);
            }

            List<String> nameList = new ArrayList();
            List<String> lengthList = new ArrayList();

            for(DesensitizationTablecolumn sourceTableCol : desensitizationTablecolumnList) {
               nameList.add(sourceTableCol.getColumnname());
               lengthList.add(sourceTableCol.getColumnlength());
            }

            StringBuffer definesb = new StringBuffer();

            for(int i = 0; i < nameList.size(); ++i) {
               definesb.append((String)nameList.get(i) + "(varchar(" + (String)lengthList.get(i) + ")),");
            }

            Map<String, String> paramMapload = new HashMap();
            paramMapload.put("ip", tCoreDatasystemTarget.getDbip());
            paramMapload.put("port", tCoreDatasystemTarget.getDbport());
            paramMapload.put("user", tCoreDatasystemTarget.getUsername());
            paramMapload.put("pwd", "1".equals(tCoreDatasystemTarget.getFlag()) ? AesTool.decrypt(tCoreDatasystemTarget.getPassword(), "ghca") : tCoreDatasystemTarget.getPassword());
            paramMapload.put("schema", executeParam.getTargetSchemaName());
            paramMapload.put("table", desensitizationTable.getTablename());
            paramMapload.put("path", teradata_file_path);
            paramMapload.put("define", definesb.substring(0, definesb.length() - 1));
            paramMapload.put("in_type", "1");
            String dbcode = tCoreDatasystemTarget.getDbtype();
            String servername = tCoreDatasystemTarget.getDbservername();
            String url = EdbType.getUrlByEdbcode(dbcode, tCoreDatasystemTarget.getDbip(), tCoreDatasystemTarget.getDbport(), servername, tCoreDatasystemTarget.getPagecode());
            String driver = EdbType.getEdbTypeByDbcode(dbcode).getDbdriver();
            paramMapload.put("driver", driver);
            paramMapload.put("url", url);
            paramMapload.put("create_sql", desensitizationTable.getCreate_sql());
            CommandTool.command("mkfifo " + teradata_file_path + desensitizationTable.getTablename() + ".pipe");
            TeradataLoadTableTool.createfastLoadTableSh(paramMapload);
         }
      }

   }

   private void createScriptFiletoSource(ExecuteParam executeParam, DesensitizationTable desensitizationTable, String dbType, TCoreDatasystem tCoreDatasystemSource, List<DesensitizationTablecolumn> desensitizationTablecolumnList, Runtime rn) throws Exception {
      String tableName = desensitizationTable.getTablename();
      TCoreConfig tcoreConfig = (TCoreConfig)this.tCoreConfigDao.queryUnique(new Criterion[]{Restrictions.eq("datasystemid", executeParam.getDataSourceId())});
      if (tcoreConfig != null) {
         String filepath = tcoreConfig.getFileDir();
         if (filepath == null || filepath.equals("")) {
            filepath = XmlTool.getFileValue(dbType + "/db-fileDir");
         }

         String type = "source";
         if (!"SYBASE_IQ".equals(dbType)) {
            if ("MSSQLSERVER".equals(dbType)) {
               List<Map<String, String>> columns = new ArrayList();

               for(int j = 0; j < desensitizationTablecolumnList.size(); ++j) {
                  Map<String, String> columnMap = new HashMap();
                  String colName = ((DesensitizationTablecolumn)desensitizationTablecolumnList.get(j)).getColumnname();
                  String colType = ((DesensitizationTablecolumn)desensitizationTablecolumnList.get(j)).getColumntype();
                  columnMap.put("name", colName);
                  columnMap.put("type", colType);
                  columns.add(columnMap);
               }

               FileTool.createFolder(filepath + type + File.separator + executeParam.getTaskNameReal() + File.separator);
               Map<String, Object> bcpProperties = new HashMap();
               bcpProperties.put("user", tCoreDatasystemSource.getUsername());
               bcpProperties.put("pwd", "1".equals(tCoreDatasystemSource.getFlag()) ? AesTool.decrypt(tCoreDatasystemSource.getPassword(), "ghca") : tCoreDatasystemSource.getPassword());
               bcpProperties.put("ip", tCoreDatasystemSource.getDbip());
               bcpProperties.put("dbschema", executeParam.getSourceSchemaName());
               bcpProperties.put("tablename", tableName);
               bcpProperties.put("database", tCoreDatasystemSource.getDbservername());
               bcpProperties.put("taskname", executeParam.getTaskNameReal());
               bcpProperties.put("path", filepath + type + File.separator + executeParam.getTaskNameReal() + File.separator + tableName + ".sh");
               bcpProperties.put("columns", columns);
               SqlServerBcpTableTool.createBcpExportScript(bcpProperties);
            } else if ("TERADATA".equals(dbType)) {
               List<String> colNameLst = new ArrayList();
               Integer totalLen = 0;

               for(int j = 0; j < desensitizationTablecolumnList.size(); ++j) {
                  totalLen = totalLen + 3;
                  String colName = ((DesensitizationTablecolumn)desensitizationTablecolumnList.get(j)).getColumnname();
                  String colType = ((DesensitizationTablecolumn)desensitizationTablecolumnList.get(j)).getColumntype();
                  String colLength = ((DesensitizationTablecolumn)desensitizationTablecolumnList.get(j)).getColumnlength();
                  String colScale = ((DesensitizationTablecolumn)desensitizationTablecolumnList.get(j)).getColumnscale() == null ? "" : ((DesensitizationTablecolumn)desensitizationTablecolumnList.get(j)).getColumnscale();
                  colName = TeradataTool.teradataTypetoVarchar(colName, colType, colLength);
                  String realColLength = TeradataTool.teradataTypeLength(colType, colLength, colScale);
                  if (StringUtils.isNotBlank(realColLength)) {
                     totalLen = totalLen + Integer.valueOf(realColLength);
                  }

                  colNameLst.add(colName);
               }

               String colNamesStr = StringUtils.join(colNameLst.toArray(), "||'|'||");
               colNamesStr = "(cast(" + colNamesStr + " as char(" + totalLen + ")))";
               Map<String, String> paramMap = new HashMap();
               paramMap.put("schema", executeParam.getSourceSchemaName());
               paramMap.put("tablename", desensitizationTable.getTablename());
               paramMap.put("colNamesStr", colNamesStr);
               String source_pipe_path = filepath + type + File.separator + executeParam.getTaskNameReal() + File.separator;
               if (!FileTool.isFileExit(source_pipe_path)) {
                  FileTool.createFolder(source_pipe_path);
               }

               paramMap.put("source_pipe_path", source_pipe_path);
               paramMap.put("teradataServersIp", tCoreDatasystemSource.getDbip());
               paramMap.put("teradataServersUser", tCoreDatasystemSource.getUsername());
               paramMap.put("teradataServerspwd", "1".equals(tCoreDatasystemSource.getFlag()) ? AesTool.decrypt(tCoreDatasystemSource.getPassword(), "ghca") : tCoreDatasystemSource.getPassword());
               paramMap.put("taskname", executeParam.getTaskNameReal());
               CommandTool.command("mkfifo  " + source_pipe_path + tableName + ".pipe");
               System.out.println("创建Teradata_source_pipe");
               TeradataTool.createTerdataExportScript_new(paramMap);
            }
         }
      }

   }

   public String startWorkFlow(ExecuteParam executeParam, String tableName, String sessionId) {
      String workFlowName = "wf_" + executeParam.getTaskNameReal() + "_" + tableName;
      String returnStatus = "FAIL";

      try {
         if (StringUtils.isNoneBlank(new CharSequence[]{workFlowName}) && !workFlowName.startsWith("wf_")) {
            workFlowName = "wf_" + workFlowName;
         }

         returnStatus = StartWorkFlowWebService.returnStatus(sessionId, executeParam.getInfoProperty(), workFlowName, executeParam.getFolderName());
         return returnStatus;
      } catch (Fault e) {
         e.printStackTrace();
         return "FAIL";
      } catch (Exception e) {
         e.printStackTrace();
         return "FAIL";
      }
   }

   public int startWorkFlowEx(String workflowName, InfoProperty engine, String folderName, String sessionId) {
      if (StringUtils.isNoneBlank(new CharSequence[]{workflowName}) && !workflowName.startsWith("wf_")) {
         workflowName = "wf_" + workflowName;
      }

      int runId = -1;
      DataIntegrationInterface webService = (new DataIntegrationService()).getDataIntegration();
      DIServiceInfo dIServiceInfo = new DIServiceInfo();
      dIServiceInfo.setDomainName(engine.getDomainname());
      dIServiceInfo.setServiceName(engine.getInteservicename());
      TypeStartWorkflowExRequest typeStartWorkflowExRequest = new TypeStartWorkflowExRequest();
      typeStartWorkflowExRequest.setDIServiceInfo(dIServiceInfo);
      typeStartWorkflowExRequest.setFolderName(folderName);
      typeStartWorkflowExRequest.setWorkflowName(workflowName);
      typeStartWorkflowExRequest.setRequestMode(ETaskRunMode.RECOVERY);

      try {
         SessionHeader sessionHeader = new SessionHeader();
         sessionHeader.setSessionId(sessionId);
         TypeStartWorkflowExResponse startWorkflowEx = webService.startWorkflowEx(typeStartWorkflowExRequest, sessionHeader);
         runId = startWorkflowEx.getRunId();
      } catch (Exception e) {
         e.printStackTrace();
      }

      return runId;
   }

   public void updateMonitor(String tableNane, Map<String, String> tableMap, String status, int runid) {
      new Properties();

      try {
         Properties props = PropertiesLoaderUtils.loadAllProperties("config.properties");
         String sqlurl = props.get("jdbc.url").toString();
         String username = props.get("jdbc.user").toString();
         String password = props.get("jdbc.password").toString();
         String driver = props.get("jdbc.driver").toString();
         Connection connection = JdbcTool.getConnection(driver, sqlurl, username, password);
         Statement statement = connection.createStatement();
         String sql = "UPDATE desensitization_monitor SET flag = '" + status + "',runid = '" + runid + "' WHERE id = '" + (String)tableMap.get(tableNane) + "'";
         System.out.println("update:desensitization_monitor=" + sql);
         statement.executeUpdate(sql.toString());
         statement.close();
         connection.close();
      } catch (IOException e) {
         e.printStackTrace();
      } catch (SQLException e) {
         e.printStackTrace();
      }

   }

   public void updateMonitorRunStatus(String tableNane, Map<String, String> tableMap) {
      new Properties();

      try {
         Properties props = PropertiesLoaderUtils.loadAllProperties("config.properties");
         String sqlurl = props.get("jdbc.url").toString();
         String username = props.get("jdbc.user").toString();
         String password = props.get("jdbc.password").toString();
         String driver = props.get("jdbc.driver").toString();
         Connection connection = JdbcTool.getConnection(driver, sqlurl, username, password);
         Statement statement = connection.createStatement();
         String sql = "UPDATE desensitization_monitor SET runstatus = 1,executetime = now() WHERE id = '" + (String)tableMap.get(tableNane) + "'";
         System.out.println("updateStatus:desensitization_monitor=" + sql);
         statement.executeUpdate(sql.toString());
         statement.close();
         connection.close();
      } catch (IOException e) {
         e.printStackTrace();
      } catch (SQLException e) {
         e.printStackTrace();
      }

   }

   public String workflowTaskCompleteMonitor(InfoProperty engine, String folderName, String workflowName, String sessionId) {
      if (StringUtils.isNoneBlank(new CharSequence[]{workflowName}) && !workflowName.startsWith("wf_")) {
         workflowName = "wf_" + workflowName;
      }

      String completeStatus = "0";
      DataIntegrationInterface webService = (new DataIntegrationService()).getDataIntegration();
      DIServiceInfo dIServiceInfo = new DIServiceInfo();
      dIServiceInfo.setDomainName(engine.getDomainname());
      dIServiceInfo.setServiceName(engine.getInteservicename());
      WorkflowRequest workflowRequest = new WorkflowRequest();
      workflowRequest.setDIServiceInfo(dIServiceInfo);
      workflowRequest.setFolderName(folderName);
      workflowRequest.setWorkflowName(workflowName);

      try {
         SessionHeader sessionHeader = new SessionHeader();
         sessionHeader.setSessionId(sessionId);
         webService.waitTillWorkflowComplete(workflowRequest, sessionHeader);
      } catch (Exception var10) {
         System.out.println("该工作流未运行，或者已完成！");
      }

      completeStatus = "1";
      return completeStatus;
   }

   public String returnBaseType(TCoreDatasystem targettype, TCoreDatasystem sourcetype) {
      String type = "";
      if (sourcetype == null) {
         type = "FILE";
      } else if (sourcetype.getFlag().equals("1")) {
         type = "DB";
      } else if (sourcetype.getFlag().equals("2")) {
         type = sourcetype.getDbtype();
      } else if (sourcetype.getFlag().equals("3")) {
         type = "HIVE";
      }

      if (targettype == null) {
         type = type + "toFILE";
      } else if (targettype.getFlag().equals("1")) {
         type = type + "toDB";
      } else if (targettype.getFlag().equals("2")) {
         type = type + "to" + sourcetype.getDbtype();
      } else if (targettype.getFlag().equals("3")) {
         type = type + "toHIVE";
      }

      return type;
   }

   public void synTableParam(List<DesensitizationTable> tableList, ExecuteParam executeParam) {
      try {
         Connection srcconn = this.dataSystemService.getConnectionByDataSystemId(executeParam.getDataSourceId());
         Connection tarconn = this.dataSystemService.getConnectionByDataSystemId(executeParam.getDataTargetId());

         for(DesensitizationTable desensitizationTable : tableList) {
            if ("isprimary".equalsIgnoreCase(executeParam.getIsPrimary())) {
               JdbcTool.synchronizePrimaryKey(srcconn, executeParam.getSourceSchemaName(), desensitizationTable.getTablename(), tarconn, executeParam.getTargetSchemaName(), desensitizationTable.getTablename());
            }

            if ("isindex".equalsIgnoreCase(executeParam.getIsIndex())) {
               JdbcTool.synchronizeIndex(srcconn, executeParam.getSourceSchemaName(), desensitizationTable.getTablename(), tarconn, executeParam.getTargetSchemaName(), desensitizationTable.getTablename());
            }
         }

         for(DesensitizationTable desensitizationTable : tableList) {
            JdbcTool.synchronizeForeignKey(srcconn, executeParam.getSourceSchemaName(), desensitizationTable.getTablename(), tarconn, executeParam.getTargetSchemaName(), desensitizationTable.getTablename());
         }

         JdbcTool.closeConnection(srcconn);
         JdbcTool.closeConnection(tarconn);
      } catch (Exception e) {
         e.printStackTrace();
      }
   }

   public SessionBean getLogForTaskMapping(String folerName, InfoProperty engine, String name, String sessionId) {
      SessionBean se = new SessionBean();

      try {
         se = MultiGetSessionStatisticsWebService.returnStatus(sessionId, engine, "wf_" + name, "mp_" + name, folerName);
      } catch (Exception e) {
         se.setStatus("EXCEPTION");
         e.printStackTrace();
      }

      return se;
   }

   public boolean updateTask(String tasknamereal, String save_state) {
      new Properties();

      try {
         Properties props = PropertiesLoaderUtils.loadAllProperties("config.properties");
         String sqlurl = props.get("jdbc.url").toString();
         String username = props.get("jdbc.user").toString();
         String password = props.get("jdbc.password").toString();
         String driver = props.get("jdbc.driver").toString();
         Connection connection = JdbcTool.getConnection(driver, sqlurl, username, password);
         Statement statement = connection.createStatement();
         String sql = "update desensitizationtask set save_state = '" + save_state + "' , taskstatus = '0'  where tasknamereal = '" + tasknamereal + "'";
         System.out.println(sql);
         statement.executeUpdate(sql.toString());
         statement.close();
         connection.close();
         return true;
      } catch (IOException e) {
         e.printStackTrace();
         return false;
      } catch (SQLException e) {
         e.printStackTrace();
         return false;
      }
   }

   public void updateTask(Desensitizationtask desensitizationtask) {
      this.desensitizationtaskDao.saveOrUpdate(desensitizationtask);
   }

   public String pageCode(String pageCode) {
      if (pageCode == null) {
         pageCode = "";
      }

      Map<String, String> mappage = new HashMap();
      mappage.put("GBK", "MS936");
      mappage.put("UTF-8", "UTF-8");
      mappage.put("UTF8", "UTF-8");
      mappage.put("", "");
      return (String)mappage.get(pageCode);
   }

   public String pageCode(int pageCode) {
      Map<Integer, String> mappage = new HashMap();
      mappage.put(1, "MS936");
      mappage.put(0, "UTF-8");
      mappage.put(2, "MS950");
      return (String)mappage.get(pageCode);
   }

   public String pageCode_dbf(int pageCode) {
      Map<Integer, String> mappage = new HashMap();
      mappage.put(1, "GBK");
      mappage.put(0, "UTF-8");
      mappage.put(2, "MS950");
      return (String)mappage.get(pageCode);
   }

   public Map<String, String> getDataRuleMap() {
      Map<String, String> data_rule = new HashMap();
      new ArrayList();

      for(TCoreMaskingRuleinfo tCoreMaskingRuleinfo : this.tCoreMaskingRuleinfoDao.queryAll()) {
         data_rule.put(tCoreMaskingRuleinfo.getRuleid(), tCoreMaskingRuleinfo.getMappletname());
      }

      return data_rule;
   }

   public HashMap<String, TCoreFieldSensitiveMemory> getTCoreFieldSensitiveMemory(String tableName, String sourceschema) {
      HashMap<String, TCoreFieldSensitiveMemory> map = new HashMap();
      if (this.redisService.exists(tableName + "+" + sourceschema)) {
         new ArrayList();
         List<TCoreFieldSensitiveMemory> memory = (List)this.redisService.get(tableName + "+" + sourceschema);
         if (memory != null) {
            for(TCoreFieldSensitiveMemory tCoreFieldSensitiveMemory : memory) {
               map.put(tCoreFieldSensitiveMemory.getColumnname(), tCoreFieldSensitiveMemory);
            }
         }
      }

      return map;
   }

   public FlatFile getflatFile(String type, String pagecode, String dataBaseType, String tableName, String tasknamereal) {
      FlatFile sourceflatFile = new FlatFile();
      sourceflatFile.setCodePage("MSSQLSERVER".equals(dataBaseType) ? "UTF-8" : this.pageCode(pagecode));
      sourceflatFile.setCommand(XmlTool.getFileValue(dataBaseType + "/db-command"));
      sourceflatFile.setDelimiter(XmlTool.getFileValue(dataBaseType + "/db-" + type + "delimiter"));
      sourceflatFile.setFilename(tableName + XmlTool.getFileValue(dataBaseType + "/db-suffix"));
      sourceflatFile.setFileType(Integer.parseInt(XmlTool.getFileValue(dataBaseType + "/db-fileType")));
      sourceflatFile.setQuoteCharacter(Integer.parseInt(XmlTool.getFileValue(dataBaseType + "/db-" + type + "quoteCharacter")));
      sourceflatFile.setSkipRows(Integer.parseInt(XmlTool.getFileValue(dataBaseType + "/db-skipRows")));
      String filepath = XmlTool.getFileValue(dataBaseType + "/db-fileDir") + type + "/" + tasknamereal + "/";
      sourceflatFile.setFileDir(filepath);
      if (!FileTool.isFileExit(filepath)) {
         FileTool.createFolder(filepath);
      }

      return sourceflatFile;
   }

   public FlatFile getflatFile(DesensitizationFile desensitizationFile, String tablename, String filetype) {
      FlatFile sourceflatFile = new FlatFile();
      sourceflatFile.setCodePage(this.pageCode(Integer.parseInt(desensitizationFile.getCodepage())));
      sourceflatFile.setCommand("");
      sourceflatFile.setDelimiter(desensitizationFile.getDelimiters());
      sourceflatFile.setFilename(tablename + "." + desensitizationFile.getSuffix());
      sourceflatFile.setQuoteCharacter(Integer.parseInt(desensitizationFile.getQuotecharacter()));
      sourceflatFile.setSkipRows(0);
      String filepath = "";
      switch (filetype) {
         case "FILE":
            sourceflatFile.setFileType(0);
            String var12 = desensitizationFile.getFiledir();
            filepath = "/data/infa_file/" + var12;
            sourceflatFile.setFileDir(filepath);
            break;
         case "FTP":
            sourceflatFile.setFileType(0);
            Desensitizationsource desensitizationsource1 = (Desensitizationsource)this.desensitizationsourceDao.queryUnique(new Criterion[]{Restrictions.eq("taskid", desensitizationFile.getTaskid())});
            TCoreConfig tcoreConfig = (TCoreConfig)this.tCoreConfigDao.queryUnique(new Criterion[]{Restrictions.eq("datasystemid", desensitizationsource1.getDatasourceid())});
            if (tcoreConfig != null) {
               filepath = tcoreConfig.getLocaldir();
               if (filepath == null || filepath.equals("")) {
                  filepath = XmlTool.getFileValue(filetype + "/localdir");
               }

               sourceflatFile.setFileDir(filepath);
            }
            break;
         case "SFTP":
            sourceflatFile.setFileType(0);
            Desensitizationsource desensitizationsource11 = (Desensitizationsource)this.desensitizationsourceDao.queryUnique(new Criterion[]{Restrictions.eq("taskid", desensitizationFile.getTaskid())});
            TCoreConfig tcoreConfig1 = (TCoreConfig)this.tCoreConfigDao.queryUnique(new Criterion[]{Restrictions.eq("datasystemid", desensitizationsource11.getDatasourceid())});
            if (tcoreConfig1 != null) {
               filepath = tcoreConfig1.getLocaldir();
               if (filepath == null || filepath.equals("")) {
                  filepath = XmlTool.getFileValue(filetype + "/localdir");
               }

               sourceflatFile.setFileDir(filepath);
            }
      }

      if (!FileTool.isFileExit(filepath)) {
         FileTool.createFolder(filepath);
      }

      return sourceflatFile;
   }

   public FlatFile getflatFile(DesensitizationTable desensitizationTable, String filetype) {
      FlatFile sourceflatFile = new FlatFile();
      new TCoreFileStructure();
      new TCoreFileStructurespliter();
      TCoreFileStructure tCoreFileStructure = (TCoreFileStructure)this.tCoreFileStructureDao.get(desensitizationTable.getFilestructureid());
      TCoreFileStructurespliter tCoreFileStructurespliter = (TCoreFileStructurespliter)this.tCoreFileStructurespliterDao.queryUnique(new Criterion[]{Restrictions.eq("filestructureid", desensitizationTable.getFilestructureid())});
      sourceflatFile.setCodePage(this.pageCode(Integer.parseInt(tCoreFileStructure.getCodepage())));
      sourceflatFile.setCommand("");
      sourceflatFile.setDelimiter(tCoreFileStructurespliter.getDelimiters());
      String filename = desensitizationTable.getFilename();
      boolean isdbf = filename.substring(filename.length() - 4, filename.length()).contains("dbf");
      sourceflatFile.setFilename(isdbf ? filename.substring(0, filename.length() - 4) + ".txt" : filename);
      sourceflatFile.setFileType(0);
      sourceflatFile.setQuoteCharacter(this.getQuoteCharacter(tCoreFileStructurespliter.getQuotecharacter()));
      sourceflatFile.setSkipRows(Integer.parseInt(tCoreFileStructure.getSkiprows()));
      String filepath = "";
      switch (filetype) {
         case "FILE":
            filepath = "/data/infa_file/" + desensitizationTable.getFilepath() + File.separator;
            if (isdbf) {
               if (FileTool.isFileExit(filepath + sourceflatFile.getFilename())) {
                  FileTool.removeFile(filepath + sourceflatFile.getFilename());
               }

               transdbf.transdbf(this.pageCode_dbf(Integer.parseInt(tCoreFileStructure.getCodepage())), filepath + filename, sourceflatFile.getDelimiter(), filepath + sourceflatFile.getFilename());
            }
            break;
         case "FTP":
            Desensitizationsource desensitizationsource1 = (Desensitizationsource)this.desensitizationsourceDao.queryUnique(new Criterion[]{Restrictions.eq("taskid", desensitizationTable.getTaskid())});
            TCoreConfig tcoreConfig = (TCoreConfig)this.tCoreConfigDao.queryUnique(new Criterion[]{Restrictions.eq("datasystemid", desensitizationsource1.getDatasourceid())});
            if (tcoreConfig != null) {
               filepath = tcoreConfig.getLocaldir();
               if (filepath == null || filepath.equals("")) {
                  filepath = XmlTool.getFileValue(filetype + "/localdir") + desensitizationTable.getFilepath();
               }
            }

            if (isdbf) {
            }
            break;
         case "SFTP":
            Desensitizationsource desensitizationsource11 = (Desensitizationsource)this.desensitizationsourceDao.queryUnique(new Criterion[]{Restrictions.eq("taskid", desensitizationTable.getTaskid())});
            TCoreConfig tcoreConfig1 = (TCoreConfig)this.tCoreConfigDao.queryUnique(new Criterion[]{Restrictions.eq("datasystemid", desensitizationsource11.getDatasourceid())});
            if (tcoreConfig1 != null) {
               filepath = tcoreConfig1.getLocaldir();
               if (filepath == null || filepath.equals("")) {
                  filepath = XmlTool.getFileValue(filetype + "/localdir") + desensitizationTable.getFilepath();
               }
            }

            if (isdbf) {
            }
      }

      sourceflatFile.setFileDir(filepath);
      if (!FileTool.isFileExit("/data/infa_file/")) {
         FileTool.createFolder("/data/infa_file/");
      }

      return sourceflatFile;
   }

   public List<Desensitizationtask> queryTaskAll() {
      return this.desensitizationtaskDao.queryAll("createtime", false);
   }

   public long getExeTaskNum() {
      return this.desensitizationtaskDao.getExeTaskNum();
   }

   public long getTableNum(String taskid) {
      return this.desensitizationtaskDao.getTableNum(taskid);
   }

   public String getRunid(ExecuteParam executeParam, String sessionId, String tableName) {
      SessionBean se = new SessionBean();
      String name = executeParam.getTaskNameReal() + "_" + tableName;

      try {
         se = MultiGetSessionStatisticsWebService.returnStatus(sessionId, executeParam.getInfoProperty(), "wf_" + name, "mp_" + name, executeParam.getFolderName());
      } catch (Exception e) {
         e.printStackTrace();
      }

      String run_id = se.getWf_run_id();
      return run_id;
   }

   public int getQuoteCharacter(String param) {
      int pa = 0;
      switch (param) {
         case "none":
            pa = 0;
            break;
         case "double":
            pa = 2;
            break;
         case "single":
            pa = 1;
      }

      return pa;
   }

   public List<DesensitizationTablecolumn> queryColumInfo(String taskid, String table) {
      DesensitizationTable desensitizationTable = (DesensitizationTable)this.desensitizationTableDao.queryUnique(new Criterion[]{Restrictions.eq("taskid", taskid), Restrictions.eq("tablename", table)});
      List<DesensitizationTablecolumn> list = this.desensitizationTablecolumnDao.queryAll(Order.asc("sortnum"), new Criterion[]{Restrictions.eq("tableid", desensitizationTable.getId())});
      return list;
   }

   public DesensitizationFile queryDesensitizationfileBytaskid(String taskid) {
      new DesensitizationFile();
      return (DesensitizationFile)this.desensitizationFileDao.queryUnique(new Criterion[]{Restrictions.eq("taskid", taskid)});
   }

   @Async
   public void executeDB_batchread_FILE_pwc_FILE_batchwrite_DB(ExecuteParam executeParam) throws Exception {
      System.out.println(">>>>>>>>>>>>>>>>>DB_batchread_FILE_pwc_FILE_batchwrite_DB<<<<<<<<<<<<<<<<<<");
      List<DesensitizationTable> tableList = this.queryTableList(executeParam.getTaskid());
      TCoreDatasystem tCoreDatasystemTarget = this.dataSystemService.queryDataSystemById(executeParam.getDataTargetId());
      TCoreDatasystem tCoreDatasystemSource = this.dataSystemService.queryDataSystemById(executeParam.getDataSourceId());
      Runtime rn = Runtime.getRuntime();
      Map<String, List<DesensitizationTablecolumn>> map = new HashMap();
      CountDownLatch countDownLatch = new CountDownLatch(tableList.size());

      for(DesensitizationTable desensitizationTable : tableList) {
         List<DesensitizationTable> list = this.desensitizationTableDao.queryAll(new Criterion[]{Restrictions.eq("tablename", desensitizationTable.getTablename()), Restrictions.eq("taskid", executeParam.getTaskid())});
         List<DesensitizationTablecolumn> desensitizationTablecolumnList = this.desensitizationTablecolumnDao.queryAll(Order.asc("sortnum"), new Criterion[]{Restrictions.eq("tableid", ((DesensitizationTable)list.get(0)).getId())});
         map.put(desensitizationTable.getTablename(), desensitizationTablecolumnList);
      }

      Desensitizationtask desensitizationTask = (Desensitizationtask)this.desensitizationtaskDao.get(executeParam.getTaskid());
      desensitizationTask.setTaskstatus("1");
      this.desensitizationtaskDao.saveOrUpdate(desensitizationTask);
      this.desensitizationtaskDao.getSession().getTransaction().commit();
      Collections.sort(tableList);

      for(DesensitizationTable desensitizationTable : tableList) {
         String sessionId = "";
         String status = "4";
         String workflowName = "wf_" + executeParam.getTaskNameReal() + "_" + desensitizationTable.getTablename();

         try {
            if ("startup".equals(props.getProperty("Forecast_Run_Time"))) {
               System.out.println("---进入启动预计运行时间方法！");
               String dataCount = "";
               dataCount = this.getDataCount(executeParam.getSourceDataSystem().getDbtype(), executeParam.getSourceDataSystem(), desensitizationTable, executeParam.getSourceSchemaName());
               System.out.println("数据源表" + desensitizationTable.getTablename() + "总行数：" + dataCount);
               this.redisService.set("dataCount:" + desensitizationTask.getTasknamereal() + "_" + desensitizationTable.getTablename(), dataCount);
               System.out.println("预计运行时间，key=dataCount:" + desensitizationTask.getTasknamereal() + "_" + desensitizationTable.getTablename() + "，dataCount=" + dataCount);
            }

            this.updateMonitorRunStatus(desensitizationTable.getTablename(), executeParam.getTableMap());
            System.out.println("~~~~~~~~~~~~~~~~~~~~~~~获取sessionId开始！");
            sessionId = LoginWebService.returnStatus(executeParam.getInfoProperty());
            System.out.println("创建执行脚本开始！tableName=" + desensitizationTable.getTablename());
            this.createScriptFiletotarget(executeParam, desensitizationTable, executeParam.getTargetDataSystem().getDbtype(), tCoreDatasystemTarget, (List)map.get(desensitizationTable.getTablename()), rn);
            System.out.println("创建目标脚本开始！");
            this.createScriptFiletoSource(executeParam, desensitizationTable, executeParam.getTargetDataSystem().getDbtype(), tCoreDatasystemSource, (List)map.get(desensitizationTable.getTablename()), rn);
            System.out.println("创建源脚本开始！");
            String targetdbType = executeParam.getTargetDataSystem().getDbtype();
            String sourcedbType = executeParam.getSourceDataSystem().getDbtype();
            System.out.println("启动脚本开始！dbType=" + targetdbType + ",tableName=" + desensitizationTable.getTablename());
            System.out.println("调用启动工作流方法开始！tableName=" + desensitizationTable.getTablename());
            int runId = this.startWorkFlowEx(workflowName, executeParam.getInfoProperty(), executeParam.getFolderName(), sessionId);
            if ("TERADATA".equals(sourcedbType)) {
               System.out.println("执行源的脚本：/data/infa_teradata/source/" + executeParam.getTaskNameReal() + "/" + desensitizationTable.getTablename() + ".sh");
               CommandTool.commandRtn("/data/infa_teradata/source/" + executeParam.getTaskNameReal() + "/" + desensitizationTable.getTablename() + ".sh");
               System.out.println("执行源的脚本:完成");
            } else if ("MSSQLSERVER".equals(sourcedbType)) {
               CommandTool.commandRtn("/data/infa_sqlserver/source/" + executeParam.getTaskNameReal() + "/" + desensitizationTable.getTablename() + ".sh");
               System.out.println("SQLSERVER执行源的脚本:完成");
            }

            if ("TERADATA".equals(targetdbType)) {
               System.out.println("执行目标的脚本");
               CommandTool.commandRtn2("/data/infa_teradata/target/" + executeParam.getTaskNameReal() + "/" + desensitizationTable.getTablename() + ".sh");
               System.out.println("执行目标的脚本:完成");
            } else if ("MSSQLSERVER".equals(targetdbType)) {
               CommandTool.command("chmod -R 777 /data/infa_sqlserver/");
               String completeStatus = this.workflowTaskCompleteMonitor(executeParam.getInfoProperty(), executeParam.getFolderName(), "wf_" + executeParam.getTaskNameReal() + "_" + desensitizationTable.getTablename(), sessionId);
               if ("1".equals(completeStatus)) {
                  CommandTool.commandRtn("/data/infa_sqlserver/target/" + executeParam.getTaskNameReal() + "/" + desensitizationTable.getTablename() + ".sh");
               }

               System.out.println("SQLSERVER执行目标的脚本:完成");
            }

            if ("TERADATA".equals(sourcedbType)) {
               System.out.println("执行源的脚本：/data/infa_teradata/source/" + executeParam.getTaskNameReal() + "/" + desensitizationTable.getTablename() + ".sh");
               CommandTool.commandRtn2("/data/infa_teradata/source/" + executeParam.getTaskNameReal() + "/" + desensitizationTable.getTablename() + ".sh");
               System.out.println("执行源的脚本:完成");
            }

            String completeStatus = "0";
            if (runId >= 0) {
               completeStatus = this.workflowTaskCompleteMonitor(executeParam.getInfoProperty(), executeParam.getFolderName(), "wf_" + executeParam.getTaskNameReal() + "_" + desensitizationTable.getTablename(), sessionId);
            }

            if ("1".equals(completeStatus)) {
               System.out.println("表" + desensitizationTable.getTablename() + ",执行完成,通过阻塞方法！");
               SessionBean sessionBean = this.getLogForTaskMapping(executeParam.getFolderName(), executeParam.getInfoProperty(), executeParam.getTaskNameReal() + "_" + desensitizationTable.getTablename(), sessionId);
               System.out.println(">>>>>>>>>>>>>>>>>>>>>>>>>>status=" + sessionBean.getStatus());
               if ("SUCCEEDED".equals(sessionBean.getStatus())) {
                  status = "1";
               } else if ("FAILED".equals(sessionBean.getStatus())) {
                  status = "2";
               } else if ("STOPPED".equals(sessionBean.getStatus())) {
                  status = "3";
               } else {
                  status = "4";
               }

               System.out.println("执行更新监控表开始！tableName=" + desensitizationTable.getTablename());
               this.updateMonitor(desensitizationTable.getTablename(), executeParam.getTableMap(), status, runId);
            }

            LogoutWebService.returnStatus(sessionId, executeParam.getInfoProperty());
         } catch (Exception e) {
            e.printStackTrace();
         } finally {
            countDownLatch.countDown();
         }
      }

      try {
         System.out.println(">>>>>>>>>>>>>>>当前活动线程数：" + this.taskExecutor.getActiveCount());
         System.out.println(">>>>>>>>>>>>>>>剩余未执行完线程数：" + countDownLatch.getCount());
         countDownLatch.await();
         this.desensitizationtaskDao.getSession().getTransaction().begin();
         desensitizationTask.setTaskstatus("0");
         this.desensitizationtaskDao.saveOrUpdate(desensitizationTask);
         this.desensitizationtaskDao.getSession().getTransaction().commit();
      } catch (Exception e) {
         e.printStackTrace();
      }

   }

   public void createTeradataExport(List<DesensitizationTablecolumn> colLst, DesensitizationTable desensitizationTable, ExecuteParam executeParam, TCoreDatasystem tCoreDatasystemSource) {
      List<String> colNameLst = new ArrayList();
      Integer totalLen = 0;

      for(int j = 0; j < colLst.size(); ++j) {
         totalLen = totalLen + 3;
         String colName = ((DesensitizationTablecolumn)colLst.get(j)).getColumnname();
         String colType = ((DesensitizationTablecolumn)colLst.get(j)).getColumntype();
         String colLength = ((DesensitizationTablecolumn)colLst.get(j)).getColumnlength();
         String colScale = ((DesensitizationTablecolumn)colLst.get(j)).getColumnscale() == null ? "" : ((DesensitizationTablecolumn)colLst.get(j)).getColumnscale();
         colName = TeradataTool.teradataTypetoVarchar(colName, colType, colLength);
         String realColLength = TeradataTool.teradataTypeLength(colType, colLength, colScale);
         if (StringUtils.isNotBlank(realColLength)) {
            totalLen = totalLen + Integer.valueOf(realColLength);
         }

         colNameLst.add(colName);
      }

      String colNamesStr = StringUtils.join(colNameLst.toArray(), "||'|'||");
      colNamesStr = "(cast(" + colNamesStr + " as char(" + totalLen + ")))";
      Map<String, String> paramMap = new HashMap();
      paramMap.put("schema", executeParam.getSourceSchemaName());
      paramMap.put("tablename", desensitizationTable.getTablename());
      paramMap.put("colNamesStr", colNamesStr);
      paramMap.put("teradataServersIp", tCoreDatasystemSource.getDbip());
      paramMap.put("teradataServersUser", tCoreDatasystemSource.getUsername());
      paramMap.put("teradataServerspwd", "1".equals(tCoreDatasystemSource.getFlag()) ? AesTool.decrypt(tCoreDatasystemSource.getPassword(), "ghca") : tCoreDatasystemSource.getPassword());
      paramMap.put("taskname", executeParam.getTaskNameReal());
      TeradataTool.createTerdataExportScript(paramMap);
   }

   public void createTeradataLoad(List<DesensitizationTablecolumn> colLst, TCoreDatasystem tCoreDatasystemTarget, DesensitizationTable desensitizationTable, ExecuteParam executeParam) {
      List<String> nameList = new ArrayList();
      List<String> lengthList = new ArrayList();

      for(DesensitizationTablecolumn sourceTableCol : colLst) {
         nameList.add(sourceTableCol.getColumnname());
         lengthList.add(sourceTableCol.getColumnlength());
      }

      StringBuffer definesb = new StringBuffer();

      for(int i = 0; i < nameList.size(); ++i) {
         definesb.append((String)nameList.get(i) + "(varchar(" + (String)lengthList.get(i) + ")),");
      }

      Map<String, String> paramMapload = new HashMap();
      paramMapload.put("ip", tCoreDatasystemTarget.getDbip());
      paramMapload.put("port", tCoreDatasystemTarget.getDbport());
      paramMapload.put("user", tCoreDatasystemTarget.getUsername());
      paramMapload.put("pwd", "1".equals(tCoreDatasystemTarget.getFlag()) ? AesTool.decrypt(tCoreDatasystemTarget.getPassword(), "ghca") : tCoreDatasystemTarget.getPassword());
      paramMapload.put("schema", executeParam.getTargetSchemaName());
      paramMapload.put("table", desensitizationTable.getTablename());
      paramMapload.put("path", TeradataTool.STR_PIPEFILE_TAR_PATH + executeParam.getTaskNameReal() + "/");
      paramMapload.put("define", definesb.substring(0, definesb.length() - 1));
      paramMapload.put("in_type", "1");
      String dbcode = tCoreDatasystemTarget.getDbtype();
      String servername = tCoreDatasystemTarget.getDbservername();
      String url = EdbType.getUrlByEdbcode(dbcode, tCoreDatasystemTarget.getDbip(), tCoreDatasystemTarget.getDbport(), servername, tCoreDatasystemTarget.getPagecode());
      String driver = EdbType.getEdbTypeByDbcode(dbcode).getDbdriver();
      paramMapload.put("driver", driver);
      paramMapload.put("url", url);
      paramMapload.put("create_sql", desensitizationTable.getCreate_sql());
      TeradataLoadTableTool.executeLoadTable(paramMapload);
   }

   public String delparentheses(String type) {
      return type.indexOf("(") == -1 ? type : type.substring(0, type.indexOf("("));
   }

   public String getDataCount(String dbType, TCoreDatasystem dataSystem, DesensitizationTable desensitizationTable, String schemaName) {
      String url = "";
      String driver = EdbType.getEdbTypeByDbcode(dbType).getDbdriver();
      switch (dbType) {
         case "INFORMIX":
            url = EdbType.getUrlByEdbcode(dbType, dataSystem.getDbip(), dataSystem.getDbport(), dataSystem.getDbservername(), dataSystem.getServername());
            break;
         case "AS400":
            url = EdbType.getUrlByEdbcode(dbType, dataSystem.getDbip(), dataSystem.getDbservername(), dataSystem.getServername());
            break;
         default:
            url = EdbType.getUrlByEdbcode(dbType, dataSystem.getDbip(), dataSystem.getDbport(), dataSystem.getDbservername());
      }

      int count = 0;

      try {
         Connection connection = JdbcTool.getConnection(driver, url, dataSystem.getUsername(), "1".equals(dataSystem.getFlag()) ? AesTool.decrypt(dataSystem.getPassword(), "ghca") : dataSystem.getPassword());
         Statement statement = connection.createStatement();
         String sqlFilter = desensitizationTable.getSqlFilter();
         String sql = "";
         if (!"".equals(sqlFilter) && sqlFilter != null) {
            sql = "select count(*) from " + schemaName + "." + desensitizationTable.getTablename() + " where " + sqlFilter;
         } else {
            sql = "select count(*) from " + schemaName + "." + desensitizationTable.getTablename();
         }

         System.out.println("" + sql);

         for(ResultSet rs = statement.executeQuery(sql); rs.next(); count = rs.getInt(1)) {
         }

         statement.close();
         connection.close();
      } catch (SQLException e) {
         e.printStackTrace();
      }

      return count + "";
   }

   @Async
   public void executeDB_batchread_FILE_pwc_FILE(ExecuteParam executeParam) throws Exception {
      System.out.println(">>>>>>>>>>>>>>>>>DB_batchread_FILE_pwc_FILE<<<<<<<<<<<<<<<<<<");
      List<DesensitizationTable> tableList = this.queryTableList(executeParam.getTaskid());
      TCoreDatasystem tCoreDatasystemSource = this.dataSystemService.queryDataSystemById(executeParam.getDataSourceId());
      Runtime rn = Runtime.getRuntime();
      Map<String, List<DesensitizationTablecolumn>> map = new HashMap();
      CountDownLatch countDownLatch = new CountDownLatch(tableList.size());

      for(DesensitizationTable desensitizationTable : tableList) {
         List<DesensitizationTable> list = this.desensitizationTableDao.queryAll(new Criterion[]{Restrictions.eq("tablename", desensitizationTable.getTablename()), Restrictions.eq("taskid", executeParam.getTaskid())});
         List<DesensitizationTablecolumn> desensitizationTablecolumnList = this.desensitizationTablecolumnDao.queryAll(Order.asc("sortnum"), new Criterion[]{Restrictions.eq("tableid", ((DesensitizationTable)list.get(0)).getId())});
         map.put(desensitizationTable.getTablename(), desensitizationTablecolumnList);
      }

      Desensitizationtask desensitizationTask = (Desensitizationtask)this.desensitizationtaskDao.get(executeParam.getTaskid());
      desensitizationTask.setTaskstatus("1");
      this.desensitizationtaskDao.saveOrUpdate(desensitizationTask);
      this.desensitizationtaskDao.getSession().getTransaction().commit();
      Collections.sort(tableList);

      for(DesensitizationTable desensitizationTable : tableList) {
         String sessionId = "";
         String status = "4";
         String workflowName = "wf_" + executeParam.getTaskNameReal() + "_" + desensitizationTable.getTablename();

         try {
            if ("startup".equals(props.getProperty("Forecast_Run_Time"))) {
               System.out.println("---进入启动预计运行时间方法！");
               String dataCount = "";
               dataCount = this.getDataCount(executeParam.getSourceDataSystem().getDbtype(), executeParam.getSourceDataSystem(), desensitizationTable, executeParam.getSourceSchemaName());
               System.out.println("数据源表" + desensitizationTable.getTablename() + "总行数：" + dataCount);
               this.redisService.set("dataCount:" + desensitizationTask.getTasknamereal() + "_" + desensitizationTable.getTablename(), dataCount);
               System.out.println("预计运行时间，key=dataCount:" + desensitizationTask.getTasknamereal() + "_" + desensitizationTable.getTablename() + "，dataCount=" + dataCount);
            }

            this.updateMonitorRunStatus(desensitizationTable.getTablename(), executeParam.getTableMap());
            System.out.println("~~~~~~~~~~~~~~~~~~~~~~~获取sessionId开始！");
            sessionId = LoginWebService.returnStatus(executeParam.getInfoProperty());
            System.out.println("创建执行脚本开始！tableName=" + desensitizationTable.getTablename());
            this.createScriptFiletoSource(executeParam, desensitizationTable, executeParam.getSourceDataSystem().getDbtype(), tCoreDatasystemSource, (List)map.get(desensitizationTable.getTablename()), rn);
            System.out.println("调用启动工作流方法开始！tableName=" + desensitizationTable.getTablename());
            int runId = this.startWorkFlowEx(workflowName, executeParam.getInfoProperty(), executeParam.getFolderName(), sessionId);
            String dbType = executeParam.getSourceDataSystem().getDbtype();
            System.out.println("启动脚本开始！dbType=" + dbType + ",tableName=" + desensitizationTable.getTablename());
            if (!"SYBASE_IQ".equals(dbType) && !"MSSQLSERVER".equals(dbType) && !"MYSQL".equals(dbType) && "TERADATA".equals(dbType)) {
               System.out.println("执行源的脚本：/data/infa_teradata/source/" + executeParam.getTaskNameReal() + "/" + desensitizationTable.getTablename() + ".sh");
               CommandTool.commandRtn("/data/infa_teradata/source/" + executeParam.getTaskNameReal() + "/" + desensitizationTable.getTablename() + ".sh");
               System.out.println("执行源的脚本:完成");
            }

            String completeStatus = "0";
            if (runId >= 0) {
               completeStatus = this.workflowTaskCompleteMonitor(executeParam.getInfoProperty(), executeParam.getFolderName(), "wf_" + executeParam.getTaskNameReal() + "_" + desensitizationTable.getTablename(), sessionId);
            }

            if ("1".equals(completeStatus)) {
               System.out.println("表" + desensitizationTable.getTablename() + ",执行完成,通过阻塞方法！");
               SessionBean sessionBean = this.getLogForTaskMapping(executeParam.getFolderName(), executeParam.getInfoProperty(), executeParam.getTaskNameReal() + "_" + desensitizationTable.getTablename(), sessionId);
               System.out.println(">>>>>>>>>>>>>>>>>>>>>>>>>>status=" + sessionBean.getStatus());
               if ("SUCCEEDED".equals(sessionBean.getStatus())) {
                  status = "1";
               } else if ("FAILED".equals(sessionBean.getStatus())) {
                  status = "2";
               } else if ("STOPPED".equals(sessionBean.getStatus())) {
                  status = "3";
               } else {
                  status = "4";
               }

               System.out.println("执行更新监控表开始！tableName=" + desensitizationTable.getTablename());
               this.updateMonitor(desensitizationTable.getTablename(), executeParam.getTableMap(), status, runId);
            }

            LogoutWebService.returnStatus(sessionId, executeParam.getInfoProperty());
         } catch (Exception e) {
            e.printStackTrace();
         } finally {
            countDownLatch.countDown();
         }
      }

      try {
         System.out.println(">>>>>>>>>>>>>>>当前活动线程数：" + this.taskExecutor.getActiveCount());
         System.out.println(">>>>>>>>>>>>>>>剩余未执行完线程数：" + countDownLatch.getCount());
         countDownLatch.await();
         this.desensitizationtaskDao.getSession().getTransaction().begin();
         desensitizationTask.setTaskstatus("0");
         this.desensitizationtaskDao.saveOrUpdate(desensitizationTask);
         this.desensitizationtaskDao.getSession().getTransaction().commit();
      } catch (Exception e) {
         e.printStackTrace();
      }

   }

   @Async
   public void executeDB_batchread_FILE_pwc_DB(ExecuteParam executeParam) throws Exception {
      System.out.println(">>>>>>>>>>>>>>>>>executeDB_batchread_FILE_pwc_DB<<<<<<<<<<<<<<<<<<");
      List<DesensitizationTable> tableList = this.queryTableList(executeParam.getTaskid());
      TCoreDatasystem tCoreDatasystemSource = this.dataSystemService.queryDataSystemById(executeParam.getDataSourceId());
      Runtime rn = Runtime.getRuntime();
      Map<String, List<DesensitizationTablecolumn>> map = new HashMap();
      CountDownLatch countDownLatch = new CountDownLatch(tableList.size());

      for(DesensitizationTable desensitizationTable : tableList) {
         List<DesensitizationTable> list = this.desensitizationTableDao.queryAll(new Criterion[]{Restrictions.eq("tablename", desensitizationTable.getTablename()), Restrictions.eq("taskid", executeParam.getTaskid())});
         List<DesensitizationTablecolumn> desensitizationTablecolumnList = this.desensitizationTablecolumnDao.queryAll(Order.asc("sortnum"), new Criterion[]{Restrictions.eq("tableid", ((DesensitizationTable)list.get(0)).getId())});
         map.put(desensitizationTable.getTablename(), desensitizationTablecolumnList);
      }

      Desensitizationtask desensitizationTask = (Desensitizationtask)this.desensitizationtaskDao.get(executeParam.getTaskid());
      desensitizationTask.setTaskstatus("1");
      this.desensitizationtaskDao.saveOrUpdate(desensitizationTask);
      this.desensitizationtaskDao.getSession().getTransaction().commit();
      Collections.sort(tableList);

      for(DesensitizationTable desensitizationTable : tableList) {
         String sessionId = "";
         String status = "4";
         String workflowName = "wf_" + executeParam.getTaskNameReal() + "_" + desensitizationTable.getTablename();

         try {
            if ("startup".equals(props.getProperty("Forecast_Run_Time"))) {
               System.out.println("---进入启动预计运行时间方法！");
               String dataCount = "";
               dataCount = this.getDataCount(executeParam.getSourceDataSystem().getDbtype(), executeParam.getSourceDataSystem(), desensitizationTable, executeParam.getSourceSchemaName());
               System.out.println("数据源表" + desensitizationTable.getTablename() + "总行数：" + dataCount);
               this.redisService.set("dataCount:" + desensitizationTask.getTasknamereal() + "_" + desensitizationTable.getTablename(), dataCount);
               System.out.println("预计运行时间，key=dataCount:" + desensitizationTask.getTasknamereal() + "_" + desensitizationTable.getTablename() + "，dataCount=" + dataCount);
            }

            this.updateMonitorRunStatus(desensitizationTable.getTablename(), executeParam.getTableMap());
            System.out.println("~~~~~~~~~~~~~~~~~~~~~~~获取sessionId开始！");
            sessionId = LoginWebService.returnStatus(executeParam.getInfoProperty());
            System.out.println("创建执行脚本开始！tableName=" + desensitizationTable.getTablename());
            this.createScriptFiletoSource(executeParam, desensitizationTable, executeParam.getSourceDataSystem().getDbtype(), tCoreDatasystemSource, (List)map.get(desensitizationTable.getTablename()), rn);
            System.out.println("调用启动工作流方法开始！tableName=" + desensitizationTable.getTablename());
            int runId = this.startWorkFlowEx(workflowName, executeParam.getInfoProperty(), executeParam.getFolderName(), sessionId);
            String dbType = executeParam.getTargetDataSystem().getDbtype();
            System.out.println("启动脚本开始！dbType=" + dbType + ",tableName=" + desensitizationTable.getTablename());
            if (!"SYBASE_IQ".equals(dbType)) {
               if ("MSSQLSERVER".equals(dbType)) {
                  CommandTool.commandRtn("/data/infa_sqlserver/source/" + executeParam.getTaskNameReal() + "/" + desensitizationTable.getTablename() + ".sh");
                  System.out.println("SQLSERVER执行源的脚本:完成");
               } else if (!"MYSQL".equals(dbType) && "TERADATA".equals(dbType)) {
                  System.out.println("执行源的脚本：/data/infa_teradata/source/" + executeParam.getTaskNameReal() + "/" + desensitizationTable.getTablename() + ".sh");
                  CommandTool.commandRtn("/data/infa_teradata/source/" + executeParam.getTaskNameReal() + "/" + desensitizationTable.getTablename() + ".sh");
                  System.out.println("执行源的脚本:完成");
               }
            }

            String completeStatus = "0";
            if (runId >= 0) {
               completeStatus = this.workflowTaskCompleteMonitor(executeParam.getInfoProperty(), executeParam.getFolderName(), "wf_" + executeParam.getTaskNameReal() + "_" + desensitizationTable.getTablename(), sessionId);
            }

            if ("1".equals(completeStatus)) {
               System.out.println("表" + desensitizationTable.getTablename() + ",执行完成,通过阻塞方法！");
               SessionBean sessionBean = this.getLogForTaskMapping(executeParam.getFolderName(), executeParam.getInfoProperty(), executeParam.getTaskNameReal() + "_" + desensitizationTable.getTablename(), sessionId);
               System.out.println(">>>>>>>>>>>>>>>>>>>>>>>>>>status=" + sessionBean.getStatus());
               if ("SUCCEEDED".equals(sessionBean.getStatus())) {
                  status = "1";
               } else if ("FAILED".equals(sessionBean.getStatus())) {
                  status = "2";
               } else if ("STOPPED".equals(sessionBean.getStatus())) {
                  status = "3";
               } else {
                  status = "4";
               }

               System.out.println("执行更新监控表开始！tableName=" + desensitizationTable.getTablename());
               this.updateMonitor(desensitizationTable.getTablename(), executeParam.getTableMap(), status, runId);
            }

            LogoutWebService.returnStatus(sessionId, executeParam.getInfoProperty());
         } catch (Exception e) {
            e.printStackTrace();
         } finally {
            countDownLatch.countDown();
         }
      }

      try {
         System.out.println(">>>>>>>>>>>>>>>当前活动线程数：" + this.taskExecutor.getActiveCount());
         System.out.println(">>>>>>>>>>>>>>>剩余未执行完线程数：" + countDownLatch.getCount());
         countDownLatch.await();
         this.desensitizationtaskDao.getSession().getTransaction().begin();
         desensitizationTask.setTaskstatus("0");
         this.desensitizationtaskDao.saveOrUpdate(desensitizationTask);
         this.desensitizationtaskDao.getSession().getTransaction().commit();
      } catch (Exception e) {
         e.printStackTrace();
      }

   }

   public long getTableNumByAll(String sql) {
      return this.desensitizationtaskDao.getTableNumByAll(sql);
   }

   static {
      try {
         props = PropertiesLoaderUtils.loadAllProperties("config.properties");
      } catch (IOException e) {
         e.printStackTrace();
      }

   }
}
