package com.chenyang.nse.bussiness.service.core.impl;

import com.chenyang.nse.bussiness.dao.table.core.TcoreDiscoveryConditionDao;
import com.chenyang.nse.bussiness.entity.orm.table.core.discovery.TcoreDiscoveryCondition;
import com.chenyang.nse.bussiness.service.core.DiscoveryConditionService;
import java.util.List;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class DiscoveryConditionServiceImpl implements DiscoveryConditionService {
   @Autowired
   private TcoreDiscoveryConditionDao tcoreDiscoveryConditionDao;

   public List<TcoreDiscoveryCondition> queryDiscoveryConditionByTaskId(String taskid) {
      List<TcoreDiscoveryCondition> list = this.tcoreDiscoveryConditionDao.queryAll(new Criterion[]{Restrictions.eq("groupid", taskid)});
      return list;
   }

   public void saveDiscoveryConditionParamter(List<TcoreDiscoveryCondition> tcoreSensitivesearchlog, String groupId) {
      List<TcoreDiscoveryCondition> list = this.tcoreDiscoveryConditionDao.queryAll(new Criterion[]{Restrictions.eq("groupid", groupId)});
      this.tcoreDiscoveryConditionDao.remove(list);

      for(TcoreDiscoveryCondition log : tcoreSensitivesearchlog) {
         this.tcoreDiscoveryConditionDao.save(log);
      }

   }

   public void delDiscoveryConditiontablelog(String groupid) {
      this.tcoreDiscoveryConditionDao.deletetablelog(groupid);
   }
}
