package com.chenyang.nse.bussiness.service.core.impl;

import com.chenyang.nse.bussiness.dao.table.core.notice.MailDao;
import com.chenyang.nse.bussiness.entity.orm.table.core.notice.MailInformation;
import com.chenyang.nse.bussiness.service.core.MailService;
import com.chenyang.nse.bussiness.tools.login.CommonUtils;
import com.chenyang.nse.bussiness.tools.string.StringTool;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.mail.SimpleMailMessage;
import org.springframework.mail.javamail.JavaMailSenderImpl;
import org.springframework.stereotype.Service;

@Service
public class MailServiceImpl implements MailService {
   @Autowired
   private JavaMailSenderImpl jms;
   private String from;
   @Autowired
   private MailDao mailDao;

   public MailInformation initEmail(String id) {
      return (MailInformation)this.mailDao.queryUnique(new Criterion[]{Restrictions.eq("id", id)});
   }

   public void addEmail(MailInformation mailInformation) {
      String username = CommonUtils.loginUsername();
      if (StringUtils.isBlank(mailInformation.getId())) {
         mailInformation.setCreateuser(username);
         mailInformation.setCreatetime(new Date());
         mailInformation.setFlag("0");
         mailInformation.setId(StringTool.getTablePrimaryKey());
         this.mailDao.save(mailInformation);
      } else {
         MailInformation mailInfo = (MailInformation)this.mailDao.queryUnique(new Criterion[]{Restrictions.eq("id", mailInformation.getId())});
         BeanUtils.copyProperties(mailInformation, mailInfo);
         mailInformation.setFlag("0");
         mailInfo.setUpdateuser(username);
         mailInfo.setUpdatetime(new Date());
         this.mailDao.saveOrUpdate(mailInfo);
      }

   }

   public void remove(String id) {
      Criterion croleid = Restrictions.in("id", new Object[]{id});
      this.mailDao.remove(new Criterion[]{croleid});
   }

   public List<MailInformation> queryAll() {
      return this.mailDao.queryAll();
   }

   public void sendSimpleMail(MailInformation mail) {
      Properties mailProperties = new Properties();
      mailProperties.put("mail.smtp.starttls.enable", true);
      mailProperties.put("mail.smtp.ssl.trust", mail.getHost());
      if (StringUtils.isNotBlank(mail.getSslflag()) && mail.getSslflag().equals("1")) {
         mailProperties.put("mail.smtp.socketFactory", "javax.net.ssl.SSLSocketFactory");
         mailProperties.put("mail.smtp.socketFactory.fallback", false);
      }

      this.jms.setJavaMailProperties(mailProperties);
      this.jms.setHost(mail.getHost());
      this.jms.setPort(mail.getPort());
      this.jms.setUsername(mail.getSendemail());
      this.jms.setPassword(mail.getSendpassword());
      SimpleMailMessage message = new SimpleMailMessage();
      message.setFrom(mail.getSendemail());
      message.setTo(mail.getMailto());
      message.setSubject(mail.getMailsubject());
      message.setText(mail.getMailbody());
      this.jms.send(message);
   }
}
