package com.chenyang.nse.bussiness.service.info;

import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreDatasystemengine;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreEnginefolder;
import com.chenyang.nse.bussiness.entity.orm.table.core.masking.TCoreMaskingRule;
import com.chenyang.nse.bussiness.entity.orm.table.core.masking.TCoreMaskingTask;
import com.chenyang.nse.bussiness.entity.orm.table.core.masking.TCoreSyncKeyindex;
import java.util.List;
import java.util.Map;

public interface InfoService {
   TCoreDatasystemengine getDatasystemEngine(String datasystemid, String engineid);

   TCoreMaskingRule queryMaskingRuleById(String id);

   TCoreEnginefolder getEngineFolder(String datasourceid, String datatargetid, String engineid, String foldername);

   void generateMaskingTask(String maskingtableid);

   void executeMaskingTask(String maskingtableid);

   void generateDataCopyTask(String maskingtableid);

   void generateDataCopyTaskMulti(String taskid);

   List<String> getAllFolder(String engineId);

   boolean importMutilMapping(String taskid);

   boolean isEngineRun(String engineid);

   List<String> queryFolderList(String engineid);

   boolean isFolderExist(String engineid, String foldername);

   boolean createFolderInEngine(String engineid, String foldername);

   boolean deleteFolderInEngine(String engineid, String foldername);

   boolean isLinkExist(String engineid, String linkname);

   boolean createLinkInEngine(String engineid, String linkname);

   boolean importMapping(String taskid, String filename, String quick);

   boolean importimpMapping(String taskid);

   boolean importSubMapping(String taskid);

   boolean executeMapping(String taskid);

   boolean executeSubMapping(String taskid);

   boolean executeSubtask(String taskid, String userid);

   void generateTask(String taskid);

   void importTask(String taskid);

   boolean executeTask(String taskid, String userid);

   boolean executeFileTask(String taskid, String userid) throws Exception;

   boolean executeimpTask(TCoreMaskingTask task, String userid);

   boolean createLinkInEngine(String engineid, String datasystemid, String linkname);

   void test();

   TCoreSyncKeyindex querySync(String taskid, String sourcename);

   boolean createFileTask(String taskid, String userid);

   boolean createTask(String taskid, String userid, String quick, Map<String, String> dataMap) throws Exception;

   void controlTask(String taskid, String userid) throws Exception;

   boolean executeFiletoSybaseIQ(String taskid, String userid, String quick) throws Exception;

   boolean executeFiletoTeradata(String taskid, String userid, String quick) throws Exception;

   boolean executeTeradataTask(String taskid, String userid) throws Exception;

   boolean executeFiletoMysqlLoad(String taskid, String userid, String quick) throws Exception;
}
