package com.chenyang.nse.bussiness.service.info.db;

import com.chenyang.nse.bussiness.entity.orm.table.console.TConsoleFastManage;
import com.chenyang.nse.bussiness.tools.jdbc.JdbcTool;
import com.power.xml.entity.ColumnInfo;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;

public class DB2 extends CommonMethod implements DatabaseTool {
   public static final String db2importname = "db2load";
   public static final String db2importmark = "快速导入";
   public static final String[][] exporttype = new String[][]{{"normal", "正常导出", "selected"}};
   public static final String[][] importtype = new String[][]{{"normal", "正常导入", "selected"}, {"db2load", "快速导入", ""}};

   public String ImportMethod() {
      StringBuffer targetradio = new StringBuffer();
      List<TConsoleFastManage> list = this.tConsoleFastManageDao.queryAll(new Criterion[]{Restrictions.eq("databasetype", this.getClass().getSimpleName())});
      if (!list.isEmpty()) {
         TConsoleFastManage tConsoleFastManage = (TConsoleFastManage)list.get(0);
         if (tConsoleFastManage.getFastimport() == 0) {
            targetradio.append(MessageFormat.format(this.targetradio(), "'normal'", "正常导出", "selected"));
         } else {
            targetradio.append("<select name='execution_type' >");

            for(String[] radio : importtype) {
               targetradio.append(MessageFormat.format(this.sourceradio(), "'" + radio[0] + "'", radio[1], radio[2]));
            }

            targetradio.append("</select>");
         }
      } else {
         targetradio.append("<select name='execution_type' >");

         for(String[] radio : importtype) {
            targetradio.append(MessageFormat.format(this.sourceradio(), "'" + radio[0] + "'", radio[1], radio[2]));
         }

         targetradio.append("</select>");
      }

      return targetradio.toString();
   }

   public String ExportMethod() {
      StringBuffer sourceradio = new StringBuffer();
      sourceradio.append("<select name='execution_type' >");

      for(String[] radio : exporttype) {
         sourceradio.append(MessageFormat.format(this.sourceradio(), "'" + radio[0] + "'", radio[1], radio[2]));
      }

      sourceradio.append("</select>");
      return sourceradio.toString();
   }

   public Map TargetParameter_normal() {
      Map<String, String> map = this.TargetParameter_fnormal();
      map.put("targetParameter", this.isrebuild() + this.isindex() + this.isprimary() + this.istrigger() + this.isfunction() + this.isconstraint() + this.isview());
      return map;
   }

   public Map TargetParameter_normal1() {
      Map<String, String> map = this.TargetParameter_fnormal();
      map.put("targetParameter", this.isrebuild() + this.isindex() + this.isprimary() + this.istrigger() + this.isfunction());
      return map;
   }

   public Map TargetParameter_notNormal() {
      Map<String, String> map = this.TargetParameter_fnotnormal();
      return map;
   }

   public List<StringBuffer> SynTriggersParam(Connection s_conn, Map map) {
      List<StringBuffer> listFunction = new ArrayList();
      PreparedStatement ps = null;
      ResultSet rs = null;
      String targetSchemaName = (String)map.get("targetSchemaName");
      String sourceSchemaName = (String)map.get("sourceSchema");
      String sql = "select TEXT AS triggers_sql from syscat.triggers where TRIGSCHEMA ='" + sourceSchemaName + "'";

      try {
         ps = s_conn.prepareStatement(sql);
         rs = ps.executeQuery();

         while(rs.next()) {
            StringBuffer sb = new StringBuffer();
            sb.append(JdbcTool.ClobToString(rs.getClob("triggers_sql")).toString().replaceAll(sourceSchemaName, targetSchemaName));
            listFunction.add(sb);
            System.out.println(sb.toString());
         }
      } catch (SQLException e) {
         e.printStackTrace();
      } catch (IOException e) {
         e.printStackTrace();
      } finally {
         try {
            if (rs != null) {
               rs.close();
            }

            if (ps != null) {
               ps.close();
            }
         } catch (SQLException e) {
            e.printStackTrace();
         }

      }

      return listFunction;
   }

   public List<StringBuffer> SynFunctionParam(Connection s_conn, Map map) {
      List<StringBuffer> listFunction = new ArrayList();
      PreparedStatement ps = null;
      ResultSet rs = null;
      String targetSchemaName = (String)map.get("targetSchemaName");
      String sourceSchemaName = (String)map.get("sourceSchema");
      String sql = "select BODY AS function_sql  from syscat.functions where funcschema='" + sourceSchemaName + "'";

      try {
         ps = s_conn.prepareStatement(sql);
         rs = ps.executeQuery();

         while(rs.next()) {
            StringBuffer sb = new StringBuffer();
            sb.append(JdbcTool.ClobToString(rs.getClob("function_sql")).toString().replaceAll(sourceSchemaName, targetSchemaName));
            listFunction.add(sb);
            System.out.println(sb.toString());
         }
      } catch (SQLException e) {
         e.printStackTrace();
      } catch (IOException e) {
         e.printStackTrace();
      } finally {
         try {
            if (rs != null) {
               rs.close();
            }

            if (ps != null) {
               ps.close();
            }
         } catch (SQLException e) {
            e.printStackTrace();
         }

      }

      return listFunction;
   }

   public List<StringBuffer> SynProcedureParam(Connection s_conn, Map map) {
      List<StringBuffer> listProcedure = new ArrayList();
      PreparedStatement ps = null;
      ResultSet rs = null;
      String targetSchemaName = (String)map.get("targetSchemaName");
      String sourceSchemaName = (String)map.get("sourceSchema");
      String sql = "select TEXT AS procedure_sql from syscat.procedures where procschema='" + sourceSchemaName + "'";

      try {
         ps = s_conn.prepareStatement(sql);
         rs = ps.executeQuery();

         while(rs.next()) {
            StringBuffer sb = new StringBuffer();
            sb.append(JdbcTool.ClobToString(rs.getClob("procedure_sql")).toString().replaceAll(sourceSchemaName, targetSchemaName));
            listProcedure.add(sb);
            System.out.println(sb.toString());
         }
      } catch (SQLException e) {
         e.printStackTrace();
      } catch (IOException e) {
         e.printStackTrace();
      } finally {
         try {
            if (rs != null) {
               rs.close();
            }

            if (ps != null) {
               ps.close();
            }
         } catch (SQLException e) {
            e.printStackTrace();
         }

      }

      return listProcedure;
   }

   public ColumnInfo getPwc_columnInfo_target(Map map) {
      ColumnInfo columnInfo = this.getPwc_columnInfo_target_all_base(map);
      return columnInfo;
   }

   public ColumnInfo getPwc_columnInfo_source(Map map) {
      ColumnInfo columnInfo = this.getPwc_columnInfo_source_all_base(map);
      return columnInfo;
   }

   public List<StringBuffer> SynViewParam(Connection s_conn, Map map) {
      List<StringBuffer> listProcedure = new ArrayList();
      PreparedStatement ps = null;
      ResultSet rs = null;
      ResultSet rss = null;
      String targetSchemaName = (String)map.get("targetSchemaName");
      String sourceSchemaName = (String)map.get("sourceSchema");
      String sourceSchema = (String)map.get("sourceSchema");
      String sql_user = "SELECT * FROM SYSIBM.SYSTABLES WHERE TYPE='V' AND CREATOR = '" + sourceSchema.toUpperCase() + "'";

      try {
         ps = s_conn.prepareStatement(sql_user);
         rss = ps.executeQuery();

         while(rss.next()) {
            String sourceViewName = rss.getString("Name");
            String sql = "SELECT TEXT FROM syscat.views WHERE viewschema='" + sourceSchema.toUpperCase() + "' AND viewname='" + sourceViewName + "'";
            ps = s_conn.prepareStatement(sql);
            rs = ps.executeQuery();

            while(rs.next()) {
               StringBuffer sb = new StringBuffer();
               String string = rs.getString(1);
               String string1 = string.replace(sourceSchemaName, targetSchemaName);
               sb.append(string1);
               listProcedure.add(sb);
            }
         }
      } catch (SQLException e) {
         e.printStackTrace();
      } finally {
         try {
            if (rs != null) {
               rs.close();
            }

            if (ps != null) {
               ps.close();
            }
         } catch (SQLException e) {
            e.printStackTrace();
         }

      }

      return listProcedure;
   }

   public String SynConstraintParam(Connection srcconn, Map map) {
      return null;
   }

   public String SynPartition(Connection s_conn, Map map) {
      PreparedStatement ps = null;
      ResultSet rs = null;
      ResultSet rss = null;
      String sourceSchemaName = (String)map.get("sourceSchemaName");
      String sourceTableName = (String)map.get("tableName");
      String sql = "select * from syscat.datapartitions t where TABSCHEMA='" + sourceSchemaName + "' and tabname = '" + sourceTableName + "'";
      String sqlType = "SELECT * FROM SYSCAT.DATAPARTITIONEXPRESSION where tabname='" + sourceTableName + "'";

      try {
         PreparedStatement var26 = s_conn.prepareStatement(sql);
         rs = var26.executeQuery();
         ps = s_conn.prepareStatement(sqlType);
         rss = ps.executeQuery();
         if (rss.next()) {
            int cnt = 0;
            StringBuffer sb = new StringBuffer();
            String type = rss.getString("DATAPARTITIONEXPRESSION");
            sb.append("PARTITION BY RANGE(");
            sb.append("\"");
            sb.append(type);
            sb.append("\"");
            sb.append(")(");

            while(rs.next()) {
               if (cnt != 0) {
                  sb.append(",");
               }

               String name = rs.getString("DATAPARTITIONNAME");
               String start = rs.getString("LOWVALUE");
               String end = rs.getString("HIGHVALUE");
               sb.append("PART ");
               sb.append("\"");
               sb.append(name);
               sb.append("\"");
               sb.append(" STARTING(" + start + ") ENDING(" + end + ")");
               ++cnt;
            }

            sb.append(")");
            sql = sb.toString();
         } else {
            sql = "false";
         }
      } catch (SQLException e) {
         e.printStackTrace();
      } finally {
         try {
            if (rs != null) {
               rs.close();
            }

            if (ps != null) {
               ps.close();
            }
         } catch (SQLException e) {
            e.printStackTrace();
         }

      }

      return sql;
   }

   public Map TargetParameter_normalEM() {
      return null;
   }
}
