package com.chenyang.nse.bussiness.tools.dataprocess;

import com.chenyang.nse.bussiness.entity.orm.table.core.encryption.TCoreEncryptionTypeField;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import org.apache.commons.beanutils.BeanUtils;

public class EncTaskTracker {
   private volatile int id;
   private ReadWriteLock lock = new ReentrantReadWriteLock();
   private Map<Integer, EncTaskStateContainer> states = new ConcurrentHashMap();

   public static EncTaskTracker instance() {
      return EncTaskTrackerInstance.INSTANCE;
   }

   EncTaskTracker() {
   }

   public EncTaskStateContainer container() {
      int i = this.nextId();
      EncTaskStateContainer c = new EncTaskStateContainer(i);
      return c;
   }

   public void register(EncTaskStateContainer taskStates) {
      if (taskStates != null && taskStates.size() != 0) {
         this.register(taskStates.getTask(), taskStates);
      }
   }

   public void register(Integer id, EncTaskStateContainer taskStates) {
      try {
         this.lock.writeLock().lock();
         this.states.put(id, taskStates);
      } finally {
         this.lock.writeLock().unlock();
      }

   }

   public void over(Integer id) {
      try {
         this.lock.writeLock().lock();
         this.states.remove(id);
      } finally {
         this.lock.writeLock().unlock();
      }

   }

   synchronized int nextId() {
      ++this.id;
      return this.id;
   }

   public List<TCoreEncryptionTypeFieldState> fillStates(List<TCoreEncryptionTypeField> fields) {
      if (fields != null && fields.size() != 0) {
         List<EncTaskStateContainer> containers = null;

         try {
            this.lock.readLock().lock();
            containers = (List)this.states.values().stream().collect(Collectors.toList());
         } finally {
            this.lock.readLock().unlock();
         }

         ArrayList execStates = new ArrayList();

         for(TCoreEncryptionTypeField field : fields) {
            TCoreEncryptionTypeFieldState execState = new TCoreEncryptionTypeFieldState();

            try {
               BeanUtils.copyProperties(execState, field);
            } catch (Exception e) {
               e.printStackTrace();
            }

            execStates.add(execState);

            for(EncTaskStateContainer container : containers) {
               EncTaskState state = container.get(field.getProjectid(), field.getTschemas(), field.getNames(), field.getTable_field_id());
               if (state != null) {
                  execState.setExecStatus(state.getState());
                  break;
               }
            }
         }

         return execStates;
      } else {
         return new ArrayList();
      }
   }

   static class EncTaskTrackerInstance {
      static EncTaskTracker INSTANCE = new EncTaskTracker();
   }

   public static class TCoreEncryptionTypeFieldState extends TCoreEncryptionTypeField {
      private int execStatus;

      public int getExecStatus() {
         return this.execStatus;
      }

      public void setExecStatus(int execStatus) {
         this.execStatus = execStatus;
      }
   }
}
