package com.chenyang.nse.bussiness.tools.dataprocess.hive.hdfs.format;

import com.chenyang.nse.bussiness.entity.db.ColumnInfo;
import com.chenyang.nse.bussiness.tools.dataprocess.NewLoadingTask;
import java.io.IOException;
import java.util.List;

public abstract class HdfsFileWriter {
   protected List<ColumnInfo> cols;

   public abstract void append(DataBatch.DataRow row) throws IOException;

   public abstract byte[] getBytes();

   public static HiveFileType getFileType(String serde) {
      if (serde != null && serde.length() != 0) {
         serde = serde.toLowerCase();
         if (!serde.contains("orcserde") && !serde.contains("inceptor") && !serde.contains("transwarp")) {
            if (serde.contains("text")) {
               return HiveFileType.text;
            } else if (serde.contains("parq")) {
               return HiveFileType.parquet;
            } else if (serde.contains("sequence")) {
               return HiveFileType.seq;
            } else {
               return serde.contains("rcfile") ? HiveFileType.rcfile : HiveFileType.text;
            }
         } else {
            if (serde.contains("inceptor") || serde.contains("transwarp")) {
               NewLoadingTask.ARGODB_FLAG = true;
            }

            return HiveFileType.orc;
         }
      } else {
         return null;
      }
   }
}
