package com.chenyang.nse.bussiness.tools.dataprocess.hive.hdfs.format;

import java.util.ArrayList;
import java.util.List;

public enum HiveFileType {
   orc(0, "ORC"),
   text(1, "TextFile"),
   seq(2, "Sequence"),
   rcfile(3, "RCFile"),
   parquet(4, "Parquet");

   private int code;
   private String name;

   private HiveFileType(int code, String name) {
      this.code = code;
      this.name = name;
   }

   public String getTypeName() {
      return this.name.toUpperCase();
   }

   public static List<String> getFileTypeNames() {
      List<String> names = new ArrayList();
      names.add(orc.name.toUpperCase());
      names.add(text.name.toUpperCase());
      names.add(seq.name.toUpperCase());
      names.add(rcfile.name.toUpperCase());
      names.add(parquet.name.toUpperCase());
      return names;
   }

   public static HiveFileType getHiveTypeFormatFromName(String name) {
      if (name != null && name.length() != 0) {
         switch (name.toUpperCase()) {
            case "ORC":
               return orc;
            case "TEXTFILE":
               return text;
            case "SEQUENCE":
               return seq;
            case "RCFILE":
               return rcfile;
            case "PARQUET":
               return parquet;
            default:
               return null;
         }
      } else {
         return null;
      }
   }
}
