package com.chenyang.nse.bussiness.tools.sql;

import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.dialect.postgresql.visitor.PGSchemaStatVisitor;
import com.alibaba.druid.stat.TableStat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class SqlParseUtil {
   public static Collection<TableStat.Column> execute(String dbType, String sql) throws Exception {
      Collection<TableStat.Column> ret = new ArrayList();
      SQLUtils.format(sql, dbType);
      List<SQLStatement> stmtList = SQLUtils.parseStatements(sql, dbType);

      for(int i = 0; i < stmtList.size(); ++i) {
         SQLStatement stmt = (SQLStatement)stmtList.get(i);
         PGSchemaStatVisitor visitor = new PGSchemaStatVisitor();
         stmt.accept(visitor);

         for(TableStat.Column iterator : visitor.getGroupByColumns()) {
            ;
         }

         Map<TableStat.Name, TableStat> tabmap = visitor.getTables();

         for(TableStat.Name var11 : tabmap.keySet()) {
            ;
         }

         System.out.println("fields : " + visitor.getColumns());
         ret.addAll(visitor.getColumns());
      }

      return ret;
   }

   public static void main(String[] args) {
      String sql = "select sum(case when a.state in  ('4', '5', '6', '7', '8', '9') then 1 else 0 end) 张三,aaa(ddd) from student ts where ts.name like '%%' limit 10";
   }
}
