package com.chenyang.nse.bussiness.commmon.json;

public enum ErrCode {
   UNAUTHORIZED("9401", "未经授权"),
   FORBIDDEN("9403", "无操作权限"),
   DATA_NOT_FOUND("9404", "数据未找到"),
   SERVER_EXCEPTION("9501", "服务端异常"),
   DATA_PROCESS_ERROR("9600", "数据处理异常"),
   BIND_ERROR("9601", "数据绑定错误"),
   DATA_IS_EXIST("9602", "同类数据已存在"),
   DATA_NOT_EDITABLE("9603", "数据不可编辑"),
   DATA_EHECK_FAILURE("9603", "数据检查失败"),
   DATA_IS_RELATION("9604", "数据被引用"),
   DATA_PARSE_FAILURE("9605", "数据解析失败"),
   DATA_ENCODE_FAILURE("9607", "数据编码失败"),
   DATA_DECODE_FAILURE("9608", "数据解码失败"),
   BUSINESS_ERROR("9701", "业务逻辑错误"),
   UNSUPPORTED_TYPE("9702", "不支持的类型"),
   REQ_PARAM_ERROR("9801", "请求的参数错误"),
   TOKEN_INVALID("9802", "令牌无效"),
   REMOTE_CALL_ERROR("9901", "远程调用失败"),
   NEVER_USED_CODE("9999", "无解了"),
   DATASOURCE_USE_CODE("9981", "该数据源已被受控资产库使用"),
   PASSWORD_ERROR_CODE("9982", "新密码与原密码相同"),
   REDUNDANCE_COLUMN("9983", "请先删除多余列"),
   CHECK_ERROR("9984", "校验失败，无法替换"),
   REPLACE_FAIL("9987", "替换失败"),
   NO_PK("9988", "当前表不存在主键，无法加载，请先设置主键"),
   CANNOT_EXPORT_EXCEL("9989", "存在中间状态，不允许做加密备份！"),
   DATABASE_NOT_EXIST("9990", "数据库结构不一致，无法导入加密规则！"),
   DUPLICATE_ENCRYPT_COLUMN("9991", "已配置加密规则，无法导入加密规则！"),
   WRONG_DATASYSTEM("9992", "导入的字段不属于该项目对应的数据源"),
   WRONG_TXT("9993", "导入的txt格式错误"),
   PROJECT_NULL("10001", "项目关联资产库不存在！"),
   CONNECT_ERROR_CODE("9984", "数据库连接异常！"),
   CONNECT_ERROR("9985", "连接异常");

   private String code;
   private String desc;

   private ErrCode(String code, String desc) {
      this.code = code;
      this.desc = desc;
   }

   public String getCode() {
      return this.code;
   }

   public String getDesc() {
      return this.desc;
   }
}
