package com.chenyang.nse.bussiness.controller;

import java.io.IOException;
import java.io.InputStream;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import javax.websocket.server.ServerEndpoint;

@ServerEndpoint("/log")
public class LogWebSocketHandle {
   private Process process;
   private InputStream inputStream;

   @OnOpen
   public void onOpen(Session session) {
      try {
         System.out.println("初始化");
         this.process = Runtime.getRuntime().exec("tail -f /data/webapp/apache-tomcat-8.0.33/logs/catalina.out");
         this.inputStream = this.process.getInputStream();
         TailLogThread thread = new TailLogThread(this.inputStream, session);
         thread.start();
      } catch (IOException e) {
         e.printStackTrace();
      }

   }

   @OnClose
   public void onClose() {
      try {
         if (this.inputStream != null) {
            this.inputStream.close();
         }
      } catch (Exception e) {
         e.printStackTrace();
      }

      if (this.process != null) {
         this.process.destroy();
      }

   }

   @OnError
   public void onError(Throwable thr) {
      thr.printStackTrace();
   }
}
