package com.chenyang.nse.bussiness.controller.console;

import com.chenyang.nse.bussiness.entity.orm.table.console.engine.TConsoleEngineProperty;
import com.chenyang.nse.bussiness.entity.orm.table.console.engine.TConsoleEngineType;
import com.chenyang.nse.bussiness.entity.vo.DataGridVO;
import com.chenyang.nse.bussiness.service.console.EngineManageService;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping({"/console/enginemanage"})
public class EngineManageController {
   @Autowired
   private EngineManageService engineManageService;

   @RequestMapping
   public String index(HttpServletRequest request, HttpServletResponse response, Model model) {
      return "console/enginemanage";
   }

   @ResponseBody
   @RequestMapping({"/query"})
   public DataGridVO<TConsoleEngineType> query(HttpServletRequest request, HttpServletResponse response, Model model) {
      List<TConsoleEngineType> list = this.engineManageService.queryAllEngineType();
      DataGridVO<TConsoleEngineType> vo = new DataGridVO<TConsoleEngineType>((long)list.size(), list);
      return vo;
   }

   @ResponseBody
   @RequestMapping({"/queryproperty"})
   public List<TConsoleEngineProperty> queryproperty(String enginetypeid, HttpServletRequest request, HttpServletResponse response, Model model) {
      List<TConsoleEngineProperty> list = this.engineManageService.queryEngineProperty(enginetypeid);
      return list;
   }

   @ResponseBody
   @RequestMapping({"/save"})
   public void save(@RequestBody TConsoleEngineType enginetype, HttpServletRequest request, HttpServletResponse response, Model model) {
      this.engineManageService.saveEngineType(enginetype);
   }

   @ResponseBody
   @RequestMapping({"/remove"})
   public void remove(String id, HttpServletRequest request, HttpServletResponse response, Model model) {
      this.engineManageService.removeEngineType(id);
   }
}
