package com.chenyang.nse.bussiness.controller.core;

import com.chenyang.nse.bussiness.commmon.json.ErrCode;
import com.chenyang.nse.bussiness.commmon.json.RespHelper;
import com.chenyang.nse.bussiness.commmon.json.Response;
import com.chenyang.nse.bussiness.dao.table.core.dataproject.TCoreDataProjectDao;
import com.chenyang.nse.bussiness.dao.table.core.scopeproject.TProEditionScopeDao;
import com.chenyang.nse.bussiness.entity.cache.LoginUser;
import com.chenyang.nse.bussiness.entity.orm.table.core.DgDefineRule;
import com.chenyang.nse.bussiness.entity.orm.table.core.dataproject.TCoreDataProject;
import com.chenyang.nse.bussiness.entity.orm.table.core.scopeproject.TProEditionScope;
import com.chenyang.nse.bussiness.entity.vo.datascope.EditionProjectReqVO;
import com.chenyang.nse.bussiness.entity.vo.datascope.EditionProjectVO;
import com.chenyang.nse.bussiness.entity.vo.datascope.TProEditionScopeVO;
import com.chenyang.nse.bussiness.service.console.OperationService;
import com.chenyang.nse.bussiness.service.core.ComplianceDirectoryService;
import com.chenyang.nse.bussiness.service.core.DataScopeService;
import com.chenyang.nse.bussiness.service.core.DataSystemService;
import com.chenyang.nse.bussiness.service.core.SensitiveLevelService;
import com.chenyang.nse.bussiness.service.redis.RedisService;
import com.chenyang.nse.bussiness.tools.login.CommonUtils;
import com.chenyang.nse.bussiness.tools.msg.MesUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping({"/core/datascopeproject"})
public class DataScopeProController {
   @Autowired
   private DataScopeService dataScopeService;
   @Autowired
   private ComplianceDirectoryService complianceDirectoryService;
   @Autowired
   private SensitiveLevelService sensitiveLevelService;
   @Autowired
   private RedisService redisService;
   @Autowired
   private OperationService operationService;
   @Autowired
   private TCoreDataProjectDao tCoreDataProjectDao;
   @Autowired
   private TProEditionScopeDao tProEditionScopeDao;
   @Autowired
   private DataSystemService dataSystemService;

   @RequestMapping
   public String index(HttpServletRequest request, HttpServletResponse response, Model model) {
      String id = request.getParameter("id");
      model.addAttribute("id", id);
      return "core/datascope/datascopeproject";
   }

   @ResponseBody
   @GetMapping({"/getdatascopeprojectlist"})
   public Response<List<TProEditionScopeVO>> getDataScopeProjectList() {
      List<TProEditionScopeVO> list = new ArrayList();

      for(TProEditionScope tProEditionScope : this.dataScopeService.getDataScopeProjectList()) {
         TProEditionScopeVO tProEditionScopeVO = new TProEditionScopeVO();
         BeanUtils.copyProperties(tProEditionScope, tProEditionScopeVO);
         String id = tProEditionScope.getId();
         String getmaxdatetid = this.dataScopeService.getmaxdatetid(id);
         if (getmaxdatetid.isEmpty()) {
            tProEditionScopeVO.setScopeFlag("1");
         } else {
            tProEditionScopeVO.setScopeFlag("0");
         }

         String getmaxdatetid1 = this.sensitiveLevelService.getmaxdatetid(id);
         if (getmaxdatetid1.isEmpty()) {
            tProEditionScopeVO.setSensitiveFlag("1");
         } else {
            tProEditionScopeVO.setSensitiveFlag("0");
         }

         String getmaxdatetid2 = this.complianceDirectoryService.getmaxdatetid(id);
         if (getmaxdatetid2.isEmpty()) {
            tProEditionScopeVO.setComplianceFlag("1");
         } else {
            tProEditionScopeVO.setComplianceFlag("0");
         }

         list.add(tProEditionScopeVO);
      }

      return RespHelper.<List<TProEditionScopeVO>>successResp(list);
   }

   @ResponseBody
   @PostMapping({"/savepeproject"})
   public Response<String> saveProject(@RequestBody EditionProjectReqVO vo, HttpServletRequest request) {
      DgDefineRule record = new DgDefineRule();
      record.setOperationUser(vo.getLoginUser().getTsysUser().getUsername());
      record.setOperationtime(new Date());
      record.setModule("分类分级版本");
      record.setFlag("1");
      boolean isRepeat = false;
      String id = vo.getEditionProjectVO().getTid();

      for(TProEditionScope edition : this.tProEditionScopeDao.queryAll(new Criterion[]{Restrictions.eq("edition_name", vo.getEditionProjectVO().getEdition_name()), Restrictions.eq("enable_type", "1")})) {
         isRepeat = true;
         if (id == null) {
            return RespHelper.<String>createResp(false, "POP_00029", MesUtil.getMsg("POP_00029", new String[0]));
         }

         if (edition.getId().equals(id)) {
            isRepeat = false;
            break;
         }
      }

      if (isRepeat) {
         return RespHelper.<String>createResp(false, "POP_00029", MesUtil.getMsg("POP_00029", new String[0]));
      } else {
         vo.getEditionProjectVO().setCreate_user(vo.getLoginUser().getTsysUser().getUsername());
         if (vo.getEditionProjectVO().getTid() == null && this.dataScopeService.isExistsByName(vo.getEditionProjectVO().getEdition_name(), vo.getEditionProjectVO().getScope_level())) {
            return RespHelper.<String>errResp(ErrCode.DATA_IS_EXIST);
         } else {
            if (vo.getEditionProjectVO().getTid() == null) {
               vo.getEditionProjectVO().setCreate_date(new Date());
               record.setLogmessage("新增分类分级版本-" + vo.getEditionProjectVO().getEdition_name());
            } else {
               record.setLogmessage("编辑分类分级版本-" + vo.getEditionProjectVO().getEdition_name());
            }

            this.dataScopeService.saveProject(vo.getEditionProjectVO());
            this.operationService.addDefineLog(record);
            return RespHelper.<String>successResp();
         }
      }
   }

   @ResponseBody
   @RequestMapping({"/haseditname"})
   public String hasEditName(EditionProjectVO project, HttpServletRequest request, HttpServletResponse response, Model model) {
      LoginUser loginUser = (LoginUser)request.getSession().getAttribute("loginUser");
      project.setCreate_user(loginUser.getTsysUser().getUsername());
      String st = this.dataScopeService.hasEditName(project);
      return st;
   }

   @ResponseBody
   @GetMapping({"/editpeproject"})
   public Response<EditionProjectVO> editpeproject(@RequestParam("editionid") String editionid) {
      EditionProjectVO pro = this.dataScopeService.editpeproject(editionid);
      return RespHelper.<EditionProjectVO>successResp(pro);
   }

   @ResponseBody
   @GetMapping({"/removepeproject"})
   public Response<String> removepeproject(@RequestParam("editionid") String editionid) {
      DgDefineRule record = new DgDefineRule();
      record.setOperationUser(CommonUtils.loginUsername());
      record.setOperationtime(new Date());
      record.setModule("分类分级版本");
      record.setFlag("1");
      List<TCoreDataProject> editionList = this.tCoreDataProjectDao.queryAll(new Criterion[]{Restrictions.eq("edition_id", editionid)});
      if (editionList != null && editionList.size() > 0) {
         return RespHelper.<String>createResp(false, "POP_00028", MesUtil.getMsg("POP_00028", new String[0]));
      } else {
         this.dataScopeService.removepeproject(editionid);
         record.setLogmessage("删除分类分级版本");
         this.operationService.addDefineLog(record);
         return RespHelper.<String>successResp();
      }
   }

   @ResponseBody
   @RequestMapping({"/querydatasystem"})
   public List<TProEditionScope> querydatasource(String type, String projectId, HttpServletRequest request, HttpServletResponse response, Model model) {
      List<TProEditionScope> list = new ArrayList();
      switch (type) {
         case "1":
            list = this.dataScopeService.geteditionlistds(projectId);
            break;
         case "3":
            list = this.sensitiveLevelService.geteditionlistds(projectId);
      }

      return list;
   }

   @ResponseBody
   @RequestMapping({"/getdefaultedition"})
   public String getdefaultedition(String setuptype, String projectId, HttpServletRequest request, HttpServletResponse response, Model model) {
      String obj = this.dataScopeService.getdefaultedition(setuptype, projectId);
      return obj;
   }

   @ResponseBody
   @RequestMapping({"/setdefaultedition"})
   public void setdefaultedition(String setuptype, String editionid, HttpServletRequest request, HttpServletResponse response, Model model) {
      this.dataScopeService.setdefaultedition(setuptype, editionid);
   }
}
