package com.chenyang.nse.bussiness.controller.core;

import com.chenyang.nse.bussiness.dao.PageInfo;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreEngineServerInfo;
import com.chenyang.nse.bussiness.entity.vo.DataGridVO;
import com.chenyang.nse.bussiness.service.core.EngineServerInfoService;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@EnableAsync
@Controller
@RequestMapping({"/core/engineserverinfo"})
public class EngineServerInfoController {
   private static Logger logger = LoggerFactory.getLogger(EngineServerInfoController.class);
   @Autowired
   private EngineServerInfoService tCoreEngineServerInfoService;
   @Autowired
   private HttpServletRequest request;

   @RequestMapping
   public String index(HttpServletRequest request, HttpServletResponse response, Model model, Integer pageCurr) {
      if (pageCurr != null) {
         model.addAttribute("toPageCurr", pageCurr);
      } else {
         model.addAttribute("toPageCurr", 1);
      }

      return "core/engineserverinfo/engineserverinfolist";
   }

   @RequestMapping({"/queryserver"})
   @ResponseBody
   public DataGridVO<TCoreEngineServerInfo> queryserver(String servername, Integer page, Integer rows, PageInfo pageInfo, HttpServletRequest request, HttpServletResponse response, Model model) {
      pageInfo.setPageno(page);
      pageInfo.setPagesize(rows);
      List<TCoreEngineServerInfo> list = this.tCoreEngineServerInfoService.queryTask(servername, pageInfo);
      DataGridVO<TCoreEngineServerInfo> vo = new DataGridVO<TCoreEngineServerInfo>(pageInfo.getCount(), list);
      return vo;
   }

   @RequestMapping({"/createServer"})
   public String createServer(@RequestParam Map<String, String> map, HttpServletResponse response, Model model) {
      return "core/engineserverinfo/createserver";
   }

   @RequestMapping({"/saveServer"})
   public String saveServer(@RequestParam Map<String, String> map, HttpServletResponse response, Model model) {
      this.tCoreEngineServerInfoService.saveEngineServer(map);
      model.addAttribute("toPageCurr", 1);
      return "core/engineserverinfo/engineserverinfolist";
   }

   @RequestMapping({"/editServer"})
   public String editServer(HttpServletRequest request, Model model, String serverid, Integer pageCurr) {
      model.addAttribute("serverid", serverid);
      model.addAttribute("pageCurr", pageCurr);
      TCoreEngineServerInfo tCoreEngineServerInfo = this.tCoreEngineServerInfoService.queryServerById(serverid);
      model.addAttribute("esinfo", tCoreEngineServerInfo);
      return "core/engineserverinfo/editserver";
   }

   @RequestMapping({"/updateServer"})
   public String updateServer(@RequestParam Map<String, String> map, HttpServletResponse response, Model model) {
      this.tCoreEngineServerInfoService.updateEngineServer(map);
      model.addAttribute("toPageCurr", 1);
      return "core/engineserverinfo/engineserverinfolist";
   }

   @RequestMapping({"/detail"})
   public String detail(HttpServletRequest request, HttpServletResponse response, Model model, String serverid, Integer pageCurr) throws SQLException {
      model.addAttribute("serverid", serverid);
      model.addAttribute("pageCurr", pageCurr);
      TCoreEngineServerInfo tCoreEngineServerInfo = this.tCoreEngineServerInfoService.queryServerById(serverid);
      model.addAttribute("esinfo", tCoreEngineServerInfo);
      return "core/engineserverinfo/detailserver";
   }

   @RequestMapping(
      value = {"/removeServer"},
      method = {RequestMethod.POST}
   )
   @ResponseBody
   public String removeServer(String serverid, HttpServletRequest request, HttpServletResponse response, Model model, Integer pageCurr) {
      if (null == pageCurr || 0 == pageCurr) {
         pageCurr = 1;
      }

      TCoreEngineServerInfo reInfo = this.tCoreEngineServerInfoService.queryServerById(serverid);
      reInfo.setDelflg("1");
      reInfo.setUpdatetime(new Date());
      this.tCoreEngineServerInfoService.updateEngineServer(reInfo);
      model.addAttribute("toPageCurr", pageCurr);
      return "core/engineserverinfo/engineserverinfolist";
   }

   @RequestMapping({"/isRepeatName"})
   @ResponseBody
   public boolean isRepeatName(String servername) {
      Boolean reFlg = false;
      if (StringUtils.isNotBlank(servername)) {
         TCoreEngineServerInfo tCoreEngineServerInfo = this.tCoreEngineServerInfoService.queryServerByName(servername);
         if (null != tCoreEngineServerInfo) {
            reFlg = true;
         }
      }

      return reFlg;
   }
}
