package com.chenyang.nse.bussiness.controller.core;

import com.chenyang.nse.bussiness.entity.cache.LoginUser;
import com.chenyang.nse.bussiness.entity.orm.table.base.TBaseUserproject;
import com.chenyang.nse.bussiness.service.core.TdataProjectService;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping({"/core/tdataclassify"})
public class TdataClassifyController {
   @Autowired
   private TdataProjectService tdataProjectService;

   @RequestMapping
   public String index(HttpServletRequest request, HttpServletResponse response, Model model) {
      String id = request.getParameter("id");
      String crud = "";
      LoginUser loginUser = (LoginUser)request.getSession().getAttribute("loginUser");
      String userid = loginUser.getTsysUser().getId();
      List<TBaseUserproject> uplist = this.tdataProjectService.queryuserprobyuseridproid(userid, id);
      String groupid = loginUser.getTsysGroup().getId();
      uplist.addAll(this.tdataProjectService.queryuserprobyuseridproid(groupid, id));

      for(int i = 0; i < uplist.size(); ++i) {
         if (crud.equals("")) {
            crud = ((TBaseUserproject)uplist.get(i)).getCrud();
         } else if (((TBaseUserproject)uplist.get(i)).getCrud() != null && !((TBaseUserproject)uplist.get(i)).getCrud().equals("") && Integer.parseInt(((TBaseUserproject)uplist.get(i)).getCrud()) > Integer.parseInt(crud)) {
            crud = ((TBaseUserproject)uplist.get(i)).getCrud();
         }
      }

      model.addAttribute("id", id);
      model.addAttribute("crud", crud);
      request.getSession().setAttribute("projectid", id);
      return "core/dataproject/tdataclassify";
   }

   @ResponseBody
   @RequestMapping({"/selectAllData"})
   public List<Map<String, Object>> selectAllData(HttpServletRequest request, HttpServletResponse response, String id, Model model) {
      LoginUser loginUser = (LoginUser)request.getSession().getAttribute("loginUser");
      String uid = loginUser.getTsysUser().getId();
      String gid = loginUser.getTsysGroup().getId();
      String userid = "";
      if (!"1".equals(uid)) {
         userid = "('" + uid + "','" + gid + "')";
      }

      List<Map<String, Object>> sourceL = this.tdataProjectService.selectSource(id, userid);
      List<Map<String, Object>> areaL = this.tdataProjectService.selectArea(id);
      List<Map<String, Object>> findL = this.tdataProjectService.selectFind(id);
      List<Map<String, Object>> maskingL = this.tdataProjectService.selectMasking(id);
      List<Map<String, Object>> dispatchL = this.tdataProjectService.selectdispatch(id);
      List<Map<String, Object>> monitorL = this.tdataProjectService.selectMonitorCount(id);
      List<Map<String, Object>> imgTaskL = this.tdataProjectService.selectImgTaskCount(id);
      List<Map<String, Object>> codatabasedata = this.tdataProjectService.selectCodatabaseDataCount(id);
      List<Map<String, Object>> selfmonitorL = this.tdataProjectService.selectSelfMonitorCount(id);
      sourceL.addAll(areaL);
      sourceL.addAll(findL);
      sourceL.addAll(maskingL);
      sourceL.addAll(dispatchL);
      sourceL.addAll(monitorL);
      sourceL.addAll(imgTaskL);
      sourceL.addAll(codatabasedata);
      sourceL.addAll(selfmonitorL);
      return sourceL;
   }
}
