package com.chenyang.nse.bussiness.dao.core;

import com.chenyang.nse.bussiness.dao.BaseDao;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.transform.Transformers;
import org.springframework.stereotype.Repository;

@Repository
public class SearchFieldDao extends BaseDao<Object, String> {
   public List<HashMap<String, String>> getScopeField(Map<String, Object> parameter) {
      String sql = "";
      String datasystemid = (String)parameter.get("datasystemid");
      String field = (String)parameter.get("field");
      String table = (String)parameter.get("table");
      String schema = (String)parameter.get("schema");
      String setuptype = (String)parameter.get("setuptype");
      String version = (String)parameter.get("version");
      String projectId = (String)parameter.get("projectId");
      if ("1".equals(setuptype)) {
         sql = "SELECT a.id as contid,b.id as roottid,b.scope_id as treeid,b.scope_name as treename,b.edition_id as editionid,c.edition_name as editionname,b.create_user as create_user, date_format(b.create_date,'%Y-%c-%d %h:%i:%s') as create_date,b.note as note FROM t_core_scope_field AS a, t_core_data_scope AS b,t_pro_edition_scope AS c WHERE 1=1 AND b.id = a.scope_id AND a.datasystem_id = '" + datasystemid + "' AND a.tschemas ='" + schema + "' AND a.names ='" + table + "' AND a.tablefield_id ='" + field + "'AND a.edition_id = c.id AND a.edition_id in (select id from t_pro_edition_scope as d where d.enable_type ='1') AND a.projectid = '" + projectId + "' order by b.create_date";
      } else if ("2".equals(setuptype)) {
         sql = "SELECT a.id as contid,b.id as roottid,b.directory_id as treeid,b.directory_name as treename,b.create_user,date_format(b.create_date,'%Y-%c-%d %h:%i:%s') as create_date,b.note  FROM t_core_field_directory AS a, t_core_compliance_directory AS b WHERE 1=1 AND b.id = a.scope_id AND a.datasystem_id = '" + datasystemid + "' AND a.tschemas ='" + schema + "' AND a.names ='" + table + "' AND a.tablefield_id ='" + field + "' AND a.projectid = '" + projectId + "' order by b.create_date";
      } else if ("3".equals(setuptype)) {
         sql = "SELECT a.id as contid,b.id as roottid,b.sensitive_id as treeid,b.sensitive_name as treename,b.edition_id as editionid,c.edition_name as editionname,b.create_user as create_user,date_format(b.create_date,'%Y-%c-%d %h:%i:%s') as create_date,b.note  FROM t_core_field_sensitive AS a, t_core_sensitive_level AS b,t_pro_edition_scope AS c WHERE 1=1 AND b.id = a.scope_id AND a.datasystem_id = '" + datasystemid + "' AND a.tschemas ='" + schema + "' AND a.names ='" + table + "' AND a.tablefield_id ='" + field + "'AND a.edition_id = c.id AND a.edition_id in (select id from t_pro_edition_scope as d where d.enable_type ='1') AND a.projectid = '" + projectId + "' order by b.create_date";
      }

      List<HashMap<String, String>> list = this.getSession().createNativeQuery(sql).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP).getResultList();
      return list;
   }

   public List<HashMap<String, String>> isSureColumnUnion(String datasystem_id, String schema, String table, String projectId) {
      String sql = "";
      sql = "SELECT tablefield_id FROM t_core_scope_field a where a.datasystem_id = '" + datasystem_id + "' AND a.tschemas = '" + schema + "' AND a.names = '" + table + "' AND a.projectid = '" + projectId + "'";
      sql = sql + "UNION SELECT tablefield_id  FROM t_core_field_directory b where b.datasystem_id = '" + datasystem_id + "' AND b.tschemas = '" + schema + "' AND b.names = '" + table + "' AND b.projectid = '" + projectId + "'";
      sql = sql + "UNION SELECT tablefield_id FROM t_core_field_sensitive c where c.datasystem_id = '" + datasystem_id + "' AND c.tschemas = '" + schema + "' AND c.names = '" + table + "' AND c.projectid = '" + projectId + "'";
      List<HashMap<String, String>> list = this.getSession().createNativeQuery(sql).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP).getResultList();
      return list;
   }
}
