package com.chenyang.nse.bussiness.dao.table.base;

import com.chenyang.nse.bussiness.config.HibernateConfig;
import com.chenyang.nse.bussiness.dao.BaseDao;
import com.chenyang.nse.bussiness.entity.orm.table.base.TBaseRole;
import java.util.List;
import org.hibernate.transform.Transformers;
import org.springframework.stereotype.Repository;

@Repository
public class TBaseRoleDao extends BaseDao<TBaseRole, String> {
   public List<TBaseRole> queryRolesByUserId(String userId) {
      String sql = "select u.id as id,u.rolename from t_base_role u inner join t_base_userrole r on u.id = r.roleid where r.userid = :userId order by u.createtime desc ";
      if (HibernateConfig.PEIZHIKUDBTYPE.equals("3")) {
         sql = "select u.id as \"id\",u.rolename as \"rolename\" from t_base_role u inner join t_base_userrole r on u.id = r.roleid where r.userid = :userId order by u.createtime desc ";
      }

      return this.getSession().createNativeQuery(sql).setParameter("userId", userId).setResultTransformer(Transformers.aliasToBean(TBaseRole.class)).getResultList();
   }
}
