package com.chenyang.nse.bussiness.dao.table.core;

import com.chenyang.nse.bussiness.dao.BaseDao;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreDataFileGroup;
import com.chenyang.nse.bussiness.entity.vo.ComboboxVO;
import com.chenyang.nse.bussiness.entity.vo.dataproject.TCoreDataFileGroupVO;
import java.util.List;
import java.util.Map;
import org.hibernate.transform.Transformers;
import org.springframework.stereotype.Repository;

@Repository
public class TCoreDataFileGroupDao extends BaseDao<TCoreDataFileGroup, String> {
   public List<ComboboxVO> queryDatafileList(String id) {
      String sql = "";
      if (null != id && !"".equals(id)) {
         sql = "select a.id value,a.dataarea text,b.flag FROM t_core_dataarea a left JOIN T_CORE_DATAFILE_GROUP b on b.datafilename=a.dataarea and b.searchregexid='" + id + "'GROUP BY a.dataarea";
      } else {
         sql = "select a.id value,a.dataarea text,'1' flag FROM t_core_dataarea a left JOIN T_CORE_DATAFILE_GROUP b on b.datafilename=a.dataarea GROUP BY a.dataarea";
      }

      List<ComboboxVO> list = this.getSession().createNativeQuery(sql).setResultTransformer(Transformers.aliasToBean(ComboboxVO.class)).getResultList();
      return list;
   }

   public void removeBySeachid(String id) {
      String sql = "delete FROM T_CORE_DATAFILE_GROUP  where searchregexid='" + id + "'";
      this.getSession().createNativeQuery(sql).executeUpdate();
   }

   public List<Map<String, String>> queryDataFileGroupList(String searchregexid, String projectid) {
      String sql = "select c.flag,c.datafileid,c.datafilename,c.searchregexid,d.name as rulename from (";
      sql = sql + " select a.*,b.rule_id";
      sql = sql + " from t_core_datafile_group a";
      sql = sql + " left join t_core_project_findrule b";
      sql = sql + " on a.datafileid=b.dataarea_id";
      sql = sql + " and b.rulestyle=0";
      sql = sql + " and b.defaultrule=1";
      sql = sql + ") as c";
      sql = sql + " left join t_console_searchregex d";
      sql = sql + " on c.rule_id=d.id";
      sql = sql + " where c.searchregexid='" + searchregexid + "'";
      List<Map<String, String>> list = this.getSession().createNativeQuery(sql).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP).getResultList();
      return list;
   }

   public List<TCoreDataFileGroupVO> queryMutexDataarea(String dataareaid) {
      String sql = "select a.* ,b.type as dataarea,b.dataarea_id from t_core_datafile_group a";
      sql = sql + " left join t_console_searchregex b";
      sql = sql + " on a.searchregexid=b.id";
      sql = sql + " where a.datafileid='" + dataareaid + "'";
      List<TCoreDataFileGroupVO> list = this.getSession().createNativeQuery(sql).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP).getResultList();
      return list;
   }

   public List<TCoreDataFileGroupVO> queryMutexDataareaByrule(String dataareaid, String rulename) {
      String sql = "select a.* ,b.type as dataarea,b.dataarea_id from t_core_datafile_group a";
      sql = sql + " left join t_console_searchregex b";
      sql = sql + " on a.searchregexid=b.id";
      sql = sql + " where b.dataarea_id='" + dataareaid + "'";
      sql = sql + " and b.name='" + rulename + "'";
      List<TCoreDataFileGroupVO> list = this.getSession().createNativeQuery(sql).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP).getResultList();
      return list;
   }
}
