package com.chenyang.nse.bussiness.dao.table.core;

import com.chenyang.nse.bussiness.config.HibernateConfig;
import com.chenyang.nse.bussiness.dao.BaseDao;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreDatasystemoracle;
import java.util.List;
import org.hibernate.transform.Transformers;
import org.springframework.stereotype.Repository;

@Repository
public class TCoreDatasystemoracleDao extends BaseDao<TCoreDatasystemoracle, String> {
   public List<TCoreDatasystemoracle> queryInsByDatasnystemId(String datasystemid) {
      String sql = "select u.id,u.datasystemid,u.insname,u.insip,u.insport  from t_core_datasystemoracle u where u.datasystemid = :datasystemid order by u.createtime desc ";
      if (HibernateConfig.PEIZHIKUDBTYPE.equals("3")) {
         sql = "select u.id as \"id\",u.datasystemid as \"datasystemid\",u.insname as \"insname\",u.insip as \"insip\",u.insport as \"insport\" from t_core_datasystemoracle u where u.datasystemid = :datasystemid order by u.createtime desc ";
      }

      return this.getSession().createNativeQuery(sql).setParameter("datasystemid", datasystemid).setResultTransformer(Transformers.aliasToBean(TCoreDatasystemoracle.class)).getResultList();
   }
}
