package com.chenyang.nse.bussiness.dao.table.core.dataproject;

import com.chenyang.nse.bussiness.config.HibernateConfig;
import com.chenyang.nse.bussiness.config.PropertiesLoaderUtils;
import com.chenyang.nse.bussiness.dao.BaseDao;
import com.chenyang.nse.bussiness.dao.PageInfo;
import com.chenyang.nse.bussiness.engine.infa.powercenter961.pubtool.StringUtil;
import com.chenyang.nse.bussiness.entity.orm.table.core.dataproject.TCoreDiscoverySysdata;
import com.chenyang.nse.bussiness.entity.orm.table.core.dataproject.TCoreProjectAllrule;
import com.chenyang.nse.bussiness.entity.orm.table.core.discovery.TcoreDiscoveryResult;
import com.chenyang.nse.bussiness.entity.vo.DiscoveryResultVO;
import com.chenyang.nse.bussiness.tools.DataSourceTools;
import java.io.IOException;
import java.math.BigInteger;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.transform.Transformers;
import org.springframework.stereotype.Repository;

@Repository
public class TdataDiscoveryResultDao extends BaseDao<TcoreDiscoveryResult, String> {
   public void makeDiscoverResultSureAll(DiscoveryResultVO obj) {
      String sql = "";
      if (!"1".equals(obj.getIssensitive())) {
         if (!"2".equals(obj.getChecksure()) && !"".equals(obj.getChecksure())) {
            sql = "update " + obj.getTablename() + " set issure ='" + obj.getIssure() + "' where (tschemas like '%" + obj.getNschema() + "%' or ttables like '%" + obj.getNtable() + "%') and tfields like '%" + obj.getNfield() + "%' and issure ='" + obj.getChecksure() + "'";
         } else {
            sql = "update " + obj.getTablename() + " set issure ='" + obj.getIssure() + "' where (tschemas like '%" + obj.getNschema() + "%' or ttables like '%" + obj.getNtable() + "%') and tfields like '%" + obj.getNfield() + "%' ";
         }
      } else if (!"2".equals(obj.getChecksure()) && !"".equals(obj.getChecksure())) {
         sql = "update " + obj.getTablename() + " set issure ='" + obj.getIssure() + "' where (tschemas like '%" + obj.getNschema() + "%' or ttables like '%" + obj.getNtable() + "%') and tfields like '%" + obj.getNfield() + "%'  and dataarea_id <> ''  and issure ='" + obj.getChecksure() + "'";
      } else {
         sql = "update " + obj.getTablename() + " set issure ='" + obj.getIssure() + "' where (tschemas like '%" + obj.getNschema() + "%' or ttables like '%" + obj.getNtable() + "%') and tfields like '%" + obj.getNfield() + "%'  and dataarea_id <> '' ";
      }

      this.getSession().createNativeQuery(sql).executeUpdate();
   }

   public void makeDiscoverResultSure(DiscoveryResultVO obj, String id) {
      String sql = "update " + obj.getTablename() + " set issure ='" + obj.getIssure() + "' where id = '" + id + "'";
      this.getSession().createNativeQuery(sql).executeUpdate();
   }

   public void discoverChangeRuleAll(DiscoveryResultVO obj) {
      if (obj.getNareaid() == null) {
         obj.setNareaid("");
      }

      if (obj.getNareaname() == null) {
         obj.setNareaname("");
      }

      if (obj.getNtruleid() == null) {
         obj.setNtruleid("");
      }

      if (obj.getNtrulename() == null) {
         obj.setNtrulename("");
      }

      String sql = "";
      if (!"1".equals(obj.getIssensitive())) {
         if (!"2".equals(obj.getChecksure()) && !"".equals(obj.getChecksure())) {
            sql = "update " + obj.getTablename() + " set dataarea_id ='" + obj.getNareaid() + "',dataarea_name = '" + obj.getNareaname() + "',sensitive_id = '" + obj.getNtruleid() + "',sensitive_name ='" + obj.getNtrulename() + "',correlation='' where (tschemas like '%" + obj.getNschema() + "%' or ttables like '%" + obj.getNtable() + "%') and tfields like '%" + obj.getNfield() + "%' and issure ='" + obj.getChecksure() + "'";
         } else {
            sql = "update " + obj.getTablename() + " set dataarea_id ='" + obj.getNareaid() + "',dataarea_name = '" + obj.getNareaname() + "',sensitive_id = '" + obj.getNtruleid() + "',sensitive_name ='" + obj.getNtrulename() + "',correlation='' where (tschemas like '%" + obj.getNschema() + "%' or ttables like '%" + obj.getNtable() + "%') and tfields like '%" + obj.getNfield() + "%'";
         }
      } else if (!"2".equals(obj.getChecksure()) && !"".equals(obj.getChecksure())) {
         sql = "update " + obj.getTablename() + " set  dataarea_id ='" + obj.getNareaid() + "',dataarea_name = '" + obj.getNareaname() + "',sensitive_id = '" + obj.getNtruleid() + "',sensitive_name ='" + obj.getNtrulename() + "',correlation='' where (tschemas like '%" + obj.getNschema() + "%' or ttables like '%" + obj.getNtable() + "%') and tfields like '%" + obj.getNfield() + "%' and issure ='" + obj.getChecksure() + "' and dataarea_id <> ''";
      } else {
         sql = "update " + obj.getTablename() + " set  dataarea_id ='" + obj.getNareaid() + "',dataarea_name = '" + obj.getNareaname() + "',sensitive_id = '" + obj.getNtruleid() + "',sensitive_name ='" + obj.getNtrulename() + "',correlation='' where (tschemas like '%" + obj.getNschema() + "%' or ttables like '%" + obj.getNtable() + "%') and tfields like '%" + obj.getNfield() + "%' and dataarea_id <> ''";
      }

      this.getSession().createNativeQuery(sql).executeUpdate();
   }

   public void discoverChangeRule(DiscoveryResultVO obj, String id) {
      if (obj.getNareaid() == null) {
         obj.setNareaid("");
      }

      if (obj.getNareaname() == null) {
         obj.setNareaname("");
      }

      if (obj.getNtruleid() == null) {
         obj.setNtruleid("");
      }

      if (obj.getNtrulename() == null) {
         obj.setNtrulename("");
      }

      String sql = "update " + obj.getTablename() + " set dataarea_id ='" + obj.getNareaid() + "',dataarea_name = '" + obj.getNareaname() + "',sensitive_id = '" + obj.getNtruleid() + "',sensitive_name ='" + obj.getNtrulename() + "',correlation='' where id = '" + id + "'";
      this.getSession().createNativeQuery(sql).executeUpdate();
   }

   public List<TCoreProjectAllrule> selectDataAreaHas(String project_id) {
      String sql = "";
      if (HibernateConfig.PEIZHIKUDBTYPE.equals("0")) {
         sql = "SELECT a.dataarea_id dataarea_id, b.dataarea dataareaname FROM t_core_project_findrule a,t_core_dataarea b WHERE  a.project_id = '" + project_id + "' and b.areatype = '0' and a.dataarea_id = b.id group by a.dataarea_id";
      } else if (HibernateConfig.PEIZHIKUDBTYPE.equals("1")) {
         sql = "SELECT a.dataarea_id dataarea_id, b.dataarea dataareaname FROM t_core_project_findrule a,t_core_dataarea b WHERE  a.project_id = '" + project_id + "' and b.areatype = '0' and a.dataarea_id = b.id group by a.dataarea_id, b.dataarea";
      } else if (HibernateConfig.PEIZHIKUDBTYPE.equals("2")) {
         sql = "SELECT a.dataarea_id dataarea_id, b.dataarea dataareaname FROM t_core_project_findrule a,t_core_dataarea b WHERE  a.project_id = '" + project_id + "' and b.areatype = '0' and a.dataarea_id = b.id group by a.dataarea_id, b.dataarea";
      } else if (HibernateConfig.PEIZHIKUDBTYPE.equals("3")) {
         sql = "SELECT a.dataarea_id as \"dataarea_id\", b.dataarea as  \"dataareaname\" FROM t_core_project_findrule a,t_core_dataarea b WHERE  a.project_id = '" + project_id + "' and b.areatype = '0' and a.dataarea_id = b.id group by a.dataarea_id, b.dataarea";
      }

      List<TCoreProjectAllrule> vo = this.getSession().createNativeQuery(sql).setResultTransformer(Transformers.aliasToBean(TCoreProjectAllrule.class)).getResultList();
      return vo;
   }

   public List<TCoreProjectAllrule> selectDataAreaHas(String project_id, String dataarea_id) {
      String sql = "SELECT a.dataarea_id dataarea_id, b.dataarea dataareaname,a.rule_id  rule_id FROM t_core_project_findrule a,t_core_dataarea b WHERE  a.project_id = '" + project_id + "' and a.dataarea_id = '" + dataarea_id + "' and a.dataarea_id = b.id ";
      if (HibernateConfig.PEIZHIKUDBTYPE.equals("3")) {
         sql = "SELECT a.dataarea_id as \"dataarea_id\", b.dataarea as \"dataareaname\",a.rule_id as \"rule_id\" FROM t_core_project_findrule a,t_core_dataarea b WHERE  a.project_id = '" + project_id + "' and a.dataarea_id = '" + dataarea_id + "' and a.dataarea_id = b.id ";
      }

      List<TCoreProjectAllrule> vo = this.getSession().createNativeQuery(sql).setResultTransformer(Transformers.aliasToBean(TCoreProjectAllrule.class)).getResultList();
      return vo;
   }

   public List<TCoreProjectAllrule> selectDataAreaFindRule(String project_id, String dataarea_id) {
      String sql = "SELECT a.rule_id rule_id, b.name rulename,a.defaultrule isdefault FROM t_core_project_findrule a,t_core_masking_ruleinfo b WHERE  a.project_id = '" + project_id + "' and a.dataarea_id = '" + dataarea_id + "' and a.rule_id = b.id ";
      List<TCoreProjectAllrule> vo = this.getSession().createNativeQuery(sql).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP).getResultList();
      return vo;
   }

   public List<TCoreProjectAllrule> queryMaskingRuleInfo(String ruleName) {
      String sql = "";
      if (HibernateConfig.PEIZHIKUDBTYPE.equals("0")) {
         sql = "select a.dataarea as dataareaname, b.dataarea_id, b.id as rule_id from t_core_dataarea a, t_core_masking_ruleinfo b where b.`name` = '" + ruleName + "' and a.id = b.dataarea_id";
      } else if (HibernateConfig.PEIZHIKUDBTYPE.equals("1")) {
         sql = "select a.dataarea as dataareaname, b.dataarea_id, b.id as rule_id from t_core_dataarea a, t_core_masking_ruleinfo b where b.\"name\" = '" + ruleName + "' and a.id = b.dataarea_id";
      } else if (HibernateConfig.PEIZHIKUDBTYPE.equals("2")) {
         sql = "select a.dataarea as dataareaname, b.dataarea_id, b.id as rule_id from t_core_dataarea a, t_core_masking_ruleinfo b where b.name = '" + ruleName + "' and a.id = b.dataarea_id";
      } else if (HibernateConfig.PEIZHIKUDBTYPE.equals("3")) {
         sql = "select a.dataarea as \"dataareaname\", b.dataarea_id as \"dataarea_id\", b.id as \"rule_id\" from t_core_dataarea a, t_core_masking_ruleinfo b where b.name = '" + ruleName + "' and a.id = b.dataarea_id";
      }

      sql = DataSourceTools.dealSqlFormat(sql);
      List<TCoreProjectAllrule> vo = this.getSession().createNativeQuery(sql).setResultTransformer(Transformers.aliasToBean(TCoreProjectAllrule.class)).getResultList();
      return vo;
   }

   public List<TCoreDiscoverySysdata> discoverResultTable(DiscoveryResultVO obj) {
      String schema = obj.getNschema();
      String tablename = obj.getNtable();
      String fieldname = obj.getNfield();
      if (StringUtil.isBlank(schema)) {
         schema = "%%";
      }

      if (StringUtil.isBlank(tablename)) {
         tablename = "%%";
      }

      if (StringUtil.isBlank(fieldname)) {
         fieldname = "%%";
      }

      String sql = "";
      if (!"1".equals(obj.getIssensitive())) {
         if (!"2".equals(obj.getChecksure()) && !"".equals(obj.getChecksure())) {
            sql = "select tdatasystem_id,tschemas,ttables from " + obj.getTablename() + "  where (tschemas like '" + schema + "') and tfields like '" + fieldname + "'  and issure ='" + obj.getChecksure() + "' group by tdatasystem_id,tschemas,ttables";
            if (HibernateConfig.PEIZHIKUDBTYPE.equals("3")) {
               sql = "select tdatasystem_id as \"tdatasystem_id\",tschemas as \"tschemas\",ttables as \"ttables\" from " + obj.getTablename() + "  where (tschemas like '" + schema + "') and tfields like '" + fieldname + "'  and issure ='" + obj.getChecksure() + "' group by tdatasystem_id,tschemas,ttables";
            }
         } else {
            sql = "select tdatasystem_id,tschemas,ttables from " + obj.getTablename() + "  where (tschemas like '" + schema + "') and tfields like '" + fieldname + "'  group by tdatasystem_id,tschemas,ttables";
            if (HibernateConfig.PEIZHIKUDBTYPE.equals("3")) {
               sql = "select tdatasystem_id as \"tdatasystem_id\",tschemas as \"tschemas\",ttables as \"ttables\" from " + obj.getTablename() + "  where (tschemas like '" + schema + "') and tfields like '" + fieldname + "'  group by tdatasystem_id,tschemas,ttables";
            }
         }
      } else if (!"2".equals(obj.getChecksure()) && !"".equals(obj.getChecksure())) {
         sql = "select tdatasystem_id,tschemas,ttables from " + obj.getTablename() + "  where (tschemas like '" + schema + "') and tfields like '" + fieldname + "' and issure ='" + obj.getChecksure() + "' and dataarea_id <> '' group by tdatasystem_id,tschemas,ttables";
         if (HibernateConfig.PEIZHIKUDBTYPE.equals("3")) {
            sql = "select tdatasystem_id as \"tdatasystem_id\",tschemas as \"tschemas\",ttables as \"ttables\" from " + obj.getTablename() + "  where (tschemas like '" + schema + "') and tfields like '" + fieldname + "' and issure ='" + obj.getChecksure() + "' and dataarea_id <> '' group by tdatasystem_id,tschemas,ttables";
         }
      } else {
         sql = "select tdatasystem_id,tschemas,ttables from " + obj.getTablename() + "  where (tschemas like '" + schema + "') and tfields like '" + fieldname + "'  and dataarea_id <> '' group by tdatasystem_id,tschemas,ttables";
         if (HibernateConfig.PEIZHIKUDBTYPE.equals("3")) {
            sql = "select tdatasystem_id as \"tdatasystem_id\",tschemas as \"tschemas\",ttables as \"ttables\" from " + obj.getTablename() + "  where (tschemas like '" + schema + "') and tfields like '" + fieldname + "'  and dataarea_id <> '' group by tdatasystem_id,tschemas,ttables";
         }
      }

      return this.getSession().createNativeQuery(sql).setResultTransformer(Transformers.aliasToBean(TCoreDiscoverySysdata.class)).getResultList();
   }

   public int clearTable() {
      String sql = "truncate table t_core_discovery_sysdata ";
      int i = this.getSession().createNativeQuery(sql).executeUpdate();
      return i;
   }

   public List<TcoreDiscoveryResult> getPageDataResult(String tablename, String tschemas, String ttables, String nfield) {
      if (StringUtil.isBlank(nfield)) {
         nfield = "%%";
      }

      String sql = "select id id,tdatasystem_id,tschemas,ttables,tfields,tfieldremark,tsampling,teffe_sampling,tmatching,dataarea_id,dataarea_name,sensitive_id,sensitive_name,issure,correlation from " + tablename + "  where tschemas = '" + tschemas + "' and ttables = '" + ttables + "' and tfields like '" + nfield + "' order by tschemas,ttables";
      if (HibernateConfig.PEIZHIKUDBTYPE.equals("2")) {
         Properties props = new Properties();

         try {
            props = PropertiesLoaderUtils.loadAllProperties("config.properties");
         } catch (IOException e) {
            e.printStackTrace();
         }

         String dmschema = props.getProperty("dmschema");
         sql = "select id id,tdatasystem_id,tschemas,ttables,tfields,tfieldremark,tsampling,teffe_sampling,tmatching,dataarea_id,dataarea_name,sensitive_id,sensitive_name,issure,correlation from " + dmschema + "." + tablename + "  where tschemas = '" + tschemas + "' and ttables = '" + ttables + "' and tfields like '" + nfield + "' order by tschemas,ttables";
      }

      if (HibernateConfig.PEIZHIKUDBTYPE.equals("3")) {
         sql = "select id as \"id\",tdatasystem_id as \"tdatasystem_id\",tschemas as \"tschemas\",ttables as \"ttables\",tfields as \"tfields\",tfieldremark as \"tfieldremark\",tsampling as \"tsampling\",teffe_sampling as \"teffe_sampling\",tmatching as \"tmatching\",dataarea_id as \"dataarea_id\",dataarea_name as \"dataarea_name\",sensitive_id as \"sensitive_id\",sensitive_name as \"sensitive_name\",issure as \"issure\",correlation as \"correlation\" from " + tablename + "  where tschemas = '" + tschemas + "' and ttables = '" + ttables + "' and tfields like '" + nfield + "' order by tschemas,ttables";
      }

      return this.getSession().createNativeQuery(sql).setResultTransformer(Transformers.aliasToBean(TcoreDiscoveryResult.class)).getResultList();
   }

   public List<TcoreDiscoveryResult> getPageDataResultfile(PageInfo pageinfo, String dataArea1, String tablename, String ttables, String tfields, String structStr1, String checksure, String issensitive) {
      String sql1 = "select count(*) from " + tablename + "  where 1=1";
      String sql = "select filecontent,id id,tdatasystem_id,tschemas,ttables,tfields,tfieldremark,tsampling,teffe_sampling,tmatching,dataarea_id,dataarea_name,sensitive_id,sensitive_name,issure,filestruct from " + tablename + "  where 1=1";
      if (ttables != null && !"".equals(ttables)) {
         sql = sql + " and ttables like '%" + ttables + "%'";
         sql1 = sql1 + " and ttables like '%" + ttables + "%'";
      }

      if (tfields != null && !"".equals(tfields)) {
         sql = sql + " and tfields like '%" + tfields + "%'";
         sql1 = sql1 + " and tfields like '%" + tfields + "%'";
      }

      if (!"-1".equals(structStr1)) {
         sql = sql + " and filestruct = '" + structStr1 + "'";
         sql1 = sql1 + " and filestruct = '" + structStr1 + "'";
      }

      if (!"2".equals(checksure) && !"".equals(checksure)) {
         if ("0".equals(checksure)) {
            sql = sql + " and issure = '0'";
            sql1 = sql1 + " and issure = '0'";
         } else {
            sql = sql + " and issure != '0'";
            sql1 = sql1 + " and issure != '0'";
         }
      }

      if (!"0".equals(issensitive)) {
         sql = sql + " and dataarea_name != ''";
         sql1 = sql1 + " and dataarea_name != ''";
      }

      if (!"".equals(dataArea1) && dataArea1 != null) {
         sql = sql + " and dataarea_name like '%" + dataArea1 + "%'";
         sql1 = sql1 + " and dataarea_name like '%" + dataArea1 + "%'";
      }

      sql = sql + " order by ttables,tfields";
      long count = (long)((BigInteger)this.getSession().createNativeQuery(sql1).getSingleResult()).intValue();
      pageinfo.setCount(count);
      return this.getSession().createNativeQuery(sql).setFirstResult(pageinfo.getOffset()).setMaxResults(pageinfo.getPagesize()).setResultTransformer(Transformers.aliasToBean(TcoreDiscoveryResult.class)).getResultList();
   }

   public String getFileContent(String id, String tablename) {
      String sql = "select filecontent from " + tablename + "  where id='" + id + "'";
      String content = ((String)this.getSession().createNativeQuery(sql).getSingleResult()).toString();
      return content;
   }

   public void discoverDeleRuleAll(DiscoveryResultVO obj) {
      String sql = "";
      if (!"1".equals(obj.getIssensitive())) {
         if (!"2".equals(obj.getChecksure()) && !"".equals(obj.getChecksure())) {
            sql = "update " + obj.getTablename() + " set dataarea_id ='',dataarea_name = '',sensitive_id = '',sensitive_name ='',correlation='' where (tschemas like '%" + obj.getNschema() + "%' or ttables like '%" + obj.getNtable() + "%') and tfields like '%" + obj.getNfield() + "%' and issure ='" + obj.getChecksure() + "'";
         } else {
            sql = "update " + obj.getTablename() + " set dataarea_id ='',dataarea_name = '',sensitive_id = '',sensitive_name ='',correlation='' where (tschemas like '%" + obj.getNschema() + "%' or ttables like '%" + obj.getNtable() + "%') and tfields like '%" + obj.getNfield() + "%'";
         }
      } else if (!"2".equals(obj.getChecksure()) && !"".equals(obj.getChecksure())) {
         sql = "update " + obj.getTablename() + " set  dataarea_id ='',dataarea_name = '',sensitive_id = '',sensitive_name ='',correlation='' where (tschemas like '%" + obj.getNschema() + "%' or ttables like '%" + obj.getNtable() + "%') and tfields like '%" + obj.getNfield() + "%' and issure ='" + obj.getChecksure() + "' and dataarea_id <> '' ";
      } else {
         sql = "update " + obj.getTablename() + " set  dataarea_id ='',dataarea_name = '',sensitive_id = '',sensitive_name ='',correlation='' where (tschemas like '%" + obj.getNschema() + "%' or ttables like '%" + obj.getNtable() + "%') and tfields like '%" + obj.getNfield() + "%' and dataarea_id <> '' ";
      }

      this.getSession().createNativeQuery(sql).executeUpdate();
   }

   public void discoverDeleRule(DiscoveryResultVO obj, String id) {
      String sql = "update " + obj.getTablename() + " set dataarea_id ='',dataarea_name = '',sensitive_id = '',sensitive_name ='',correlation='' where id = '" + id + "'";
      this.getSession().createNativeQuery(sql).executeUpdate();
   }

   public List<TcoreDiscoveryResult> selectAll(DiscoveryResultVO obj) {
      String sql = "select id as id ,tdatasystem_id,tschemas,ttables,tfields,tsampling,teffe_sampling,tmatching,dataarea_id,dataarea_name,sensitive_id,sensitive_name,issure from " + obj.getTablename() + " order by ttables ASC";
      return this.getSession().createNativeQuery(sql).setResultTransformer(Transformers.aliasToBean(TcoreDiscoveryResult.class)).getResultList();
   }

   public List<TcoreDiscoveryResult> selectApiDiscoveryResultList(DiscoveryResultVO vo) {
      String sql = "select tschemas,ttables,tfields,tsampling,teffe_sampling,tmatching,dataarea_name,sensitive_name,issure from " + vo.getTablename() + " where 1=1 ";
      StringBuffer conditionSql = new StringBuffer();
      if (StringUtils.isNotBlank(vo.getNschema())) {
         conditionSql.append(" and tschemas = '" + vo.getNschema() + "'");
         if (StringUtils.isNotBlank(vo.getNtable())) {
            conditionSql.append(" and ttables = '" + vo.getNtable() + "'");
         }
      }

      sql = sql + conditionSql;
      return this.getSession().createNativeQuery(sql).setResultTransformer(Transformers.aliasToBean(TcoreDiscoveryResult.class)).getResultList();
   }

   public List<TcoreDiscoveryResult> getResultTableInfo(DiscoveryResultVO obj) {
      String sql = "select tdatasystem_id,tschemas,ttables from " + obj.getTablename() + " group by tdatasystem_id,tschemas,ttables";
      return this.getSession().createNativeQuery(sql).setResultTransformer(Transformers.aliasToBean(TcoreDiscoveryResult.class)).getResultList();
   }

   public List<TcoreDiscoveryResult> selectResult(DiscoveryResultVO obj) {
      String sql = "select id as id ,tdatasystem_id,tschemas,ttables,tfields,tsampling,teffe_sampling,tmatching,dataarea_id,dataarea_name,sensitive_id,sensitive_name,issure from " + obj.getTablename() + " where issure <>'0'";
      if (HibernateConfig.PEIZHIKUDBTYPE.equals("3")) {
         sql = "select id as \"id\" ,tdatasystem_id as \"tdatasystem_id\",tschemas as \"tschemas\",ttables as \"ttables\",tfields as \"tfields\",tsampling as \"tsampling\",teffe_sampling as \"teffe_sampling\",tmatching as \"tmatching\",dataarea_id as \"dataarea_id\",dataarea_name as \"dataarea_name\",sensitive_id as \"sensitive_id\",sensitive_name as \"sensitive_name\",issure as \"issure\" from " + obj.getTablename() + " where issure <>'0'";
      }

      if (StringUtils.isNotBlank(obj.getNschema())) {
         sql = sql + " and tschemas='" + obj.getNschema() + "'";
      }

      if (StringUtils.isNotBlank(obj.getNtable())) {
         sql = sql + " and ttables='" + obj.getNtable() + "'";
      }

      return this.getSession().createNativeQuery(sql).setResultTransformer(Transformers.aliasToBean(TcoreDiscoveryResult.class)).getResultList();
   }

   public void savetCoreAssignmentField(StringBuilder sql) {
      this.getSession().createNativeQuery(sql.toString()).executeUpdate();
   }

   public int clearRealTable(DiscoveryResultVO obj) {
      String sql = "truncate table " + obj.getTablename();
      int i = this.getSession().createNativeQuery(sql).executeUpdate();
      return i;
   }

   public int resetResultRun(String sql) {
      return this.getSession().createNativeQuery(sql).executeUpdate();
   }

   public int clearTable(String tablename) {
      String sql = "truncate table " + tablename;
      return this.getSession().createNativeQuery(sql).executeUpdate();
   }

   public int deleteTable(String tablename) {
      String sql = "drop table " + tablename;
      return this.getSession().createNativeQuery(sql).executeUpdate();
   }
}
