package com.chenyang.nse.bussiness.dao.table.core.masking;

import com.chenyang.nse.bussiness.dao.BaseDao;
import com.chenyang.nse.bussiness.dao.PageInfo;
import com.chenyang.nse.bussiness.entity.orm.table.core.masking.TCoreMaskingRule;
import com.chenyang.nse.bussiness.entity.vo.dataproject.TCoreSensitiveregexVO;
import com.chenyang.nse.bussiness.tools.xml.XmlTool;
import java.math.BigInteger;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.hibernate.transform.Transformers;
import org.springframework.stereotype.Repository;

@Repository
public class TCoreMaskingRuleDao extends BaseDao<TCoreMaskingRule, String> {
   public List<TCoreMaskingRule> queryRuleByTaskidForDB(String taskid, String datadirection) {
      String sql = XmlTool.getSql("maskingtask", "queryRuleByTaskidForDB");
      List<TCoreMaskingRule> list = this.getSession().createNativeQuery(sql).setParameter("taskid", taskid).setParameter("datadirection", datadirection).setResultTransformer(Transformers.aliasToBean(TCoreMaskingRule.class)).getResultList();
      return list;
   }

   public List<TCoreMaskingRule> queryRuleByTaskidForFS(String taskid, String datadirection) {
      String sql = XmlTool.getSql("maskingtask", "queryRuleByTaskidForFS");
      List<TCoreMaskingRule> list = this.getSession().createNativeQuery(sql).setParameter("taskid", taskid).setParameter("datadirection", datadirection).setResultTransformer(Transformers.aliasToBean(TCoreMaskingRule.class)).getResultList();
      return list;
   }

   public List<String> queryRuleGroup() {
      String hql = "select distinct t.rulegroupname from TCoreMaskingRule t";
      List<String> rulegroup = this.getSession().createQuery(hql).getResultList();
      return rulegroup;
   }

   public List<TCoreMaskingRule> queryRuleByGroupName(String groupname) {
      List<TCoreMaskingRule> list = this.queryAll(new Criterion[]{Restrictions.eq("rulegroupname", groupname)});
      return list;
   }

   public List<TCoreSensitiveregexVO> querySensitiveregexList(String dataarea, String rulename, PageInfo pageInfo) {
      String sqls = XmlTool.getSql("dataarea", "queryAllSensitiveregexCount");
      BigInteger i = (BigInteger)this.getSession().createNativeQuery(sqls).setParameter("dataarea", "%" + dataarea + "%").setParameter("rulename", "%" + rulename + "%").uniqueResult();
      pageInfo.setCount(i.longValue());
      String sql = XmlTool.getSql("dataarea", "querySensitiveregexList");
      return this.getSession().getSession().createNativeQuery(sql).setParameter("dataarea", "%" + dataarea + "%").setParameter("rulename", "%" + rulename + "%").setFirstResult(pageInfo.getOffset()).setMaxResults(pageInfo.getPagesize()).setResultTransformer(Transformers.aliasToBean(TCoreSensitiveregexVO.class)).getResultList();
   }

   public List<TCoreSensitiveregexVO> querySensitiveregexList(String dataarea, String rulename) {
      String sql = "";
      if (StringUtils.isNotBlank(rulename)) {
         sql = XmlTool.getSql("dataarea", "querySensitiveregexList");
         return this.getSession().getSession().createNativeQuery(sql).setParameter("dataarea", "%" + dataarea + "%").setParameter("rulename", "%" + rulename + "%").setResultTransformer(Transformers.aliasToBean(TCoreSensitiveregexVO.class)).getResultList();
      } else {
         sql = XmlTool.getSql("dataarea", "querySensitiveregexListnorulename");
         return this.getSession().getSession().createNativeQuery(sql).setParameter("dataarea", "%" + dataarea + "%").setResultTransformer(Transformers.aliasToBean(TCoreSensitiveregexVO.class)).getResultList();
      }
   }
}
