package com.chenyang.nse.bussiness.engine.infa.basic.webservice;

import com.chenyang.nse.bussiness.commmon.ApplicationConstants;
import com.chenyang.nse.bussiness.engine.infa.InfoProperty;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPBodyElement;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPHeaderElement;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.Dispatch;
import javax.xml.ws.Service;
import javax.xml.ws.Service.Mode;
import org.w3c.dom.Document;

public class MultiGetSessionStatisticsWebService {
   public static SessionBean returnStatus(String sessionId, InfoProperty engine, String workflowname, String mpname, String fdname) throws Exception {
      String ns = engine.getWebserviceurl();
      String wsdlUrl = engine.getWebserviceserverurl();
      URL url = new URL(wsdlUrl);
      QName sname = new QName(ns, "DataIntegrationService");
      Service service = Service.create(url, sname);
      Dispatch<SOAPMessage> dispatch = service.createDispatch(new QName(ns, "DataIntegration"), SOAPMessage.class, Mode.MESSAGE);
      SOAPMessage msg = MessageFactory.newInstance("SOAP 1.1 Protocol").createMessage();
      SOAPEnvelope envelope = msg.getSOAPPart().getEnvelope();
      SOAPHeader head = envelope.getHeader();
      QName hename = new QName(ns, "Context", "ns0");
      SOAPHeaderElement hele = head.addHeaderElement(hename);
      hele.addChildElement("SessionId").setValue(sessionId);
      SOAPBody body = envelope.getBody();
      QName ename = new QName(ns, "GetSessionStatistics", "ns0");
      SOAPBodyElement ele = body.addBodyElement(ename);
      SOAPElement di = ele.addChildElement("DIServiceInfo");
      di.addChildElement("DomainName").setValue(engine.getDomainname());
      di.addChildElement("ServiceName").setValue(engine.getInteservicename());
      if (workflowname != null) {
         ele.addChildElement("FolderName").setValue(fdname);
         ele.addChildElement("WorkflowName").setValue(workflowname);
         ele.addChildElement("TaskInstancePath").setValue("s_M_" + mpname);
      }

      SOAPMessage response = (SOAPMessage)dispatch.invoke(msg);
      Document doc = response.getSOAPPart().getEnvelope().getBody().extractContentAsDocument();
      SessionBean se = new SessionBean();
      List<SessionBeanDetail> sdetail_list = new ArrayList();
      Map<String, SessionBeanDetail> partitionNameMap = new HashMap();

      for(int i = 0; i < doc.getElementsByTagName("WidgetName").getLength(); ++i) {
         SessionBeanDetail sdetail = new SessionBeanDetail();
         sdetail.setApplied_rows(Long.parseLong(doc.getElementsByTagName("NumAppliedRows").item(i).getTextContent()));
         sdetail.setAffected_rows(Long.parseLong(doc.getElementsByTagName("NumAffectedRows").item(i).getTextContent()));
         sdetail.setRejected_rows(Long.parseLong(doc.getElementsByTagName("NumRejectedRows").item(i).getTextContent()));
         if ("target".equals(doc.getElementsByTagName("WidgetType").item(i).getTextContent())) {
            sdetail.setTabletype("目标");
         } else {
            sdetail.setTabletype("源");
         }

         sdetail.setTablename(doc.getElementsByTagName("WidgetName").item(i).getTextContent());
         sdetail.setWidgetInstanceName(doc.getElementsByTagName("WidgetInstanceName").item(i).getTextContent());
         sdetail.setPartitionName(doc.getElementsByTagName("PartitionName").item(i).getTextContent());
         sdetail.setThroughput(doc.getElementsByTagName("Throughput").item(i).getTextContent());
         partitionNameMap.put(sdetail.getTablename() + "-" + doc.getElementsByTagName("PartitionName").item(i).getTextContent(), sdetail);
      }

      for(Map.Entry<String, SessionBeanDetail> entry : partitionNameMap.entrySet()) {
         entry.getValue();
         sdetail_list.add(entry.getValue());
      }

      se.setSessionBeanDetail(sdetail_list);
      if (doc.getElementsByTagName("TaskRunStatus") == null) {
         se.setStatus("FAILED");
      } else {
         String str = doc.getElementsByTagName("TaskRunStatus").item(0).getTextContent();
         se.setStatus(str);
      }

      if (doc.getElementsByTagName("WorkflowRunId") == null) {
         se.setWf_run_id("FAIL");
      } else {
         String str = doc.getElementsByTagName("WorkflowRunId").item(0).getTextContent();
         se.setWf_run_id(str);
      }

      return se;
   }

   public static SessionBean returnStatus1(String sessionId, InfoProperty engine, String workflowname, String mpname, String fdname) throws Exception {
      String ns = engine.getWebserviceurl();
      String wsdlUrl = engine.getWebserviceserverurl();
      URL url = new URL(wsdlUrl);
      QName sname = new QName(ns, "DataIntegrationService");
      Service service = Service.create(url, sname);
      Dispatch<SOAPMessage> dispatch = service.createDispatch(new QName(ns, "DataIntegration"), SOAPMessage.class, Mode.MESSAGE);
      SOAPMessage msg = MessageFactory.newInstance("SOAP 1.1 Protocol").createMessage();
      SOAPEnvelope envelope = msg.getSOAPPart().getEnvelope();
      SOAPHeader head = envelope.getHeader();
      QName hename = new QName(ns, "Context", "ns0");
      SOAPHeaderElement hele = head.addHeaderElement(hename);
      hele.addChildElement("SessionId").setValue(sessionId);
      SOAPBody body = envelope.getBody();
      QName ename = new QName(ns, "GetSessionStatistics", "ns0");
      SOAPBodyElement ele = body.addBodyElement(ename);
      SOAPElement di = ele.addChildElement("DIServiceInfo");
      di.addChildElement("DomainName").setValue(engine.getDomainname());
      di.addChildElement("ServiceName").setValue(engine.getInteservicename());
      if (workflowname != null) {
         ele.addChildElement("FolderName").setValue(fdname);
         ele.addChildElement("WorkflowName").setValue(workflowname);
         ele.addChildElement("TaskInstancePath").setValue(mpname);
      }

      SOAPMessage response = (SOAPMessage)dispatch.invoke(msg);
      Document doc = response.getSOAPPart().getEnvelope().getBody().extractContentAsDocument();
      SessionBean se = new SessionBean();
      List<SessionBeanDetail> sdetail_list = new ArrayList();
      Map<String, SessionBeanDetail> partitionNameMap = new HashMap();

      for(int i = 0; i < doc.getElementsByTagName("WidgetName").getLength(); ++i) {
         SessionBeanDetail sdetail = new SessionBeanDetail();
         sdetail.setApplied_rows(Long.parseLong(doc.getElementsByTagName("NumAppliedRows").item(i).getTextContent()));
         sdetail.setAffected_rows(Long.parseLong(doc.getElementsByTagName("NumAffectedRows").item(i).getTextContent()));
         sdetail.setRejected_rows(Long.parseLong(doc.getElementsByTagName("NumRejectedRows").item(i).getTextContent()));
         if ("target".equals(doc.getElementsByTagName("WidgetType").item(i).getTextContent())) {
            sdetail.setTabletype("目标");
         } else {
            sdetail.setTabletype("源");
         }

         sdetail.setTablename(doc.getElementsByTagName("WidgetName").item(i).getTextContent());
         sdetail.setWidgetInstanceName(doc.getElementsByTagName("WidgetInstanceName").item(i).getTextContent());
         sdetail.setPartitionName(doc.getElementsByTagName("PartitionName").item(i).getTextContent());
         sdetail.setThroughput(doc.getElementsByTagName("Throughput").item(i).getTextContent());
         partitionNameMap.put(sdetail.getTablename() + "-" + doc.getElementsByTagName("PartitionName").item(i).getTextContent(), sdetail);
      }

      for(Map.Entry<String, SessionBeanDetail> entry : partitionNameMap.entrySet()) {
         entry.getValue();
         sdetail_list.add(entry.getValue());
      }

      se.setSessionBeanDetail(sdetail_list);
      if (doc.getElementsByTagName("TaskRunStatus") == null) {
         se.setStatus("FAILED");
      } else {
         String str = doc.getElementsByTagName("TaskRunStatus").item(0).getTextContent();
         se.setStatus(str);
      }

      if (doc.getElementsByTagName("WorkflowRunId") == null) {
         se.setWf_run_id("FAIL");
      } else {
         String str = doc.getElementsByTagName("WorkflowRunId").item(0).getTextContent();
         se.setWf_run_id(str);
      }

      return se;
   }

   public static SessionBean returnStatus(String sessionId, String domain, String server, String workflowname, String mpname, String sename, String fdname) throws Exception {
      String ns = ApplicationConstants.webservice_url;
      String wsdlUrl = ApplicationConstants.wsdl_url;
      URL url = new URL(wsdlUrl);
      QName sname = new QName(ns, "DataIntegrationService");
      Service service = Service.create(url, sname);
      Dispatch<SOAPMessage> dispatch = service.createDispatch(new QName(ns, "DataIntegration"), SOAPMessage.class, Mode.MESSAGE);
      SOAPMessage msg = MessageFactory.newInstance("SOAP 1.1 Protocol").createMessage();
      SOAPEnvelope envelope = msg.getSOAPPart().getEnvelope();
      SOAPHeader head = envelope.getHeader();
      QName hename = new QName(ns, "Context", "ns0");
      SOAPHeaderElement hele = head.addHeaderElement(hename);
      hele.addChildElement("SessionId").setValue(sessionId);
      SOAPBody body = envelope.getBody();
      QName ename = new QName(ns, "GetSessionStatistics", "ns0");
      SOAPBodyElement ele = body.addBodyElement(ename);
      SOAPElement di = ele.addChildElement("DIServiceInfo");
      di.addChildElement("DomainName").setValue(domain);
      di.addChildElement("ServiceName").setValue(server);
      if (workflowname != null) {
         ele.addChildElement("FolderName").setValue(fdname);
         ele.addChildElement("WorkflowName").setValue(workflowname);
         ele.addChildElement("TaskInstancePath").setValue(sename);
      }

      SOAPMessage response = (SOAPMessage)dispatch.invoke(msg);
      Document doc = response.getSOAPPart().getEnvelope().getBody().extractContentAsDocument();
      SessionBean se = new SessionBean();
      List<SessionBeanDetail> sdetail_list = new ArrayList();

      for(int i = 0; i < doc.getElementsByTagName("WidgetName").getLength(); ++i) {
         SessionBeanDetail sdetail = new SessionBeanDetail();
         sdetail.setApplied_rows(Long.parseLong(doc.getElementsByTagName("NumAppliedRows").item(i).getTextContent()));
         sdetail.setAffected_rows(Long.parseLong(doc.getElementsByTagName("NumAffectedRows").item(i).getTextContent()));
         sdetail.setRejected_rows(Long.parseLong(doc.getElementsByTagName("NumRejectedRows").item(i).getTextContent()));
         sdetail.setError_log(doc.getElementsByTagName("LastErrorMessage").item(i).getTextContent());
         if ("target".equals(doc.getElementsByTagName("WidgetType").item(i).getTextContent())) {
            sdetail.setTabletype("目标");
            sdetail.setTablename(doc.getElementsByTagName("WidgetName").item(i).getTextContent());
         } else {
            sdetail.setTabletype("源");
            sdetail.setTablename(doc.getElementsByTagName("WidgetName").item(i).getTextContent().replace("SQ_", ""));
         }

         sdetail_list.add(sdetail);
      }

      se.setSessionBeanDetail(sdetail_list);
      if (doc.getElementsByTagName("TaskRunStatus") == null) {
         se.setStatus("FAILED");
      } else {
         String str = doc.getElementsByTagName("TaskRunStatus").item(0).getTextContent();
         se.setStatus(str);
      }

      if (doc.getElementsByTagName("WorkflowRunId") == null) {
         se.setWf_run_id("FAIL");
      } else {
         String str = doc.getElementsByTagName("WorkflowRunId").item(0).getTextContent();
         se.setWf_run_id(str);
      }

      return se;
   }

   public static String returnStatusOnly(String sessionId, InfoProperty engine, String workflowname, String mpname, String fdname) throws Exception {
      String ns = engine.getWebserviceurl();
      String wsdlUrl = engine.getWebserviceserverurl();
      URL url = new URL(wsdlUrl);
      QName sname = new QName(ns, "DataIntegrationService");
      Service service = Service.create(url, sname);
      Dispatch<SOAPMessage> dispatch = service.createDispatch(new QName(ns, "DataIntegration"), SOAPMessage.class, Mode.MESSAGE);
      SOAPMessage msg = MessageFactory.newInstance("SOAP 1.1 Protocol").createMessage();
      SOAPEnvelope envelope = msg.getSOAPPart().getEnvelope();
      SOAPHeader head = envelope.getHeader();
      QName hename = new QName(ns, "Context", "ns0");
      SOAPHeaderElement hele = head.addHeaderElement(hename);
      hele.addChildElement("SessionId").setValue(sessionId);
      SOAPBody body = envelope.getBody();
      QName ename = new QName(ns, "GetSessionStatistics", "ns0");
      SOAPBodyElement ele = body.addBodyElement(ename);
      SOAPElement di = ele.addChildElement("DIServiceInfo");
      di.addChildElement("DomainName").setValue(engine.getDomainname());
      di.addChildElement("ServiceName").setValue(engine.getInteservicename());
      if (workflowname != null) {
         ele.addChildElement("FolderName").setValue(fdname);
         ele.addChildElement("WorkflowName").setValue(workflowname);
         ele.addChildElement("TaskInstancePath").setValue("s_M_" + mpname);
      }

      SOAPMessage response = (SOAPMessage)dispatch.invoke(msg);
      Document doc = response.getSOAPPart().getEnvelope().getBody().extractContentAsDocument();
      String rtnStatus = null;
      if (doc.getElementsByTagName("TaskRunStatus") == null) {
         rtnStatus = "FAILED";
      } else {
         rtnStatus = doc.getElementsByTagName("TaskRunStatus").item(0).getTextContent();
      }

      return rtnStatus;
   }

   public static SessionBean returnStatus(String sessionId, InfoProperty engine, String workflowname, String mpname, String fdname, long dataCount) throws Exception {
      String ns = engine.getWebserviceurl();
      String wsdlUrl = engine.getWebserviceserverurl();
      URL url = new URL(wsdlUrl);
      QName sname = new QName(ns, "DataIntegrationService");
      Service service = Service.create(url, sname);
      Dispatch<SOAPMessage> dispatch = service.createDispatch(new QName(ns, "DataIntegration"), SOAPMessage.class, Mode.MESSAGE);
      SOAPMessage msg = MessageFactory.newInstance("SOAP 1.1 Protocol").createMessage();
      SOAPEnvelope envelope = msg.getSOAPPart().getEnvelope();
      SOAPHeader head = envelope.getHeader();
      QName hename = new QName(ns, "Context", "ns0");
      SOAPHeaderElement hele = head.addHeaderElement(hename);
      hele.addChildElement("SessionId").setValue(sessionId);
      SOAPBody body = envelope.getBody();
      QName ename = new QName(ns, "GetSessionStatistics", "ns0");
      SOAPBodyElement ele = body.addBodyElement(ename);
      SOAPElement di = ele.addChildElement("DIServiceInfo");
      di.addChildElement("DomainName").setValue(engine.getDomainname());
      di.addChildElement("ServiceName").setValue(engine.getInteservicename());
      if (workflowname != null) {
         ele.addChildElement("FolderName").setValue(fdname);
         ele.addChildElement("WorkflowName").setValue(workflowname);
         ele.addChildElement("TaskInstancePath").setValue("s_M_" + mpname);
      }

      SOAPMessage response = (SOAPMessage)dispatch.invoke(msg);
      Document doc = response.getSOAPPart().getEnvelope().getBody().extractContentAsDocument();
      SessionBean se = new SessionBean();
      List<SessionBeanDetail> sdetail_list = new ArrayList();
      Map<String, SessionBeanDetail> partitionNameMap = new HashMap();

      for(int i = 0; i < doc.getElementsByTagName("WidgetName").getLength(); ++i) {
         SessionBeanDetail sdetail = new SessionBeanDetail();
         sdetail.setApplied_rows(Long.parseLong(doc.getElementsByTagName("NumAppliedRows").item(i).getTextContent()));
         sdetail.setAffected_rows(Long.parseLong(doc.getElementsByTagName("NumAffectedRows").item(i).getTextContent()));
         sdetail.setRejected_rows(Long.parseLong(doc.getElementsByTagName("NumRejectedRows").item(i).getTextContent()));
         if ("target".equals(doc.getElementsByTagName("WidgetType").item(i).getTextContent())) {
            sdetail.setTabletype("目标");
         } else {
            sdetail.setTabletype("源");
         }

         sdetail.setTablename(doc.getElementsByTagName("WidgetName").item(i).getTextContent());
         sdetail.setWidgetInstanceName(doc.getElementsByTagName("WidgetInstanceName").item(i).getTextContent());
         sdetail.setPartitionName(doc.getElementsByTagName("PartitionName").item(i).getTextContent());
         sdetail.setThroughput(doc.getElementsByTagName("Throughput").item(i).getTextContent());
         long NumAppliedRows = Long.parseLong(doc.getElementsByTagName("NumAppliedRows").item(i).getTextContent());
         long NumRejectedRows = Long.parseLong(doc.getElementsByTagName("NumRejectedRows").item(i).getTextContent());
         long Throughput = Long.parseLong(doc.getElementsByTagName("Throughput").item(i).getTextContent());
         long timeRemaining = 0L;
         StringBuffer sb = new StringBuffer();
         if (dataCount != 0L) {
            if (Throughput == 0L) {
               timeRemaining = (dataCount - (NumAppliedRows + NumRejectedRows)) / 1L;
            } else {
               timeRemaining = (dataCount - (NumAppliedRows + NumRejectedRows)) / Throughput;
            }

            long temp = 0L;
            temp = timeRemaining / 3600L;
            sb.append(temp < 10L ? "0" + temp + ":" : "" + temp + ":");
            temp = timeRemaining % 3600L / 60L;
            sb.append(temp < 10L ? "0" + temp + ":" : "" + temp + ":");
            temp = timeRemaining % 3600L % 60L;
            sb.append(temp < 10L ? "0" + temp : "" + temp);
         }

         sdetail.setForecastRunTime(sb.toString());
         partitionNameMap.put(sdetail.getTablename() + "-" + doc.getElementsByTagName("PartitionName").item(i).getTextContent(), sdetail);
      }

      for(Map.Entry<String, SessionBeanDetail> entry : partitionNameMap.entrySet()) {
         entry.getValue();
         sdetail_list.add(entry.getValue());
      }

      se.setSessionBeanDetail(sdetail_list);
      if (doc.getElementsByTagName("TaskRunStatus") == null) {
         se.setStatus("FAILED");
      } else {
         String str = doc.getElementsByTagName("TaskRunStatus").item(0).getTextContent();
         se.setStatus(str);
      }

      if (doc.getElementsByTagName("WorkflowRunId") == null) {
         se.setWf_run_id("FAIL");
      } else {
         String str = doc.getElementsByTagName("WorkflowRunId").item(0).getTextContent();
         se.setWf_run_id(str);
      }

      return se;
   }

   public static SessionBean returnStatusByDataCount(String sessionId, InfoProperty engine, String workflowname, String mpname, String fdname, long dataCount) throws Exception {
      String ns = engine.getWebserviceurl();
      String wsdlUrl = engine.getWebserviceserverurl();
      URL url = new URL(wsdlUrl);
      QName sname = new QName(ns, "DataIntegrationService");
      Service service = Service.create(url, sname);
      Dispatch<SOAPMessage> dispatch = service.createDispatch(new QName(ns, "DataIntegration"), SOAPMessage.class, Mode.MESSAGE);
      SOAPMessage msg = MessageFactory.newInstance("SOAP 1.1 Protocol").createMessage();
      SOAPEnvelope envelope = msg.getSOAPPart().getEnvelope();
      SOAPHeader head = envelope.getHeader();
      QName hename = new QName(ns, "Context", "ns0");
      SOAPHeaderElement hele = head.addHeaderElement(hename);
      hele.addChildElement("SessionId").setValue(sessionId);
      SOAPBody body = envelope.getBody();
      QName ename = new QName(ns, "GetSessionStatistics", "ns0");
      SOAPBodyElement ele = body.addBodyElement(ename);
      SOAPElement di = ele.addChildElement("DIServiceInfo");
      di.addChildElement("DomainName").setValue(engine.getDomainname());
      di.addChildElement("ServiceName").setValue(engine.getInteservicename());
      if (workflowname != null) {
         ele.addChildElement("FolderName").setValue(fdname);
         ele.addChildElement("WorkflowName").setValue(workflowname);
         ele.addChildElement("TaskInstancePath").setValue("s_M_" + mpname);
      }

      SOAPMessage response = (SOAPMessage)dispatch.invoke(msg);
      Document doc = response.getSOAPPart().getEnvelope().getBody().extractContentAsDocument();
      SessionBean se = new SessionBean();
      List<SessionBeanDetail> sdetail_list = new ArrayList();
      Map<String, SessionBeanDetail> partitionNameMap = new HashMap();

      for(int i = 0; i < doc.getElementsByTagName("WidgetName").getLength(); ++i) {
         SessionBeanDetail sdetail = new SessionBeanDetail();
         sdetail.setApplied_rows(Long.parseLong(doc.getElementsByTagName("NumAppliedRows").item(i).getTextContent()));
         sdetail.setAffected_rows(Long.parseLong(doc.getElementsByTagName("NumAffectedRows").item(i).getTextContent()));
         sdetail.setRejected_rows(Long.parseLong(doc.getElementsByTagName("NumRejectedRows").item(i).getTextContent()));
         if ("target".equals(doc.getElementsByTagName("WidgetType").item(i).getTextContent())) {
            sdetail.setTabletype("目标");
         } else {
            sdetail.setTabletype("源");
         }

         sdetail.setTablename(doc.getElementsByTagName("WidgetName").item(i).getTextContent());
         sdetail.setWidgetInstanceName(doc.getElementsByTagName("WidgetInstanceName").item(i).getTextContent());
         sdetail.setPartitionName(doc.getElementsByTagName("PartitionName").item(i).getTextContent());
         sdetail.setThroughput(doc.getElementsByTagName("Throughput").item(i).getTextContent());
         long NumAppliedRows = Long.parseLong(doc.getElementsByTagName("NumAppliedRows").item(i).getTextContent());
         long NumRejectedRows = Long.parseLong(doc.getElementsByTagName("NumRejectedRows").item(i).getTextContent());
         long Throughput = Long.parseLong(doc.getElementsByTagName("Throughput").item(i).getTextContent());
         long timeRemaining = 0L;
         StringBuffer sb = new StringBuffer();
         if (dataCount != 0L) {
            if (Throughput == 0L) {
               timeRemaining = (dataCount - (NumAppliedRows + NumRejectedRows)) / 1L;
            } else {
               timeRemaining = (dataCount - (NumAppliedRows + NumRejectedRows)) / Throughput;
            }

            long temp = 0L;
            temp = timeRemaining / 3600L;
            sb.append(temp < 10L ? "0" + temp + ":" : "" + temp + ":");
            temp = timeRemaining % 3600L / 60L;
            sb.append(temp < 10L ? "0" + temp + ":" : "" + temp + ":");
            temp = timeRemaining % 3600L % 60L;
            sb.append(temp < 10L ? "0" + temp : "" + temp);
         }

         sdetail.setForecastRunTime(sb.toString());
         partitionNameMap.put(sdetail.getTablename() + "-" + doc.getElementsByTagName("PartitionName").item(i).getTextContent(), sdetail);
      }

      for(Map.Entry<String, SessionBeanDetail> entry : partitionNameMap.entrySet()) {
         entry.getValue();
         sdetail_list.add(entry.getValue());
      }

      se.setSessionBeanDetail(sdetail_list);
      if (doc.getElementsByTagName("TaskRunStatus") == null) {
         se.setStatus("FAILED");
      } else {
         String str = doc.getElementsByTagName("TaskRunStatus").item(0).getTextContent();
         se.setStatus(str);
      }

      if (doc.getElementsByTagName("WorkflowRunId") == null) {
         se.setWf_run_id("FAIL");
      } else {
         String str = doc.getElementsByTagName("WorkflowRunId").item(0).getTextContent();
         se.setWf_run_id(str);
      }

      return se;
   }
}
