package com.chenyang.nse.bussiness.entity.orm.table.core.datamap;

import com.chenyang.nse.bussiness.entity.orm.table.TBaseEntity;
import javax.persistence.Entity;
import javax.persistence.Table;

@Entity
@Table(
   name = "T_CORE_DATAMAP_TABLEALIAS"
)
public class TCoreDatamapTablealias extends TBaseEntity {
   private String datasystemid;
   private String dbschema;
   private String tablename;
   private String tablebyname;

   public TCoreDatamapTablealias() {
   }

   public TCoreDatamapTablealias(String datasystemid, String dbschema, String tablename, String tablebyname) {
      this.datasystemid = datasystemid;
      this.dbschema = dbschema;
      this.tablename = tablename;
      this.tablebyname = tablebyname;
   }

   public String getDatasystemid() {
      return this.datasystemid;
   }

   public void setDatasystemid(String datasystemid) {
      this.datasystemid = datasystemid;
   }

   public String getDbschema() {
      return this.dbschema;
   }

   public void setDbschema(String dbschema) {
      this.dbschema = dbschema;
   }

   public String getTablename() {
      return this.tablename;
   }

   public void setTablename(String tablename) {
      this.tablename = tablename;
   }

   public String getTablebyname() {
      return this.tablebyname;
   }

   public void setTablebyname(String tablebyname) {
      this.tablebyname = tablebyname;
   }

   public String toString() {
      return "TCoreDatamapTablealias [datasystemid=" + this.datasystemid + ", dbschema=" + this.dbschema + ", tablename=" + this.tablename + ", tablebyname=" + this.tablebyname + "]";
   }

   public int hashCode() {
      int prime = 31;
      int result = 1;
      result = 31 * result + (this.datasystemid == null ? 0 : this.datasystemid.hashCode());
      result = 31 * result + (this.dbschema == null ? 0 : this.dbschema.hashCode());
      result = 31 * result + (this.tablebyname == null ? 0 : this.tablebyname.hashCode());
      result = 31 * result + (this.tablename == null ? 0 : this.tablename.hashCode());
      return result;
   }

   public boolean equals(Object obj) {
      if (this == obj) {
         return true;
      } else if (obj == null) {
         return false;
      } else if (this.getClass() != obj.getClass()) {
         return false;
      } else {
         TCoreDatamapTablealias other = (TCoreDatamapTablealias)obj;
         if (this.datasystemid == null) {
            if (other.datasystemid != null) {
               return false;
            }
         } else if (!this.datasystemid.equals(other.datasystemid)) {
            return false;
         }

         if (this.dbschema == null) {
            if (other.dbschema != null) {
               return false;
            }
         } else if (!this.dbschema.equals(other.dbschema)) {
            return false;
         }

         if (this.tablebyname == null) {
            if (other.tablebyname != null) {
               return false;
            }
         } else if (!this.tablebyname.equals(other.tablebyname)) {
            return false;
         }

         if (this.tablename == null) {
            if (other.tablename != null) {
               return false;
            }
         } else if (!this.tablename.equals(other.tablename)) {
            return false;
         }

         return true;
      }
   }
}
