package com.chenyang.nse.bussiness.entity.orm.table.core.maskingself;

import com.chenyang.nse.bussiness.entity.orm.table.TBaseEntity;
import javax.persistence.Entity;
import javax.persistence.Table;

@Entity
@Table(
   name = "T_CORE_MASKINGSELF_FILE"
)
public class TCoreMaskingselfFile extends TBaseEntity {
   private String taskid;
   private String mappingkey;

   public TCoreMaskingselfFile() {
   }

   public TCoreMaskingselfFile(String taskid, String mappingkey) {
      this.taskid = taskid;
      this.mappingkey = mappingkey;
   }

   public String getTaskid() {
      return this.taskid;
   }

   public void setTaskid(String taskid) {
      this.taskid = taskid;
   }

   public String getMappingkey() {
      return this.mappingkey;
   }

   public void setMappingkey(String mappingkey) {
      this.mappingkey = mappingkey;
   }

   public String toString() {
      return "TCoreMaskingselfFile [taskid=" + this.taskid + ", mappingkey=" + this.mappingkey + "]";
   }

   public int hashCode() {
      int prime = 31;
      int result = 1;
      result = 31 * result + (this.mappingkey == null ? 0 : this.mappingkey.hashCode());
      result = 31 * result + (this.taskid == null ? 0 : this.taskid.hashCode());
      return result;
   }

   public boolean equals(Object obj) {
      if (this == obj) {
         return true;
      } else if (obj == null) {
         return false;
      } else if (this.getClass() != obj.getClass()) {
         return false;
      } else {
         TCoreMaskingselfFile other = (TCoreMaskingselfFile)obj;
         if (this.mappingkey == null) {
            if (other.mappingkey != null) {
               return false;
            }
         } else if (!this.mappingkey.equals(other.mappingkey)) {
            return false;
         }

         if (this.taskid == null) {
            if (other.taskid != null) {
               return false;
            }
         } else if (!this.taskid.equals(other.taskid)) {
            return false;
         }

         return true;
      }
   }
}
