package com.chenyang.nse.bussiness.jar.db;

import com.chenyang.nse.bussiness.config.PropertiesLoaderUtils;
import com.chenyang.nse.bussiness.dao.BaseDao;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import org.springframework.stereotype.Repository;

@Repository
public class ServerClientSocketLogDao extends BaseDao<ServerClientSocketLog, String> {
   static SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

   public void log(String log) {
      try {
         if (isSaveLog()) {
            ServerClientSocketLog socketLog = new ServerClientSocketLog();
            socketLog.setTime(sdf.format(new Date()));
            socketLog.setLog(log);
            this.save(socketLog);
         }
      } catch (Exception var3) {
      }

   }

   public void log(String ip, int port, String log) {
      try {
         if (isSaveLog()) {
            ServerClientSocketLog socketLog = new ServerClientSocketLog();
            socketLog.setTime(sdf.format(new Date()));
            socketLog.setLog(log);
            socketLog.setClient(ip + ":" + port);
            this.save(socketLog);
         }
      } catch (Exception var5) {
      }

   }

   public static boolean isSaveLog() {
      boolean result = false;
      new Properties();

      try {
         Properties props = PropertiesLoaderUtils.loadAllProperties("config.properties");
         if (props.get("isSaveServerClientLog").toString().equalsIgnoreCase("true")) {
            result = true;
         }
      } catch (IOException e) {
         e.printStackTrace();
      }

      return result;
   }
}
