package com.chenyang.nse.bussiness.service.console.impl;

import com.chenyang.nse.bussiness.dao.table.base.TBaseButtonDao;
import com.chenyang.nse.bussiness.dao.table.base.TBaseMenuDao;
import com.chenyang.nse.bussiness.dao.table.base.TBaseRolemenuDao;
import com.chenyang.nse.bussiness.dao.table.console.TConsoleLogDao;
import com.chenyang.nse.bussiness.entity.orm.table.base.TBaseButton;
import com.chenyang.nse.bussiness.entity.orm.table.base.TBaseMenu;
import com.chenyang.nse.bussiness.entity.orm.table.base.TBaseRolemenu;
import com.chenyang.nse.bussiness.entity.orm.table.console.TConsoleLog;
import com.chenyang.nse.bussiness.entity.vo.MenuRtVO;
import com.chenyang.nse.bussiness.entity.vo.TreeVO;
import com.chenyang.nse.bussiness.enumeration.EroleFlag;
import com.chenyang.nse.bussiness.service.console.MenuService;
import com.chenyang.nse.bussiness.service.console.OperationService;
import com.chenyang.nse.bussiness.tools.login.CommonUtils;
import com.chenyang.nse.bussiness.tools.string.StringTool;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class MenuServiceImpl implements MenuService {
   @Autowired
   private TBaseMenuDao tBaseMenuDao;
   @Autowired
   private TBaseRolemenuDao tBaseRolemenuDao;
   @Autowired
   private OperationService operationService;
   @Autowired
   private TBaseButtonDao tBaseButtonDao;
   @Autowired
   private TConsoleLogDao tConsoleLogDao;

   public List<TBaseMenu> queryMenuByParentId(String parentid, String flag) {
      Criterion cparentid = null;
      Object var5;
      if (parentid == null) {
         var5 = Restrictions.isNull("parentid");
      } else {
         var5 = Restrictions.eq("parentid", parentid);
      }

      if (null != flag && !"".equals(flag)) {
         Criterion cflag = Restrictions.eq("flag", flag);
         return this.tBaseMenuDao.queryAll(Order.asc("sortstring"), new Criterion[]{cflag, (Criterion)var5});
      } else {
         return this.tBaseMenuDao.queryAll(Order.asc("sortstring"), new Criterion[]{(Criterion)var5});
      }
   }

   public List<TBaseMenu> queryMenuByParentId1(String parentid, String flag) {
      Criterion cparentid = null;
      Object var5;
      if (parentid == null) {
         var5 = Restrictions.isNull("parentid");
      } else {
         var5 = Restrictions.eq("parentid", parentid);
      }

      if (null != flag && !"".equals(flag)) {
         Criterion cflag = Restrictions.eq("flag", flag);
         return this.tBaseMenuDao.queryAll(Order.desc("createtime"), new Criterion[]{cflag, (Criterion)var5});
      } else {
         return this.tBaseMenuDao.queryAll(Order.desc("createtime"), new Criterion[]{(Criterion)var5});
      }
   }

   public void remove(List<String> idlist) {
      for(String id : idlist) {
         this.tBaseMenuDao.removeById(id);
         this.tBaseMenuDao.remove(new Criterion[]{Restrictions.eq("parentid", id)});
      }

   }

   public void removerow(String id) {
      TBaseMenu tBaseMenu = (TBaseMenu)this.tBaseMenuDao.get(id);
      if (null != tBaseMenu.getParentid() && !"".equals(tBaseMenu.getParentid())) {
         this.tBaseButtonDao.remove(new Criterion[]{Restrictions.eq("menuid", id)});
         this.tBaseMenuDao.removeById(id);
      } else {
         List<TBaseMenu> queryAll = this.tBaseMenuDao.queryAll(new Criterion[]{Restrictions.eq("parentid", id)});
         if (queryAll.size() > 0) {
            for(TBaseMenu tBaseMenu2 : queryAll) {
               this.tBaseButtonDao.remove(new Criterion[]{Restrictions.eq("menuid", tBaseMenu2.getId())});
            }
         }

         this.tBaseMenuDao.remove(new Criterion[]{Restrictions.eq("parentid", id)});
         this.tBaseMenuDao.removeById(id);
      }

   }

   public void add(TBaseMenu menu) {
      menu.setCreateuser(CommonUtils.loginUsername());
      menu.setCreatetime(new Date());
      this.tBaseMenuDao.save(menu);
   }

   public boolean isMenunameExist(String menuname) {
      Criterion cmenuname = Restrictions.eq("menuname", menuname);
      long count = this.tBaseMenuDao.count(new Criterion[]{cmenuname});
      return count > 0L;
   }

   public void modifyMenu(TBaseMenu menu, String username) {
      TBaseMenu entity = (TBaseMenu)this.tBaseMenuDao.get(menu.getId());
      TConsoleLog record = new TConsoleLog();
      record.setModule("菜单管理");
      record.setOperationtime(new Date());
      record.setUser(username);
      if (entity != null) {
         if (entity.getParentid() == null) {
            entity.setFlag(menu.getFlag());
            entity.setMenuname(menu.getMenuname());
            entity.setNote(menu.getNote());
            entity.setFlag("1");
            entity.setCreateuser(CommonUtils.loginUsername());
            entity.setCreatetime(new Date());
            record.setLogmessage("修改主菜单");
            record.setOperationObject(menu.getMenuname());
         } else {
            entity.setParentid(menu.getParentid());
            entity.setMenuname(menu.getMenuname());
            entity.setUrl(menu.getUrl());
            entity.setNote(menu.getNote());
            entity.setFlag("1");
            entity.setUpdateuser(CommonUtils.loginUsername());
            entity.setUpdatetime(new Date());
            record.setLogmessage("修改子菜单");
            record.setOperationObject(menu.getMenuname());
         }

         this.tBaseMenuDao.saveOrUpdate(entity);
         this.operationService.add(record);
      }

   }

   public void sortMenu(List<String> idlist) {
      for(int i = 0; i < idlist.size(); ++i) {
         String id = (String)idlist.get(i);
         TBaseMenu m = (TBaseMenu)this.tBaseMenuDao.get(id);
         m.setSortstring(i + 1);
         this.tBaseMenuDao.saveOrUpdate(m);
      }

   }

   public List<TreeVO> queryMenuTree(String flag) {
      List<TreeVO> result = new ArrayList();
      List<TBaseMenu> list = null;
      if (flag == null) {
         list = this.tBaseMenuDao.queryAll();
      } else {
         list = this.tBaseMenuDao.queryAll(Order.desc("createtime"), new Criterion[]{Restrictions.eq("flag", flag)});
      }

      Map<String, List<TreeVO>> map = new HashMap();
      Map<String, List<TreeVO>> map2 = new HashMap();

      for(TBaseMenu menu : list) {
         String parentId = menu.getParentid();
         if (parentId == null) {
            result.add(new TreeVO(menu.getId(), menu.getMenuname()));
         } else {
            if (!map.containsKey(parentId)) {
               map.put(parentId, new ArrayList());
            }

            ((List)map.get(parentId)).add(new TreeVO(menu.getId(), menu.getMenuname()));
            String menuid = menu.getId();

            for(TBaseButton tBaseButton : this.tBaseButtonDao.queryAll(Order.desc("createtime"), new Criterion[]{Restrictions.eq("menuid", menuid)})) {
               if (!map2.containsKey(menuid)) {
                  map2.put(menuid, new ArrayList());
               }

               ((List)map2.get(menuid)).add(new TreeVO(tBaseButton.getId(), tBaseButton.getButtonname()));
            }
         }
      }

      for(TreeVO vo : result) {
         vo.setChildren((List)map.get(vo.getId()));
         if (null != map.get(vo.getId())) {
            for(int i = 0; i < ((List)map.get(vo.getId())).size(); ++i) {
               List<TreeVO> list2 = (List)map2.get(((TreeVO)vo.getChildren().get(i)).getId());
               if (null != map2.get(((TreeVO)vo.getChildren().get(i)).getId())) {
                  List<TreeVO> children = vo.getChildren();
                  ((TreeVO)children.get(i)).setChildren((List)map2.get(((TreeVO)vo.getChildren().get(i)).getId()));
               }
            }
         }
      }

      return result;
   }

   public List<TreeVO> getMenuTreeList(String type) {
      List<TreeVO> result = new ArrayList();
      List<TBaseMenu> list = null;
      if (type == "") {
         list = this.tBaseMenuDao.queryAll();
      } else {
         list = this.tBaseMenuDao.queryAll(Order.desc("createtime"), new Criterion[]{Restrictions.eq("type", type)});
      }

      Map<String, List<TreeVO>> map = new HashMap();
      Map<String, List<TreeVO>> map2 = new HashMap();

      for(TBaseMenu menu : list) {
         String parentId = menu.getParentid();
         if (parentId == null) {
            result.add(new TreeVO(menu.getId(), menu.getMenuname()));
         } else {
            if (!map.containsKey(parentId)) {
               map.put(parentId, new ArrayList());
            }

            ((List)map.get(parentId)).add(new TreeVO(menu.getId(), menu.getMenuname()));
            String menuid = menu.getId();

            for(TBaseButton tBaseButton : this.tBaseButtonDao.queryAll(Order.desc("createtime"), new Criterion[]{Restrictions.eq("menuid", menuid)})) {
               if (!map2.containsKey(menuid)) {
                  map2.put(menuid, new ArrayList());
               }

               ((List)map2.get(menuid)).add(new TreeVO(tBaseButton.getId(), tBaseButton.getButtonname()));
            }
         }
      }

      for(TreeVO vo : result) {
         vo.setChildren((List)map.get(vo.getId()));
         if (null != map.get(vo.getId())) {
            for(int i = 0; i < ((List)map.get(vo.getId())).size(); ++i) {
               List<TreeVO> list2 = (List)map2.get(((TreeVO)vo.getChildren().get(i)).getId());
               if (null != map2.get(((TreeVO)vo.getChildren().get(i)).getId())) {
                  List<TreeVO> children = vo.getChildren();
                  ((TreeVO)children.get(i)).setChildren((List)map2.get(((TreeVO)vo.getChildren().get(i)).getId()));
               }
            }
         }
      }

      return result;
   }

   public List<MenuRtVO> queryMenuAll() {
      List<MenuRtVO> result = new ArrayList();
      List<TBaseMenu> list = null;
      list = this.tBaseMenuDao.queryAll(Order.asc("sortstring"), new Criterion[0]);
      Map<String, List<MenuRtVO>> map = new HashMap();
      Map<String, List<MenuRtVO>> map2 = new HashMap();

      for(TBaseMenu menu : list) {
         String parentId = menu.getParentid();
         if (parentId == null) {
            result.add(new MenuRtVO(menu.getId(), menu.getMenuname(), menu.getUrl(), menu.getIcon(), menu.getType()));
         } else {
            if (!map.containsKey(parentId)) {
               map.put(parentId, new ArrayList());
            }

            ((List)map.get(parentId)).add(new MenuRtVO(menu.getId(), menu.getMenuname(), menu.getUrl(), menu.getIcon(), menu.getType()));
         }
      }

      for(MenuRtVO vo : result) {
         vo.setChildren((List)map.get(vo.getId()));
         if (null != map.get(vo.getId())) {
            for(int i = 0; i < ((List)map.get(vo.getId())).size(); ++i) {
               List<MenuRtVO> list2 = (List)map2.get(((MenuRtVO)vo.getChildren().get(i)).getId());
               if (null != map2.get(((MenuRtVO)vo.getChildren().get(i)).getId())) {
                  List<MenuRtVO> children = vo.getChildren();
                  ((MenuRtVO)children.get(i)).setChildren((List)map2.get(((MenuRtVO)vo.getChildren().get(i)).getId()));
               }
            }
         }
      }

      return result;
   }

   public int add(TBaseMenu menu, List<TBaseMenu> subMenu, String username) {
      menu.setId(StringTool.getTablePrimaryKey());
      menu.getNote();
      Date now = new Date();
      menu.setCreatetime(now);
      menu.setCreateuser(CommonUtils.loginUsername());
      TConsoleLog record = new TConsoleLog();
      record.setModule("菜单管理");
      record.setOperationtime(now);
      record.setUser(username);
      List<TBaseMenu> queryAll = this.tBaseMenuDao.queryAll(new Criterion[]{Restrictions.eq("menuname", menu.getMenuname())});
      if (queryAll.size() != 0) {
         return 1;
      } else {
         for(TBaseMenu tmenu : subMenu) {
            tmenu.setParentid(menu.getId());
            tmenu.setCreatetime(now);
            tmenu.setId(StringTool.getTablePrimaryKey());
            List<TBaseMenu> query = this.tBaseMenuDao.queryAll(new Criterion[]{Restrictions.eq("menuname", tmenu.getMenuname())});
            if (query.size() != 0) {
               return 2;
            }

            TConsoleLog record1 = new TConsoleLog();
            record1.setModule("菜单管理");
            record1.setOperationtime(now);
            record1.setUser(username);
            record1.setLogmessage("增加子菜单");
            record1.setOperationObject(tmenu.getMenuname());
            this.tConsoleLogDao.save(record1);
            this.tBaseMenuDao.save(tmenu);
         }

         record.setLogmessage("增加主菜单");
         record.setOperationObject(menu.getMenuname());
         this.tConsoleLogDao.save(record);
         this.tBaseMenuDao.save(menu);
         if (EroleFlag.CONSOLE.getFlag().equals(menu.getFlag())) {
            TBaseRolemenu rm = new TBaseRolemenu();
            rm.setMenuid(menu.getId());
            rm.setRoleid("1");
            rm.setId(StringTool.getTablePrimaryKey());
            this.tBaseRolemenuDao.save(rm);

            for(TBaseMenu tmenu : subMenu) {
               rm = new TBaseRolemenu();
               rm.setMenuid(tmenu.getId());
               rm.setRoleid("1");
               rm.setId(StringTool.getTablePrimaryKey());
               this.tBaseRolemenuDao.save(rm);
            }
         }

         return 0;
      }
   }

   public int add(String menuId, String note, List<TBaseMenu> subMenu) {
      int a = 0;
      TBaseMenu menu = (TBaseMenu)this.tBaseMenuDao.get(menuId);
      Date now = new Date();

      for(TBaseMenu tmenu : subMenu) {
         tmenu.setParentid(menuId);
         tmenu.setCreatetime(now);
         tmenu.setCreateuser(CommonUtils.loginUsername());
         tmenu.setId(StringTool.getTablePrimaryKey());
         tmenu.setNote(note);
         List<TBaseMenu> query = this.tBaseMenuDao.queryAll(new Criterion[]{Restrictions.eq("menuname", tmenu.getMenuname())});
         if (query.size() != 0) {
            return 2;
         }

         this.tBaseMenuDao.save(tmenu);
      }

      if (EroleFlag.CONSOLE.getFlag().equals(menu.getFlag())) {
         TBaseRolemenu rm = null;

         for(TBaseMenu tmenu : subMenu) {
            rm = new TBaseRolemenu();
            rm.setId(UUID.randomUUID().toString());
            rm.setMenuid(tmenu.getId());
            rm.setRoleid("1");
            rm.setCreatetime(now);
            rm.setCreateuser(CommonUtils.loginUsername());
            this.tBaseRolemenuDao.save(rm);
         }
      }

      return a;
   }

   public void remove(String note) {
      this.tBaseMenuDao.remove(new Criterion[]{Restrictions.eq("note", note)});
   }

   public TBaseMenu queryMenueByid(String id) {
      TBaseMenu queryUnique = (TBaseMenu)this.tBaseMenuDao.queryUnique(new Criterion[]{Restrictions.eq("id", id)});
      if (null != queryUnique.getParentid()) {
         TBaseMenu queryUnique2 = (TBaseMenu)this.tBaseMenuDao.queryUnique(new Criterion[]{Restrictions.eq("id", queryUnique.getParentid())});
         queryUnique.setParentname(queryUnique2.getMenuname());
      }

      return queryUnique;
   }

   public int add(TBaseMenu menu, List<TBaseMenu> subMenu) {
      menu.setId(StringTool.getTablePrimaryKey());
      menu.getNote();
      Date now = new Date();
      menu.setCreatetime(now);
      menu.setCreateuser(CommonUtils.loginUsername());
      List<TBaseMenu> queryAll = this.tBaseMenuDao.queryAll(new Criterion[]{Restrictions.eq("menuname", menu.getMenuname())});
      if (queryAll.size() != 0) {
         return 1;
      } else {
         for(TBaseMenu tmenu : subMenu) {
            tmenu.setParentid(menu.getId());
            tmenu.setCreatetime(now);
            tmenu.setCreateuser(CommonUtils.loginUsername());
            tmenu.setId(StringTool.getTablePrimaryKey());
            List<TBaseMenu> query = this.tBaseMenuDao.queryAll(new Criterion[]{Restrictions.eq("menuname", tmenu.getMenuname())});
            if (query.size() != 0) {
               return 2;
            }

            this.tBaseMenuDao.save(tmenu);
         }

         this.tBaseMenuDao.save(menu);
         if (EroleFlag.CONSOLE.getFlag().equals(menu.getFlag())) {
            TBaseRolemenu rm = new TBaseRolemenu();
            rm.setMenuid(menu.getId());
            rm.setRoleid("1");
            rm.setId(StringTool.getTablePrimaryKey());
            this.tBaseRolemenuDao.save(rm);

            for(TBaseMenu tmenu : subMenu) {
               rm = new TBaseRolemenu();
               rm.setMenuid(tmenu.getId());
               rm.setRoleid("1");
               rm.setId(StringTool.getTablePrimaryKey());
               rm.setCreatetime(now);
               rm.setCreateuser(CommonUtils.loginUsername());
               this.tBaseRolemenuDao.save(rm);
            }
         }

         return 0;
      }
   }
}
