package com.chenyang.nse.bussiness.service.core.impl;

import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.chenyang.nse.bussiness.entity.vo.DataScopeEntity;
import com.chenyang.nse.bussiness.entity.vo.Field;
import com.chenyang.nse.bussiness.entity.vo.ReturnInterfaceDate;
import com.chenyang.nse.bussiness.entity.vo.Scope;
import com.chenyang.nse.bussiness.entity.vo.TableInfo;
import com.chenyang.nse.bussiness.init.StaticDatasPool;
import com.chenyang.nse.bussiness.service.core.DataSecurityControlledAssetService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class DataSecurityControlledAssetServiceImpl implements DataSecurityControlledAssetService {
   public List<String> getClassifyInfos(List<Map<String, String>> list) {
      new HashMap();
      new ArrayList();
      new ArrayList();
      new ArrayList();
      if (list != null && list.size() != 0 && list.get(0) != null) {
         String dbip = (String)((Map)list.get(0)).get("dbip");
         String dbport = (String)((Map)list.get(0)).get("dbport");
         String dbtype = (String)((Map)list.get(0)).get("dbtype");
         List<ReturnInterfaceDate> columnAndClassifyAndLevelAndAreaRelationList = StaticDatasPool.columnAndClassifyAndLevelAndAreaRelationList;
         String ipAndPortAndTypeAndSchema = null;
         new ReturnInterfaceDate();
         List<ReturnInterfaceDate> returnInterfaceDateArrayList = new ArrayList();

         for(ReturnInterfaceDate line : columnAndClassifyAndLevelAndAreaRelationList) {
            ipAndPortAndTypeAndSchema = dbip + dbport + dbtype;
            if (ipAndPortAndTypeAndSchema.equals(line.getDatabaseIp() + line.getDatabasePort() + line.getDatabaseType())) {
               returnInterfaceDateArrayList.add(line);
            }
         }

         List<String> sensitiveLevelList = new ArrayList();

         for(ReturnInterfaceDate line : returnInterfaceDateArrayList) {
            for(Field field : line.getField()) {
               for(TableInfo tableInfo : field.getTableInfos()) {
                  if (StringUtils.isNotBlank(tableInfo.getSensitiveLevel())) {
                     sensitiveLevelList.add(tableInfo.getSensitiveLevel());
                  }
               }
            }
         }

         return (List)sensitiveLevelList.stream().distinct().collect(Collectors.toList());
      } else {
         return null;
      }
   }

   public Map<String, List<DataScopeEntity>> getClassifyInfos(List<Map<String, String>> list, String schemaName, String tableName) {
      Map<String, List<DataScopeEntity>> result = new HashMap();
      List<DataScopeEntity> fieldSensitiveBySchemaAndTableAndColumn = new ArrayList();
      List<DataScopeEntity> scopeNames = new ArrayList();
      List<DataScopeEntity> dataareaNameBySchemaAndTable = new ArrayList();
      if (list != null && list.size() != 0 && list.get(0) != null) {
         String dbip = (String)((Map)list.get(0)).get("dbip");
         String dbport = (String)((Map)list.get(0)).get("dbport");
         String dbtype = (String)((Map)list.get(0)).get("dbtype");
         List<ReturnInterfaceDate> columnAndClassifyAndLevelAndAreaRelationList = StaticDatasPool.columnAndClassifyAndLevelAndAreaRelationList;
         String ipAndPortAndTypeAndSchema = null;
         ReturnInterfaceDate returnInterfaceDate = new ReturnInterfaceDate();

         for(ReturnInterfaceDate line : columnAndClassifyAndLevelAndAreaRelationList) {
            ipAndPortAndTypeAndSchema = dbip + dbport + dbtype + schemaName;
            if (ipAndPortAndTypeAndSchema.equals(line.getDatabaseIp() + line.getDatabasePort() + line.getDatabaseType() + line.getSchemaName())) {
               returnInterfaceDate = line;
               break;
            }
         }

         if (returnInterfaceDate != null && returnInterfaceDate.getField() != null) {
            for(Field field : returnInterfaceDate.getField()) {
               if (field.getTableName().equals(tableName)) {
                  for(TableInfo tableInfo : field.getTableInfos()) {
                     String columnName = tableInfo.getColumnName();
                     String sensitiveLevel = tableInfo.getSensitiveLevel();
                     if (StringUtils.isNotBlank(sensitiveLevel)) {
                        DataScopeEntity dataScopeEntity = new DataScopeEntity();
                        dataScopeEntity.setSchemaName(schemaName);
                        dataScopeEntity.setTableName(tableName);
                        dataScopeEntity.setColumnName(columnName);
                        dataScopeEntity.setSensitiveLevel(sensitiveLevel);
                        dataScopeEntity.setIsAuto(tableInfo.getIsAuto());
                        fieldSensitiveBySchemaAndTableAndColumn.add(dataScopeEntity);
                     }

                     String dataAreaName = tableInfo.getDataAreaName();
                     if (StringUtils.isNotBlank(dataAreaName)) {
                        DataScopeEntity dataScopeEntity = new DataScopeEntity();
                        dataScopeEntity.setSchemaName(schemaName);
                        dataScopeEntity.setTableName(tableName);
                        dataScopeEntity.setColumnName(columnName);
                        dataScopeEntity.setDataareaName(dataAreaName);
                        dataareaNameBySchemaAndTable.add(dataScopeEntity);
                     }

                     if (tableInfo.getScopes() != null && tableInfo.getScopes().size() > 0 && tableInfo.getScopes().get(0) != null) {
                        for(Scope scope : tableInfo.getScopes()) {
                           String scopeName = scope.getScopeName();
                           if (StringUtils.isNotBlank(scopeName)) {
                              DataScopeEntity dataScopeEntity = new DataScopeEntity();
                              dataScopeEntity.setSchemaName(schemaName);
                              dataScopeEntity.setTableName(tableName);
                              dataScopeEntity.setColumnName(columnName);
                              dataScopeEntity.setScopeName(scopeName);
                              dataScopeEntity.setIsAuto(scope.getIsAuto());
                              scopeNames.add(dataScopeEntity);
                           }
                        }
                     }
                  }
               }
            }

            result.put("dataareas", dataareaNameBySchemaAndTable);
            result.put("fieldSensitives", fieldSensitiveBySchemaAndTableAndColumn);
            result.put("scopeNames", scopeNames);
            return result;
         } else {
            result.put("dataareas", null);
            result.put("fieldSensitives", null);
            result.put("scopeNames", new ArrayList());
            return result;
         }
      } else {
         return null;
      }
   }
}
