package com.chenyang.nse.bussiness.service.core.impl;

import com.chenyang.nse.bussiness.bean.Column;
import com.chenyang.nse.bussiness.config.PropertiesLoaderUtils;
import com.chenyang.nse.bussiness.dao.table.core.TCoreDatasystemDao;
import com.chenyang.nse.bussiness.dao.table.core.encryption.ColumnPrimaryKeyInfoDao;
import com.chenyang.nse.bussiness.dao.table.core.encryption.TCoreEncryptionTypeFieldDao;
import com.chenyang.nse.bussiness.entity.db.PrimaryKeyInfo;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreDatasystem;
import com.chenyang.nse.bussiness.entity.orm.table.core.encryption.ColumnPrimaryKeyInfo;
import com.chenyang.nse.bussiness.entity.orm.table.core.encryption.TCoreEncryptionTypeField;
import com.chenyang.nse.bussiness.entity.vo.encyption.EncryptionConfigVO;
import com.chenyang.nse.bussiness.entity.vo.maskingtask.ColumnInfoVO;
import com.chenyang.nse.bussiness.enumeration.EdbType;
import com.chenyang.nse.bussiness.service.core.DataSystemService;
import com.chenyang.nse.bussiness.service.core.SwitchFieldService;
import com.chenyang.nse.bussiness.service.core.encryption.EncryptionConfigService;
import com.chenyang.nse.bussiness.service.core.encryption.TCoreEncryptionService;
import com.chenyang.nse.bussiness.service.core.encryption.impl.TCoreEncryptionContext;
import com.chenyang.nse.bussiness.service.core.strategy.MaksingAppDataRuleService;
import com.chenyang.nse.bussiness.tools.dataprocess.ApplicationContextProvider;
import com.chenyang.nse.bussiness.tools.dataprocess.NewLoadingTask;
import com.chenyang.nse.bussiness.tools.encryption.EncProvider;
import com.chenyang.nse.bussiness.tools.encryption.EncUtils;
import com.chenyang.nse.bussiness.tools.es.EsUtil;
import com.chenyang.nse.bussiness.tools.jdbc.JdbcTool;
import com.chenyang.nse.bussiness.tools.jdbc.MongodbTool;
import com.chenyang.nse.bussiness.tools.logger.LoggerBuilder;
import com.chenyang.nse.bussiness.tools.propertyutil.PropertyGhcaUtil;
import com.chenyang.nse.bussiness.tools.string.AesTool;
import com.chenyang.nse.bussiness.tools.utils.GHCAUtils;
import com.mongodb.MongoClient;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.UpdateOptions;
import java.io.File;
import java.io.IOException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.frameworkset.elasticsearch.client.ClientInterface;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;

@Service
public class SwitchFieldServiceImpl implements SwitchFieldService {
   private String copySuffix = "";
   private String initialSuffix = "";
   private String cipherSuffix = "";
   private String mongodbpk = "";
   @Autowired
   @Qualifier("TCoreEncryptionContext")
   TCoreEncryptionService tCoreEncryptionService;
   @Autowired
   EncryptionConfigService encryptionConfigService;
   @Autowired
   MaksingAppDataRuleService maksingAppDataRuleService;
   @Autowired
   DataSystemService dataSystemService;
   protected Logger logger = LoggerFactory.getLogger(this.getClass());
   @Autowired
   protected TCoreDatasystemDao tCoreDatasystemDao;
   @Autowired
   protected TCoreEncryptionTypeFieldDao tCoreEncryptionTypeFieldDao;
   @Autowired
   protected ColumnPrimaryKeyInfoDao columnPrimaryKeyInfoDao;
   @Autowired
   protected JdbcTemplate jdbcTemplate;

   public SwitchFieldServiceImpl() {
      this.copySuffix = PropertyGhcaUtil.copySuffix;
      this.initialSuffix = PropertyGhcaUtil.initialSuffix;
      this.cipherSuffix = PropertyGhcaUtil.cipherSuffix;
      this.mongodbpk = PropertyGhcaUtil.mongodbpk;
   }

   public List<TCoreEncryptionTypeField> switchFieldAfterEncryption(String projectId, String dataSystemId, String schema, String tableName, StringBuilder msg) {
      String loggerPath = System.getProperty("user.dir") + File.separator + "encryprocesslog" + File.separator + projectId + File.separator + dataSystemId;
      ch.qos.logback.classic.Logger logger = (new LoggerBuilder()).getLogger(loggerPath, schema + "." + tableName);
      List<TCoreEncryptionTypeField> tCoreEncryptionTypeFieldList = new ArrayList();
      List<String> pkFlags = new ArrayList();
      List<String> pkCols = new ArrayList();
      List<String> colSizes = new ArrayList();
      TCoreDatasystem datasystem = this.getDatasystem(dataSystemId);
      Boolean bb = true;
      if (!datasystem.getDbtype().equals(EdbType.ORACLE.toString())) {
         bb = false;
      }

      Boolean bbb = true;
      if (!datasystem.getDbtype().equals(EdbType.POSTGRESQL.toString()) && !datasystem.getDbtype().equals(EdbType.GAUSS.toString())) {
         bbb = false;
      }

      Boolean isGreenplum = true;
      if (!datasystem.getDbtype().equals(EdbType.GREENPLUM.toString())) {
         isGreenplum = false;
      }

      Boolean SQBoolean = true;
      if (!datasystem.getDbtype().equals(EdbType.MSSQLSERVER.toString())) {
         SQBoolean = false;
      }

      Boolean DMBoolean = true;
      if (!datasystem.getDbtype().equals(EdbType.DM.toString())) {
         DMBoolean = false;
      }

      Boolean KBBoolean = true;
      if (!datasystem.getDbtype().equals(EdbType.KINGBASE.toString())) {
         KBBoolean = false;
      }

      Boolean isHivetdh = true;
      if (!datasystem.getDbtype().equals(EdbType.HIVE_TDH.toString())) {
         isHivetdh = false;
      }

      List<TCoreEncryptionTypeField> fields = this.getFields(dataSystemId, schema, tableName, "1");
      logger.info("fields.size=[{}]", fields.size());
      if (fields.size() == 0) {
         return tCoreEncryptionTypeFieldList;
      } else {
         Connection srCon = null;

         try {
            Connection conn = JdbcTool.getConnection(datasystem);
            Throwable var23 = null;

            try {
               Statement stmt = conn.createStatement();
               Throwable var25 = null;

               try {
                  srCon = conn;

                  for(TCoreEncryptionTypeField field : fields) {
                     try {
                        List<ColumnPrimaryKeyInfo> columnPrimaryKeyInfoList = this.columnPrimaryKeyInfoDao.queryAll(new Criterion[]{Restrictions.eq("datasystem_id", dataSystemId), Restrictions.eq("tschema", schema), Restrictions.eq("tname", tableName)});
                        boolean ispk = false;
                        boolean isupk = false;
                        if (columnPrimaryKeyInfoList != null && columnPrimaryKeyInfoList.size() != 0) {
                           String pks = ((ColumnPrimaryKeyInfo)columnPrimaryKeyInfoList.get(0)).getPrimary_key_columns();
                           String[] primaryKeys = pks.split(",");
                           List pklist = Arrays.asList(primaryKeys);
                           if (pklist.contains(field.getTable_field_id())) {
                              if (((ColumnPrimaryKeyInfo)columnPrimaryKeyInfoList.get(0)).getFlag() == null || !((ColumnPrimaryKeyInfo)columnPrimaryKeyInfoList.get(0)).getFlag().equals("1")) {
                                 ispk = true;
                              }

                              if ("1".equals(((ColumnPrimaryKeyInfo)columnPrimaryKeyInfoList.get(0)).getFlag())) {
                                 isupk = true;
                              }
                           }
                        }

                        String primaryKeyFlag = "0";
                        String primary_key_columns = "";
                        String primary_key_col = "";
                        List<ColumnInfoVO> allColumns = this.maksingAppDataRuleService.queryColumnInfo(field.getDatasystem_id(), field.getTschemas(), field.getNames());

                        for(ColumnInfoVO allColumn : allColumns) {
                           if (allColumn.getPrimarykey().equals("1")) {
                              primary_key_columns = primary_key_columns + allColumn.getColumnname() + ",";
                              if (DMBoolean) {
                                 primary_key_col = primary_key_columns + allColumn.getColumnname();
                              } else {
                                 primary_key_col = "\"" + primary_key_columns + allColumn.getColumnname() + "\",";
                              }
                           }
                        }

                        if (!"".equals(primary_key_col) && primary_key_col.charAt(primary_key_col.length() - 1) == ',') {
                           primary_key_col = primary_key_col.substring(0, primary_key_col.length() - 1);
                        }

                        if (!"".equals(primary_key_columns)) {
                           if (primary_key_columns.charAt(primary_key_columns.length() - 1) == ',') {
                              primary_key_columns = primary_key_columns.substring(0, primary_key_columns.length() - 1);
                           }

                           String[] fileds = primary_key_columns.split(",");
                           if (fileds.length > 0) {
                              for(String filed11 : fileds) {
                                 if (field.getTable_field_id().equals(filed11)) {
                                    primaryKeyFlag = "1";
                                 }
                              }
                           }
                        }

                        pkFlags.add(primaryKeyFlag);
                        pkCols.add(primary_key_col);
                        String columnName = field.getTable_field_id();
                        String columnType = field.getColumn_type();
                        int columnSize = 0;
                        String columnSizeSql = "";
                        if (bb) {
                           columnSizeSql = "SELECT \"" + columnName + "\" FROM \"" + schema + "\".\"" + tableName + "\" WHERE 1=2";
                        } else if (bbb) {
                           columnSizeSql = "SELECT \"" + columnName + "\" FROM \"" + schema + "\".\"" + tableName + "\" WHERE 1=2";
                        } else if (isGreenplum) {
                           columnSizeSql = "SELECT \"" + columnName + "\" FROM \"" + schema + "\".\"" + tableName + "\" WHERE 1=2";
                        } else if (isHivetdh) {
                           columnSizeSql = "SELECT " + columnName + " FROM " + schema + "." + tableName + " WHERE 1=2";
                        } else if (SQBoolean) {
                           columnSizeSql = this.columnSizeSql(schema, tableName, columnName);
                        } else if (DMBoolean) {
                           columnSizeSql = "SELECT \"" + columnName + "\" FROM \"" + schema + "\".\"" + tableName + "\" WHERE 1=2";
                        } else if (KBBoolean) {
                           columnSizeSql = "SELECT \"" + columnName + "\" FROM \"" + schema + "\".\"" + tableName + "\" WHERE 1=2";
                        } else {
                           columnSizeSql = this.columnSizeSql(schema, tableName, columnName);
                        }

                        ResultSet rs = stmt.executeQuery(columnSizeSql);
                        Throwable alterColumnToInitialSql = null;

                        try {
                           columnSize = rs.getMetaData().getColumnDisplaySize(1);
                        } catch (Throwable var139) {
                           alterColumnToInitialSql = var139;
                           throw var139;
                        } finally {
                           if (rs != null) {
                              if (alterColumnToInitialSql != null) {
                                 try {
                                    rs.close();
                                 } catch (Throwable var136) {
                                    alterColumnToInitialSql.addSuppressed(var136);
                                 }
                              } else {
                                 rs.close();
                              }
                           }

                        }

                        colSizes.add(columnSize + "");
                        String res = this.checkEncryption(datasystem, field.getTschemas(), field.getNames(), field.getTable_field_id(), field.getEncryption_secretkey_id(), field.getIslike(), field.getKeepfirst(), field.getEncdigit(), field.getTwoindex());
                        if (!"ok".equals(res)) {
                           logger.error(String.format("列%s.%s.%s加密替换校验失败。", schema, tableName, field.getTable_field_id()));
                           this.updateFieldFlag(field.getId(), "12");
                           tCoreEncryptionTypeFieldList.add(field);
                        } else {
                           String alterColumnToInitialSqlNew = "";
                           if (bb) {
                              alterColumnToInitialSqlNew = "ALTER TABLE \"" + schema + "\".\"" + tableName + "\"  RENAME COLUMN \"" + columnName + "\" TO \"" + columnName + this.initialSuffix + "\"";
                           } else if (bbb) {
                              alterColumnToInitialSqlNew = "ALTER TABLE \"" + schema + "\".\"" + tableName + "\"  RENAME COLUMN \"" + columnName + "\" TO \"" + columnName + this.initialSuffix + "\"";
                           } else if (isGreenplum) {
                              alterColumnToInitialSqlNew = "ALTER TABLE \"" + schema + "\".\"" + tableName + "\"  RENAME COLUMN \"" + columnName + "\" TO \"" + columnName + this.initialSuffix + "\"";
                           } else if (isHivetdh) {
                              alterColumnToInitialSqlNew = "ALTER TABLE " + schema + "." + tableName + "  change " + columnName + " " + columnName + this.initialSuffix + " " + columnType + "(" + field.getColumn_size() + ")";
                           } else if (SQBoolean) {
                              alterColumnToInitialSqlNew = "EXEC sp_rename '[" + schema + "].[" + tableName + "].[" + columnName + "]', '" + columnName + this.initialSuffix + "', 'COLUMN'";
                           } else if (DMBoolean) {
                              alterColumnToInitialSqlNew = "ALTER TABLE \"" + schema + "\".\"" + tableName + "\"  alter column \"" + columnName + "\" rename to \"" + columnName + this.initialSuffix + "\"";
                           } else if (KBBoolean) {
                              alterColumnToInitialSqlNew = "ALTER TABLE \"" + schema + "\".\"" + tableName + "\"  RENAME COLUMN \"" + columnName + "\" TO \"" + columnName + this.initialSuffix + "\"";
                           } else {
                              alterColumnToInitialSqlNew = this.alterColumnToInitialSql(schema, tableName, columnName, columnType, columnSize);
                           }

                           stmt.executeUpdate(alterColumnToInitialSqlNew);
                           if (primaryKeyFlag.equals("1") && !"".equals(primary_key_columns)) {
                              String primaryKeysqlIndex = "";
                              String primaryKeysql = "";
                              String primaryKeysql1 = "";
                              if (bb) {
                                 primaryKeysql = "ALTER TABLE \"" + schema + "\".\"" + tableName + "\"  drop primary key";
                              } else if (bbb) {
                                 primaryKeysql = "ALTER TABLE \"" + schema + "\".\"" + tableName + "\"  DROP CONSTRAINT \"" + tableName + "_pkey\"";
                              } else if (isGreenplum) {
                                 primaryKeysql = "ALTER TABLE \"" + schema + "\".\"" + tableName + "\"  DROP CONSTRAINT \"" + tableName + "_pkey\"";
                              } else if (SQBoolean) {
                                 List<PrimaryKeyInfo> primarykeyInfo = PrimaryKeyInfo.getPrimaryKeyInfoByConnection(conn, schema, tableName);
                                 StringBuilder primaryKeysqlBuilder = new StringBuilder();
                                 if (null != primarykeyInfo && primarykeyInfo.size() > 0) {
                                    for(int i = 0; i < primarykeyInfo.size(); ++i) {
                                       primaryKeysql = "ALTER TABLE " + schema + "." + tableName + " DROP  Constraint " + ((PrimaryKeyInfo)primarykeyInfo.get(i)).getPkname() + " ";
                                       primaryKeysqlBuilder.append(primaryKeysql);
                                    }

                                    primaryKeysql = primaryKeysqlBuilder.toString();
                                 }
                              } else if (DMBoolean) {
                                 List<PrimaryKeyInfo> primarykeyInfo = PrimaryKeyInfo.getPrimaryKeyInfoByConnection(conn, schema, tableName);
                                 if (null != primarykeyInfo && primarykeyInfo.size() > 0) {
                                    for(int i = 0; i < primarykeyInfo.size(); ++i) {
                                       primaryKeysqlIndex = "create CLUSTER index \"" + schema + "_" + tableName + "_" + columnName + "_index\" on \"" + schema + "\".\"" + tableName + "\"(\"" + columnName + this.copySuffix + "\") ";
                                       primaryKeysql = "ALTER TABLE \"" + schema + "\".\"" + tableName + "\" DROP  Constraint \"" + ((PrimaryKeyInfo)primarykeyInfo.get(i)).getPkname() + "\"";
                                       primaryKeysql1 = "drop index \"" + schema + "\".\"" + schema + "_" + tableName + "_" + columnName + "_index\"";
                                       PreparedStatement preStatementKeyIndex = conn.prepareStatement(primaryKeysqlIndex);
                                       preStatementKeyIndex.executeUpdate();
                                       preStatementKeyIndex.close();

                                       try {
                                          PreparedStatement preStatementKey = conn.prepareStatement(primaryKeysql);
                                          preStatementKey.executeUpdate();
                                          preStatementKey.close();
                                       } catch (Exception var138) {
                                       }

                                       PreparedStatement preStatementKey1 = conn.prepareStatement(primaryKeysql1);
                                       preStatementKey1.executeUpdate();
                                       preStatementKey1.close();
                                    }
                                 }
                              } else if (!KBBoolean) {
                                 primaryKeysql = "alter table " + schema + "." + tableName + "  drop primary key";
                              } else {
                                 List<PrimaryKeyInfo> primarykeyInfo = PrimaryKeyInfo.getPrimaryKeyInfoByConnection(conn, schema, tableName);
                                 StringBuilder primaryKeysqlBuilder = new StringBuilder();
                                 if (null != primarykeyInfo && primarykeyInfo.size() > 0) {
                                    for(int i = 0; i < primarykeyInfo.size(); ++i) {
                                       primaryKeysql = "ALTER TABLE \"" + schema + "\".\"" + tableName + "\" DROP CONSTRAINT \"" + ((PrimaryKeyInfo)primarykeyInfo.get(i)).getPkname() + "\" ";
                                       primaryKeysqlBuilder.append(primaryKeysql);
                                    }

                                    primaryKeysql = primaryKeysqlBuilder.toString();
                                 }
                              }

                              if (!DMBoolean) {
                                 PreparedStatement preStatementKey = conn.prepareStatement(primaryKeysql);
                                 preStatementKey.executeUpdate();
                                 preStatementKey.close();
                              }
                           }

                           if (bb) {
                              columnSizeSql = "SELECT \"" + columnName + this.copySuffix + "\" FROM \"" + schema + "\".\"" + tableName + "\" WHERE 1=2";
                           } else if (bbb) {
                              columnSizeSql = "SELECT \"" + columnName + this.copySuffix + "\" FROM \"" + schema + "\".\"" + tableName + "\" WHERE 1=2";
                           } else if (isGreenplum) {
                              columnSizeSql = "SELECT \"" + columnName + this.copySuffix + "\" FROM \"" + schema + "\".\"" + tableName + "\" WHERE 1=2";
                           } else if (isHivetdh) {
                              columnSizeSql = "SELECT " + columnName + this.copySuffix + " FROM " + schema + "." + tableName + " WHERE 1=2";
                           } else if (SQBoolean) {
                              columnSizeSql = this.columnSizeSql(schema, tableName, columnName + this.copySuffix);
                           } else if (DMBoolean) {
                              columnSizeSql = "SELECT \"" + columnName + this.copySuffix + "\" FROM \"" + schema + "\".\"" + tableName + "\" WHERE 1=2";
                           } else if (KBBoolean) {
                              columnSizeSql = "SELECT \"" + columnName + this.copySuffix + "\" FROM \"" + schema + "\".\"" + tableName + "\" WHERE 1=2";
                           } else {
                              columnSizeSql = this.columnSizeSql(schema, tableName, columnName + this.copySuffix);
                           }

                           ResultSet rsNew = stmt.executeQuery(columnSizeSql);
                           Throwable var174 = null;

                           try {
                              columnSize = rsNew.getMetaData().getColumnDisplaySize(1);
                           } catch (Throwable var137) {
                              var174 = var137;
                              throw var137;
                           } finally {
                              if (rsNew != null) {
                                 if (var174 != null) {
                                    try {
                                       rsNew.close();
                                    } catch (Throwable var135) {
                                       var174.addSuppressed(var135);
                                    }
                                 } else {
                                    rsNew.close();
                                 }
                              }

                           }

                           boolean isNullable = true;
                           String columnDef = "";
                           String remarks = "";

                           for(ColumnInfoVO allColumn : allColumns) {
                              if (columnName.equals(allColumn.getColumnname())) {
                                 isNullable = "1".equalsIgnoreCase(allColumn.getNullable());
                                 columnDef = allColumn.getColumndef();
                                 remarks = allColumn.getRemarks();
                                 break;
                              }
                           }

                           String nullStr = "";
                           nullStr = !isupk ? "NULL" : "NOT NULL";
                           List<String> sqlList = new ArrayList();
                           String alterCopyToColumnSql = "";
                           String alterCopyToColumnSql1 = "";
                           if (bb) {
                              alterCopyToColumnSql = "ALTER TABLE \"" + schema + "\".\"" + tableName + "\"  RENAME COLUMN \"" + columnName + this.copySuffix + "\" TO \"" + columnName + "\"";
                              alterCopyToColumnSql1 = "ALTER TABLE \"" + schema + "\".\"" + tableName + "\" MODIFY \"" + columnName + "\" " + columnType + "(" + columnSize + " BYTE) ";
                              if (StringUtils.isNotBlank(columnDef)) {
                                 alterCopyToColumnSql1 = alterCopyToColumnSql1 + " DEFAULT " + columnDef + "";
                              }

                              if (isupk) {
                                 alterCopyToColumnSql1 = alterCopyToColumnSql1 + " not null";
                              }

                              sqlList.add(alterCopyToColumnSql);
                              sqlList.add(alterCopyToColumnSql1);
                           } else if (bbb) {
                              alterCopyToColumnSql = "ALTER TABLE \"" + schema + "\".\"" + tableName + "\"  RENAME COLUMN \"" + columnName + this.copySuffix + "\" TO \"" + columnName + "\"";
                              alterCopyToColumnSql1 = "ALTER TABLE \"" + schema + "\".\"" + tableName + "\"  ALTER COLUMN \"" + columnName + "\" TYPE " + columnType + "(" + columnSize + ")";
                              sqlList.add(alterCopyToColumnSql);
                              sqlList.add(alterCopyToColumnSql1);
                           } else if (isGreenplum) {
                              alterCopyToColumnSql = "ALTER TABLE \"" + schema + "\".\"" + tableName + "\"  RENAME COLUMN \"" + columnName + this.copySuffix + "\" TO \"" + columnName + "\"";
                              alterCopyToColumnSql1 = "ALTER TABLE \"" + schema + "\".\"" + tableName + "\"  ALTER COLUMN \"" + columnName + "\" TYPE " + columnType + "(" + columnSize + ")";
                              sqlList.add(alterCopyToColumnSql);
                              sqlList.add(alterCopyToColumnSql1);
                           } else if (SQBoolean) {
                              alterCopyToColumnSql = "EXEC sp_rename '[" + schema + "].[" + tableName + "].[" + columnName + this.copySuffix + "]', '" + columnName + "', 'COLUMN'";
                              alterCopyToColumnSql1 = "ALTER TABLE [" + schema + "].[" + tableName + "]  ALTER COLUMN [" + columnName + "] " + columnType + "(" + columnSize + ") ";
                              sqlList.add(alterCopyToColumnSql);
                              sqlList.add(alterCopyToColumnSql1);
                           } else if (DMBoolean) {
                              alterCopyToColumnSql = "ALTER TABLE \"" + schema + "\".\"" + tableName + "\"  alter column \"" + columnName + this.copySuffix + "\" rename to \"" + columnName + "\"";
                              alterCopyToColumnSql1 = "ALTER TABLE \"" + schema + "\".\"" + tableName + "\"  modify \"" + columnName + "\" " + columnType + "(" + columnSize + ")";
                              sqlList.add(alterCopyToColumnSql);
                              if (isupk) {
                                 alterCopyToColumnSql1 = alterCopyToColumnSql1 + " not null";
                              }

                              sqlList.add(alterCopyToColumnSql1);
                           } else if (KBBoolean) {
                              sqlList.add("ALTER TABLE \"" + schema + "\".\"" + tableName + "\"  RENAME COLUMN \"" + columnName + this.copySuffix + "\" TO \"" + columnName + "\"");
                              sqlList.add("ALTER TABLE \"" + schema + "\".\"" + tableName + "\"  ALTER COLUMN \"" + columnName + "\" TYPE " + columnType + "(" + columnSize + ")");
                              if (nullStr.equals("NOT NULL")) {
                                 sqlList.add("ALTER TABLE " + schema + "." + tableName + "  alter column " + columnName + " set " + nullStr + "");
                              }
                           } else if (isHivetdh) {
                              sqlList.add("ALTER TABLE " + schema + "." + tableName + "  change " + columnName + this.copySuffix + " " + columnName + " " + columnType + "(" + columnSize + ")");
                           } else {
                              alterCopyToColumnSql = this.alterCopyToColumnSql(schema, tableName, columnName, columnType, columnSize);
                              if (StringUtils.isNotBlank(columnDef)) {
                                 alterCopyToColumnSql = alterCopyToColumnSql + " DEFAULT '" + columnDef + "'";
                              }

                              if (StringUtils.isNotBlank(remarks)) {
                                 alterCopyToColumnSql = alterCopyToColumnSql + "  COMMENT '" + remarks + "'";
                              }

                              if (isupk) {
                                 alterCopyToColumnSql = alterCopyToColumnSql + " not null ";
                              }

                              sqlList.add(alterCopyToColumnSql);
                           }

                           if (StringUtils.isNotBlank(columnDef) && !bbb) {
                              if (SQBoolean) {
                                 sqlList.add("ALTER TABLE [" + schema + "].[" + tableName + "] ADD  DEFAULT " + columnDef + " FOR [" + columnName + "]");
                              } else if (DMBoolean) {
                                 sqlList.add("alter table " + schema + "." + tableName + " alter column " + columnName + " set default (" + columnDef + ")");
                              }
                           }

                           if (StringUtils.isNotBlank(remarks)) {
                              if (bb) {
                                 sqlList.add("COMMENT ON COLUMN " + schema + "." + tableName + "." + columnName + " IS '" + remarks + "'");
                              } else if (bbb) {
                                 sqlList.add("COMMENT ON COLUMN " + schema + "." + tableName + "." + columnName + " IS '" + remarks + "'");
                              } else if (SQBoolean) {
                                 sqlList.add("EXECUTE sp_updateextendedproperty N'MS_Description', N'" + remarks + "', N'SCHEMA', N'" + schema + "', N'TABLE', N'" + tableName + "', N'COLUMN', N'" + columnName + "' GO");
                              } else if (DMBoolean) {
                                 sqlList.add(" comment on column " + schema + "." + tableName + "." + columnName + " is '" + remarks + "'");
                              }
                           }

                           for(String s : sqlList) {
                              stmt.executeUpdate(s);
                           }

                           if (primaryKeyFlag.equals("1") && !"".equals(primary_key_columns)) {
                              String[] fileds = primary_key_columns.split(",");
                              if (fileds.length > 1) {
                                 String primaryKeysql111 = "";
                                 StringBuilder primaryKeysql333 = new StringBuilder();
                                 if (bb) {
                                    if (!"".equals(primary_key_col)) {
                                       primaryKeysql111 = "alter table \"" + schema + "\".\"" + tableName + "\"  add primary key (" + primary_key_col + ")";
                                    }
                                 } else if (bbb) {
                                    if (!"".equals(primary_key_col)) {
                                       primaryKeysql111 = "alter table \"" + schema + "\".\"" + tableName + "\"  add primary key (" + primary_key_col + ")";
                                    }
                                 } else if (isGreenplum) {
                                    if (!"".equals(primary_key_col)) {
                                       primaryKeysql111 = "alter table \"" + schema + "\".\"" + tableName + "\"  add primary key (" + primary_key_col + ")";
                                    }
                                 } else if (SQBoolean) {
                                    for(ColumnInfoVO allColumn : allColumns) {
                                       String substring = primary_key_columns.substring(0, primary_key_columns.length() - 1);
                                       String[] split = substring.split(",");

                                       for(String col : split) {
                                          if (col.equals(allColumn.getColumnname())) {
                                             primaryKeysql333.append("ALTER TABLE [" + schema + "].[" + tableName + "]  ALTER COLUMN [" + col + "] " + allColumn.getTypename() + "(" + allColumn.getColumnsize() + ") COLLATE Chinese_PRC_CI_AS NOT NULL ");
                                          }
                                       }
                                    }

                                    primaryKeysql111 = "alter table " + schema + "." + tableName + "  add primary key (" + primary_key_columns + ")";
                                 } else if (!DMBoolean) {
                                    if (KBBoolean) {
                                       primaryKeysql111 = "alter table \"" + schema + "\".\"" + tableName + "\"  add primary key (" + primary_key_columns + ")";
                                    } else {
                                       primaryKeysql111 = "alter table " + schema + "." + tableName + "  add primary key (" + primary_key_columns + ")";
                                    }
                                 } else if (!"".equals(primary_key_col)) {
                                    String[] arr1 = primary_key_col.split(",");
                                    List list = new ArrayList();

                                    for(int n = 0; n < arr1.length; ++n) {
                                       String s = arr1[n].trim();
                                       if (!list.contains(s)) {
                                          list.add(s);
                                       }
                                    }

                                    primary_key_col = StringUtils.strip(list.toString(), "[]");
                                    primaryKeysql111 = "alter table \"" + schema + "\".\"" + tableName + "\"  add primary key (" + primary_key_col + ")";
                                 }

                                 if (null != primaryKeysql333 && !"".equals(primaryKeysql333.toString())) {
                                    PreparedStatement preStatementKey333 = conn.prepareStatement(primaryKeysql333.toString());
                                    preStatementKey333.executeUpdate();
                                    preStatementKey333.close();
                                 }

                                 PreparedStatement preStatementKey111 = conn.prepareStatement(primaryKeysql111);
                                 preStatementKey111.executeUpdate();
                                 preStatementKey111.close();
                              } else {
                                 String primaryKeysql111 = "";
                                 StringBuilder primaryKeysql333 = new StringBuilder();
                                 if (bb) {
                                    primaryKeysql111 = "alter table \"" + schema + "\".\"" + tableName + "\"  add primary key (\"" + columnName + "\")";
                                 } else if (bbb) {
                                    primaryKeysql111 = "alter table \"" + schema + "\".\"" + tableName + "\"  add primary key (\"" + columnName + "\")";
                                 } else if (isGreenplum) {
                                    primaryKeysql111 = "alter table \"" + schema + "\".\"" + tableName + "\"  add primary key (\"" + columnName + "\")";
                                 } else if (!SQBoolean) {
                                    if (DMBoolean) {
                                       primaryKeysql111 = "alter table \"" + schema + "\".\"" + tableName + "\"  add primary key (\"" + columnName + "\")";
                                    } else if (KBBoolean) {
                                       primaryKeysql111 = "alter table \"" + schema + "\".\"" + tableName + "\"  add primary key (\"" + columnName + "\")";
                                    } else {
                                       primaryKeysql111 = "alter table " + schema + "." + tableName + "  add primary key (" + columnName + ")";
                                    }
                                 } else {
                                    for(ColumnInfoVO allColumn : allColumns) {
                                       if (columnName.equals(allColumn.getColumnname())) {
                                          primaryKeysql333.append("ALTER TABLE [" + schema + "].[" + tableName + "]  ALTER COLUMN [" + columnName + "] " + allColumn.getTypename() + "(" + allColumn.getColumnsize() + ") COLLATE Chinese_PRC_CI_AS NOT NULL ");
                                       }
                                    }

                                    primaryKeysql111 = "alter table " + schema + "." + tableName + "  add primary key (" + columnName + ")";
                                 }

                                 if (null != primaryKeysql333 && !"".equals(primaryKeysql333.toString())) {
                                    PreparedStatement preStatementKey333 = conn.prepareStatement(primaryKeysql333.toString());
                                    preStatementKey333.executeUpdate();
                                    preStatementKey333.close();
                                 }

                                 PreparedStatement preStatementKey111 = conn.prepareStatement(primaryKeysql111);
                                 preStatementKey111.executeUpdate();
                                 preStatementKey111.close();
                              }
                           }

                           this.updateFieldFlag(field.getId(), "5");
                        }
                     } catch (Exception e) {
                        logger.error(e.getMessage(), e);
                        msg.append(String.format("%s.%s.%s字段加载替换失败.", field.getTschemas(), field.getNames(), field.getTable_field_id()));
                        this.rollbackColumns(srCon, fields, this.initialSuffix, colSizes, pkFlags, pkCols, tCoreEncryptionTypeFieldList, datasystem);
                        this.updateFieldFlag(field.getId(), "9");
                     }
                  }
               } catch (Throwable var143) {
                  var25 = var143;
                  throw var143;
               } finally {
                  if (stmt != null) {
                     if (var25 != null) {
                        try {
                           stmt.close();
                        } catch (Throwable var134) {
                           var25.addSuppressed(var134);
                        }
                     } else {
                        stmt.close();
                     }
                  }

               }
            } catch (Throwable var145) {
               var23 = var145;
               throw var145;
            } finally {
               if (conn != null) {
                  if (var23 != null) {
                     try {
                        conn.close();
                     } catch (Throwable var133) {
                        var23.addSuppressed(var133);
                     }
                  } else {
                     conn.close();
                  }
               }

            }
         } catch (Exception var147) {
            this.rollbackColumns(srCon, fields, this.initialSuffix, colSizes, pkFlags, pkCols, tCoreEncryptionTypeFieldList, datasystem);
         }

         return tCoreEncryptionTypeFieldList;
      }
   }

   public List<TCoreEncryptionTypeField> switchFieldAfterDecryption(String projectId, String dataSystemId, String schema, String tableName, StringBuilder msg) {
      String loggerPath = System.getProperty("user.dir") + File.separator + "encryprocesslog" + File.separator + projectId + File.separator + dataSystemId;
      ch.qos.logback.classic.Logger logger = (new LoggerBuilder()).getLogger(loggerPath, schema + "." + tableName);
      List<TCoreEncryptionTypeField> tCoreEncryptionTypeFieldList = new ArrayList();
      List<String> pkFlags = new ArrayList();
      List<String> pkCols = new ArrayList();
      List<String> colSizes = new ArrayList();
      EncryptionConfigVO vo = new EncryptionConfigVO();
      vo.setTable_name(tableName);
      vo.setSchema(schema);
      vo.setDatasystem_id(dataSystemId);
      List<Map<String, String>> columnsBeforeEncryptionInfos = this.encryptionConfigService.queryEncryptionList(vo);
      TCoreDatasystem datasystem = this.getDatasystem(dataSystemId);
      Boolean bb = true;
      if (!datasystem.getDbtype().equals(EdbType.ORACLE.toString())) {
         bb = false;
      }

      Boolean bbb = true;
      if (!datasystem.getDbtype().equals(EdbType.POSTGRESQL.toString()) && !datasystem.getDbtype().equals(EdbType.GAUSS.toString())) {
         bbb = false;
      }

      Boolean isGreenplum = true;
      if (!datasystem.getDbtype().equals(EdbType.GREENPLUM.toString())) {
         isGreenplum = false;
      }

      Boolean SQBoolean = true;
      if (!datasystem.getDbtype().equals(EdbType.MSSQLSERVER.toString())) {
         SQBoolean = false;
      }

      Boolean DMBoolean = true;
      if (!datasystem.getDbtype().equals(EdbType.DM.toString())) {
         DMBoolean = false;
      }

      Boolean KBBoolean = true;
      if (!datasystem.getDbtype().equals(EdbType.KINGBASE.toString())) {
         KBBoolean = false;
      }

      Boolean isHivetdh = true;
      if (!datasystem.getDbtype().equals(EdbType.HIVE_TDH.toString())) {
         isHivetdh = false;
      }

      List<TCoreEncryptionTypeField> fields = this.getFields(dataSystemId, schema, tableName, "6");
      logger.info("fields.size=[{}]", fields.size());
      if (fields.size() == 0) {
         return tCoreEncryptionTypeFieldList;
      } else {
         Connection srConn = null;

         try {
            try {
               Connection conn = JdbcTool.getConnection(datasystem);
               Throwable var25 = null;

               try {
                  Statement stmt = conn.createStatement();
                  Throwable var27 = null;

                  try {
                     srConn = conn;

                     for(TCoreEncryptionTypeField field : fields) {
                        try {
                           List<ColumnPrimaryKeyInfo> columnPrimaryKeyInfoList = this.columnPrimaryKeyInfoDao.queryAll(new Criterion[]{Restrictions.eq("datasystem_id", dataSystemId), Restrictions.eq("tschema", schema), Restrictions.eq("tname", tableName)});
                           boolean ispk = false;
                           boolean isupk = false;
                           if (columnPrimaryKeyInfoList != null && columnPrimaryKeyInfoList.size() != 0) {
                              String pks = ((ColumnPrimaryKeyInfo)columnPrimaryKeyInfoList.get(0)).getPrimary_key_columns();
                              String[] primaryKeys = pks.split(",");
                              List pklist = Arrays.asList(primaryKeys);
                              if (pklist.contains(field.getTable_field_id())) {
                                 if (((ColumnPrimaryKeyInfo)columnPrimaryKeyInfoList.get(0)).getFlag() == null || !((ColumnPrimaryKeyInfo)columnPrimaryKeyInfoList.get(0)).getFlag().equals("1")) {
                                    ispk = true;
                                 }

                                 if ("1".equals(((ColumnPrimaryKeyInfo)columnPrimaryKeyInfoList.get(0)).getFlag())) {
                                    isupk = true;
                                 }
                              }
                           }

                           String primaryKeyFlag = "0";
                           String primary_key_columns = "";
                           String primary_key_col = "";
                           List<ColumnInfoVO> allColumns = this.maksingAppDataRuleService.queryColumnInfo(field.getDatasystem_id(), field.getTschemas(), field.getNames());

                           for(ColumnInfoVO allColumn : allColumns) {
                              if (allColumn.getPrimarykey().equals("1")) {
                                 primary_key_columns = primary_key_columns + allColumn.getColumnname() + ",";
                                 if (DMBoolean) {
                                    primary_key_col = primary_key_columns + allColumn.getColumnname();
                                 } else {
                                    primary_key_col = "\"" + primary_key_columns + allColumn.getColumnname() + "\",";
                                 }
                              }
                           }

                           if (!"".equals(primary_key_col) && primary_key_col.charAt(primary_key_col.length() - 1) == ',') {
                              primary_key_col = primary_key_col.substring(0, primary_key_col.length() - 1);
                           }

                           if (!"".equals(primary_key_columns)) {
                              if (primary_key_columns.charAt(primary_key_columns.length() - 1) == ',') {
                                 primary_key_columns = primary_key_columns.substring(0, primary_key_columns.length() - 1);
                              }

                              String[] fileds = primary_key_columns.split(",");
                              if (fileds.length > 0) {
                                 for(String filed11 : fileds) {
                                    if (field.getTable_field_id().equals(filed11)) {
                                       primaryKeyFlag = "1";
                                    }
                                 }
                              }
                           }

                           String columnName = field.getTable_field_id();
                           String columnType = field.getColumn_type();
                           List<Map<String, String>> columnSizeTmp = (List)columnsBeforeEncryptionInfos.stream().filter((x) -> ((String)x.get("fieldName")).equals(columnName)).collect(Collectors.toList());
                           int columnSize = 255;
                           String columnSizeStr = "255";
                           if (columnSizeTmp != null && columnSizeTmp.size() > 0) {
                              columnSizeStr = (String)((Map)columnSizeTmp.get(0)).get("columnSize");
                              Map<String, String> encryptionInfo = this.tCoreEncryptionService.queryEncryptionInfo(field.getEncryption_secretkey_id());
                              columnSizeStr = EncUtils.strColumnSize(datasystem.getDbtype(), columnType, columnSizeStr, field.getIslike(), primaryKeyFlag, (String)encryptionInfo.get("encryptionType"));
                           }

                           columnSize = Integer.parseInt(columnSizeStr);
                           pkFlags.add(primaryKeyFlag);
                           pkCols.add(primary_key_col);
                           colSizes.add(columnSize + "");
                           String res = this.checkDecryption(datasystem, field.getTschemas(), field.getNames(), field.getTable_field_id(), field.getEncryption_secretkey_id(), field.getIslike(), field.getKeepfirst(), field.getEncdigit(), field.getTwoindex());
                           if (!"ok".equals(res)) {
                              logger.error(String.format("列%s.%s.%s解密替换校验失败。", schema, tableName, field.getTable_field_id()));
                              this.updateFieldFlag(field.getId(), "11");
                              tCoreEncryptionTypeFieldList.add(field);
                           } else {
                              String alterColumnToCipherSql = "";
                              if (bb) {
                                 alterColumnToCipherSql = "ALTER TABLE \"" + schema + "\".\"" + tableName + "\"  RENAME COLUMN \"" + columnName + "\" TO \"" + columnName + this.cipherSuffix + "\"";
                              } else if (bbb) {
                                 alterColumnToCipherSql = "ALTER TABLE \"" + schema + "\".\"" + tableName + "\"  RENAME COLUMN \"" + columnName + "\" TO \"" + columnName + this.cipherSuffix + "\"";
                              } else if (isGreenplum) {
                                 alterColumnToCipherSql = "ALTER TABLE \"" + schema + "\".\"" + tableName + "\"  RENAME COLUMN \"" + columnName + "\" TO \"" + columnName + this.cipherSuffix + "\"";
                              } else if (isHivetdh) {
                                 alterColumnToCipherSql = "ALTER TABLE " + schema + "." + tableName + "  change " + columnName + " " + columnName + this.cipherSuffix + " " + columnType + "(" + columnSize + ")";
                              } else if (SQBoolean) {
                                 alterColumnToCipherSql = "EXEC sp_rename '[" + schema + "].[" + tableName + "].[" + columnName + "]', '" + columnName + this.cipherSuffix + "', 'COLUMN'";
                              } else if (DMBoolean) {
                                 alterColumnToCipherSql = "ALTER TABLE \"" + schema + "\".\"" + tableName + "\"  alter column \"" + columnName + "\" rename to \"" + columnName + this.cipherSuffix + "\"";
                              } else if (KBBoolean) {
                                 alterColumnToCipherSql = "ALTER TABLE \"" + schema + "\".\"" + tableName + "\"  RENAME COLUMN \"" + columnName + "\" TO \"" + columnName + this.cipherSuffix + "\"";
                              } else {
                                 alterColumnToCipherSql = this.alterColumnToCipherSql(schema, tableName, columnName, columnType, columnSize);
                              }

                              stmt.executeUpdate(alterColumnToCipherSql);
                              if (columnSizeTmp != null && columnSizeTmp.size() > 0) {
                                 columnSize = Integer.parseInt((String)((Map)columnSizeTmp.get(0)).get("columnSize"));
                              }

                              if (primaryKeyFlag.equals("1") && !"".equals(primary_key_columns)) {
                                 String primaryKeysqlIndex = "";
                                 String primaryKeysql = "";
                                 String primaryKeysql1 = "";
                                 if (bb) {
                                    primaryKeysql = "ALTER TABLE \"" + schema + "\".\"" + tableName + "\"  drop primary key";
                                 } else if (bbb) {
                                    primaryKeysql = "ALTER TABLE \"" + schema + "\".\"" + tableName + "\"  DROP CONSTRAINT \"" + tableName + "_pkey\"";
                                 } else if (isGreenplum) {
                                    primaryKeysql = "ALTER TABLE \"" + schema + "\".\"" + tableName + "\"  DROP CONSTRAINT \"" + tableName + "_pkey\"";
                                 } else if (SQBoolean) {
                                    List<PrimaryKeyInfo> primarykeyInfo = PrimaryKeyInfo.getPrimaryKeyInfoByConnection(conn, schema, tableName);
                                    StringBuilder primaryKeysqlBuilder = new StringBuilder();
                                    if (null != primarykeyInfo && primarykeyInfo.size() > 0) {
                                       for(int i = 0; i < primarykeyInfo.size(); ++i) {
                                          primaryKeysql = "ALTER TABLE " + schema + "." + tableName + " DROP  Constraint " + ((PrimaryKeyInfo)primarykeyInfo.get(i)).getPkname() + " ";
                                          primaryKeysqlBuilder.append(primaryKeysql);
                                       }

                                       primaryKeysql = primaryKeysqlBuilder.toString();
                                    }
                                 } else if (DMBoolean) {
                                    List<PrimaryKeyInfo> primarykeyInfo = PrimaryKeyInfo.getPrimaryKeyInfoByConnection(conn, schema, tableName);
                                    if (null != primarykeyInfo && primarykeyInfo.size() > 0) {
                                       for(int i = 0; i < primarykeyInfo.size(); ++i) {
                                          primaryKeysqlIndex = "create CLUSTER index \"" + schema + "_" + tableName + "_" + columnName + "_index\" on \"" + schema + "\".\"" + tableName + "\"(\"" + columnName + this.copySuffix + "\") ";
                                          primaryKeysql = "ALTER TABLE \"" + schema + "\".\"" + tableName + "\" DROP  Constraint \"" + ((PrimaryKeyInfo)primarykeyInfo.get(i)).getPkname() + "\"";
                                          primaryKeysql1 = "drop index \"" + schema + "\".\"" + schema + "_" + tableName + "_" + columnName + "_index\"";
                                          PreparedStatement preStatementKeyIndex = conn.prepareStatement(primaryKeysqlIndex);
                                          preStatementKeyIndex.executeUpdate();
                                          preStatementKeyIndex.close();

                                          try {
                                             PreparedStatement preStatementKey = conn.prepareStatement(primaryKeysql);
                                             preStatementKey.executeUpdate();
                                             preStatementKey.close();
                                          } catch (Exception var104) {
                                          }

                                          PreparedStatement preStatementKey1 = conn.prepareStatement(primaryKeysql1);
                                          preStatementKey1.executeUpdate();
                                          preStatementKey1.close();
                                       }
                                    }
                                 } else if (!KBBoolean) {
                                    primaryKeysql = "alter table " + schema + "." + tableName + "  drop primary key";
                                 } else {
                                    List<PrimaryKeyInfo> primarykeyInfo = PrimaryKeyInfo.getPrimaryKeyInfoByConnection(conn, schema, tableName);
                                    StringBuilder primaryKeysqlBuilder = new StringBuilder();
                                    if (null != primarykeyInfo && primarykeyInfo.size() > 0) {
                                       for(int i = 0; i < primarykeyInfo.size(); ++i) {
                                          primaryKeysql = "ALTER TABLE \"" + schema + "\".\"" + tableName + "\" DROP CONSTRAINT \"" + ((PrimaryKeyInfo)primarykeyInfo.get(i)).getPkname() + "\" ";
                                          primaryKeysqlBuilder.append(primaryKeysql);
                                       }

                                       primaryKeysql = primaryKeysqlBuilder.toString();
                                    }
                                 }

                                 if (!DMBoolean) {
                                    PreparedStatement preStatementKey = conn.prepareStatement(primaryKeysql);
                                    preStatementKey.executeUpdate();
                                    preStatementKey.close();
                                 }
                              }

                              boolean isNullable = true;
                              String columnDef = "";
                              String remarks = "";

                              for(ColumnInfoVO allColumn : allColumns) {
                                 if (columnName.equals(allColumn.getColumnname())) {
                                    isNullable = "1".equalsIgnoreCase(allColumn.getNullable());
                                    columnDef = allColumn.getColumndef();
                                    remarks = allColumn.getRemarks();
                                    break;
                                 }
                              }

                              String nullStr = "";
                              nullStr = !isupk ? "NULL" : "NOT NULL";
                              List<String> sqlList = new ArrayList();
                              String alterCopyToColumnSql = "";
                              String alterCopyToColumnSql1 = "";
                              if (bb) {
                                 alterCopyToColumnSql = "ALTER TABLE \"" + schema + "\".\"" + tableName + "\"  RENAME COLUMN \"" + columnName + this.copySuffix + "\" TO \"" + columnName + "\"";
                                 alterCopyToColumnSql1 = "ALTER TABLE \"" + schema + "\".\"" + tableName + "\" MODIFY \"" + columnName + "\" " + columnType + "(" + columnSize + " BYTE) ";
                                 if (StringUtils.isNotBlank(columnDef)) {
                                    alterCopyToColumnSql1 = alterCopyToColumnSql1 + " DEFAULT " + columnDef + "";
                                 }

                                 if (isupk) {
                                    alterCopyToColumnSql1 = alterCopyToColumnSql1 + " not null";
                                 }

                                 sqlList.add(alterCopyToColumnSql);
                                 sqlList.add(alterCopyToColumnSql1);
                              } else if (bbb) {
                                 alterCopyToColumnSql = "ALTER TABLE \"" + schema + "\".\"" + tableName + "\"  RENAME COLUMN \"" + columnName + this.copySuffix + "\" TO \"" + columnName + "\"";
                                 sqlList.add(alterCopyToColumnSql);
                                 if (columnSize == Integer.MAX_VALUE) {
                                    sqlList.add("ALTER TABLE \"" + schema + "\".\"" + tableName + "\"  ALTER COLUMN \"" + columnName + "\" TYPE " + columnType + "");
                                 } else {
                                    sqlList.add("ALTER TABLE \"" + schema + "\".\"" + tableName + "\"  ALTER COLUMN \"" + columnName + "\" TYPE " + columnType + "(" + columnSize + ")");
                                 }
                              } else if (isGreenplum) {
                                 alterCopyToColumnSql = "ALTER TABLE \"" + schema + "\".\"" + tableName + "\"  RENAME COLUMN \"" + columnName + this.copySuffix + "\" TO \"" + columnName + "\"";
                                 sqlList.add(alterCopyToColumnSql);
                                 if (columnSize == Integer.MAX_VALUE) {
                                    sqlList.add("ALTER TABLE \"" + schema + "\".\"" + tableName + "\"  ALTER COLUMN \"" + columnName + "\" TYPE " + columnType + "");
                                 } else {
                                    sqlList.add("ALTER TABLE \"" + schema + "\".\"" + tableName + "\"  ALTER COLUMN \"" + columnName + "\" TYPE " + columnType + "(" + columnSize + ")");
                                 }
                              } else if (isHivetdh) {
                                 alterCopyToColumnSql = "ALTER TABLE " + schema + "." + tableName + "  change " + columnName + this.copySuffix + " " + columnName + " " + columnType + "(" + columnSize + ")";
                                 sqlList.add(alterCopyToColumnSql);
                              } else if (SQBoolean) {
                                 alterCopyToColumnSql = "EXEC sp_rename '[" + schema + "].[" + tableName + "].[" + columnName + this.copySuffix + "]', '" + columnName + "', 'COLUMN'";
                                 alterCopyToColumnSql1 = "ALTER TABLE [" + schema + "].[" + tableName + "]  ALTER COLUMN [" + columnName + "] " + columnType + "(" + columnSize + ") ";
                                 sqlList.add(alterCopyToColumnSql);
                                 sqlList.add(alterCopyToColumnSql1);
                              } else if (DMBoolean) {
                                 alterCopyToColumnSql = "ALTER TABLE \"" + schema + "\".\"" + tableName + "\"  alter column \"" + columnName + this.copySuffix + "\" rename to \"" + columnName + "\"";
                                 alterCopyToColumnSql1 = "ALTER TABLE \"" + schema + "\".\"" + tableName + "\"  modify \"" + columnName + "\" " + columnType + "(" + columnSize + ")";
                                 sqlList.add(alterCopyToColumnSql);
                                 if (isupk) {
                                    alterCopyToColumnSql1 = alterCopyToColumnSql1 + " not null";
                                 }

                                 sqlList.add(alterCopyToColumnSql1);
                              } else if (KBBoolean) {
                                 sqlList.add("ALTER TABLE \"" + schema + "\".\"" + tableName + "\"  RENAME COLUMN \"" + columnName + this.copySuffix + "\" TO \"" + columnName + "\"");
                                 if (columnSize == Integer.MAX_VALUE) {
                                    sqlList.add("ALTER TABLE \"" + schema + "\".\"" + tableName + "\"  ALTER COLUMN \"" + columnName + "\" TYPE " + columnType + "");
                                 } else {
                                    sqlList.add("ALTER TABLE \"" + schema + "\".\"" + tableName + "\"  ALTER COLUMN \"" + columnName + "\" TYPE " + columnType + "(" + columnSize + ")");
                                 }

                                 if (nullStr.equals("NOT NULL")) {
                                    sqlList.add("ALTER TABLE " + schema + "." + tableName + "  alter column " + columnName + " set " + nullStr + "");
                                 }
                              } else {
                                 alterCopyToColumnSql = this.alterCopyToColumnSql(schema, tableName, columnName, columnType, columnSize);
                                 if (StringUtils.isNotBlank(columnDef)) {
                                    alterCopyToColumnSql = alterCopyToColumnSql + " DEFAULT '" + columnDef + "'";
                                 }

                                 if (StringUtils.isNotBlank(remarks)) {
                                    alterCopyToColumnSql = alterCopyToColumnSql + "  COMMENT '" + remarks + "'";
                                 }

                                 if (isupk) {
                                    alterCopyToColumnSql = alterCopyToColumnSql + " not null ";
                                 }

                                 sqlList.add(alterCopyToColumnSql);
                              }

                              if (StringUtils.isNotBlank(columnDef) && !bbb) {
                                 if (SQBoolean) {
                                    sqlList.add("ALTER TABLE [" + schema + "].[" + tableName + "] ADD  DEFAULT " + columnDef + " FOR [" + columnName + "]");
                                 } else if (DMBoolean) {
                                    sqlList.add("alter table " + schema + "." + tableName + " alter column " + columnName + " set default (" + columnDef + ")");
                                 }
                              }

                              if (StringUtils.isNotBlank(remarks)) {
                                 if (bb) {
                                    sqlList.add("COMMENT ON COLUMN " + schema + "." + tableName + "." + columnName + " IS '" + remarks + "'");
                                 } else if (bbb) {
                                    sqlList.add("COMMENT ON COLUMN " + schema + "." + tableName + "." + columnName + " IS '" + remarks + "'");
                                 } else if (SQBoolean) {
                                    sqlList.add("EXECUTE sp_updateextendedproperty N'MS_Description', N'" + remarks + "', N'SCHEMA', N'" + schema + "', N'TABLE', N'" + tableName + "', N'COLUMN', N'" + columnName + "' GO");
                                 } else if (DMBoolean) {
                                    sqlList.add(" comment on column " + schema + "." + tableName + "." + columnName + " is '" + remarks + "'");
                                 }
                              }

                              for(String s : sqlList) {
                                 stmt.executeUpdate(s);
                              }

                              if (primaryKeyFlag.equals("1") && !"".equals(primary_key_columns)) {
                                 String[] fileds = primary_key_columns.split(",");
                                 if (fileds.length > 1) {
                                    String primaryKeysql111 = "";
                                    StringBuilder primaryKeysql333 = new StringBuilder();
                                    if (bb) {
                                       if (!"".equals(primary_key_col)) {
                                          primaryKeysql111 = "alter table \"" + schema + "\".\"" + tableName + "\"  add primary key (" + primary_key_col + ")";
                                       }
                                    } else if (bbb) {
                                       if (!"".equals(primary_key_col)) {
                                          primaryKeysql111 = "alter table \"" + schema + "\".\"" + tableName + "\"  add primary key (" + primary_key_col + ")";
                                       }
                                    } else if (isGreenplum) {
                                       if (!"".equals(primary_key_col)) {
                                          primaryKeysql111 = "alter table \"" + schema + "\".\"" + tableName + "\"  add primary key (" + primary_key_col + ")";
                                       }
                                    } else if (SQBoolean) {
                                       for(ColumnInfoVO allColumn : allColumns) {
                                          String substring = primary_key_columns.substring(0, primary_key_columns.length() - 1);
                                          String[] split = substring.split(",");

                                          for(String col : split) {
                                             if (col.equals(allColumn.getColumnname())) {
                                                primaryKeysql333.append("ALTER TABLE [" + schema + "].[" + tableName + "]  ALTER COLUMN [" + col + "] " + allColumn.getTypename() + "(" + allColumn.getColumnsize() + ") COLLATE Chinese_PRC_CI_AS NOT NULL ");
                                             }
                                          }
                                       }

                                       primaryKeysql111 = "alter table " + schema + "." + tableName + "  add primary key (" + primary_key_columns + ")";
                                    } else if (!DMBoolean) {
                                       if (KBBoolean) {
                                          primaryKeysql111 = "alter table \"" + schema + "\".\"" + tableName + "\"  add primary key (" + primary_key_columns + ")";
                                       } else {
                                          primaryKeysql111 = "alter table " + schema + "." + tableName + "  add primary key (" + primary_key_columns + ")";
                                       }
                                    } else if (!"".equals(primary_key_col)) {
                                       String[] arr1 = primary_key_col.split(",");
                                       List list = new ArrayList();

                                       for(int n = 0; n < arr1.length; ++n) {
                                          String s = arr1[n].trim();
                                          if (!list.contains(s)) {
                                             list.add(s);
                                          }
                                       }

                                       primary_key_col = StringUtils.strip(list.toString(), "[]");
                                       primaryKeysql111 = "alter table \"" + schema + "\".\"" + tableName + "\"  add primary key (" + primary_key_col + ")";
                                    }

                                    if (null != primaryKeysql333 && !"".equals(primaryKeysql333.toString())) {
                                       PreparedStatement preStatementKey333 = conn.prepareStatement(primaryKeysql333.toString());
                                       preStatementKey333.executeUpdate();
                                       preStatementKey333.close();
                                    }

                                    PreparedStatement preStatementKey111 = conn.prepareStatement(primaryKeysql111);
                                    preStatementKey111.executeUpdate();
                                    preStatementKey111.close();
                                 } else {
                                    String primaryKeysql111 = "";
                                    StringBuilder primaryKeysql333 = new StringBuilder();
                                    if (bb) {
                                       primaryKeysql111 = "alter table \"" + schema + "\".\"" + tableName + "\"  add primary key (\"" + columnName + "\")";
                                    } else if (bbb) {
                                       primaryKeysql111 = "alter table \"" + schema + "\".\"" + tableName + "\"  add primary key (\"" + columnName + "\")";
                                    } else if (isGreenplum) {
                                       primaryKeysql111 = "alter table \"" + schema + "\".\"" + tableName + "\"  add primary key (\"" + columnName + "\")";
                                    } else if (!SQBoolean) {
                                       if (DMBoolean) {
                                          primaryKeysql111 = "alter table \"" + schema + "\".\"" + tableName + "\"  add primary key (\"" + columnName + "\")";
                                       } else if (KBBoolean) {
                                          primaryKeysql111 = "alter table \"" + schema + "\".\"" + tableName + "\"  add primary key (\"" + columnName + "\")";
                                       } else {
                                          primaryKeysql111 = "alter table " + schema + "." + tableName + "  add primary key (" + columnName + ")";
                                       }
                                    } else {
                                       for(ColumnInfoVO allColumn : allColumns) {
                                          if (columnName.equals(allColumn.getColumnname())) {
                                             primaryKeysql333.append("ALTER TABLE [" + schema + "].[" + tableName + "]  ALTER COLUMN [" + columnName + "] " + allColumn.getTypename() + "(" + allColumn.getColumnsize() + ") COLLATE Chinese_PRC_CI_AS NOT NULL ");
                                          }
                                       }

                                       primaryKeysql111 = "alter table " + schema + "." + tableName + "  add primary key (" + columnName + ")";
                                    }

                                    if (null != primaryKeysql333 && !"".equals(primaryKeysql333.toString())) {
                                       PreparedStatement preStatementKey333 = conn.prepareStatement(primaryKeysql333.toString());
                                       preStatementKey333.executeUpdate();
                                       preStatementKey333.close();
                                    }

                                    PreparedStatement preStatementKey111 = conn.prepareStatement(primaryKeysql111);
                                    preStatementKey111.executeUpdate();
                                    preStatementKey111.close();
                                 }
                              }

                              this.updateFieldFlag(field.getId(), "7");
                           }
                        } catch (Exception e) {
                           logger.error(e.getMessage(), e);
                           msg.append(String.format("%s.%s.%s字段解密替换失败.", field.getTschemas(), field.getNames(), field.getTable_field_id()));
                           this.rollbackColumns(srConn, fields, this.cipherSuffix, colSizes, pkFlags, pkCols, tCoreEncryptionTypeFieldList, datasystem);
                           this.updateFieldFlag(field.getId(), "10");
                        }
                     }
                  } catch (Throwable var106) {
                     var27 = var106;
                     throw var106;
                  } finally {
                     if (stmt != null) {
                        if (var27 != null) {
                           try {
                              stmt.close();
                           } catch (Throwable var103) {
                              var27.addSuppressed(var103);
                           }
                        } else {
                           stmt.close();
                        }
                     }

                  }
               } catch (Throwable var108) {
                  var25 = var108;
                  throw var108;
               } finally {
                  if (conn != null) {
                     if (var25 != null) {
                        try {
                           conn.close();
                        } catch (Throwable var102) {
                           var25.addSuppressed(var102);
                        }
                     } else {
                        conn.close();
                     }
                  }

               }
            } catch (Exception e) {
               logger.error(e.getMessage(), e);
               this.rollbackColumns(srConn, fields, this.cipherSuffix, colSizes, pkFlags, pkCols, tCoreEncryptionTypeFieldList, datasystem);
            }

            return tCoreEncryptionTypeFieldList;
         } finally {
            ;
         }
      }
   }

   public void switchFieldEncryptionProject(String projectId) {
      List<TCoreEncryptionTypeField> fields = this.getProjectFields(projectId, "1");
      this.logger.info("fields.size=[{}]", fields.size());
      new ArrayList();
      new ArrayList();
      if (fields.size() != 0) {
         for(TCoreEncryptionTypeField field : fields) {
            String dataSystemId = field.getDatasystem_id();
            String schema = field.getTschemas();
            TCoreDatasystem datasystem = this.getDatasystem(dataSystemId);
            Boolean bb = true;
            if (!datasystem.getDbtype().equals(EdbType.ORACLE.toString())) {
               bb = false;
            }

            Boolean bbb = true;
            if (!datasystem.getDbtype().equals(EdbType.POSTGRESQL.toString()) && !datasystem.getDbtype().equals(EdbType.GAUSS.toString())) {
               bbb = false;
            }

            Boolean SQBoolean = true;
            if (!datasystem.getDbtype().equals(EdbType.MSSQLSERVER.toString())) {
               SQBoolean = false;
            }

            Boolean DMBoolean = true;
            if (!datasystem.getDbtype().equals(EdbType.DM.toString())) {
               DMBoolean = false;
            }

            Boolean KBBoolean = true;
            if (!datasystem.getDbtype().equals(EdbType.KINGBASE.toString())) {
               KBBoolean = false;
            }

            String primaryKeyFlag = "0";
            String primary_key_columns = "";
            String primary_key_col = "";
            List<ColumnInfoVO> allColumns = this.maksingAppDataRuleService.queryColumnInfo(field.getDatasystem_id(), field.getTschemas(), field.getNames());

            for(ColumnInfoVO allColumn : allColumns) {
               if (allColumn.getPrimarykey().equals("1")) {
                  primary_key_columns = primary_key_columns + allColumn.getColumnname() + ",";
                  if (DMBoolean) {
                     primary_key_col = primary_key_columns + allColumn.getColumnname();
                  } else {
                     primary_key_col = "\"" + primary_key_columns + allColumn.getColumnname() + "\",";
                  }
               }
            }

            if (!"".equals(primary_key_col) && primary_key_col.charAt(primary_key_col.length() - 1) == ',') {
               primary_key_col = primary_key_col.substring(0, primary_key_col.length() - 1);
            }

            if (!"".equals(primary_key_columns)) {
               if (primary_key_columns.charAt(primary_key_columns.length() - 1) == ',') {
                  primary_key_columns = primary_key_columns.substring(0, primary_key_columns.length() - 1);
               }

               String[] fileds = primary_key_columns.split(",");
               if (fileds.length > 0) {
                  for(String filed11 : fileds) {
                     if (field.getTable_field_id().equals(filed11)) {
                        primaryKeyFlag = "1";
                     }
                  }
               }
            }

            try {
               Connection conn = JdbcTool.getConnection(datasystem);
               Throwable var140 = null;

               try {
                  Statement stmt = conn.createStatement();
                  Throwable var142 = null;

                  try {
                     String tableName = field.getNames();
                     String columnName = field.getTable_field_id();
                     String columnType = field.getColumn_type();
                     String columnSize = "";

                     try {
                        String columnSizeSql = "";
                        if (bb) {
                           columnSizeSql = "SELECT \"" + columnName + "\" FROM \"" + schema + "\".\"" + tableName + "\" WHERE 1=2";
                        } else if (bbb) {
                           columnSizeSql = "SELECT \"" + columnName + "\" FROM \"" + schema + "\".\"" + tableName + "\" WHERE 1=2";
                        } else if (SQBoolean) {
                           columnSizeSql = this.columnSizeSql(schema, tableName, columnName);
                        } else if (DMBoolean) {
                           columnSizeSql = "SELECT \"" + columnName + "\" FROM \"" + schema + "\".\"" + tableName + "\" WHERE 1=2";
                        } else if (KBBoolean) {
                           columnSizeSql = "SELECT \"" + columnName + "\" FROM \"" + schema + "\".\"" + tableName + "\" WHERE 1=2";
                        } else {
                           columnSizeSql = this.columnSizeSql(schema, tableName, columnName);
                        }

                        ResultSet rs = stmt.executeQuery(columnSizeSql);
                        Throwable columnSize1 = null;

                        try {
                           columnSize = "(" + rs.getMetaData().getColumnDisplaySize(1) + ")";
                           if (null != columnType && columnType.toLowerCase().contains("text")) {
                              columnSize = "";
                           }
                        } catch (Throwable var129) {
                           columnSize1 = var129;
                           throw var129;
                        } finally {
                           if (rs != null) {
                              if (columnSize1 != null) {
                                 try {
                                    rs.close();
                                 } catch (Throwable var124) {
                                    columnSize1.addSuppressed(var124);
                                 }
                              } else {
                                 rs.close();
                              }
                           }

                        }

                        String alterColumnToInitialSql = "";
                        if (bb) {
                           alterColumnToInitialSql = "ALTER TABLE \"" + schema + "\".\"" + tableName + "\"  RENAME COLUMN \"" + columnName + "\" TO \"" + columnName + this.initialSuffix + "\"";
                        } else if (bbb) {
                           alterColumnToInitialSql = "ALTER TABLE \"" + schema + "\".\"" + tableName + "\"  RENAME COLUMN \"" + columnName + "\" TO \"" + columnName + this.initialSuffix + "\"";
                        } else if (SQBoolean) {
                           alterColumnToInitialSql = "EXEC sp_rename '[" + schema + "].[" + tableName + "].[" + columnName + "]', '" + columnName + this.initialSuffix + "', 'COLUMN'";
                        } else if (DMBoolean) {
                           alterColumnToInitialSql = "ALTER TABLE \"" + schema + "\".\"" + tableName + "\"  alter column \"" + columnName + "\" rename to \"" + columnName + this.initialSuffix + "\"";
                        } else if (KBBoolean) {
                           alterColumnToInitialSql = "ALTER TABLE \"" + schema + "\".\"" + tableName + "\"  RENAME COLUMN \"" + columnName + "\" TO \"" + columnName + this.initialSuffix + "\"";
                        } else {
                           alterColumnToInitialSql = this.alterColumnToInitialSqlProject(schema, tableName, columnName, columnType, columnSize);
                        }

                        stmt.executeUpdate(alterColumnToInitialSql);
                        if (primaryKeyFlag.equals("1") && !"".equals(primary_key_columns)) {
                           String primaryKeysqlIndex = "";
                           String primaryKeysql = "";
                           String primaryKeysql1 = "";
                           if (bb) {
                              primaryKeysql = "ALTER TABLE \"" + schema + "\".\"" + tableName + "\"  drop primary key";
                           } else if (bbb) {
                              primaryKeysql = "ALTER TABLE \"" + schema + "\".\"" + tableName + "\"  DROP CONSTRAINT \"" + tableName + "_pkey\"";
                           } else if (SQBoolean) {
                              List<PrimaryKeyInfo> primarykeyInfo = PrimaryKeyInfo.getPrimaryKeyInfoByConnection(conn, schema, tableName);
                              StringBuilder primaryKeysqlBuilder = new StringBuilder();
                              if (null != primarykeyInfo && primarykeyInfo.size() > 0) {
                                 for(int i = 0; i < primarykeyInfo.size(); ++i) {
                                    primaryKeysql = "ALTER TABLE " + schema + "." + tableName + " DROP  Constraint " + ((PrimaryKeyInfo)primarykeyInfo.get(i)).getPkname() + " ";
                                    primaryKeysqlBuilder.append(primaryKeysql);
                                 }

                                 primaryKeysql = primaryKeysqlBuilder.toString();
                              }
                           } else if (DMBoolean) {
                              List<PrimaryKeyInfo> primarykeyInfo = PrimaryKeyInfo.getPrimaryKeyInfoByConnection(conn, schema, tableName);
                              if (null != primarykeyInfo && primarykeyInfo.size() > 0) {
                                 for(int i = 0; i < primarykeyInfo.size(); ++i) {
                                    primaryKeysqlIndex = "create CLUSTER index \"" + schema + "_" + tableName + "_" + columnName + "_index\" on \"" + schema + "\".\"" + tableName + "\"(\"" + columnName + this.copySuffix + "\") ";
                                    primaryKeysql = "ALTER TABLE \"" + schema + "\".\"" + tableName + "\" DROP  Constraint \"" + ((PrimaryKeyInfo)primarykeyInfo.get(i)).getPkname() + "\"";
                                    primaryKeysql1 = "drop index \"" + schema + "\".\"" + schema + "_" + tableName + "_" + columnName + "_index\"";
                                    PreparedStatement preStatementKeyIndex = conn.prepareStatement(primaryKeysqlIndex);
                                    preStatementKeyIndex.executeUpdate();
                                    preStatementKeyIndex.close();

                                    try {
                                       PreparedStatement preStatementKey = conn.prepareStatement(primaryKeysql);
                                       preStatementKey.executeUpdate();
                                       preStatementKey.close();
                                    } catch (Exception var126) {
                                    }

                                    PreparedStatement preStatementKey1 = conn.prepareStatement(primaryKeysql1);
                                    preStatementKey1.executeUpdate();
                                    preStatementKey1.close();
                                 }
                              }
                           } else if (!KBBoolean) {
                              primaryKeysql = "alter table " + schema + "." + tableName + "  drop primary key";
                           } else {
                              List<PrimaryKeyInfo> primarykeyInfo = PrimaryKeyInfo.getPrimaryKeyInfoByConnection(conn, schema, tableName);
                              StringBuilder primaryKeysqlBuilder = new StringBuilder();
                              if (null != primarykeyInfo && primarykeyInfo.size() > 0) {
                                 for(int i = 0; i < primarykeyInfo.size(); ++i) {
                                    primaryKeysql = "ALTER TABLE \"" + schema + "\".\"" + tableName + "\" DROP CONSTRAINT \"" + ((PrimaryKeyInfo)primarykeyInfo.get(i)).getPkname() + "\" ";
                                    primaryKeysqlBuilder.append(primaryKeysql);
                                 }

                                 primaryKeysql = primaryKeysqlBuilder.toString();
                              }
                           }

                           if (!DMBoolean) {
                              PreparedStatement preStatementKey = conn.prepareStatement(primaryKeysql);
                              preStatementKey.executeUpdate();
                              preStatementKey.close();
                           }
                        }

                        if (bb) {
                           columnSizeSql = "SELECT \"" + columnName + this.copySuffix + "\" FROM \"" + schema + "\".\"" + tableName + "\" WHERE 1=2";
                        } else if (bbb) {
                           columnSizeSql = "SELECT \"" + columnName + this.copySuffix + "\" FROM \"" + schema + "\".\"" + tableName + "\" WHERE 1=2";
                        } else if (SQBoolean) {
                           columnSizeSql = this.columnSizeSql(schema, tableName, columnName + this.copySuffix);
                        } else if (DMBoolean) {
                           columnSizeSql = "SELECT \"" + columnName + this.copySuffix + "\" FROM \"" + schema + "\".\"" + tableName + "\" WHERE 1=2";
                        } else if (KBBoolean) {
                           columnSizeSql = "SELECT \"" + columnName + this.copySuffix + "\" FROM \"" + schema + "\".\"" + tableName + "\" WHERE 1=2";
                        } else {
                           columnSizeSql = this.columnSizeSql(schema, tableName, columnName + this.copySuffix);
                        }

                        int columnSize1New = 0;
                        ResultSet rsNew1 = stmt.executeQuery(columnSizeSql);
                        Throwable var160 = null;

                        try {
                           columnSize1New = rsNew1.getMetaData().getColumnDisplaySize(1);
                           columnSize = "(" + rsNew1.getMetaData().getColumnDisplaySize(1) + ")";
                           if (null != columnType && columnType.toLowerCase().contains("text")) {
                              columnSize = "";
                           }
                        } catch (Throwable var127) {
                           var160 = var127;
                           throw var127;
                        } finally {
                           if (rsNew1 != null) {
                              if (var160 != null) {
                                 try {
                                    rsNew1.close();
                                 } catch (Throwable var123) {
                                    var160.addSuppressed(var123);
                                 }
                              } else {
                                 rsNew1.close();
                              }
                           }

                        }

                        String alterCopyToColumnSql = "";
                        String alterCopyToColumnSql1 = "";
                        if (bb) {
                           alterCopyToColumnSql = "ALTER TABLE \"" + schema + "\".\"" + tableName + "\"  RENAME COLUMN \"" + columnName + this.copySuffix + "\" TO \"" + columnName + "\"";
                           alterCopyToColumnSql1 = "ALTER TABLE \"" + schema + "\".\"" + tableName + "\" MODIFY (\"" + columnName + "\" " + columnType + "(" + columnSize1New + " BYTE))";
                        } else if (bbb) {
                           alterCopyToColumnSql = "ALTER TABLE \"" + schema + "\".\"" + tableName + "\"  RENAME COLUMN \"" + columnName + this.copySuffix + "\" TO \"" + columnName + "\"";
                           alterCopyToColumnSql1 = "ALTER TABLE \"" + schema + "\".\"" + tableName + "\"  ALTER COLUMN \"" + columnName + "\" TYPE " + columnType + columnSize;
                        } else if (SQBoolean) {
                           alterCopyToColumnSql = "EXEC sp_rename '[" + schema + "].[" + tableName + "].[" + columnName + this.copySuffix + "]', '" + columnName + "', 'COLUMN'";
                           alterCopyToColumnSql1 = "ALTER TABLE [" + schema + "].[" + tableName + "]  ALTER COLUMN [" + columnName + "] " + columnType + columnSize + "";
                        } else if (DMBoolean) {
                           alterCopyToColumnSql = "ALTER TABLE \"" + schema + "\".\"" + tableName + "\"  alter column \"" + columnName + this.copySuffix + "\" rename to \"" + columnName + "\"";
                           alterCopyToColumnSql1 = "ALTER TABLE \"" + schema + "\".\"" + tableName + "\"  modify \"" + columnName + "\" " + columnType + columnSize + "";
                        } else if (KBBoolean) {
                           alterCopyToColumnSql = "ALTER TABLE \"" + schema + "\".\"" + tableName + "\"  RENAME COLUMN \"" + columnName + this.copySuffix + "\" TO \"" + columnName + "\"";
                           alterCopyToColumnSql1 = "ALTER TABLE \"" + schema + "\".\"" + tableName + "\"  ALTER COLUMN \"" + columnName + "\" TYPE " + columnType + columnSize + "";
                        } else {
                           alterCopyToColumnSql = this.alterCopyToColumnSqlProject(schema, tableName, columnName, columnType, columnSize);
                        }

                        stmt.executeUpdate(alterCopyToColumnSql);
                        if (!"".equals(alterCopyToColumnSql1)) {
                           PreparedStatement preStatement1 = conn.prepareStatement(alterCopyToColumnSql1);
                           preStatement1.executeUpdate();
                           if (preStatement1 != null) {
                              try {
                                 preStatement1.close();
                              } catch (SQLException e) {
                                 e.printStackTrace();
                              }
                           }
                        }

                        if (primaryKeyFlag.equals("1") && !"".equals(primary_key_columns)) {
                           String[] fileds = primary_key_columns.split(",");
                           if (fileds.length > 1) {
                              String primaryKeysql111 = "";
                              StringBuilder primaryKeysql333 = new StringBuilder();
                              if (bb) {
                                 if (!"".equals(primary_key_col)) {
                                    primaryKeysql111 = "alter table \"" + schema + "\".\"" + tableName + "\"  add primary key (" + primary_key_col + ")";
                                 }
                              } else if (bbb) {
                                 if (!"".equals(primary_key_col)) {
                                    primaryKeysql111 = "alter table \"" + schema + "\".\"" + tableName + "\"  add primary key (" + primary_key_col + ")";
                                 }
                              } else if (!SQBoolean) {
                                 if (DMBoolean) {
                                    if (!"".equals(primary_key_col)) {
                                       primaryKeysql111 = "alter table \"" + schema + "\".\"" + tableName + "\"  add primary key (" + primary_key_col + ")";
                                    }
                                 } else if (KBBoolean) {
                                    primaryKeysql111 = "alter table \"" + schema + "\".\"" + tableName + "\"  add primary key (" + primary_key_columns + ")";
                                 } else {
                                    primaryKeysql111 = "alter table " + schema + "." + tableName + "  add primary key (" + primary_key_columns + ")";
                                 }
                              } else {
                                 for(ColumnInfoVO allColumn : allColumns) {
                                    String substring = primary_key_columns.substring(0, primary_key_columns.length() - 1);
                                    String[] split = substring.split(",");

                                    for(String col : split) {
                                       if (col.equals(allColumn.getColumnname())) {
                                          primaryKeysql333.append("ALTER TABLE [" + schema + "].[" + tableName + "]  ALTER COLUMN [" + col + "] " + allColumn.getTypename() + "(" + allColumn.getColumnsize() + ") COLLATE Chinese_PRC_CI_AS NOT NULL ");
                                       }
                                    }
                                 }

                                 primaryKeysql111 = "alter table " + schema + "." + tableName + "  add primary key (" + primary_key_columns + ")";
                              }

                              if (null != primaryKeysql333 && !"".equals(primaryKeysql333.toString())) {
                                 PreparedStatement preStatementKey333 = conn.prepareStatement(primaryKeysql333.toString());
                                 preStatementKey333.executeUpdate();
                                 preStatementKey333.close();
                              }

                              PreparedStatement preStatementKey111 = conn.prepareStatement(primaryKeysql111);
                              preStatementKey111.executeUpdate();
                              preStatementKey111.close();
                           } else {
                              String primaryKeysql111 = "";
                              StringBuilder primaryKeysql333 = new StringBuilder();
                              if (bb) {
                                 primaryKeysql111 = "alter table \"" + schema + "\".\"" + tableName + "\"  add primary key (\"" + columnName + "\")";
                              } else if (bbb) {
                                 primaryKeysql111 = "alter table \"" + schema + "\".\"" + tableName + "\"  add primary key (\"" + columnName + "\")";
                              } else if (!SQBoolean) {
                                 if (DMBoolean) {
                                    primaryKeysql111 = "alter table \"" + schema + "\".\"" + tableName + "\"  add primary key (\"" + columnName + "\")";
                                 } else if (KBBoolean) {
                                    primaryKeysql111 = "alter table \"" + schema + "\".\"" + tableName + "\"  add primary key (\"" + columnName + "\")";
                                 } else {
                                    primaryKeysql111 = "alter table " + schema + "." + tableName + "  add primary key (" + columnName + ")";
                                 }
                              } else {
                                 for(ColumnInfoVO allColumn : allColumns) {
                                    if (columnName.equals(allColumn.getColumnname())) {
                                       primaryKeysql333.append("ALTER TABLE [" + schema + "].[" + tableName + "]  ALTER COLUMN [" + columnName + "] " + allColumn.getTypename() + "(" + allColumn.getColumnsize() + ") COLLATE Chinese_PRC_CI_AS NOT NULL ");
                                    }
                                 }

                                 primaryKeysql111 = "alter table " + schema + "." + tableName + "  add primary key (" + columnName + ")";
                              }

                              if (null != primaryKeysql333 && !"".equals(primaryKeysql333.toString())) {
                                 PreparedStatement preStatementKey333 = conn.prepareStatement(primaryKeysql333.toString());
                                 preStatementKey333.executeUpdate();
                                 preStatementKey333.close();
                              }

                              PreparedStatement preStatementKey111 = conn.prepareStatement(primaryKeysql111);
                              preStatementKey111.executeUpdate();
                              preStatementKey111.close();
                           }
                        }

                        this.updateFieldFlag(field.getId(), "5");
                     } catch (Exception e) {
                        this.updateFieldFlag(field.getId(), "9");
                        e.printStackTrace();
                     }
                  } catch (Throwable var132) {
                     var142 = var132;
                     throw var132;
                  } finally {
                     if (stmt != null) {
                        if (var142 != null) {
                           try {
                              stmt.close();
                           } catch (Throwable var122) {
                              var142.addSuppressed(var122);
                           }
                        } else {
                           stmt.close();
                        }
                     }

                  }
               } catch (Throwable var134) {
                  var140 = var134;
                  throw var134;
               } finally {
                  if (conn != null) {
                     if (var140 != null) {
                        try {
                           conn.close();
                        } catch (Throwable var121) {
                           var140.addSuppressed(var121);
                        }
                     } else {
                        conn.close();
                     }
                  }

               }
            } catch (Exception e) {
               this.logger.error(e.getMessage(), e);
               throw new RuntimeException(e.getMessage(), e);
            }
         }

      }
   }

   public void switchFieldDecryptionProject(String projectId) {
      List<TCoreEncryptionTypeField> fields = this.getProjectFields(projectId, "6");
      this.logger.info("fields.size=[{}]", fields.size());
      List<String> pkFlags = new ArrayList();
      List<String> pkCols = new ArrayList();
      if (fields.size() != 0) {
         for(TCoreEncryptionTypeField field : fields) {
            String dataSystemId = field.getDatasystem_id();
            String schema = field.getTschemas();
            TCoreDatasystem datasystem = this.getDatasystem(dataSystemId);
            Boolean bb = true;
            if (!datasystem.getDbtype().equals(EdbType.ORACLE.toString())) {
               bb = false;
            }

            Boolean bbb = true;
            if (!datasystem.getDbtype().equals(EdbType.POSTGRESQL.toString()) && !datasystem.getDbtype().equals(EdbType.GAUSS.toString())) {
               bbb = false;
            }

            Boolean SQBoolean = true;
            if (!datasystem.getDbtype().equals(EdbType.MSSQLSERVER.toString())) {
               SQBoolean = false;
            }

            Boolean DMBoolean = true;
            if (!datasystem.getDbtype().equals(EdbType.DM.toString())) {
               DMBoolean = false;
            }

            Boolean KBBoolean = true;
            if (!datasystem.getDbtype().equals(EdbType.KINGBASE.toString())) {
               KBBoolean = false;
            }

            String primaryKeyFlag = "0";
            String primary_key_columns = "";
            String primary_key_col = "";
            List<ColumnInfoVO> allColumns = this.maksingAppDataRuleService.queryColumnInfo(field.getDatasystem_id(), field.getTschemas(), field.getNames());

            for(ColumnInfoVO allColumn : allColumns) {
               if (allColumn.getPrimarykey().equals("1")) {
                  primary_key_columns = primary_key_columns + allColumn.getColumnname() + ",";
                  if (DMBoolean) {
                     primary_key_col = primary_key_columns + allColumn.getColumnname();
                  } else {
                     primary_key_col = "\"" + primary_key_columns + allColumn.getColumnname() + "\",";
                  }
               }
            }

            if (!"".equals(primary_key_col) && primary_key_col.charAt(primary_key_col.length() - 1) == ',') {
               primary_key_col = primary_key_col.substring(0, primary_key_col.length() - 1);
            }

            if (!"".equals(primary_key_columns)) {
               if (primary_key_columns.charAt(primary_key_columns.length() - 1) == ',') {
                  primary_key_columns = primary_key_columns.substring(0, primary_key_columns.length() - 1);
               }

               String[] fileds = primary_key_columns.split(",");
               if (fileds.length > 0) {
                  for(String filed11 : fileds) {
                     if (field.getTable_field_id().equals(filed11)) {
                        primaryKeyFlag = "1";
                     }
                  }
               }
            }

            pkFlags.add(primaryKeyFlag);
            pkCols.add(primary_key_columns);

            try {
               Connection conn = JdbcTool.getConnection(datasystem);
               Throwable var140 = null;

               try {
                  Statement stmt = conn.createStatement();
                  Throwable var142 = null;

                  try {
                     String tableName = field.getNames();
                     String columnName = field.getTable_field_id();
                     String columnType = field.getColumn_type();
                     String columnSize = "";

                     try {
                        String columnSizeSql = "";
                        if (bb) {
                           columnSizeSql = "SELECT \"" + columnName + "\" FROM \"" + schema + "\".\"" + tableName + "\" WHERE 1=2";
                        } else if (bbb) {
                           columnSizeSql = "SELECT \"" + columnName + "\" FROM \"" + schema + "\".\"" + tableName + "\" WHERE 1=2";
                        } else if (SQBoolean) {
                           columnSizeSql = this.columnSizeSql(schema, tableName, columnName);
                        } else if (DMBoolean) {
                           columnSizeSql = "SELECT \"" + columnName + "\" FROM \"" + schema + "\".\"" + tableName + "\" WHERE 1=2";
                        } else if (KBBoolean) {
                           columnSizeSql = "SELECT \"" + columnName + "\" FROM \"" + schema + "\".\"" + tableName + "\" WHERE 1=2";
                        } else {
                           columnSizeSql = this.columnSizeSql(schema, tableName, columnName);
                        }

                        ResultSet rs = stmt.executeQuery(columnSizeSql);
                        Throwable columnSize1 = null;

                        try {
                           columnSize = "(" + rs.getMetaData().getColumnDisplaySize(1) + ")";
                           if (null != columnType && columnType.toLowerCase().contains("text")) {
                              columnSize = "";
                           }
                        } catch (Throwable var129) {
                           columnSize1 = var129;
                           throw var129;
                        } finally {
                           if (rs != null) {
                              if (columnSize1 != null) {
                                 try {
                                    rs.close();
                                 } catch (Throwable var124) {
                                    columnSize1.addSuppressed(var124);
                                 }
                              } else {
                                 rs.close();
                              }
                           }

                        }

                        String alterColumnToCipherSql = "";
                        if (bb) {
                           alterColumnToCipherSql = "ALTER TABLE \"" + schema + "\".\"" + tableName + "\"  RENAME COLUMN \"" + columnName + "\" TO \"" + columnName + this.cipherSuffix + "\"";
                        } else if (bbb) {
                           alterColumnToCipherSql = "ALTER TABLE \"" + schema + "\".\"" + tableName + "\"  RENAME COLUMN \"" + columnName + "\" TO \"" + columnName + this.cipherSuffix + "\"";
                        } else if (SQBoolean) {
                           alterColumnToCipherSql = "EXEC sp_rename '[" + schema + "].[" + tableName + "].[" + columnName + "]', '" + columnName + this.cipherSuffix + "', 'COLUMN'";
                        } else if (DMBoolean) {
                           alterColumnToCipherSql = "ALTER TABLE \"" + schema + "\".\"" + tableName + "\"  alter column \"" + columnName + "\" rename to \"" + columnName + this.cipherSuffix + "\"";
                        } else if (KBBoolean) {
                           alterColumnToCipherSql = "ALTER TABLE \"" + schema + "\".\"" + tableName + "\"  RENAME COLUMN \"" + columnName + "\" TO \"" + columnName + this.cipherSuffix + "\"";
                        } else {
                           alterColumnToCipherSql = this.alterColumnToCipherSqlProject(schema, tableName, columnName, columnType, columnSize);
                        }

                        stmt.executeUpdate(alterColumnToCipherSql);
                        if (primaryKeyFlag.equals("1") && !"".equals(primary_key_columns)) {
                           String primaryKeysqlIndex = "";
                           String primaryKeysql = "";
                           String primaryKeysql1 = "";
                           if (bb) {
                              primaryKeysql = "ALTER TABLE \"" + schema + "\".\"" + tableName + "\"  drop primary key";
                           } else if (bbb) {
                              primaryKeysql = "ALTER TABLE \"" + schema + "\".\"" + tableName + "\"  DROP CONSTRAINT \"" + tableName + "_pkey\"";
                           } else if (SQBoolean) {
                              List<PrimaryKeyInfo> primarykeyInfo = PrimaryKeyInfo.getPrimaryKeyInfoByConnection(conn, schema, tableName);
                              StringBuilder primaryKeysqlBuilder = new StringBuilder();
                              if (null != primarykeyInfo && primarykeyInfo.size() > 0) {
                                 for(int i = 0; i < primarykeyInfo.size(); ++i) {
                                    primaryKeysql = "ALTER TABLE " + schema + "." + tableName + " DROP  Constraint " + ((PrimaryKeyInfo)primarykeyInfo.get(i)).getPkname() + " ";
                                    primaryKeysqlBuilder.append(primaryKeysql);
                                 }

                                 primaryKeysql = primaryKeysqlBuilder.toString();
                              }
                           } else if (DMBoolean) {
                              List<PrimaryKeyInfo> primarykeyInfo = PrimaryKeyInfo.getPrimaryKeyInfoByConnection(conn, schema, tableName);
                              if (null != primarykeyInfo && primarykeyInfo.size() > 0) {
                                 for(int i = 0; i < primarykeyInfo.size(); ++i) {
                                    primaryKeysqlIndex = "create CLUSTER index \"" + schema + "_" + tableName + "_" + columnName + "_index\" on \"" + schema + "\".\"" + tableName + "\"(\"" + columnName + this.copySuffix + "\") ";
                                    primaryKeysql = "ALTER TABLE \"" + schema + "\".\"" + tableName + "\" DROP  Constraint \"" + ((PrimaryKeyInfo)primarykeyInfo.get(i)).getPkname() + "\"";
                                    primaryKeysql1 = "drop index \"" + schema + "\".\"" + schema + "_" + tableName + "_" + columnName + "_index\"";
                                    PreparedStatement preStatementKeyIndex = conn.prepareStatement(primaryKeysqlIndex);
                                    preStatementKeyIndex.executeUpdate();
                                    preStatementKeyIndex.close();

                                    try {
                                       PreparedStatement preStatementKey = conn.prepareStatement(primaryKeysql);
                                       preStatementKey.executeUpdate();
                                       preStatementKey.close();
                                    } catch (Exception var126) {
                                    }

                                    PreparedStatement preStatementKey1 = conn.prepareStatement(primaryKeysql1);
                                    preStatementKey1.executeUpdate();
                                    preStatementKey1.close();
                                 }
                              }
                           } else if (!KBBoolean) {
                              primaryKeysql = "alter table " + schema + "." + tableName + "  drop primary key";
                           } else {
                              List<PrimaryKeyInfo> primarykeyInfo = PrimaryKeyInfo.getPrimaryKeyInfoByConnection(conn, schema, tableName);
                              StringBuilder primaryKeysqlBuilder = new StringBuilder();
                              if (null != primarykeyInfo && primarykeyInfo.size() > 0) {
                                 for(int i = 0; i < primarykeyInfo.size(); ++i) {
                                    primaryKeysql = "ALTER TABLE \"" + schema + "\".\"" + tableName + "\" DROP CONSTRAINT \"" + ((PrimaryKeyInfo)primarykeyInfo.get(i)).getPkname() + "\" ";
                                    primaryKeysqlBuilder.append(primaryKeysql);
                                 }

                                 primaryKeysql = primaryKeysqlBuilder.toString();
                              }
                           }

                           if (!DMBoolean) {
                              PreparedStatement preStatementKey = conn.prepareStatement(primaryKeysql);
                              preStatementKey.executeUpdate();
                              preStatementKey.close();
                           }
                        }

                        if (bb) {
                           columnSizeSql = "SELECT \"" + columnName + this.copySuffix + "\" FROM \"" + schema + "\".\"" + tableName + "\" WHERE 1=2";
                        } else if (bbb) {
                           columnSizeSql = "SELECT \"" + columnName + this.copySuffix + "\" FROM \"" + schema + "\".\"" + tableName + "\" WHERE 1=2";
                        } else if (SQBoolean) {
                           columnSizeSql = this.columnSizeSql(schema, tableName, columnName + this.copySuffix);
                        } else if (DMBoolean) {
                           columnSizeSql = "SELECT \"" + columnName + this.copySuffix + "\" FROM \"" + schema + "\".\"" + tableName + "\" WHERE 1=2";
                        } else if (KBBoolean) {
                           columnSizeSql = "SELECT \"" + columnName + this.copySuffix + "\" FROM \"" + schema + "\".\"" + tableName + "\" WHERE 1=2";
                        } else {
                           columnSizeSql = this.columnSizeSql(schema, tableName, columnName + this.copySuffix);
                        }

                        int columnSize1New2 = 0;
                        ResultSet rsNew2 = stmt.executeQuery(columnSizeSql);
                        Throwable var160 = null;

                        try {
                           columnSize1New2 = rsNew2.getMetaData().getColumnDisplaySize(1);
                           columnSize = "(" + rsNew2.getMetaData().getColumnDisplaySize(1) + ")";
                           if (null != columnType && columnType.toLowerCase().contains("text")) {
                              columnSize = "";
                           }
                        } catch (Throwable var127) {
                           var160 = var127;
                           throw var127;
                        } finally {
                           if (rsNew2 != null) {
                              if (var160 != null) {
                                 try {
                                    rsNew2.close();
                                 } catch (Throwable var123) {
                                    var160.addSuppressed(var123);
                                 }
                              } else {
                                 rsNew2.close();
                              }
                           }

                        }

                        String alterCopyToColumnSql = "";
                        String alterCopyToColumnSql1 = "";
                        if (bb) {
                           alterCopyToColumnSql = "ALTER TABLE \"" + schema + "\".\"" + tableName + "\"  RENAME COLUMN \"" + columnName + this.copySuffix + "\" TO \"" + columnName + "\"";
                           alterCopyToColumnSql1 = "ALTER TABLE \"" + schema + "\".\"" + tableName + "\" MODIFY (\"" + columnName + "\" " + columnType + "(" + columnSize1New2 + " BYTE))";
                        } else if (bbb) {
                           alterCopyToColumnSql = "ALTER TABLE \"" + schema + "\".\"" + tableName + "\"  RENAME COLUMN \"" + columnName + this.copySuffix + "\" TO \"" + columnName + "\"";
                           alterCopyToColumnSql1 = "ALTER TABLE \"" + schema + "\".\"" + tableName + "\"  ALTER COLUMN \"" + columnName + "\" TYPE " + columnType + columnSize;
                        } else if (SQBoolean) {
                           alterCopyToColumnSql = "EXEC sp_rename '[" + schema + "].[" + tableName + "].[" + columnName + this.copySuffix + "]', '" + columnName + "', 'COLUMN'";
                           alterCopyToColumnSql1 = "ALTER TABLE [" + schema + "].[" + tableName + "]  ALTER COLUMN [" + columnName + "] " + columnType + columnSize + "";
                        } else if (DMBoolean) {
                           alterCopyToColumnSql = "ALTER TABLE \"" + schema + "\".\"" + tableName + "\"  alter column \"" + columnName + this.copySuffix + "\" rename to \"" + columnName + "\"";
                           alterCopyToColumnSql1 = "ALTER TABLE \"" + schema + "\".\"" + tableName + "\"  modify \"" + columnName + "\" " + columnType + columnSize + "";
                        } else if (KBBoolean) {
                           alterCopyToColumnSql = "ALTER TABLE \"" + schema + "\".\"" + tableName + "\"  RENAME COLUMN \"" + columnName + this.copySuffix + "\" TO \"" + columnName + "\"";
                           alterCopyToColumnSql1 = "ALTER TABLE \"" + schema + "\".\"" + tableName + "\"  ALTER COLUMN \"" + columnName + "\" TYPE " + columnType + columnSize + "";
                        } else {
                           alterCopyToColumnSql = this.alterCopyToColumnSqlProject(schema, tableName, columnName, columnType, columnSize);
                        }

                        stmt.executeUpdate(alterCopyToColumnSql);
                        if (!"".equals(alterCopyToColumnSql1)) {
                           PreparedStatement preStatement1 = conn.prepareStatement(alterCopyToColumnSql1);
                           preStatement1.executeUpdate();
                           if (preStatement1 != null) {
                              try {
                                 preStatement1.close();
                              } catch (SQLException e) {
                                 e.printStackTrace();
                              }
                           }
                        }

                        if (primaryKeyFlag.equals("1") && !"".equals(primary_key_columns)) {
                           String[] fileds = primary_key_columns.split(",");
                           if (fileds.length > 1) {
                              String primaryKeysql111 = "";
                              StringBuilder primaryKeysql333 = new StringBuilder();
                              if (bb) {
                                 if (!"".equals(primary_key_col)) {
                                    primaryKeysql111 = "alter table \"" + schema + "\".\"" + tableName + "\"  add primary key (" + primary_key_col + ")";
                                 }
                              } else if (bbb) {
                                 if (!"".equals(primary_key_col)) {
                                    primaryKeysql111 = "alter table \"" + schema + "\".\"" + tableName + "\"  add primary key (" + primary_key_col + ")";
                                 }
                              } else if (!SQBoolean) {
                                 if (DMBoolean) {
                                    if (!"".equals(primary_key_col)) {
                                       primaryKeysql111 = "alter table \"" + schema + "\".\"" + tableName + "\"  add primary key (" + primary_key_col + ")";
                                    }
                                 } else if (KBBoolean) {
                                    primaryKeysql111 = "alter table \"" + schema + "\".\"" + tableName + "\"  add primary key (" + primary_key_columns + ")";
                                 } else {
                                    primaryKeysql111 = "alter table " + schema + "." + tableName + "  add primary key (" + primary_key_columns + ")";
                                 }
                              } else {
                                 for(ColumnInfoVO allColumn : allColumns) {
                                    String substring = primary_key_columns.substring(0, primary_key_columns.length() - 1);
                                    String[] split = substring.split(",");

                                    for(String col : split) {
                                       if (col.equals(allColumn.getColumnname())) {
                                          primaryKeysql333.append("ALTER TABLE [" + schema + "].[" + tableName + "]  ALTER COLUMN [" + col + "] " + allColumn.getTypename() + "(" + allColumn.getColumnsize() + ") COLLATE Chinese_PRC_CI_AS NOT NULL ");
                                       }
                                    }
                                 }

                                 primaryKeysql111 = "alter table " + schema + "." + tableName + "  add primary key (" + primary_key_columns + ")";
                              }

                              if (null != primaryKeysql333 && !"".equals(primaryKeysql333.toString())) {
                                 PreparedStatement preStatementKey333 = conn.prepareStatement(primaryKeysql333.toString());
                                 preStatementKey333.executeUpdate();
                                 preStatementKey333.close();
                              }

                              PreparedStatement preStatementKey111 = conn.prepareStatement(primaryKeysql111);
                              preStatementKey111.executeUpdate();
                              preStatementKey111.close();
                           } else {
                              String primaryKeysql111 = "";
                              StringBuilder primaryKeysql333 = new StringBuilder();
                              if (bb) {
                                 primaryKeysql111 = "alter table \"" + schema + "\".\"" + tableName + "\"  add primary key (\"" + columnName + "\")";
                              } else if (bbb) {
                                 primaryKeysql111 = "alter table \"" + schema + "\".\"" + tableName + "\"  add primary key (\"" + columnName + "\")";
                              } else if (!SQBoolean) {
                                 if (DMBoolean) {
                                    primaryKeysql111 = "alter table \"" + schema + "\".\"" + tableName + "\"  add primary key (\"" + columnName + "\")";
                                 } else if (KBBoolean) {
                                    primaryKeysql111 = "alter table \"" + schema + "\".\"" + tableName + "\"  add primary key (\"" + columnName + "\")";
                                 } else {
                                    primaryKeysql111 = "alter table " + schema + "." + tableName + "  add primary key (" + columnName + ")";
                                 }
                              } else {
                                 for(ColumnInfoVO allColumn : allColumns) {
                                    if (columnName.equals(allColumn.getColumnname())) {
                                       primaryKeysql333.append("ALTER TABLE [" + schema + "].[" + tableName + "]  ALTER COLUMN [" + columnName + "] " + allColumn.getTypename() + "(" + allColumn.getColumnsize() + ") COLLATE Chinese_PRC_CI_AS NOT NULL ");
                                    }
                                 }

                                 primaryKeysql111 = "alter table " + schema + "." + tableName + "  add primary key (" + columnName + ")";
                              }

                              if (null != primaryKeysql333 && !"".equals(primaryKeysql333.toString())) {
                                 PreparedStatement preStatementKey333 = conn.prepareStatement(primaryKeysql333.toString());
                                 preStatementKey333.executeUpdate();
                                 preStatementKey333.close();
                              }

                              PreparedStatement preStatementKey111 = conn.prepareStatement(primaryKeysql111);
                              preStatementKey111.executeUpdate();
                              preStatementKey111.close();
                           }
                        }

                        this.updateFieldFlag(field.getId(), "7");
                     } catch (Exception e) {
                        this.updateFieldFlag(field.getId(), "10");
                        e.printStackTrace();
                     }
                  } catch (Throwable var132) {
                     var142 = var132;
                     throw var132;
                  } finally {
                     if (stmt != null) {
                        if (var142 != null) {
                           try {
                              stmt.close();
                           } catch (Throwable var122) {
                              var142.addSuppressed(var122);
                           }
                        } else {
                           stmt.close();
                        }
                     }

                  }
               } catch (Throwable var134) {
                  var140 = var134;
                  throw var134;
               } finally {
                  if (conn != null) {
                     if (var140 != null) {
                        try {
                           conn.close();
                        } catch (Throwable var121) {
                           var140.addSuppressed(var121);
                        }
                     } else {
                        conn.close();
                     }
                  }

               }
            } catch (Exception e) {
               this.logger.error(e.getMessage(), e);
               throw new RuntimeException(e.getMessage(), e);
            }
         }

      }
   }

   public void addColumn(String dataSystemId, String schema, String tableName, String columnName, String columnType, String columnSize) {
      TCoreDatasystem datasystem = this.getDatasystem(dataSystemId);

      try {
         Connection conn = JdbcTool.getConnection(datasystem);
         Throwable var9 = null;

         try {
            Statement stmt = conn.createStatement();
            Throwable var11 = null;

            try {
               if (null != columnSize && !columnSize.trim().equals("")) {
                  columnSize = "(" + columnSize + ")";
               }

               if (null != columnType && columnType.toLowerCase().contains("text")) {
                  columnSize = "";
               }

               String alterColumnToInitialSql = this.addColumn(schema, tableName, columnName, columnType, columnSize);
               stmt.executeUpdate(alterColumnToInitialSql);
            } catch (Throwable var36) {
               var11 = var36;
               throw var36;
            } finally {
               if (stmt != null) {
                  if (var11 != null) {
                     try {
                        stmt.close();
                     } catch (Throwable var35) {
                        var11.addSuppressed(var35);
                     }
                  } else {
                     stmt.close();
                  }
               }

            }
         } catch (Throwable var38) {
            var9 = var38;
            throw var38;
         } finally {
            if (conn != null) {
               if (var9 != null) {
                  try {
                     conn.close();
                  } catch (Throwable var34) {
                     var9.addSuppressed(var34);
                  }
               } else {
                  conn.close();
               }
            }

         }

      } catch (Exception e) {
         this.logger.error(e.getMessage(), e);
         throw new RuntimeException(e.getMessage(), e);
      }
   }

   public String delTableColumn(String projectId, String dataSystemId, String schema, String tableName) {
      Properties props = new Properties();

      try {
         props = PropertiesLoaderUtils.loadAllProperties("config.properties");
      } catch (IOException e) {
         e.printStackTrace();
      }

      TCoreDatasystem datasystem = this.getDatasystem(dataSystemId);
      Boolean isOracleType = true;
      if (!datasystem.getDbtype().equals(EdbType.ORACLE.toString())) {
         isOracleType = false;
      }

      Boolean isPostgresql = true;
      if (!datasystem.getDbtype().equals(EdbType.POSTGRESQL.toString()) && !datasystem.getDbtype().equals(EdbType.GAUSS.toString())) {
         isPostgresql = false;
      }

      Boolean isMSsqlserver = true;
      if (!datasystem.getDbtype().equals(EdbType.MSSQLSERVER.toString())) {
         isMSsqlserver = false;
      }

      Boolean DMBoolean = true;
      if (!datasystem.getDbtype().equals(EdbType.DM.toString())) {
         DMBoolean = false;
      }

      Boolean KBBoolean = true;
      if (!datasystem.getDbtype().equals(EdbType.KINGBASE.toString())) {
         KBBoolean = false;
      }

      String columnName = "";
      List<ColumnInfoVO> allColumns = this.maksingAppDataRuleService.queryColumnInfo(dataSystemId, schema, tableName);
      int sumNum = 0;
      ResultSet rsCount = null;

      try {
         Connection conn = JdbcTool.getConnection(datasystem);
         Throwable var17 = null;

         try {
            Statement stmt = conn.createStatement();
            Throwable var19 = null;

            try {
               Statement stmt111 = conn.createStatement();
               Throwable var21 = null;

               try {
                  List<TCoreEncryptionTypeField> tCorTypeFieldList = this.tCoreEncryptionTypeFieldDao.queryAll(new Criterion[]{Restrictions.eq("projectid", projectId), Restrictions.eq("datasystem_id", dataSystemId), Restrictions.eq("tschemas", schema), Restrictions.eq("names", tableName)});
                  int checkNum = 100;

                  try {
                     checkNum = Integer.valueOf(props.getProperty("checkNum"));
                  } catch (Exception e) {
                     e.printStackTrace();
                  }

                  int c = tCorTypeFieldList.size();

                  for(int n = 0; n < c; ++n) {
                     try {
                        if (((TCoreEncryptionTypeField)tCorTypeFieldList.get(n)).getTable_field_id() != null) {
                           columnName = ((TCoreEncryptionTypeField)tCorTypeFieldList.get(n)).getTable_field_id();
                           String alterColumnToInitialSql = "";
                           String alterColumnToCipherSql = "";
                           if (null != ((TCoreEncryptionTypeField)tCorTypeFieldList.get(n)).getFlag() && !"".equals(((TCoreEncryptionTypeField)tCorTypeFieldList.get(n)).getFlag())) {
                              String isExistInitailCol = "0";

                              for(ColumnInfoVO allColumn : allColumns) {
                                 if (allColumn.getColumnname().equals(columnName + this.initialSuffix)) {
                                    isExistInitailCol = "1";
                                    break;
                                 }
                              }

                              String columnNameN;
                              String secretKeyId;
                              StringBuilder mg111;
                              if (isExistInitailCol.equals("1")) {
                                 if (!"7".equals(((TCoreEncryptionTypeField)tCorTypeFieldList.get(n)).getFlag()) && !"1".equals(((TCoreEncryptionTypeField)tCorTypeFieldList.get(n)).getFlag()) && !"9".equals(((TCoreEncryptionTypeField)tCorTypeFieldList.get(n)).getFlag()) && !"-1".equals(((TCoreEncryptionTypeField)tCorTypeFieldList.get(n)).getFlag())) {
                                    int iCLimitCount = 0;
                                    ResultSet rsC = null;

                                    try {
                                       if (isOracleType) {
                                          rsC = stmt.executeQuery("SELECT COUNT(1) AS num FROM(SELECT * FROM ( select ROWNUM RN ,TT.* FROM  (SELECT * FROM " + schema + "\".\"" + tableName + "\" WHERE \"" + columnName + this.initialSuffix + "\" IS NOT NULL AND \"" + columnName + "\" IS NULL) TT ) WHERE RN>" + iCLimitCount + " AND RN <= " + checkNum + ")");
                                       } else if (isPostgresql) {
                                          rsC = stmt.executeQuery("SELECT count(1) AS num FROM (SELECT * FROM " + schema + "." + tableName + " WHERE " + columnName + this.initialSuffix + " IS NOT NULL AND (" + columnName + " IS NULL ) offset " + iCLimitCount + " limit " + checkNum + " )t");
                                       } else if (isMSsqlserver) {
                                          rsC = stmt.executeQuery("select count(*) as num from (select * from gen_table  WHERE " + columnName + this.initialSuffix + " IS NOT NULL AND " + columnName + " IS NULL order by " + columnName + " offset 0 rows fetch next " + checkNum + " rows only )t group by " + columnName);
                                       } else if (DMBoolean) {
                                          rsC = stmt.executeQuery("SELECT COUNT(1) AS num FROM(SELECT * FROM ( select ROWNUM RN ,TT.* FROM  (SELECT * FROM \"" + schema + "\".\"" + tableName + "\" WHERE \"" + columnName + this.initialSuffix + "\" IS NOT NULL AND \"" + columnName + "\" IS NULL) TT ) WHERE RN>" + iCLimitCount + " AND RN <= " + checkNum + ")");
                                       } else if (KBBoolean) {
                                          rsC = stmt.executeQuery("SELECT COUNT(1) AS num FROM(SELECT * FROM ( select ROWNUM RN ,TT.* FROM  (SELECT * FROM \"" + schema + "\".\"" + tableName + "\" WHERE \"" + columnName + this.initialSuffix + "\" IS NOT NULL AND \"" + columnName + "\" IS NULL) TT ) WHERE RN>" + iCLimitCount + " AND RN <= " + checkNum + ")");
                                       } else {
                                          rsC = stmt.executeQuery("SELECT count(1) AS num FROM (SELECT * FROM " + schema + "." + tableName + " WHERE " + columnName + this.initialSuffix + " IS NOT NULL AND (" + columnName + " IS NULL ) limit " + iCLimitCount + "," + checkNum + " )t");
                                       }

                                       int num;
                                       for(num = 0; rsC.next(); num = rsC.getInt("num")) {
                                       }

                                       if (num > 0) {
                                          StringBuilder mg = new StringBuilder();
                                          mg.append("数据源：");
                                          mg.append(schema);
                                          mg.append("表：");
                                          mg.append(tableName);
                                          mg.append("列：");
                                          mg.append(columnName);
                                          mg.append("加密后的数据为空，加密失败，暂时不能删除多余列。");
                                          columnNameN = mg.toString();
                                          return columnNameN;
                                       }
                                    } catch (Exception e) {
                                       e.printStackTrace();
                                    } finally {
                                       if (rsC != null) {
                                          try {
                                             rsC.close();
                                          } catch (SQLException e) {
                                             e.printStackTrace();
                                          }
                                       }

                                    }

                                    ResultSet rsC1 = null;

                                    try {
                                       if (isOracleType) {
                                          rsC1 = stmt.executeQuery("select nn.\"" + columnName + "\",nn.\"" + columnName + this.initialSuffix + "\" from (select t.\"" + columnName + "\",t.\"" + columnName + this.initialSuffix + "\",rownum rn from \"" + schema + "\".\"" + tableName + "\" t) nn where nn.rn>=" + iCLimitCount + "and nn.rn<" + checkNum);
                                       } else if (isPostgresql) {
                                          rsC1 = stmt.executeQuery("select \"" + columnName + "\",\"" + columnName + this.initialSuffix + "\" from \"" + schema + "\".\"" + tableName + "\" LIMIT " + checkNum + " OFFSET " + iCLimitCount);
                                       } else if (isMSsqlserver) {
                                          rsC1 = stmt.executeQuery("SELECT " + columnName + "," + columnName + this.initialSuffix + ", 0 AS _NAV_ORDER_F_ FROM " + schema + "." + tableName + " ORDER BY _NAV_ORDER_F_ OFFSET " + iCLimitCount + " ROWS FETCH NEXT " + checkNum + " ROWS ONLY");
                                       } else if (DMBoolean) {
                                          rsC1 = stmt.executeQuery("select \"" + columnName + "\",\"" + columnName + this.initialSuffix + "\" from \"" + schema + "\".\"" + tableName + "\" LIMIT " + iCLimitCount + "," + checkNum);
                                       } else if (KBBoolean) {
                                          rsC1 = stmt.executeQuery("select \"" + columnName + "\",\"" + columnName + this.initialSuffix + "\" from \"" + schema + "\".\"" + tableName + "\" LIMIT " + iCLimitCount + "," + checkNum);
                                       } else {
                                          rsC1 = stmt.executeQuery(this.checkColumn(schema, tableName, columnName, columnName + this.initialSuffix, iCLimitCount, checkNum));
                                       }

                                       while(rsC1.next()) {
                                          String initial = rsC1.getString(columnName + this.initialSuffix);
                                          if (null != initial) {
                                             columnNameN = rsC1.getString(columnName);
                                             secretKeyId = ((TCoreEncryptionTypeField)tCorTypeFieldList.get(n)).getEncryption_secretkey_id();
                                             Map<String, String> encryptionInfo = this.tCoreEncryptionService.queryEncryptionInfo(secretKeyId);
                                             if (null != encryptionInfo.get("encryptionType") && !"".equals(encryptionInfo.get("encryptionType"))) {
                                                Boolean isEq = EncUtils.compareStringEq(initial, EncProvider.decryptEcb((String)encryptionInfo.get("encryptionType"), (String)encryptionInfo.get("secretkey"), columnNameN, ((TCoreEncryptionTypeField)tCorTypeFieldList.get(n)).getIslike(), ((TCoreEncryptionTypeField)tCorTypeFieldList.get(n)).getKeepfirst(), ((TCoreEncryptionTypeField)tCorTypeFieldList.get(n)).getEncdigit(), ((TCoreEncryptionTypeField)tCorTypeFieldList.get(n)).getTwoindex()));
                                                if (!isEq) {
                                                   StringBuilder mg111New = new StringBuilder();
                                                   mg111New.append("数据源：");
                                                   mg111New.append(schema);
                                                   mg111New.append("表：");
                                                   mg111New.append(tableName);
                                                   mg111New.append("列：");
                                                   mg111New.append(columnName);
                                                   mg111New.append("解密校验失败，暂时不能删除多余列。");
                                                   return mg111New.toString();
                                                }
                                             }
                                          }
                                       }
                                    } catch (Exception e) {
                                       e.printStackTrace();
                                    } finally {
                                       if (rsC1 != null) {
                                          try {
                                             rsC1.close();
                                          } catch (SQLException e) {
                                             e.printStackTrace();
                                          }
                                       }

                                    }
                                 }

                                 if (isOracleType) {
                                    alterColumnToInitialSql = "ALTER TABLE \"" + schema + "\".\"" + tableName + "\" DROP (\"" + columnName + this.initialSuffix + "\")";
                                 } else if (isPostgresql) {
                                    alterColumnToInitialSql = "ALTER TABLE \"" + schema + "\".\"" + tableName + "\" DROP COLUMN \"" + columnName + this.initialSuffix + "\"";
                                 } else if (isMSsqlserver) {
                                    alterColumnToInitialSql = this.delColumn(schema, tableName, columnName + this.initialSuffix);
                                 } else if (DMBoolean) {
                                    alterColumnToInitialSql = "ALTER TABLE \"" + schema + "\".\"" + tableName + "\" DROP COLUMN \"" + columnName + this.initialSuffix + "\"";
                                 } else if (KBBoolean) {
                                    alterColumnToInitialSql = "ALTER TABLE \"" + schema + "\".\"" + tableName + "\" DROP COLUMN \"" + columnName + this.initialSuffix + "\"";
                                 } else {
                                    alterColumnToInitialSql = this.delColumn(schema, tableName, columnName + this.initialSuffix);
                                 }

                                 try {
                                    stmt.executeUpdate(alterColumnToInitialSql);
                                 } catch (SQLException se) {
                                    if (se.getMessage().contains("依赖于") && isMSsqlserver) {
                                       String constraint = se.getMessage().split("'")[1];
                                       String deleteConstraint = "alter table  " + schema + "." + tableName + " drop constraint " + constraint;
                                       stmt.executeUpdate(deleteConstraint);
                                       stmt.executeUpdate(alterColumnToInitialSql);
                                    }
                                 }
                              }

                              String isExistCipherCol = "0";

                              for(ColumnInfoVO allColumn : allColumns) {
                                 if (allColumn.getColumnname().equals(columnName + this.cipherSuffix)) {
                                    isExistCipherCol = "1";
                                 }
                              }

                              if (isExistCipherCol.equals("1")) {
                                 if (!"5".equals(((TCoreEncryptionTypeField)tCorTypeFieldList.get(n)).getFlag()) && !"6".equals(((TCoreEncryptionTypeField)tCorTypeFieldList.get(n)).getFlag()) && !"10".equals(((TCoreEncryptionTypeField)tCorTypeFieldList.get(n)).getFlag()) && !"44".equals(((TCoreEncryptionTypeField)tCorTypeFieldList.get(n)).getFlag()) && !"-2".equals(((TCoreEncryptionTypeField)tCorTypeFieldList.get(n)).getFlag())) {
                                    int iCLimitCount = 0;
                                    ResultSet rsC = null;

                                    try {
                                       if (isOracleType) {
                                          rsC = stmt.executeQuery("SELECT COUNT(1) AS num FROM(SELECT * FROM ( select ROWNUM RN ,TT.* FROM  (SELECT * FROM \"" + schema + "\".\"" + tableName + "\" WHERE \"" + columnName + this.cipherSuffix + "\" IS NOT NULL AND \"" + columnName + "\" IS NULL) TT ) WHERE RN>" + iCLimitCount + " AND RN <= " + checkNum + ")");
                                       } else if (isPostgresql) {
                                          rsC = stmt.executeQuery("SELECT count(1) AS num FROM (SELECT * FROM " + schema + "." + tableName + " WHERE " + columnName + this.cipherSuffix + " IS NOT NULL AND (" + columnName + " IS NULL  ) offset " + iCLimitCount + " limit " + checkNum + " )t");
                                       } else if (isMSsqlserver) {
                                          rsC = stmt.executeQuery("SELECT COUNT(1) AS num FROM (SELECT * FROM " + schema + "." + tableName + " WHERE " + columnName + this.cipherSuffix + " IS NOT NULL AND (" + columnName + " IS NULL  ) limit " + iCLimitCount + "," + checkNum + " )t");
                                       } else if (DMBoolean) {
                                          rsC = stmt.executeQuery("SELECT COUNT(1) AS num FROM(SELECT * FROM ( select ROWNUM RN ,TT.* FROM  (SELECT * FROM \"" + schema + "\".\"" + tableName + "\" WHERE \"" + columnName + this.cipherSuffix + "\" IS NOT NULL AND \"" + columnName + "\" IS NULL) TT ) WHERE RN>" + iCLimitCount + " AND RN <= " + checkNum + ")");
                                       } else if (KBBoolean) {
                                          rsC = stmt.executeQuery("SELECT COUNT(1) AS num FROM(SELECT * FROM ( select ROWNUM RN ,TT.* FROM  (SELECT * FROM \"" + schema + "\".\"" + tableName + "\" WHERE \"" + columnName + this.cipherSuffix + "\" IS NOT NULL AND \"" + columnName + "\" IS NULL) TT ) WHERE RN>" + iCLimitCount + " AND RN <= " + checkNum + ")");
                                       } else {
                                          rsC = stmt.executeQuery("SELECT count(1) AS num FROM (SELECT * FROM " + schema + "." + tableName + " WHERE " + columnName + this.cipherSuffix + " IS NOT NULL AND (" + columnName + " IS NULL ) limit " + iCLimitCount + "," + checkNum + " )t");
                                       }

                                       int num;
                                       for(num = 0; rsC.next(); num = rsC.getInt("num")) {
                                       }

                                       if (num > 0) {
                                          StringBuilder columnNameNew = new StringBuilder();
                                          ((StringBuilder)columnNameNew).append("数据源：");
                                          ((StringBuilder)columnNameNew).append(schema);
                                          ((StringBuilder)columnNameNew).append("表：");
                                          ((StringBuilder)columnNameNew).append(tableName);
                                          ((StringBuilder)columnNameNew).append("列：");
                                          ((StringBuilder)columnNameNew).append(columnName);
                                          ((StringBuilder)columnNameNew).append("解密后的数据为空，解密失败，暂时不能删除多余列。");
                                          secretKeyId = ((StringBuilder)columnNameNew).toString();
                                          return secretKeyId;
                                       }
                                    } catch (Exception e) {
                                       e.printStackTrace();
                                    } finally {
                                       if (rsC != null) {
                                          try {
                                             rsC.close();
                                          } catch (SQLException e) {
                                             e.printStackTrace();
                                          }
                                       }

                                    }

                                    ResultSet rsC1 = null;

                                    try {
                                       if (isOracleType) {
                                          rsC1 = stmt.executeQuery("select nn.\"" + columnName + "\",nn.\"" + columnName + this.cipherSuffix + "\" from (select t.\"" + columnName + "\",t.\"" + columnName + this.cipherSuffix + "\",rownum rn from \"" + schema + "\".\"" + tableName + "\" t) nn where nn.rn>=" + iCLimitCount + "and nn.rn<" + checkNum);
                                       } else if (isPostgresql) {
                                          rsC1 = stmt.executeQuery("select \"" + columnName + "\",\"" + columnName + this.cipherSuffix + "\" from \"" + schema + "\".\"" + tableName + "\" LIMIT " + checkNum + " OFFSET " + iCLimitCount);
                                       } else if (isMSsqlserver) {
                                          rsC1 = stmt.executeQuery("SELECT " + columnName + "," + columnName + this.cipherSuffix + ", 0 AS _NAV_ORDER_F_ FROM " + schema + "." + tableName + " ORDER BY _NAV_ORDER_F_ OFFSET " + iCLimitCount + " ROWS FETCH NEXT " + checkNum + " ROWS ONLY");
                                       } else if (DMBoolean) {
                                          rsC1 = stmt.executeQuery("select \"" + columnName + "\",\"" + columnName + this.cipherSuffix + "\" from \"" + schema + "\".\"" + tableName + "\" LIMIT " + iCLimitCount + "," + checkNum);
                                       } else if (KBBoolean) {
                                          rsC1 = stmt.executeQuery("select \"" + columnName + "\",\"" + columnName + this.cipherSuffix + "\" from \"" + schema + "\".\"" + tableName + "\" LIMIT " + iCLimitCount + "," + checkNum);
                                       } else {
                                          rsC1 = stmt.executeQuery(this.checkColumn(schema, tableName, columnName, columnName + this.cipherSuffix, iCLimitCount, checkNum));
                                       }

                                       while(rsC1.next()) {
                                          columnNameN = rsC1.getString(columnName + this.cipherSuffix);
                                          if (null != columnNameN) {
                                             secretKeyId = rsC1.getString(columnName);
                                             String secretKeyIdNew = ((TCoreEncryptionTypeField)tCorTypeFieldList.get(n)).getEncryption_secretkey_id();
                                             Map<String, String> encryptionInfo = this.tCoreEncryptionService.queryEncryptionInfo(secretKeyIdNew);
                                             if (null != encryptionInfo.get("encryptionType") && !"".equals(encryptionInfo.get("encryptionType"))) {
                                                Boolean isEq = EncUtils.compareStringEq(secretKeyIdNew, EncProvider.decryptEcb((String)encryptionInfo.get("encryptionType"), (String)encryptionInfo.get("secretkey"), columnNameN, ((TCoreEncryptionTypeField)tCorTypeFieldList.get(n)).getIslike(), ((TCoreEncryptionTypeField)tCorTypeFieldList.get(n)).getKeepfirst(), ((TCoreEncryptionTypeField)tCorTypeFieldList.get(n)).getEncdigit(), ((TCoreEncryptionTypeField)tCorTypeFieldList.get(n)).getTwoindex()));
                                                if (!isEq) {
                                                   mg111 = new StringBuilder();
                                                   mg111.append("数据源：");
                                                   mg111.append(schema);
                                                   mg111.append("表：");
                                                   mg111.append(tableName);
                                                   mg111.append("列：");
                                                   mg111.append(columnName);
                                                   mg111.append("加密校验失败，暂时不能删除多余列。");
                                                   return mg111.toString();
                                                }
                                             }
                                          }
                                       }
                                    } catch (Exception var429) {
//                                       columnNameN = var429;
                                       var429.printStackTrace();
                                    } finally {
                                       if (rsC1 != null) {
                                          try {
                                             rsC1.close();
                                          } catch (SQLException e) {
                                             e.printStackTrace();
                                          }
                                       }

                                    }
                                 }

                                 if (isOracleType) {
                                    alterColumnToCipherSql = "ALTER TABLE \"" + schema + "\".\"" + tableName + "\" DROP (\"" + columnName + this.cipherSuffix + "\")";
                                 } else if (isPostgresql) {
                                    alterColumnToCipherSql = "ALTER TABLE \"" + schema + "\".\"" + tableName + "\" DROP COLUMN \"" + columnName + this.cipherSuffix + "\"";
                                 } else if (isMSsqlserver) {
                                    alterColumnToCipherSql = this.delColumn(schema, tableName, columnName + this.cipherSuffix);
                                 } else if (DMBoolean) {
                                    alterColumnToCipherSql = "ALTER TABLE \"" + schema + "\".\"" + tableName + "\" DROP COLUMN \"" + columnName + this.cipherSuffix + "\"";
                                 } else if (KBBoolean) {
                                    alterColumnToCipherSql = "ALTER TABLE \"" + schema + "\".\"" + tableName + "\" DROP COLUMN \"" + columnName + this.cipherSuffix + "\"";
                                 } else {
                                    alterColumnToCipherSql = this.delColumn(schema, tableName, columnName + this.cipherSuffix);
                                 }

                                 try {
                                    stmt.executeUpdate(alterColumnToCipherSql);
                                 } catch (SQLException se) {
                                    if (se.getMessage().contains("依赖于") && isMSsqlserver) {
                                       String constraint = se.getMessage().split("'")[1];
                                       String deleteConstraint = "alter table  " + schema + "." + tableName + " drop constraint " + constraint;
                                       stmt.executeUpdate(deleteConstraint);
                                       stmt.executeUpdate(alterColumnToCipherSql);
                                    }
                                 }
                              }
                           }
                        }
                     } catch (Exception e) {
                        e.printStackTrace();
                     } finally {
                        if (rsCount != null) {
                           try {
                              rsCount.close();
                           } catch (SQLException e) {
                              e.printStackTrace();
                           }
                        }

                     }
                  }

                  return "OK";
               } catch (Throwable var440) {
                  var21 = var440;
                  throw var440;
               } finally {
                  if (stmt111 != null) {
                     if (var21 != null) {
                        try {
                           stmt111.close();
                        } catch (Throwable var420) {
                           var21.addSuppressed(var420);
                        }
                     } else {
                        stmt111.close();
                     }
                  }

               }
            } catch (Throwable var442) {
               var19 = var442;
               throw var442;
            } finally {
               if (stmt != null) {
                  if (var19 != null) {
                     try {
                        stmt.close();
                     } catch (Throwable var419) {
                        var19.addSuppressed(var419);
                     }
                  } else {
                     stmt.close();
                  }
               }

            }
         } catch (Throwable var444) {
            var17 = var444;
            throw var444;
         } finally {
            if (conn != null) {
               if (var17 != null) {
                  try {
                     conn.close();
                  } catch (Throwable var418) {
                     var17.addSuppressed(var418);
                  }
               } else {
                  conn.close();
               }
            }

         }
      } catch (Exception e) {
         this.logger.error(e.getMessage(), e);
         return "OK";
      }
   }

   public String delBatchTableColumn(String projectId) {
      Properties props = new Properties();

      try {
         props = PropertiesLoaderUtils.loadAllProperties("config.properties");
      } catch (IOException e) {
         e.printStackTrace();
      }

      String columnName = "";
      List<TCoreDatasystem> datasystemList = this.tCoreDatasystemDao.getbyprojectid(projectId);
      if (null != datasystemList && datasystemList.size() != 0) {
         for(TCoreDatasystem datasystem : datasystemList) {
            String dataSystemId = datasystem.getId();
            Boolean isOracle = true;
            if (!datasystem.getDbtype().equals(EdbType.ORACLE.toString())) {
               isOracle = false;
            }

            Boolean isPostgres = true;
            if (!datasystem.getDbtype().equals(EdbType.POSTGRESQL.toString()) && !datasystem.getDbtype().equals(EdbType.GAUSS.toString())) {
               isPostgres = false;
            }

            Boolean isMssqlserver = true;
            if (!datasystem.getDbtype().equals(EdbType.MSSQLSERVER.toString())) {
               isMssqlserver = false;
            }

            Boolean isDM = true;
            if (!datasystem.getDbtype().equals(EdbType.DM.toString())) {
               isDM = false;
            }

            Boolean KBBoolean = true;
            if (!datasystem.getDbtype().equals(EdbType.KINGBASE.toString())) {
               KBBoolean = false;
            }

            Connection conn = null;
            Statement stmtInitail = null;
            Statement stmtCipher = null;
            List<TCoreEncryptionTypeField> schemaFieldList = null;

            try {
               conn = JdbcTool.getConnection(datasystem);
               stmtInitail = conn.createStatement();
               stmtCipher = conn.createStatement();
               if (conn != null) {
                  schemaFieldList = this.tCoreEncryptionTypeFieldDao.queryAll(new Criterion[]{Restrictions.eq("projectid", projectId), Restrictions.eq("datasystem_id", dataSystemId)});
                  Map<String, List<TCoreEncryptionTypeField>> map = (Map)schemaFieldList.stream().collect(Collectors.groupingBy((x) -> x.getTschemas() + "_" + x.getNames()));
                  int checkNum = Integer.valueOf(props.getProperty("checkNum"));

                  for(String key : map.keySet()) {
                     String schema = "";
                     String tableName = "";
                     List<TCoreEncryptionTypeField> v = (List)map.get(key);
                     if (null != v || v.size() != 0) {
                        schema = ((TCoreEncryptionTypeField)v.get(0)).getTschemas();
                        tableName = ((TCoreEncryptionTypeField)v.get(0)).getNames();
                     }

                     int sumNum = 0;
                     ResultSet rsCount = null;
                     List<TCoreEncryptionTypeField> tCorTypeFieldList = null;

                     try {
                        tCorTypeFieldList = this.tCoreEncryptionTypeFieldDao.queryAll(new Criterion[]{Restrictions.eq("projectid", projectId), Restrictions.eq("datasystem_id", dataSystemId), Restrictions.eq("tschemas", schema), Restrictions.eq("names", tableName)});
                        List<ColumnInfoVO> allColumns = this.maksingAppDataRuleService.queryColumnInfo(dataSystemId, schema, tableName);
                        int c = tCorTypeFieldList.size();

                        for(int n = 0; n < c; ++n) {
                           try {
                              if (((TCoreEncryptionTypeField)tCorTypeFieldList.get(n)).getTable_field_id() != null) {
                                 columnName = ((TCoreEncryptionTypeField)tCorTypeFieldList.get(n)).getTable_field_id();
                                 String alterColumnToInitialSql = "";
                                 String alterColumnToCipherSql = "";
                                 if (null != ((TCoreEncryptionTypeField)tCorTypeFieldList.get(n)).getFlag() && !"".equals(((TCoreEncryptionTypeField)tCorTypeFieldList.get(n)).getFlag())) {
                                    String isExistInitailCol = "0";

                                    for(ColumnInfoVO allColumn : allColumns) {
                                       if (isDM) {
                                          if (allColumn.getColumnname().equals(columnName + this.initialSuffix)) {
                                             isExistInitailCol = "1";
                                          }
                                       } else if (allColumn.getColumnname().equals(columnName + this.initialSuffix)) {
                                          isExistInitailCol = "1";
                                       }
                                    }

                                    String columnNameN;
                                    String secretKeyId;
                                    StringBuilder mg111;
                                    if (isExistInitailCol.equals("1")) {
                                       if (!"7".equals(((TCoreEncryptionTypeField)tCorTypeFieldList.get(n)).getFlag()) && !"1".equals(((TCoreEncryptionTypeField)tCorTypeFieldList.get(n)).getFlag()) && !"9".equals(((TCoreEncryptionTypeField)tCorTypeFieldList.get(n)).getFlag()) && !"-1".equals(((TCoreEncryptionTypeField)tCorTypeFieldList.get(n)).getFlag())) {
                                          int iCLimitCount = 0;
                                          ResultSet rsC = null;

                                          try {
                                             if (isOracle) {
                                                rsC = stmtInitail.executeQuery("SELECT COUNT(*) AS num FROM(SELECT * FROM ( select ROWNUM RN ,TT.* FROM  (SELECT * FROM \"" + schema + "\".\"" + tableName + "\" WHERE \"" + columnName + this.initialSuffix + "\" IS NOT NULL AND \"" + columnName + "\" IS NULL) TT ) WHERE RN>" + iCLimitCount + " AND RN <= " + checkNum + ")");
                                             } else if (isPostgres) {
                                                rsC = stmtInitail.executeQuery("SELECT count(*) AS num FROM (SELECT * FROM " + schema + "." + tableName + " WHERE " + columnName + this.initialSuffix + " IS NOT NULL AND (" + columnName + " IS NULL ) offset " + iCLimitCount + " limit " + checkNum + " )t");
                                             } else if (isMssqlserver) {
                                                rsC = stmtInitail.executeQuery("SELECT COUNT(1) AS num FROM (SELECT * FROM " + schema + "." + tableName + " WHERE " + columnName + this.initialSuffix + " IS NOT NULL AND (" + columnName + " IS NULL ) limit " + iCLimitCount + "," + checkNum + " )t");
                                             } else if (isDM) {
                                                rsC = stmtInitail.executeQuery("SELECT COUNT(1) AS num FROM(SELECT * FROM ( select ROWNUM RN ,TT.* FROM  (SELECT * FROM \"" + schema + "\".\"" + tableName + "\" WHERE \"" + columnName + this.initialSuffix + "\" IS NOT NULL AND \"" + columnName + "\" IS NULL) TT ) WHERE RN>" + iCLimitCount + " AND RN <= " + checkNum + ")");
                                             } else if (KBBoolean) {
                                                rsC = stmtInitail.executeQuery("SELECT COUNT(1) AS num FROM(SELECT * FROM ( select ROWNUM RN ,TT.* FROM  (SELECT * FROM \"" + schema + "\".\"" + tableName + "\" WHERE \"" + columnName + this.initialSuffix + "\" IS NOT NULL AND \"" + columnName + "\" IS NULL) TT ) WHERE RN>" + iCLimitCount + " AND RN <= " + checkNum + ")");
                                             } else {
                                                rsC = stmtInitail.executeQuery("SELECT count(1) AS num FROM (SELECT * FROM " + schema + "." + tableName + " WHERE " + columnName + this.initialSuffix + " IS NOT NULL AND (" + columnName + " IS NULL ) limit " + iCLimitCount + "," + checkNum + " )t");
                                             }

                                             int num;
                                             for(num = 0; rsC.next(); num = rsC.getInt("num")) {
                                             }

                                             if (num > 0) {
                                                StringBuilder mg = new StringBuilder();
                                                mg.append("数据源：");
                                                mg.append(schema);
                                                mg.append("表：");
                                                mg.append(tableName);
                                                mg.append("列：");
                                                mg.append(columnName);
                                                mg.append("加密后的数据为空，加密失败，暂时不能删除多余列。");
                                                columnNameN = mg.toString();
                                                return columnNameN;
                                             }
                                          } catch (Exception e) {
                                             e.printStackTrace();
                                          } finally {
                                             if (rsC != null) {
                                                try {
                                                   rsC.close();
                                                } catch (SQLException e) {
                                                   e.printStackTrace();
                                                }
                                             }

                                          }

                                          ResultSet rsC1 = null;

                                          try {
                                             if (isOracle) {
                                                rsC1 = stmtInitail.executeQuery("select nn.\"" + columnName + "\",nn.\"" + columnName + this.initialSuffix + "\" from (select t.\"" + columnName + "\",t.\"" + columnName + this.initialSuffix + "\",rownum rn from \"" + schema + "\".\"" + tableName + "\" t) nn where nn.rn>=" + iCLimitCount + "and nn.rn<" + checkNum);
                                             } else if (isPostgres) {
                                                rsC1 = stmtInitail.executeQuery("select \"" + columnName + "\",\"" + columnName + this.initialSuffix + "\" from \"" + schema + "\".\"" + tableName + "\" LIMIT " + checkNum + " OFFSET " + iCLimitCount);
                                             } else if (isMssqlserver) {
                                                rsC1 = stmtInitail.executeQuery("SELECT " + columnName + "," + columnName + this.initialSuffix + ", 0 AS _NAV_ORDER_F_ FROM " + schema + "." + tableName + " ORDER BY _NAV_ORDER_F_ OFFSET " + iCLimitCount + " ROWS FETCH NEXT " + checkNum + " ROWS ONLY");
                                             } else if (isDM) {
                                                rsC1 = stmtInitail.executeQuery("select \"" + columnName + "\",\"" + columnName + this.initialSuffix + "\" from \"" + schema + "\".\"" + tableName + "\" LIMIT " + iCLimitCount + "," + checkNum);
                                             } else if (KBBoolean) {
                                                rsC1 = stmtInitail.executeQuery("select \"" + columnName + "\",\"" + columnName + this.initialSuffix + "\" from \"" + schema + "\".\"" + tableName + "\" LIMIT " + iCLimitCount + "," + checkNum);
                                             } else {
                                                rsC1 = stmtInitail.executeQuery(this.checkColumn(schema, tableName, columnName, columnName + this.initialSuffix, iCLimitCount, checkNum));
                                             }

                                             while(rsC1.next()) {
                                                String initial = rsC1.getString(columnName + this.initialSuffix);
                                                if (null != initial) {
                                                   columnNameN = rsC1.getString(columnName);
                                                   secretKeyId = ((TCoreEncryptionTypeField)tCorTypeFieldList.get(n)).getEncryption_secretkey_id();
                                                   Map<String, String> encryptionInfo = this.tCoreEncryptionService.queryEncryptionInfo(secretKeyId);
                                                   if (null != encryptionInfo.get("encryptionType") && !"".equals(encryptionInfo.get("encryptionType"))) {
                                                      Boolean isEq = EncUtils.compareStringEq(initial, EncProvider.decryptEcb((String)encryptionInfo.get("encryptionType"), (String)encryptionInfo.get("secretkey"), columnNameN, ((TCoreEncryptionTypeField)tCorTypeFieldList.get(n)).getIslike(), ((TCoreEncryptionTypeField)tCorTypeFieldList.get(n)).getKeepfirst(), ((TCoreEncryptionTypeField)tCorTypeFieldList.get(n)).getEncdigit(), ((TCoreEncryptionTypeField)tCorTypeFieldList.get(n)).getTwoindex()));
                                                      if (!isEq) {
                                                         StringBuilder mg111New = new StringBuilder();
                                                         mg111New.append("数据源：");
                                                         mg111New.append(schema);
                                                         mg111New.append("表：");
                                                         mg111New.append(tableName);
                                                         mg111New.append("列：");
                                                         mg111New.append(columnName);
                                                         mg111New.append("解密校验失败，暂时不能删除多余列。");
                                                         return mg111New.toString();
                                                      }
                                                   }
                                                }
                                             }
                                          } catch (Exception e) {
                                             e.printStackTrace();
                                          } finally {
                                             if (rsC1 != null) {
                                                try {
                                                   rsC1.close();
                                                } catch (SQLException e) {
                                                   e.printStackTrace();
                                                }
                                             }

                                          }
                                       }

                                       if (isOracle) {
                                          alterColumnToInitialSql = "ALTER TABLE \"" + schema + "\".\"" + tableName + "\" DROP (\"" + columnName + this.initialSuffix + "\")";
                                       } else if (isPostgres) {
                                          alterColumnToInitialSql = "ALTER TABLE \"" + schema + "\".\"" + tableName + "\" DROP COLUMN \"" + columnName + this.initialSuffix + "\"";
                                       } else if (isMssqlserver) {
                                          alterColumnToInitialSql = this.delColumn(schema, tableName, columnName + this.initialSuffix);
                                       } else if (isDM) {
                                          alterColumnToInitialSql = "ALTER TABLE \"" + schema + "\".\"" + tableName + "\" DROP COLUMN \"" + columnName + this.initialSuffix + "\"";
                                       } else if (KBBoolean) {
                                          alterColumnToInitialSql = "ALTER TABLE \"" + schema + "\".\"" + tableName + "\" DROP COLUMN \"" + columnName + this.initialSuffix + "\"";
                                       } else {
                                          alterColumnToInitialSql = this.delColumn(schema, tableName, columnName + this.initialSuffix);
                                       }

                                       stmtInitail.executeUpdate(alterColumnToInitialSql);
                                    }

                                    String isExistCipherCol = "0";

                                    for(ColumnInfoVO allColumn : allColumns) {
                                       if (isDM) {
                                          if (allColumn.getColumnname().equals(columnName + this.cipherSuffix)) {
                                             isExistCipherCol = "1";
                                          }
                                       } else if (allColumn.getColumnname().equals(columnName + this.cipherSuffix)) {
                                          isExistCipherCol = "1";
                                       }
                                    }

                                    if (isExistCipherCol.equals("1")) {
                                       if (!"5".equals(((TCoreEncryptionTypeField)tCorTypeFieldList.get(n)).getFlag()) && !"6".equals(((TCoreEncryptionTypeField)tCorTypeFieldList.get(n)).getFlag()) && !"10".equals(((TCoreEncryptionTypeField)tCorTypeFieldList.get(n)).getFlag()) && !"44".equals(((TCoreEncryptionTypeField)tCorTypeFieldList.get(n)).getFlag()) && !"-2".equals(((TCoreEncryptionTypeField)tCorTypeFieldList.get(n)).getFlag())) {
                                          int iCLimitCount = 0;
                                          ResultSet rsC = null;

                                          try {
                                             if (isOracle) {
                                                rsC = stmtCipher.executeQuery("SELECT COUNT(1) AS num FROM(SELECT * FROM ( select ROWNUM RN ,TT.* FROM  (SELECT * FROM \"" + schema + "\".\"" + tableName + "\" WHERE \"" + columnName + this.cipherSuffix + "\" IS NOT NULL AND \"" + columnName + "\" IS NULL) TT ) WHERE RN>" + iCLimitCount + " AND RN <= " + checkNum + ")");
                                             } else if (isPostgres) {
                                                rsC = stmtCipher.executeQuery("SELECT count(1) AS num FROM (SELECT * FROM " + schema + "." + tableName + " WHERE " + columnName + this.cipherSuffix + " IS NOT NULL AND (" + columnName + " IS NULL ) offset " + iCLimitCount + " limit " + checkNum + " )t");
                                             } else if (isMssqlserver) {
                                                rsC = stmtCipher.executeQuery("SELECT COUNT(1) AS num FROM (SELECT * FROM " + schema + "." + tableName + " WHERE " + columnName + this.cipherSuffix + " IS NOT NULL AND (" + columnName + " IS NULL  ) limit " + iCLimitCount + "," + checkNum + " )t");
                                             } else if (isDM) {
                                                rsC = stmtCipher.executeQuery("SELECT COUNT(1) AS num FROM(SELECT * FROM ( select ROWNUM RN ,TT.* FROM  (SELECT * FROM \"" + schema + "\".\"" + tableName + "\" WHERE \"" + columnName + this.cipherSuffix + "\" IS NOT NULL AND \"" + columnName + "\" IS NULL) TT ) WHERE RN>" + iCLimitCount + " AND RN <= " + checkNum + ")");
                                             } else if (KBBoolean) {
                                                rsC = stmtCipher.executeQuery("SELECT COUNT(1) AS num FROM(SELECT * FROM ( select ROWNUM RN ,TT.* FROM  (SELECT * FROM \"" + schema + "\".\"" + tableName + "\" WHERE \"" + columnName + this.cipherSuffix + "\" IS NOT NULL AND \"" + columnName + "\" IS NULL) TT ) WHERE RN>" + iCLimitCount + " AND RN <= " + checkNum + ")");
                                             } else {
                                                rsC = stmtCipher.executeQuery("SELECT count(1) AS num FROM (SELECT * FROM " + schema + "." + tableName + " WHERE " + columnName + this.cipherSuffix + " IS NOT NULL AND (" + columnName + " IS NULL  ) limit " + iCLimitCount + "," + checkNum + " )t");
                                             }

                                             int num;
                                             for(num = 0; rsC.next(); num = rsC.getInt("num")) {
                                             }

                                             if (num > 0) {
                                                StringBuilder columnNameNew = new StringBuilder();
                                                ((StringBuilder)columnNameNew).append("数据源：");
                                                ((StringBuilder)columnNameNew).append(schema);
                                                ((StringBuilder)columnNameNew).append("表：");
                                                ((StringBuilder)columnNameNew).append(tableName);
                                                ((StringBuilder)columnNameNew).append("列：");
                                                ((StringBuilder)columnNameNew).append(columnName);
                                                ((StringBuilder)columnNameNew).append("解密后的数据为空，解密失败，暂时不能删除多余列。");
                                                secretKeyId = ((StringBuilder)columnNameNew).toString();
                                                return secretKeyId;
                                             }
                                          } catch (Exception e) {
                                             e.printStackTrace();
                                          } finally {
                                             if (rsC != null) {
                                                try {
                                                   rsC.close();
                                                } catch (SQLException e) {
                                                   e.printStackTrace();
                                                }
                                             }

                                          }

                                          ResultSet rsC1 = null;

                                          try {
                                             if (isOracle) {
                                                rsC1 = stmtCipher.executeQuery("select nn.\"" + columnName + "\",nn.\"" + columnName + this.cipherSuffix + "\" from (select t.\"" + columnName + "\",t.\"" + columnName + this.cipherSuffix + "\",rownum rn from \"" + schema + "\".\"" + tableName + "\" t) nn where nn.rn>=" + iCLimitCount + "and nn.rn<" + checkNum);
                                             } else if (isPostgres) {
                                                rsC1 = stmtCipher.executeQuery("select \"" + columnName + "\",\"" + columnName + this.cipherSuffix + "\" from \"" + schema + "\".\"" + tableName + "\" LIMIT " + checkNum + " OFFSET " + iCLimitCount);
                                             } else if (isMssqlserver) {
                                                rsC1 = stmtCipher.executeQuery("SELECT " + columnName + "," + columnName + this.cipherSuffix + ", 0 AS _NAV_ORDER_F_ FROM " + schema + "." + tableName + " ORDER BY _NAV_ORDER_F_ OFFSET " + iCLimitCount + " ROWS FETCH NEXT " + checkNum + " ROWS ONLY");
                                             } else if (isDM) {
                                                rsC1 = stmtCipher.executeQuery("select \"" + columnName + "\",\"" + columnName + this.cipherSuffix + "\" from \"" + schema + "\".\"" + tableName + "\" LIMIT " + iCLimitCount + "," + checkNum);
                                             } else if (KBBoolean) {
                                                rsC1 = stmtCipher.executeQuery("select \"" + columnName + "\",\"" + columnName + this.cipherSuffix + "\" from \"" + schema + "\".\"" + tableName + "\" LIMIT " + iCLimitCount + "," + checkNum);
                                             } else {
                                                rsC1 = stmtCipher.executeQuery(this.checkColumn(schema, tableName, columnName, columnName + this.cipherSuffix, iCLimitCount, checkNum));
                                             }

                                             while(rsC1.next()) {
                                                columnNameN = rsC1.getString(columnName + this.cipherSuffix);
                                                if (null != columnNameN) {
                                                   secretKeyId = rsC1.getString(columnName);
                                                   String secretKeyIdNew = ((TCoreEncryptionTypeField)tCorTypeFieldList.get(n)).getEncryption_secretkey_id();
                                                   Map<String, String> encryptionInfo = this.tCoreEncryptionService.queryEncryptionInfo(secretKeyIdNew);
                                                   if (null != encryptionInfo.get("encryptionType") && !"".equals(encryptionInfo.get("encryptionType"))) {
                                                      Boolean isEq = EncUtils.compareStringEq(secretKeyIdNew, EncProvider.decryptEcb((String)encryptionInfo.get("encryptionType"), (String)encryptionInfo.get("secretkey"), columnNameN, ((TCoreEncryptionTypeField)tCorTypeFieldList.get(n)).getIslike(), ((TCoreEncryptionTypeField)tCorTypeFieldList.get(n)).getKeepfirst(), ((TCoreEncryptionTypeField)tCorTypeFieldList.get(n)).getEncdigit(), ((TCoreEncryptionTypeField)tCorTypeFieldList.get(n)).getTwoindex()));
                                                      if (!isEq) {
                                                         mg111 = new StringBuilder();
                                                         mg111.append("数据源：");
                                                         mg111.append(schema);
                                                         mg111.append("表：");
                                                         mg111.append(tableName);
                                                         mg111.append("列：");
                                                         mg111.append(columnName);
                                                         mg111.append("加密校验失败，暂时不能删除多余列。");
                                                         String throwables = mg111.toString();
                                                         return throwables;
                                                      }
                                                   }
                                                }
                                             }
                                          } catch (Exception var253) {
//                                             columnNameN = var253;
                                             var253.printStackTrace();
                                          } finally {
                                             if (rsC1 != null) {
                                                try {
                                                   rsC1.close();
                                                } catch (SQLException e) {
                                                   e.printStackTrace();
                                                }
                                             }

                                          }
                                       }

                                       if (isOracle) {
                                          alterColumnToCipherSql = "ALTER TABLE \"" + schema + "\".\"" + tableName + "\" DROP (\"" + columnName + this.cipherSuffix + "\")";
                                       } else if (isPostgres) {
                                          alterColumnToCipherSql = "ALTER TABLE \"" + schema + "\".\"" + tableName + "\" DROP COLUMN \"" + columnName + this.cipherSuffix + "\"";
                                       } else if (isMssqlserver) {
                                          alterColumnToCipherSql = this.delColumn(schema, tableName, columnName + this.cipherSuffix);
                                       } else if (isDM) {
                                          alterColumnToCipherSql = "ALTER TABLE \"" + schema + "\".\"" + tableName + "\" DROP COLUMN \"" + columnName + this.cipherSuffix + "\"";
                                       } else if (KBBoolean) {
                                          alterColumnToCipherSql = "ALTER TABLE \"" + schema + "\".\"" + tableName + "\" DROP COLUMN \"" + columnName + this.cipherSuffix + "\"";
                                       } else {
                                          alterColumnToCipherSql = this.delColumn(schema, tableName, columnName + this.cipherSuffix);
                                       }

                                       stmtCipher.executeUpdate(alterColumnToCipherSql);
                                    }
                                 }
                              }
                           } catch (Exception e) {
                              e.printStackTrace();
                           } finally {
                              if (rsCount != null) {
                                 try {
                                    rsCount.close();
                                 } catch (SQLException e) {
                                    e.printStackTrace();
                                 }
                              }

                           }
                        }
                     } catch (Exception e) {
                        this.logger.error(e.getMessage(), e);
                     }
                  }
               }
            } catch (Exception e) {
               this.logger.error(e.getMessage(), e);
            } finally {
               try {
                  stmtInitail.close();
                  stmtCipher.close();
                  conn.close();
               } catch (SQLException throwables) {
                  throwables.printStackTrace();
               }

            }
         }

         return "OK";
      } else {
         return "error";
      }
   }

   private TCoreDatasystem getDatasystem(String dataSystemId) {
      TCoreDatasystem datasystem = (TCoreDatasystem)this.tCoreDatasystemDao.queryUnique(new Criterion[]{Restrictions.eq("id", dataSystemId)});
      if (datasystem == null) {
         throw new RuntimeException(String.format("NotFound dataSystemId=[%s]", dataSystemId));
      } else {
         return datasystem;
      }
   }

   private List<TCoreEncryptionTypeField> getFields(String dataSystemId, String schema, String tableName, String flag) {
      Criterion criterion = Restrictions.and(new Criterion[]{Restrictions.eq("datasystem_id", dataSystemId), Restrictions.eq("tschemas", schema), Restrictions.eq("names", tableName), Restrictions.eq("flag", flag)});
      List<TCoreEncryptionTypeField> fields = this.tCoreEncryptionTypeFieldDao.queryAll(new Criterion[]{criterion});
      return fields;
   }

   private List<TCoreEncryptionTypeField> getProjectFields(String projectId, String flag) {
      Criterion criterion = Restrictions.and(Restrictions.eq("projectid", projectId), Restrictions.eq("flag", flag));
      List<TCoreEncryptionTypeField> fields = this.tCoreEncryptionTypeFieldDao.queryAll(new Criterion[]{criterion});
      return fields;
   }

   private String alterColumnToInitialSql(String schema, String tableName, String columnName, String columnType, int columnSize) {
      String sql = String.format("ALTER TABLE %s.%s CHANGE COLUMN %s %s %s(%d)", schema, tableName, columnName, columnName + this.initialSuffix, columnType, columnSize);
      this.logger.info(sql);
      return sql;
   }

   private String alterColumnToInitialSqlProject(String schema, String tableName, String columnName, String columnType, String columnSize) {
      String sql = String.format("ALTER TABLE %s.%s CHANGE COLUMN %s %s %s%s", schema, tableName, columnName, columnName + this.initialSuffix, columnType, columnSize);
      this.logger.info(sql);
      return sql;
   }

   private String addColumn(String schema, String tableName, String columnName, String columnType, String columnSize) {
      String sql = String.format("ALTER TABLE %s.%s ADD COLUMN %s %s%s", schema, tableName, columnName, columnType, columnSize);
      this.logger.info(sql);
      return sql;
   }

   private String delColumn(String schema, String tableName, String columnName) {
      String sql;
      if (NewLoadingTask.ARGODB_FLAG) {
         sql = String.format("ALTER TABLE %s.%s DELETE COLUMNS (%s)", schema, tableName, columnName);
      } else {
         sql = String.format("ALTER TABLE %s.%s DROP COLUMN %s", schema, tableName, columnName);
      }

      this.logger.info(sql);
      return sql;
   }

   private String checkColumn(String schema, String tableName, String columnName, String checkColumnName, int iCLimitCount, int limitCount) {
      String sql = String.format("SELECT %s,%s FROM %s.%s limit %s,%s", columnName, checkColumnName, schema, tableName, iCLimitCount, limitCount);
      this.logger.info(sql);
      return sql;
   }

   private String check(String schema, String tableName, String columnName, String checkColumnName) {
      String sql = String.format("SELECT COUNT(1) AS num FROM %s.%s WHERE %s <> NULL AND (%s = NULL or %s = '')", schema, tableName, checkColumnName, columnName, columnName);
      this.logger.info(sql);
      return sql;
   }

   private String delColumn1(String schema, String tableName, String columnName, String columnName1) {
      String sql = String.format("ALTER TABLE %s.%s DROP COLUMN %s, DROP COLUMN %s", schema, tableName, columnName, columnName1);
      this.logger.info(sql);
      return sql;
   }

   private String dropColumn(String schema, String tableName, String columnName) {
      String sql = String.format("ALTER TABLE %s.%s DROP COLUMN %s", schema, tableName, columnName);
      this.logger.info(sql);
      return sql;
   }

   private String alterCopyToColumnSql(String schema, String tableName, String columnName, String columnType, int columnSize) {
      String sql = String.format("ALTER TABLE %s.%s CHANGE COLUMN %s %s %s(%d)", schema, tableName, columnName + this.copySuffix, columnName, columnType, columnSize);
      this.logger.info(sql);
      return sql;
   }

   private String alterCopyToColumnSqlProject(String schema, String tableName, String columnName, String columnType, String columnSize) {
      String sql = String.format("ALTER TABLE %s.%s CHANGE COLUMN %s %s %s%s", schema, tableName, columnName + this.copySuffix, columnName, columnType, columnSize);
      this.logger.info(sql);
      return sql;
   }

   private String alterColumnToCipherSql(String schema, String tableName, String columnName, String columnType, int columnSize) {
      String sql = String.format("ALTER TABLE %s.%s CHANGE COLUMN %s %s %s(%d)", schema, tableName, columnName, columnName + this.cipherSuffix, columnType, columnSize);
      this.logger.info(sql);
      return sql;
   }

   private String alterColumnToCipherSqlProject(String schema, String tableName, String columnName, String columnType, String columnSize) {
      String sql = String.format("ALTER TABLE %s.%s CHANGE COLUMN %s %s %s%s", schema, tableName, columnName, columnName + this.cipherSuffix, columnType, columnSize);
      this.logger.info(sql);
      return sql;
   }

   private String columnSizeSql(String schema, String tableName, String columnName) {
      String sql = String.format("SELECT %s FROM %s.%s WHERE 1=2", columnName, schema, tableName);
      this.logger.info(sql);
      return sql;
   }

   private int updateFieldFlag(String id, String flag) {
      int num = this.jdbcTemplate.update("UPDATE t_core_encryption_field SET flag = ? WHERE id = ?", new Object[]{flag, id});
      return num;
   }

   private String checkDecryption(TCoreDatasystem tCoreDatasystem, String schema, String tableName, String columnName, String secretKeyId, String isLike, String keepfirst, String encdigit, String twoindex) {
      ResultSet rsCount = null;
      int checkNum = PropertyGhcaUtil.checkNum;
      int sumNum = 0;
      TCoreEncryptionService tCoreEncryptionService = (TCoreEncryptionService)ApplicationContextProvider.getBean(TCoreEncryptionContext.class);

      try {
         Connection conn = JdbcTool.getConnection(tCoreDatasystem);
         Throwable var15 = null;

         try {
            Statement stmt = conn.createStatement();
            Throwable var17 = null;

            try {
               String copySuffix = PropertyGhcaUtil.copySuffix;
               Boolean bb = true;
               if (!tCoreDatasystem.getDbtype().equals(EdbType.ORACLE.toString())) {
                  bb = false;
               }

               Boolean bbb = true;
               if (!tCoreDatasystem.getDbtype().equals(EdbType.POSTGRESQL.toString()) && !tCoreDatasystem.getDbtype().equals(EdbType.GAUSS.toString())) {
                  bbb = false;
               }

               Boolean isGreenplum = true;
               if (!tCoreDatasystem.getDbtype().equals(EdbType.GREENPLUM.toString())) {
                  isGreenplum = false;
               }

               Boolean SQBoolean = true;
               if (!tCoreDatasystem.getDbtype().equals(EdbType.MSSQLSERVER.toString())) {
                  SQBoolean = false;
               }

               Boolean DMBoolean = true;
               if (!tCoreDatasystem.getDbtype().equals(EdbType.DM.toString())) {
                  DMBoolean = false;
               }

               Boolean KBBoolean = true;
               if (!tCoreDatasystem.getDbtype().equals(EdbType.KINGBASE.toString())) {
                  KBBoolean = false;
               }

               Boolean isHivetdh = true;
               if (!tCoreDatasystem.getDbtype().equals(EdbType.HIVE_TDH.toString())) {
                  isHivetdh = false;
               }

               int iCLimitCount = 0;
               ResultSet rsC = null;

               String copy;
               try {
                  if (bb) {
                     rsC = stmt.executeQuery("SELECT COUNT(1) AS num FROM(SELECT * FROM ( select ROWNUM RN ,TT.* FROM  (SELECT * FROM \"" + schema + "\".\"" + tableName + "\" WHERE \"" + columnName + "\" IS NOT NULL AND \"" + columnName + copySuffix + "\" IS NULL) TT ) WHERE RN>" + iCLimitCount + " AND RN <= " + checkNum + ")");
                  } else if (bbb) {
                     rsC = stmt.executeQuery("SELECT count(1) AS num FROM (SELECT * FROM " + schema + "." + tableName + " WHERE " + columnName + " IS NOT NULL AND (" + columnName + copySuffix + " IS NULL  ) offset " + iCLimitCount + " limit " + checkNum + " )t");
                  } else if (isGreenplum) {
                     rsC = stmt.executeQuery("SELECT count(1) AS num FROM (SELECT * FROM " + schema + "." + tableName + " WHERE " + columnName + " IS NOT NULL AND (" + columnName + copySuffix + " IS NULL  ) offset " + iCLimitCount + " limit " + checkNum + " )t");
                  } else if (SQBoolean) {
                     rsC = stmt.executeQuery("SELECT COUNT(1) AS num FROM " + schema + "." + tableName + " WHERE " + columnName + " IS NOT NULL AND (" + columnName + copySuffix + " IS NULL  ) limit " + iCLimitCount + "," + checkNum);
                  } else if (isHivetdh) {
                     rsC = stmt.executeQuery("SELECT COUNT(1) AS num FROM (SELECT * FROM " + schema + "." + tableName + " WHERE " + columnName + " IS NOT NULL AND (" + columnName + copySuffix + " IS NULL  ) limit " + iCLimitCount + "," + checkNum + " )t");
                  } else if (DMBoolean) {
                     rsC = stmt.executeQuery("SELECT COUNT(1) AS num FROM(SELECT * FROM ( select ROWNUM RN ,TT.* FROM  (SELECT * FROM \"" + schema + "\".\"" + tableName + "\" WHERE \"" + columnName + "\" IS NOT NULL AND \"" + columnName + copySuffix + "\" IS NULL) TT ) WHERE RN>" + iCLimitCount + " AND RN <= " + checkNum + ")");
                  } else if (KBBoolean) {
                     rsC = stmt.executeQuery("SELECT COUNT(1) AS num FROM(SELECT * FROM ( select ROWNUM RN ,TT.* FROM  (SELECT * FROM \"" + schema + "\".\"" + tableName + "\" WHERE \"" + columnName + "\" IS NOT NULL AND \"" + columnName + copySuffix + "\" IS NULL) TT ) WHERE RN>" + iCLimitCount + " AND RN <= " + checkNum + ")");
                  } else {
                     rsC = stmt.executeQuery("SELECT count(1) AS num FROM (SELECT * FROM " + schema + "." + tableName + " WHERE " + columnName + " IS NOT NULL AND (" + columnName + copySuffix + " IS NULL ) limit " + iCLimitCount + "," + checkNum + " )t");
                  }

                  int num;
                  for(num = 0; rsC.next(); num = rsC.getInt("num")) {
                  }

                  if (num > 0) {
                     StringBuilder mg = new StringBuilder();
                     mg.append("数据源：");
                     mg.append(schema);
                     mg.append("表：");
                     mg.append(tableName);
                     mg.append("列：");
                     mg.append(columnName);
                     mg.append("解密后的数据为空，解密失败，准备回滚。");
                     copy = mg.toString();
                     return copy;
                  }
               } catch (Exception e) {
                  e.printStackTrace();
               } finally {
                  if (rsC != null) {
                     try {
                        rsC.close();
                     } catch (SQLException e) {
                        e.printStackTrace();
                     }
                  }

               }

               int LimitCount = 0;
               ResultSet rs1 = null;

               try {
                  String columnNameN;
                  try {
                     if (bb) {
                        rs1 = stmt.executeQuery("select nn.\"" + columnName + "\",nn.\"" + columnName + copySuffix + "\" from (select t.\"" + columnName + "\",t.\"" + columnName + copySuffix + "\",rownum rn from \"" + schema + "\".\"" + tableName + "\" t) nn where nn.rn>=" + iCLimitCount + "and nn.rn<" + checkNum);
                     } else if (bbb) {
                        rs1 = stmt.executeQuery("select \"" + columnName + "\",\"" + columnName + copySuffix + "\" from \"" + schema + "\".\"" + tableName + "\" LIMIT " + checkNum + " OFFSET " + iCLimitCount);
                     } else if (isGreenplum) {
                        rs1 = stmt.executeQuery("select \"" + columnName + "\",\"" + columnName + copySuffix + "\" from \"" + schema + "\".\"" + tableName + "\" LIMIT " + checkNum + " OFFSET " + iCLimitCount);
                     } else if (isHivetdh) {
                        rs1 = stmt.executeQuery("select " + columnName + "," + columnName + copySuffix + " from " + schema + "." + tableName + " LIMIT " + iCLimitCount + " , " + checkNum);
                     } else if (SQBoolean) {
                        rs1 = stmt.executeQuery("SELECT " + columnName + "," + columnName + copySuffix + ", 0 AS _NAV_ORDER_F_ FROM " + schema + "." + tableName + " ORDER BY _NAV_ORDER_F_ OFFSET " + iCLimitCount + " ROWS FETCH NEXT " + checkNum + " ROWS ONLY");
                     } else if (DMBoolean) {
                        rs1 = stmt.executeQuery("select \"" + columnName + "\",\"" + columnName + copySuffix + "\" from \"" + schema + "\".\"" + tableName + "\" LIMIT " + iCLimitCount + "," + checkNum);
                     } else if (KBBoolean) {
                        rs1 = stmt.executeQuery("select \"" + columnName + "\",\"" + columnName + copySuffix + "\" from \"" + schema + "\".\"" + tableName + "\" LIMIT " + iCLimitCount + "," + checkNum);
                     } else {
                        rs1 = stmt.executeQuery(this.checkColumn(schema, tableName, columnName, columnName + copySuffix, iCLimitCount, checkNum));
                     }

                     while(rs1.next()) {
                        copy = rs1.getString(columnName + copySuffix);
                        if (null != copy) {
                           columnNameN = rs1.getString(columnName);
                           if (!EncUtils.compareStringEq(columnNameN, copy)) {
                              Map<String, String> encryptionInfo = tCoreEncryptionService.queryEncryptionInfo(secretKeyId);
                              if (null != encryptionInfo.get("encryptionType") && !"".equals(encryptionInfo.get("encryptionType"))) {
                                 Boolean isEq = EncUtils.compareStringEq(columnNameN, EncProvider.encryptEcb((String)encryptionInfo.get("encryptionType"), (String)encryptionInfo.get("secretkey"), copy, isLike, keepfirst, encdigit, twoindex));
                                 if (!isEq) {
                                    StringBuilder mg111 = new StringBuilder();
                                    mg111.append("数据源：");
                                    mg111.append(schema);
                                    mg111.append("表：");
                                    mg111.append(tableName);
                                    mg111.append("列：");
                                    mg111.append(columnName);
                                    mg111.append("解密后的数据加密后与原数据不一致，准备回滚。");
                                    String var35 = mg111.toString();
                                    return var35;
                                 }
                              }
                           }
                        }
                     }

                     return "ok";
                  } catch (Exception var132) {
//                     copy = var132;
                     var132.printStackTrace();
                     columnNameN = "e1";
                     return columnNameN;
                  }
               } finally {
                  if (rs1 != null) {
                     try {
                        rs1.close();
                     } catch (SQLException e) {
                        e.printStackTrace();
                     }
                  }

               }
            } catch (Throwable var136) {
               var17 = var136;
               throw var136;
            } finally {
               if (stmt != null) {
                  if (var17 != null) {
                     try {
                        stmt.close();
                     } catch (Throwable var129) {
                        var17.addSuppressed(var129);
                     }
                  } else {
                     stmt.close();
                  }
               }

            }
         } catch (Throwable var138) {
            var15 = var138;
            throw var138;
         } finally {
            if (conn != null) {
               if (var15 != null) {
                  try {
                     conn.close();
                  } catch (Throwable var128) {
                     var15.addSuppressed(var128);
                  }
               } else {
                  conn.close();
               }
            }

         }
      } catch (Exception e) {
         e.printStackTrace();
         return "e2";
      }
   }

   private String checkEncryption(TCoreDatasystem tCoreDatasystem, String schema, String tableName, String columnName, String secretKeyId, String isLike, String keepfirst, String encdigit, String twoindex) {
      ResultSet rsCount = null;
      int checkNum = Integer.valueOf(PropertyGhcaUtil.checkNum);
      int sumNum = 0;
      TCoreEncryptionService tCoreEncryptionService = (TCoreEncryptionService)ApplicationContextProvider.getBean(TCoreEncryptionContext.class);

      try {
         Connection conn = JdbcTool.getConnection(tCoreDatasystem);
         Throwable var15 = null;

         try {
            Statement stmt = conn.createStatement();
            Throwable var17 = null;

            try {
               String copySuffix = PropertyGhcaUtil.copySuffix;
               Boolean bb = true;
               if (!tCoreDatasystem.getDbtype().equals(EdbType.ORACLE.toString())) {
                  bb = false;
               }

               Boolean bbb = true;
               if (!tCoreDatasystem.getDbtype().equals(EdbType.POSTGRESQL.toString()) && !tCoreDatasystem.getDbtype().equals(EdbType.GAUSS.toString())) {
                  bbb = false;
               }

               Boolean isGreenplum = true;
               if (!tCoreDatasystem.getDbtype().equals(EdbType.GREENPLUM.toString())) {
                  isGreenplum = false;
               }

               Boolean SQBoolean = true;
               if (!tCoreDatasystem.getDbtype().equals(EdbType.MSSQLSERVER.toString())) {
                  SQBoolean = false;
               }

               Boolean DMBoolean = true;
               if (!tCoreDatasystem.getDbtype().equals(EdbType.DM.toString())) {
                  DMBoolean = false;
               }

               Boolean KBBoolean = true;
               if (!tCoreDatasystem.getDbtype().equals(EdbType.KINGBASE.toString())) {
                  KBBoolean = false;
               }

               Boolean isHivetdh = true;
               if (!tCoreDatasystem.getDbtype().equals(EdbType.HIVE_TDH.toString())) {
                  isHivetdh = false;
               }

               int iCLimitCount = 0;
               ResultSet rsC = null;

               String columnNameN;
               try {
                  if (bb) {
                     rsC = stmt.executeQuery("SELECT COUNT(1) AS num FROM(SELECT * FROM ( select ROWNUM RN ,TT.* FROM  (SELECT * FROM \"" + schema + "\".\"" + tableName + "\" WHERE \"" + columnName + "\" IS NOT NULL AND \"" + columnName + copySuffix + "\" IS NULL) TT ) WHERE RN>" + iCLimitCount + " AND RN <= " + checkNum + ")");
                  } else if (bbb) {
                     rsC = stmt.executeQuery("SELECT count(1) AS num FROM (SELECT * FROM " + schema + "." + tableName + " WHERE \"" + columnName + "\" IS NOT NULL AND (" + columnName + copySuffix + " IS NULL ) offset " + iCLimitCount + " limit " + checkNum + " )t");
                  } else if (isGreenplum) {
                     rsC = stmt.executeQuery("SELECT count(1) AS num FROM (SELECT * FROM " + schema + "." + tableName + " WHERE \"" + columnName + "\" IS NOT NULL AND (" + columnName + copySuffix + " IS NULL ) offset " + iCLimitCount + " limit " + checkNum + " )t");
                  } else if (tCoreDatasystem.getDbtype().equals(EdbType.GAUSS.toString())) {
                     rsC = stmt.executeQuery("SELECT count(1) AS num FROM (SELECT * FROM " + schema + "." + tableName + " WHERE \"" + columnName + "\" IS NOT NULL AND (" + columnName + copySuffix + " IS NULL ) offset " + iCLimitCount + " limit " + checkNum + " )t");
                  } else if (tCoreDatasystem.getDbtype().equals(EdbType.HIVE_TDH.toString())) {
                     rsC = stmt.executeQuery("SELECT count(1) AS num FROM " + schema + "." + tableName + " WHERE " + columnName + " IS NOT NULL AND (" + columnName + copySuffix + " IS NULL ) limit " + iCLimitCount + " , " + checkNum + " )t");
                  } else if (SQBoolean) {
                     rsC = stmt.executeQuery("SELECT COUNT(1) AS num FROM (SELECT * FROM " + schema + "." + tableName + " WHERE " + columnName + " IS NOT NULL AND (" + columnName + copySuffix + " IS NULL ) limit " + iCLimitCount + "," + checkNum + " )t");
                  } else if (DMBoolean) {
                     rsC = stmt.executeQuery("SELECT COUNT(1) AS num FROM(SELECT * FROM ( select ROWNUM RN ,TT.* FROM  (SELECT * FROM \"" + schema + "\".\"" + tableName + "\" WHERE \"" + columnName + "\" IS NOT NULL AND \"" + columnName + copySuffix + "\" IS NULL) TT ) WHERE RN>" + iCLimitCount + " AND RN <= " + checkNum + ")");
                  } else if (KBBoolean) {
                     rsC = stmt.executeQuery("SELECT COUNT(1) AS num FROM(SELECT * FROM ( select ROWNUM RN ,TT.* FROM  (SELECT * FROM \"" + schema + "\".\"" + tableName + "\" WHERE \"" + columnName + "\" IS NOT NULL AND \"" + columnName + copySuffix + "\" IS NULL) TT ) WHERE RN>" + iCLimitCount + " AND RN <= " + checkNum + ")");
                  } else {
                     rsC = stmt.executeQuery("SELECT count(1) AS num FROM (SELECT * FROM " + schema + "." + tableName + " WHERE " + columnName + " IS NOT NULL AND (" + columnName + copySuffix + " IS NULL ) limit " + iCLimitCount + "," + checkNum + " )t");
                  }

                  int num;
                  for(num = 0; rsC.next(); num = rsC.getInt("num")) {
                  }

                  if (num > 0) {
                     StringBuilder mg = new StringBuilder();
                     mg.append("数据源：");
                     mg.append(schema);
                     mg.append("表：");
                     mg.append(tableName);
                     mg.append("列：");
                     mg.append(columnName);
                     mg.append("加密后的数据为空，加密失败，准备回滚。");
                     columnNameN = mg.toString();
                     return columnNameN;
                  }
               } catch (Exception e) {
                  e.printStackTrace();
               } finally {
                  if (rsC != null) {
                     try {
                        rsC.close();
                     } catch (SQLException e) {
                        e.printStackTrace();
                     }
                  }

               }

               ResultSet rs1 = null;

               try {
                  if (bb) {
                     rs1 = stmt.executeQuery("select nn.\"" + columnName + "\",nn.\"" + columnName + copySuffix + "\" from (select t.\"" + columnName + "\",t.\"" + columnName + copySuffix + "\",rownum rn from \"" + schema + "\".\"" + tableName + "\" t) nn where nn.rn>=" + iCLimitCount + "and nn.rn<" + checkNum);
                  } else if (bbb) {
                     rs1 = stmt.executeQuery("select \"" + columnName + "\",\"" + columnName + copySuffix + "\" from \"" + schema + "\".\"" + tableName + "\" LIMIT " + checkNum + " OFFSET " + iCLimitCount);
                  } else if (isGreenplum) {
                     rs1 = stmt.executeQuery("select \"" + columnName + "\",\"" + columnName + copySuffix + "\" from \"" + schema + "\".\"" + tableName + "\" LIMIT " + checkNum + " OFFSET " + iCLimitCount);
                  } else if (tCoreDatasystem.getDbtype().equals(EdbType.GAUSS.toString())) {
                     rs1 = stmt.executeQuery("select \"" + columnName + "\",\"" + columnName + copySuffix + "\" from \"" + schema + "\".\"" + tableName + "\" LIMIT " + checkNum + " OFFSET " + iCLimitCount);
                  } else if (isHivetdh) {
                     rs1 = stmt.executeQuery("select " + columnName + "," + columnName + copySuffix + " from " + schema + "." + tableName + " LIMIT " + iCLimitCount + " , " + checkNum);
                  } else if (SQBoolean) {
                     rs1 = stmt.executeQuery("SELECT " + columnName + "," + columnName + copySuffix + ", 0 AS _NAV_ORDER_F_ FROM " + schema + "." + tableName + " ORDER BY _NAV_ORDER_F_ OFFSET " + iCLimitCount + " ROWS FETCH NEXT " + checkNum + " ROWS ONLY");
                  } else if (KBBoolean) {
                     rs1 = stmt.executeQuery("select \"" + columnName + "\",\"" + columnName + copySuffix + "\" from \"" + schema + "\".\"" + tableName + "\" LIMIT " + iCLimitCount + "," + checkNum);
                  } else if (DMBoolean) {
                     rs1 = stmt.executeQuery("select \"" + columnName + "\",\"" + columnName + copySuffix + "\" from \"" + schema + "\".\"" + tableName + "\" LIMIT " + iCLimitCount + "," + checkNum);
                  } else {
                     rs1 = stmt.executeQuery(this.checkColumn(schema, tableName, columnName, columnName + copySuffix, iCLimitCount, checkNum));
                  }

                  while(rs1.next()) {
                     String copy = rs1.getString(columnName + copySuffix);
                     if (null != copy) {
                        columnNameN = rs1.getString(columnName);
                        Map<String, String> encryptionInfo = tCoreEncryptionService.queryEncryptionInfo(secretKeyId);
                        if (null != encryptionInfo.get("encryptionType") && !"".equals(encryptionInfo.get("encryptionType"))) {
                           Boolean isEq = EncUtils.compareStringEq(columnNameN, EncProvider.decryptEcb((String)encryptionInfo.get("encryptionType"), (String)encryptionInfo.get("secretkey"), copy, isLike, keepfirst, encdigit, twoindex));
                           if (!isEq) {
                              StringBuilder mg111 = new StringBuilder();
                              mg111.append("数据源：");
                              mg111.append(schema);
                              mg111.append("表：");
                              mg111.append(tableName);
                              mg111.append("列：");
                              mg111.append(columnName);
                              mg111.append("加密后的数据解密后与元数据不一致，准备回滚。");
                              String var34 = mg111.toString();
                              return var34;
                           }
                        }
                     }
                  }

                  return "ok";
               } catch (Exception e) {
                  e.printStackTrace();
                  columnNameN = "e1";
                  return columnNameN;
               } finally {
                  if (rs1 != null) {
                     try {
                        rs1.close();
                     } catch (SQLException e) {
                        e.printStackTrace();
                     }
                  }

               }
            } catch (Throwable var135) {
               var17 = var135;
               throw var135;
            } finally {
               if (stmt != null) {
                  if (var17 != null) {
                     try {
                        stmt.close();
                     } catch (Throwable var128) {
                        var17.addSuppressed(var128);
                     }
                  } else {
                     stmt.close();
                  }
               }

            }
         } catch (Throwable var137) {
            var15 = var137;
            throw var137;
         } finally {
            if (conn != null) {
               if (var15 != null) {
                  try {
                     conn.close();
                  } catch (Throwable var127) {
                     var15.addSuppressed(var127);
                  }
               } else {
                  conn.close();
               }
            }

         }
      } catch (Exception e) {
         e.printStackTrace();
         return "e2";
      }
   }

   private String delCopyColumn(String schema, String tableName, String columnName) {
      String sql = String.format("ALTER TABLE %s.%s DROP COLUMN %s", schema, tableName, columnName);
      return sql;
   }

   private void rollbackColumns(Connection conn, List<TCoreEncryptionTypeField> allColumns, String suffix, List<String> colSizes, List<String> pkFlags, List<String> pkCols, List<TCoreEncryptionTypeField> checkFailed, TCoreDatasystem tCoreDatasystem) {
      if (allColumns != null && allColumns.size() != 0) {
         TCoreEncryptionTypeField proto = (TCoreEncryptionTypeField)allColumns.get(0);
         Set<String> colSet = JdbcTool.getColumnMap(conn, proto.getTschemas(), proto.getTable_field_id());

         for(int i = 0; i < allColumns.size(); ++i) {
            try {
               TCoreEncryptionTypeField column = (TCoreEncryptionTypeField)allColumns.get(i);
               if (checkFailed == null || checkFailed.size() <= 0 || !checkFailed.stream().anyMatch((x) -> x != null && x.getNames().equalsIgnoreCase(column.getNames()))) {
                  JdbcTool.rollbackReplaceColumn(conn, colSet, column.getTschemas(), column.getNames(), column.getTable_field_id(), column.getTable_field_id() + suffix, column.getColumn_type(), (String)colSizes.get(i), (String)pkFlags.get(i), (String)pkCols.get(i), column.getNames(), tCoreDatasystem);
               }
            } catch (Exception ex) {
               ex.printStackTrace();
            }
         }

      }
   }

   public String newDelTableColumn(String projectId, String dataSystemId, String schema, String tableName) {
      TCoreDatasystem datasystem = this.getDatasystem(dataSystemId);
      Boolean isOracleType = true;
      if (!datasystem.getDbtype().equals(EdbType.ORACLE.toString())) {
         isOracleType = false;
      }

      Boolean isPostgresql = true;
      if (!datasystem.getDbtype().equals(EdbType.POSTGRESQL.toString()) && !datasystem.getDbtype().equals(EdbType.GAUSS.toString())) {
         isPostgresql = false;
      }

      Boolean isMSsqlserver = true;
      if (!datasystem.getDbtype().equals(EdbType.MSSQLSERVER.toString())) {
         isMSsqlserver = false;
      }

      Boolean DMBoolean = true;
      if (!datasystem.getDbtype().equals(EdbType.DM.toString())) {
         DMBoolean = false;
      }

      Boolean KBBoolean = true;
      if (!datasystem.getDbtype().equals(EdbType.KINGBASE.toString())) {
         KBBoolean = false;
      }

      Boolean isDB2 = true;
      if (!datasystem.getDbtype().equals(EdbType.DB2.toString())) {
         isDB2 = false;
      }

      String columnName = "";
      List<ColumnInfoVO> allColumns = this.maksingAppDataRuleService.queryColumnInfo(dataSystemId, schema, tableName);
      int sumNum = 0;
      ResultSet rsCount = null;
      if (!"MONGODB".equals(datasystem.getDbtype()) && !"ES".equals(datasystem.getDbtype())) {
         try {
            Connection conn = JdbcTool.getConnection(datasystem);
            Throwable var154 = null;

            String alterColumnToInitialSql;
            try {
               Statement stmt = conn.createStatement();
               Throwable var161 = null;

               try {
                  Statement stmt111 = conn.createStatement();
                  Throwable var167 = null;

                  try {
                     List<TCoreEncryptionTypeField> tCorTypeFieldList = this.tCoreEncryptionTypeFieldDao.queryAll(new Criterion[]{Restrictions.eq("projectid", projectId), Restrictions.eq("datasystem_id", dataSystemId), Restrictions.eq("tschemas", schema), Restrictions.eq("names", tableName)});
                     Iterator var174 = tCorTypeFieldList.iterator();

                     TCoreEncryptionTypeField tCoreEncryptionTypeField;
                     do {
                        if (!var174.hasNext()) {
                           int c = tCorTypeFieldList.size();

                           for(int n = 0; n < c; ++n) {
                              try {
                                 if (((TCoreEncryptionTypeField)tCorTypeFieldList.get(n)).getTable_field_id() != null) {
                                    columnName = ((TCoreEncryptionTypeField)tCorTypeFieldList.get(n)).getTable_field_id();
                                    alterColumnToInitialSql = "";
                                    if (null != ((TCoreEncryptionTypeField)tCorTypeFieldList.get(n)).getFlag() && !"".equals(((TCoreEncryptionTypeField)tCorTypeFieldList.get(n)).getFlag())) {
                                       String isExistCopyCol = "0";

                                       for(ColumnInfoVO allColumn : allColumns) {
                                          if (allColumn.getColumnname().equals(columnName + this.copySuffix)) {
                                             isExistCopyCol = "1";
                                             break;
                                          }
                                       }

                                       if (isExistCopyCol.equals("1") && ("7".equals(((TCoreEncryptionTypeField)tCorTypeFieldList.get(n)).getFlag()) || "0".equals(((TCoreEncryptionTypeField)tCorTypeFieldList.get(n)).getFlag()) || "5".equals(((TCoreEncryptionTypeField)tCorTypeFieldList.get(n)).getFlag()))) {
                                          if (isOracleType) {
                                             alterColumnToInitialSql = "ALTER TABLE \"" + schema + "\".\"" + tableName + "\" DROP (\"" + columnName + this.copySuffix + "\")";
                                          } else if (isPostgresql) {
                                             alterColumnToInitialSql = "ALTER TABLE \"" + schema + "\".\"" + tableName + "\" DROP COLUMN \"" + columnName + this.copySuffix + "\"";
                                          } else if (isMSsqlserver) {
                                             alterColumnToInitialSql = this.delColumn(schema, tableName, columnName + this.copySuffix);
                                          } else if (DMBoolean) {
                                             alterColumnToInitialSql = "ALTER TABLE \"" + schema + "\".\"" + tableName + "\" DROP COLUMN \"" + columnName + this.copySuffix + "\"";
                                          } else if (KBBoolean) {
                                             alterColumnToInitialSql = "ALTER TABLE \"" + schema + "\".\"" + tableName + "\" DROP COLUMN \"" + columnName + this.copySuffix + "\"";
                                          } else if (isDB2) {
                                             alterColumnToInitialSql = "ALTER TABLE \"" + schema + "\".\"" + tableName + "\" DROP COLUMN \"" + columnName + this.copySuffix + "\"";
                                          } else {
                                             alterColumnToInitialSql = this.delColumn(schema, tableName, columnName + this.copySuffix);
                                          }

                                          try {
                                             stmt.executeUpdate(alterColumnToInitialSql);
                                             if ("DB2".equals(datasystem.getDbtype())) {
                                                CallableStatement cs = conn.prepareCall("call SYSPROC.ADMIN_CMD('reorg table " + schema + "." + tableName + "')");
                                                cs.execute();
                                                cs.close();
                                             }
                                          } catch (SQLException se) {
                                             if (se.getMessage().contains("依赖于") && isMSsqlserver) {
                                                String constraint = se.getMessage().split("'")[1];
                                                String deleteConstraint = "alter table  " + schema + "." + tableName + " drop constraint " + constraint;
                                                stmt.executeUpdate(deleteConstraint);
                                                stmt.executeUpdate(alterColumnToInitialSql);
                                             }
                                          }
                                       }
                                    }
                                 }
                              } catch (Exception var136) {
//                                 alterColumnToInitialSql = var136;
                                 var136.printStackTrace();
                              } finally {
                                 if (rsCount != null) {
                                    try {
                                       rsCount.close();
                                    } catch (SQLException e) {
                                       e.printStackTrace();
                                    }
                                 }

                              }
                           }

                           return "OK";
                        }

                        tCoreEncryptionTypeField = (TCoreEncryptionTypeField)var174.next();
                     } while(!"4".equals(tCoreEncryptionTypeField.getFlag()) && !"44".equals(tCoreEncryptionTypeField.getFlag()));

                     alterColumnToInitialSql = "hasfailedstatus";
                  } catch (Throwable var138) {
                     var167 = var138;
                     throw var138;
                  } finally {
                     if (stmt111 != null) {
                        if (var167 != null) {
                           try {
                              stmt111.close();
                           } catch (Throwable var132) {
                              var167.addSuppressed(var132);
                           }
                        } else {
                           stmt111.close();
                        }
                     }

                  }
               } catch (Throwable var140) {
                  var161 = var140;
                  throw var140;
               } finally {
                  if (stmt != null) {
                     if (var161 != null) {
                        try {
                           stmt.close();
                        } catch (Throwable var131) {
                           var161.addSuppressed(var131);
                        }
                     } else {
                        stmt.close();
                     }
                  }

               }
            } catch (Throwable var142) {
               var154 = var142;
               throw var142;
            } finally {
               if (conn != null) {
                  if (var154 != null) {
                     try {
                        conn.close();
                     } catch (Throwable var130) {
                        var154.addSuppressed(var130);
                     }
                  } else {
                     conn.close();
                  }
               }

            }

            return alterColumnToInitialSql;
         } catch (Exception e) {
            this.logger.error(e.getMessage(), e);
         }
      } else if ("ES".equals(datasystem.getDbtype())) {
         try {
            List<TCoreEncryptionTypeField> tCorTypeFieldList = this.tCoreEncryptionTypeFieldDao.queryAll(new Criterion[]{Restrictions.eq("projectid", projectId), Restrictions.eq("datasystem_id", dataSystemId), Restrictions.eq("tschemas", schema), Restrictions.eq("names", tableName)});

            for(TCoreEncryptionTypeField tCoreEncryptionTypeField : tCorTypeFieldList) {
               if ("4".equals(tCoreEncryptionTypeField.getFlag()) || "44".equals(tCoreEncryptionTypeField.getFlag())) {
                  return "hasfailedstatus";
               }
            }

            EsUtil esUtil = new EsUtil();

            for(TCoreEncryptionTypeField tCoreEncryptionTypeField : tCorTypeFieldList) {
               if (tCoreEncryptionTypeField.getTable_field_id() != null) {
                  columnName = tCoreEncryptionTypeField.getTable_field_id();
                  if (null != tCoreEncryptionTypeField.getFlag() && !"".equals(tCoreEncryptionTypeField.getFlag())) {
                     String isExistCopyCol = "0";
                     Set<String> columns = esUtil.getColumnsIncludeCopyColumn(datasystem, schema, tableName);

                     for(String column : columns.stream().map((x) -> {
                        String[] m = x.split(":");
                        return m[0];
                     }).collect(Collectors.toSet())) {
                        if (column.equals(columnName + this.copySuffix)) {
                           isExistCopyCol = "1";
                           break;
                        }
                     }

                     if (isExistCopyCol.equals("1") && ("7".equals(tCoreEncryptionTypeField.getFlag()) || "0".equals(tCoreEncryptionTypeField.getFlag()) || "5".equals(tCoreEncryptionTypeField.getFlag()))) {
                        ClientInterface connect = GHCAUtils.getInstance().connectToES(datasystem.getDbip(), datasystem.getDbport(), datasystem.getUsername(), AesTool.decrypt(datasystem.getPassword(), "ghca"));
                        boolean del = true;

                        while(del) {
                           try {
                              esUtil.delColumnCopy(connect, schema, tableName, columnName, this.copySuffix);
                              Thread.sleep(200L);
                              del = false;
                           } catch (Exception var134) {
                              connect = GHCAUtils.getInstance().connectToES(datasystem.getDbip(), datasystem.getDbport(), datasystem.getUsername(), AesTool.decrypt(datasystem.getPassword(), "ghca"));
                              del = true;
                           }
                        }
                     }
                  }
               }
            }
         } catch (Exception e) {
            e.printStackTrace();
         }
      } else {
         try {
            MongoClient connect = MongodbTool.connect(datasystem.getDbservername(), datasystem.getUsername(), AesTool.decrypt(datasystem.getPassword(), "ghca"), datasystem.getDbip(), Integer.parseInt(datasystem.getDbport()), true);
            List<TCoreEncryptionTypeField> tCorTypeFieldList = this.tCoreEncryptionTypeFieldDao.queryAll(new Criterion[]{Restrictions.eq("projectid", projectId), Restrictions.eq("datasystem_id", dataSystemId), Restrictions.eq("tschemas", schema), Restrictions.eq("names", tableName)});

            for(TCoreEncryptionTypeField tCoreEncryptionTypeField : tCorTypeFieldList) {
               if ("4".equals(tCoreEncryptionTypeField.getFlag()) || "44".equals(tCoreEncryptionTypeField.getFlag())) {
                  return "hasfailedstatus";
               }
            }

            for(TCoreEncryptionTypeField tCoreEncryptionTypeField : tCorTypeFieldList) {
               if (tCoreEncryptionTypeField.getTable_field_id() != null) {
                  columnName = tCoreEncryptionTypeField.getTable_field_id();
                  if (null != tCoreEncryptionTypeField.getFlag() && !"".equals(tCoreEncryptionTypeField.getFlag())) {
                     String isExistCopyCol = "0";

                     for(ColumnInfoVO allColumn : allColumns) {
                        if (allColumn.getColumnname().equals(columnName + this.copySuffix)) {
                           isExistCopyCol = "1";
                           break;
                        }
                     }

                     if (isExistCopyCol.equals("1") && ("7".equals(tCoreEncryptionTypeField.getFlag()) || "0".equals(tCoreEncryptionTypeField.getFlag()) || "5".equals(tCoreEncryptionTypeField.getFlag()))) {
                        MongoDatabase db = connect.getDatabase(schema);
                        MongoCollection<Document> collection = db.getCollection(tableName);
                        FindIterable<Document> find = collection.find();
                        MongoCursor<Document> cursor = find.iterator();
                        List<Document> results = new ArrayList();

                        while(cursor.hasNext()) {
                           results.add(cursor.next());
                        }

                        for(Document document : results) {
                           Object pk = document.get(this.mongodbpk);
                           Bson eq = Filters.eq(this.mongodbpk, pk);
                           collection.updateMany(eq, new Document("$unset", new Document(columnName + this.copySuffix, "")), (new UpdateOptions()).upsert(true));
                        }
                     }
                  }
               }
            }
         } catch (Exception e) {
            e.printStackTrace();
         }
      }

      return "OK";
   }

   public String newDelBatchTableColumn(String projectId) {
      String columnName = "";
      List<TCoreDatasystem> datasystemList = this.tCoreDatasystemDao.getbyprojectid(projectId);
      if (null != datasystemList && datasystemList.size() != 0) {
         for(TCoreDatasystem datasystem : datasystemList) {
            if (!"MONGODB".equals(datasystem.getDbtype()) && !"ES".equals(datasystem.getDbtype())) {
               String dataSystemId = datasystem.getId();
               Boolean isOracle = true;
               if (!datasystem.getDbtype().equals(EdbType.ORACLE.toString())) {
                  isOracle = false;
               }

               Boolean isPostgres = true;
               if (!datasystem.getDbtype().equals(EdbType.POSTGRESQL.toString()) && !datasystem.getDbtype().equals(EdbType.GAUSS.toString())) {
                  isPostgres = false;
               }

               Boolean isMssqlserver = true;
               if (!datasystem.getDbtype().equals(EdbType.MSSQLSERVER.toString())) {
                  isMssqlserver = false;
               }

               Boolean isDM = true;
               if (!datasystem.getDbtype().equals(EdbType.DM.toString())) {
                  isDM = false;
               }

               Boolean KBBoolean = true;
               if (!datasystem.getDbtype().equals(EdbType.KINGBASE.toString())) {
                  KBBoolean = false;
               }

               Boolean isDB2 = true;
               if (!datasystem.getDbtype().equals(EdbType.DB2.toString())) {
                  isDB2 = false;
               }

               Connection conn = null;
               Statement stmtInitail = null;
               Statement stmtCipher = null;
               List<TCoreEncryptionTypeField> schemaFieldList = null;

               try {
                  conn = JdbcTool.getConnection(datasystem);
                  stmtInitail = conn.createStatement();
                  stmtCipher = conn.createStatement();
                  if (conn != null) {
                     schemaFieldList = this.tCoreEncryptionTypeFieldDao.queryAll(new Criterion[]{Restrictions.eq("projectid", projectId), Restrictions.eq("datasystem_id", dataSystemId)});
                     Map<String, List<TCoreEncryptionTypeField>> map = (Map)schemaFieldList.stream().collect(Collectors.groupingBy((x) -> x.getTschemas() + "_" + x.getNames()));

                     for(String key : map.keySet()) {
                        String schema = "";
                        String tableName = "";
                        List<TCoreEncryptionTypeField> v = (List)map.get(key);
                        if (null != v || v.size() != 0) {
                           schema = ((TCoreEncryptionTypeField)v.get(0)).getTschemas();
                           tableName = ((TCoreEncryptionTypeField)v.get(0)).getNames();
                        }

                        ResultSet rsCount = null;
                        List<TCoreEncryptionTypeField> tCorTypeFieldList = null;

                        try {
                           tCorTypeFieldList = this.tCoreEncryptionTypeFieldDao.queryAll(new Criterion[]{Restrictions.eq("projectid", projectId), Restrictions.eq("datasystem_id", dataSystemId), Restrictions.eq("tschemas", schema), Restrictions.eq("names", tableName)});

                           for(TCoreEncryptionTypeField tCoreEncryptionTypeField : tCorTypeFieldList) {
                              if ("4".equals(tCoreEncryptionTypeField.getFlag()) || "44".equals(tCoreEncryptionTypeField.getFlag())) {
                                 String var131 = "hasfailedstatus";
                                 return var131;
                              }
                           }

                           List<ColumnInfoVO> allColumns = this.maksingAppDataRuleService.queryColumnInfo(dataSystemId, schema, tableName);
                           int c = tCorTypeFieldList.size();

                           for(int n = 0; n < c; ++n) {
                              try {
                                 if (((TCoreEncryptionTypeField)tCorTypeFieldList.get(n)).getTable_field_id() != null) {
                                    columnName = ((TCoreEncryptionTypeField)tCorTypeFieldList.get(n)).getTable_field_id();
                                    String alterColumnToInitialSql = "";
                                    String alterColumnToCipherSql = "";
                                    if (null != ((TCoreEncryptionTypeField)tCorTypeFieldList.get(n)).getFlag() && !"".equals(((TCoreEncryptionTypeField)tCorTypeFieldList.get(n)).getFlag())) {
                                       String isExistCopyCol = "0";

                                       for(ColumnInfoVO allColumn : allColumns) {
                                          if (isDM) {
                                             if (allColumn.getColumnname().equals(columnName + this.copySuffix)) {
                                                isExistCopyCol = "1";
                                             }
                                          } else if (allColumn.getColumnname().equals(columnName + this.copySuffix)) {
                                             isExistCopyCol = "1";
                                          }
                                       }

                                       if (isExistCopyCol.equals("1") && ("7".equals(((TCoreEncryptionTypeField)tCorTypeFieldList.get(n)).getFlag()) || "0".equals(((TCoreEncryptionTypeField)tCorTypeFieldList.get(n)).getFlag()) || "5".equals(((TCoreEncryptionTypeField)tCorTypeFieldList.get(n)).getFlag()))) {
                                          if (isOracle) {
                                             alterColumnToInitialSql = "ALTER TABLE \"" + schema + "\".\"" + tableName + "\" DROP (\"" + columnName + this.copySuffix + "\")";
                                          } else if (isPostgres) {
                                             alterColumnToInitialSql = "ALTER TABLE \"" + schema + "\".\"" + tableName + "\" DROP COLUMN \"" + columnName + this.copySuffix + "\"";
                                          } else if (isMssqlserver) {
                                             alterColumnToInitialSql = this.delColumn(schema, tableName, columnName + this.copySuffix);
                                          } else if (isDM) {
                                             alterColumnToInitialSql = "ALTER TABLE \"" + schema + "\".\"" + tableName + "\" DROP COLUMN \"" + columnName + this.copySuffix + "\"";
                                          } else if (KBBoolean) {
                                             alterColumnToInitialSql = "ALTER TABLE \"" + schema + "\".\"" + tableName + "\" DROP COLUMN \"" + columnName + this.copySuffix + "\"";
                                          } else if (isDB2) {
                                             alterColumnToInitialSql = "ALTER TABLE \"" + schema + "\".\"" + tableName + "\" DROP COLUMN \"" + columnName + this.copySuffix + "\"";
                                          } else {
                                             alterColumnToInitialSql = this.delColumn(schema, tableName, columnName + this.copySuffix);
                                          }

                                          stmtInitail.executeUpdate(alterColumnToInitialSql);
                                          if ("DB2".equals(datasystem.getDbtype())) {
                                             CallableStatement cs = conn.prepareCall("call SYSPROC.ADMIN_CMD('reorg table " + schema + "." + tableName + "')");
                                             cs.execute();
                                             cs.close();
                                          }
                                       }
                                    }
                                 }
                              } catch (Exception e) {
                                 e.printStackTrace();
                              } finally {
                                 if (rsCount != null) {
                                    try {
                                       rsCount.close();
                                    } catch (SQLException e) {
                                       e.printStackTrace();
                                    }
                                 }

                              }
                           }
                        } catch (Exception e) {
                           this.logger.error(e.getMessage(), e);
                        }
                     }
                  }
               } catch (Exception e) {
                  this.logger.error(e.getMessage(), e);
               } finally {
                  try {
                     stmtInitail.close();
                     stmtCipher.close();
                     conn.close();
                  } catch (SQLException throwables) {
                     throwables.printStackTrace();
                  }

               }
            } else if ("ES".equals(datasystem.getDbtype())) {
               try {
                  ClientInterface connect = GHCAUtils.getInstance().connectToES(datasystem.getDbip(), datasystem.getDbport(), datasystem.getUsername(), AesTool.decrypt(datasystem.getPassword(), "ghca"));
                  String dataSystemId = datasystem.getId();
                  List<TCoreEncryptionTypeField> schemaFieldList = null;
                  schemaFieldList = this.tCoreEncryptionTypeFieldDao.queryAll(new Criterion[]{Restrictions.eq("projectid", projectId), Restrictions.eq("datasystem_id", dataSystemId)});
                  Map<String, List<TCoreEncryptionTypeField>> map = (Map)schemaFieldList.stream().collect(Collectors.groupingBy((x) -> x.getTschemas() + "_" + x.getNames()));
                  if (connect != null) {
                     for(String key : map.keySet()) {
                        String schema = "";
                        String tableName = "";
                        List<TCoreEncryptionTypeField> v = (List)map.get(key);
                        if (null != v || v.size() != 0) {
                           schema = ((TCoreEncryptionTypeField)v.get(0)).getTschemas();
                           tableName = ((TCoreEncryptionTypeField)v.get(0)).getNames();
                        }

                        List<TCoreEncryptionTypeField> tCorTypeFieldList = null;
                        tCorTypeFieldList = this.tCoreEncryptionTypeFieldDao.queryAll(new Criterion[]{Restrictions.eq("projectid", projectId), Restrictions.eq("datasystem_id", dataSystemId), Restrictions.eq("tschemas", schema), Restrictions.eq("names", tableName)});

                        for(TCoreEncryptionTypeField tCoreEncryptionTypeField : tCorTypeFieldList) {
                           if ("4".equals(tCoreEncryptionTypeField.getFlag()) || "44".equals(tCoreEncryptionTypeField.getFlag())) {
                              return "hasfailedstatus";
                           }
                        }

                        EsUtil esUtil = new EsUtil();
                        Set<String> columns = esUtil.getColumnsIncludeCopyColumn(datasystem, schema, tableName);
                        columns = (Set)columns.stream().map((x) -> {
                           String[] m = x.split(":");
                           return m[0];
                        }).collect(Collectors.toSet());

                        for(TCoreEncryptionTypeField tCoreEncryptionTypeField : tCorTypeFieldList) {
                           if (tCoreEncryptionTypeField.getTable_field_id() != null) {
                              columnName = tCoreEncryptionTypeField.getTable_field_id();
                           }

                           if (null != tCoreEncryptionTypeField.getFlag() && !"".equals(tCoreEncryptionTypeField.getFlag())) {
                              String isExistCopyCol = "0";

                              for(String column : columns) {
                                 if (column.equals(columnName + this.copySuffix)) {
                                    isExistCopyCol = "1";
                                    break;
                                 }
                              }

                              if (isExistCopyCol.equals("1") && ("7".equals(tCoreEncryptionTypeField.getFlag()) || "0".equals(tCoreEncryptionTypeField.getFlag()) || "5".equals(tCoreEncryptionTypeField.getFlag()))) {
                                 try {
                                    connect = GHCAUtils.getInstance().connectToES(datasystem.getDbip(), datasystem.getDbport(), datasystem.getUsername(), AesTool.decrypt(datasystem.getPassword(), "ghca"));
                                    esUtil.delColumnCopy(connect, schema, tableName, columnName, this.copySuffix);
                                 } catch (Exception var67) {
                                    connect = GHCAUtils.getInstance().connectToES(datasystem.getDbip(), datasystem.getDbport(), datasystem.getUsername(), AesTool.decrypt(datasystem.getPassword(), "ghca"));
                                    esUtil.delColumnCopy(connect, schema, tableName, columnName, this.copySuffix);
                                 }
                              }
                           }
                        }
                     }
                  }
               } catch (Exception e) {
                  e.printStackTrace();
               }
            } else {
               try {
                  MongoClient connect = MongodbTool.connect(datasystem.getDbservername(), datasystem.getUsername(), AesTool.decrypt(datasystem.getPassword(), "ghca"), datasystem.getDbip(), Integer.parseInt(datasystem.getDbport()), true);
                  String dataSystemId = datasystem.getId();
                  List<TCoreEncryptionTypeField> schemaFieldList = null;
                  schemaFieldList = this.tCoreEncryptionTypeFieldDao.queryAll(new Criterion[]{Restrictions.eq("projectid", projectId), Restrictions.eq("datasystem_id", dataSystemId)});
                  Map<String, List<TCoreEncryptionTypeField>> map = (Map)schemaFieldList.stream().collect(Collectors.groupingBy((x) -> x.getTschemas() + "_" + x.getNames()));
                  if (connect != null) {
                     for(String key : map.keySet()) {
                        String schema = "";
                        String tableName = "";
                        List<TCoreEncryptionTypeField> v = (List)map.get(key);
                        if (null != v || v.size() != 0) {
                           schema = ((TCoreEncryptionTypeField)v.get(0)).getTschemas();
                           tableName = ((TCoreEncryptionTypeField)v.get(0)).getNames();
                        }

                        List<TCoreEncryptionTypeField> tCorTypeFieldList = null;
                        tCorTypeFieldList = this.tCoreEncryptionTypeFieldDao.queryAll(new Criterion[]{Restrictions.eq("projectid", projectId), Restrictions.eq("datasystem_id", dataSystemId), Restrictions.eq("tschemas", schema), Restrictions.eq("names", tableName)});

                        for(TCoreEncryptionTypeField tCoreEncryptionTypeField : tCorTypeFieldList) {
                           if ("4".equals(tCoreEncryptionTypeField.getFlag()) || "44".equals(tCoreEncryptionTypeField.getFlag())) {
                              return "hasfailedstatus";
                           }
                        }

                        List<Column> columnList = MongodbTool.findAllColumns(connect, schema, tableName);

                        for(TCoreEncryptionTypeField tCoreEncryptionTypeField : tCorTypeFieldList) {
                           if (tCoreEncryptionTypeField.getTable_field_id() != null) {
                              columnName = tCoreEncryptionTypeField.getTable_field_id();
                           }

                           if (null != tCoreEncryptionTypeField.getFlag() && !"".equals(tCoreEncryptionTypeField.getFlag())) {
                              String isExistCopyCol = "0";

                              for(Column allColumn : columnList) {
                                 if (allColumn.getColumnName().equals(columnName + this.copySuffix)) {
                                    isExistCopyCol = "1";
                                    break;
                                 }
                              }

                              if (isExistCopyCol.equals("1") && ("7".equals(tCoreEncryptionTypeField.getFlag()) || "0".equals(tCoreEncryptionTypeField.getFlag()) || "5".equals(tCoreEncryptionTypeField.getFlag()))) {
                                 MongoDatabase db = connect.getDatabase(schema);
                                 MongoCollection<Document> collection = db.getCollection(tableName);
                                 FindIterable<Document> find = collection.find();
                                 MongoCursor<Document> cursor = find.iterator();
                                 List<Document> results = new ArrayList();

                                 while(cursor.hasNext()) {
                                    results.add(cursor.next());
                                 }

                                 for(Document document : results) {
                                    Object pk = document.get(this.mongodbpk);
                                    Bson eq = Filters.eq(this.mongodbpk, pk);
                                    collection.updateMany(eq, new Document("$unset", new Document(columnName + this.copySuffix, "")), (new UpdateOptions()).upsert(true));
                                 }
                              }
                           }
                        }
                     }
                  }
               } catch (Exception e) {
                  e.printStackTrace();
               }
            }
         }

         return "OK";
      } else {
         return "error";
      }
   }

   class MyException extends RuntimeException {
      private String message;

      public MyException(String message) {
         super(message);
         this.message = message;
      }
   }
}
