package com.chenyang.nse.bussiness.service.core.mappletxml;

import com.chenyang.nse.bussiness.dao.table.core.mappletxml.TCoreRulEKeyStrInfoDAO;
import com.chenyang.nse.bussiness.dao.table.core.mappletxml.TCoreRuleMappletInfoDAO;
import com.chenyang.nse.bussiness.dao.table.core.mappletxml.TCoreRulePortDAO;
import com.chenyang.nse.bussiness.dao.table.core.mappletxml.TCoreRuleRandomNumInfoDAO;
import com.chenyang.nse.bussiness.dao.table.core.mappletxml.TCoreRuleRandomStrInfoDAO;
import com.chenyang.nse.bussiness.dao.table.core.mappletxml.TCoreRuleSubstitutionInfoDAO;
import com.chenyang.nse.bussiness.dao.table.core.mappletxml.TCoreRuleTransformationInfoDAO;
import com.chenyang.nse.bussiness.entity.orm.table.core.mappletxml.TCoreRulePort;
import com.chenyang.nse.bussiness.entity.orm.table.core.mappletxml.TCoreRuleTransformationInfo;
import com.chenyang.nse.bussiness.entity.vo.mappletxml.MappletxmlVO;
import com.chenyang.nse.bussiness.entity.vo.mappletxml.TCoreRulePortVO;
import com.chenyang.nse.bussiness.entity.vo.mappletxml.TCoreRuleTransformationInfoVO;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class TCoreRuleMappletInfoServiceImpl implements TCoreRuleMappletInfoService {
   @Autowired
   private TCoreRuleMappletInfoDAO tCoreRuleMappletInfoDAO;
   @Autowired
   private TCoreRuleTransformationInfoDAO tCoreRuleTransformationInfoDAO;
   @Autowired
   private TCoreRuleSubstitutionInfoDAO tCoreRuleSubstitutionInfoDAO;
   @Autowired
   private TCoreRuleRandomStrInfoDAO tCoreRuleRandomStrInfoDAO;
   @Autowired
   private TCoreRulEKeyStrInfoDAO tCoreRulEKeyStrInfoDAO;
   @Autowired
   private TCoreRuleRandomNumInfoDAO tCoreRuleRandomNumInfoDAO;
   @Autowired
   private TCoreRulePortDAO tCoreRulePortDAO;

   public String savemapplet(MappletxmlVO mappletxmlVO) {
      if (mappletxmlVO.gettCoreRuleMappletInfo().getId() != null && !"".equals(mappletxmlVO.gettCoreRuleMappletInfo().getId())) {
         this.tCoreRuleMappletInfoDAO.saveOrUpdate(mappletxmlVO.gettCoreRuleMappletInfo());
         String mappletinfoid = mappletxmlVO.gettCoreRuleMappletInfo().getId();
         this.tCoreRuleTransformationInfoDAO.remove(new Criterion[]{Restrictions.eq("mappletinfoid", mappletinfoid)});

         for(TCoreRuleTransformationInfoVO TransformationInfovo : mappletxmlVO.getTransformationInfoList()) {
            String oldtransformationinfoid = TransformationInfovo.gettCoreRuleTransformationInfo().getId();
            this.tCoreRulePortDAO.remove(new Criterion[]{Restrictions.eq("transformationinfoid", oldtransformationinfoid)});
            TransformationInfovo.gettCoreRuleTransformationInfo().setMappletinfoid(mappletinfoid);
            TransformationInfovo.gettCoreRuleTransformationInfo().setId((String)null);
            this.tCoreRuleTransformationInfoDAO.saveOrUpdate(TransformationInfovo.gettCoreRuleTransformationInfo());
            String transformationinfoid = TransformationInfovo.gettCoreRuleTransformationInfo().getId();
            if (TransformationInfovo.gettCoreRuleTransformationInfo().getType().equals("Data_Masking")) {
               for(TCoreRulePortVO tCoreRulePortVO : TransformationInfovo.getPortListVO()) {
                  TCoreRulePort tCoreRulePort = tCoreRulePortVO.gettCoreRulePort();
                  tCoreRulePort.setTransformationinfoid(transformationinfoid);
                  tCoreRulePort.setId((String)null);
                  this.tCoreRulePortDAO.saveOrUpdate(tCoreRulePort);
                  if ("substitution".equals(tCoreRulePort.getMaskingOption())) {
                     tCoreRulePortVO.gettCoreRuleSubstitutionInfo().setPortid(tCoreRulePort.getId());
                     tCoreRulePortVO.gettCoreRuleSubstitutionInfo().setId((String)null);
                     this.tCoreRuleSubstitutionInfoDAO.saveOrUpdate(tCoreRulePortVO.gettCoreRuleSubstitutionInfo());
                  } else if ("randomstr".equals(tCoreRulePort.getMaskingOption())) {
                     tCoreRulePortVO.gettCoreRuleRandomStrInfo().setPortid(tCoreRulePort.getId());
                     tCoreRulePortVO.gettCoreRuleRandomStrInfo().setId((String)null);
                     this.tCoreRuleRandomStrInfoDAO.saveOrUpdate(tCoreRulePortVO.gettCoreRuleRandomStrInfo());
                  } else if ("keystr".equals(tCoreRulePort.getMaskingOption())) {
                     tCoreRulePortVO.gettCoreRulEKeyStrInfo().setPortid(tCoreRulePort.getId());
                     tCoreRulePortVO.gettCoreRulEKeyStrInfo().setId((String)null);
                     this.tCoreRulEKeyStrInfoDAO.saveOrUpdate(tCoreRulePortVO.gettCoreRulEKeyStrInfo());
                  } else if ("randomnum".equals(tCoreRulePort.getMaskingOption())) {
                     tCoreRulePortVO.gettCoreRuleRandomNumInfo().setPortid(tCoreRulePort.getId());
                     tCoreRulePortVO.gettCoreRuleRandomNumInfo().setId((String)null);
                     this.tCoreRuleRandomNumInfoDAO.save(tCoreRulePortVO.gettCoreRuleRandomNumInfo());
                  } else if ("keynum".equals(tCoreRulePort.getMaskingOption())) {
                     tCoreRulePortVO.gettCoreRulEKeyStrInfo().setPortid(tCoreRulePort.getId());
                     tCoreRulePortVO.gettCoreRulEKeyStrInfo().setId((String)null);
                     this.tCoreRulEKeyStrInfoDAO.saveOrUpdate(tCoreRulePortVO.gettCoreRulEKeyStrInfo());
                  } else if ("randomdate".equals(tCoreRulePort.getMaskingOption())) {
                     tCoreRulePortVO.gettCoreRuleRandomNumInfo().setPortid(tCoreRulePort.getId());
                     tCoreRulePortVO.gettCoreRuleRandomNumInfo().setId((String)null);
                     this.tCoreRuleRandomNumInfoDAO.save(tCoreRulePortVO.gettCoreRuleRandomNumInfo());
                  }
               }
            } else {
               for(TCoreRulePortVO tCoreRulePortVO : TransformationInfovo.getPortListVO()) {
                  TCoreRulePort tCoreRulePort = tCoreRulePortVO.gettCoreRulePort();
                  tCoreRulePort.setTransformationinfoid(transformationinfoid);
                  tCoreRulePort.setId((String)null);
                  this.tCoreRulePortDAO.saveOrUpdate(tCoreRulePort);
               }
            }
         }
      } else {
         this.tCoreRuleMappletInfoDAO.save(mappletxmlVO.gettCoreRuleMappletInfo());

         for(TCoreRuleTransformationInfoVO TransformationInfovo : mappletxmlVO.getTransformationInfoList()) {
            TCoreRuleTransformationInfo transformationInfo = TransformationInfovo.gettCoreRuleTransformationInfo();
            transformationInfo.setMappletinfoid(mappletxmlVO.gettCoreRuleMappletInfo().getId());
            this.tCoreRuleTransformationInfoDAO.save(transformationInfo);
            if (transformationInfo.getType().equals("Data_Masking")) {
               for(TCoreRulePortVO tCoreRulePortVO : TransformationInfovo.getPortListVO()) {
                  TCoreRulePort tCoreRulePort = tCoreRulePortVO.gettCoreRulePort();
                  tCoreRulePort.setTransformationinfoid(transformationInfo.getId());
                  this.tCoreRulePortDAO.save(tCoreRulePort);
                  if ("substitution".equals(tCoreRulePort.getMaskingOption())) {
                     tCoreRulePortVO.gettCoreRuleSubstitutionInfo().setPortid(tCoreRulePort.getId());
                     this.tCoreRuleSubstitutionInfoDAO.save(tCoreRulePortVO.gettCoreRuleSubstitutionInfo());
                  } else if ("randomstr".equals(tCoreRulePort.getMaskingOption())) {
                     tCoreRulePortVO.gettCoreRuleRandomStrInfo().setPortid(tCoreRulePort.getId());
                     this.tCoreRuleRandomStrInfoDAO.save(tCoreRulePortVO.gettCoreRuleRandomStrInfo());
                  } else if ("keystr".equals(tCoreRulePort.getMaskingOption())) {
                     tCoreRulePortVO.gettCoreRulEKeyStrInfo().setPortid(tCoreRulePort.getId());
                     this.tCoreRulEKeyStrInfoDAO.save(tCoreRulePortVO.gettCoreRulEKeyStrInfo());
                  } else if ("randomnum".equals(tCoreRulePort.getMaskingOption())) {
                     tCoreRulePortVO.gettCoreRuleRandomNumInfo().setPortid(tCoreRulePort.getId());
                     this.tCoreRuleRandomNumInfoDAO.save(tCoreRulePortVO.gettCoreRuleRandomNumInfo());
                  } else if ("keynum".equals(tCoreRulePort.getMaskingOption())) {
                     tCoreRulePortVO.gettCoreRulEKeyStrInfo().setPortid(tCoreRulePort.getId());
                     this.tCoreRulEKeyStrInfoDAO.save(tCoreRulePortVO.gettCoreRulEKeyStrInfo());
                  } else if ("randomdate".equals(tCoreRulePort.getMaskingOption())) {
                     tCoreRulePortVO.gettCoreRuleRandomNumInfo().setPortid(tCoreRulePort.getId());
                     this.tCoreRuleRandomNumInfoDAO.save(tCoreRulePortVO.gettCoreRuleRandomNumInfo());
                  }
               }
            } else {
               for(TCoreRulePortVO tCoreRulePortVO : TransformationInfovo.getPortListVO()) {
                  TCoreRulePort tCoreRulePort = tCoreRulePortVO.gettCoreRulePort();
                  tCoreRulePort.setTransformationinfoid(transformationInfo.getId());
                  this.tCoreRulePortDAO.save(tCoreRulePort);
               }
            }
         }
      }

      return "1";
   }
}
