package com.chenyang.nse.bussiness.service.serviceImp;

import com.chenyang.nse.bussiness.dao.UserDao;
import com.chenyang.nse.bussiness.entity.User;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service("userService")
@Transactional(
   readOnly = true
)
public class UserService {
   @Autowired
   private UserDao userDao;

   @Transactional(
      readOnly = false
   )
   public void save(User user) {
      this.userDao.save(user);
   }

   public User findById(Long id) {
      User user = (User)this.userDao.findByID(id);
      return user;
   }

   public List<User> findAll() {
      String hql = "from User";
      return this.userDao.findAll(hql);
   }

   @Transactional(
      readOnly = false
   )
   public void update(Long id) {
      this.userDao.update(id);
   }

   @Transactional(
      readOnly = false
   )
   public void delete(Long id) {
      this.userDao.delete(id);
   }
}
