package com.chenyang.nse.bussiness.tools.dmp;

import com.chenyang.nse.bussiness.config.PropertiesLoaderUtils;
import com.chenyang.nse.bussiness.tools.datatime.DateTime1Tool;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;

public class MultipleDmpGenerateTool {
   public static final int arraySize = 1024;
   public static final String STR_DATA_SEPARATOR = "#_#";
   public static final int headGarbageData = 2048;

   private static String toHex(byte b) {
      int i = b & 255;
      String s = "";
      if (null != Integer.toHexString(i)) {
         s = Integer.toHexString(i).toUpperCase();
         if (s.length() == 1) {
            s = '0' + s;
         }
      } else {
         System.out.println("btye is:" + b + ":toHex 方法：十进制数转换为十六进制字符串时返回了NULL!");
      }

      return s;
   }

   private static String tableName2HexStr(String tablename) {
      byte[] tablenameByteArr = tablename.getBytes();
      StringBuffer tableNameHexBuf = new StringBuffer();

      for(int i = 0; i < tablenameByteArr.length; ++i) {
         byte tablenameByte = tablenameByteArr[i];
         String tablenameHexStr = toHex(tablenameByte);
         tableNameHexBuf.append(tablenameHexStr);
      }

      return tableNameHexBuf.toString();
   }

   private static List<String> createTableSql(List<String> dmpFilePathList) {
      Date startDate = new Date();
      List<String> createTableSqlList = new ArrayList();
      List<String> insertTableSql = new ArrayList();
      List<String> uniqueTableSql = new ArrayList();
      List<String> synonTableSql = new ArrayList();
      List<String> viewTableSql = new ArrayList();

      try {
         for(int i = 0; i < dmpFilePathList.size(); ++i) {
            String dmpFilePath = (String)dmpFilePathList.get(i);
            FileInputStream is = new FileInputStream(dmpFilePath);
            Reader reader = new InputStreamReader(is);
            BufferedReader bufferedReader = new BufferedReader(reader);
            String line = "";
            int lineNum = 0;

            while((line = bufferedReader.readLine()) != null) {
               ++lineNum;
               line = new String(line.getBytes("ISO-8859-1"), "GBK");
               if (line.length() > 12) {
                  String top12 = line.substring(0, 12);
                  if (top12.equals("CREATE TABLE")) {
                     createTableSqlList.add(line);
                  } else if (top12.equals("INSERT INTO ")) {
                     insertTableSql.add(line);
                  } else if (top12.equals("CREATE UNIQU")) {
                     uniqueTableSql.add(line);
                  } else if (top12.equals("CREATE SYNON")) {
                     synonTableSql.add(line);
                  } else if (top12.equals("CREATE VIEW ")) {
                     viewTableSql.add(line);
                  }
               }
            }
         }
      } catch (Exception e) {
         e.printStackTrace();
      }

      Date endDate = new Date();
      DateTime1Tool.dateBetween(startDate, endDate);
      return createTableSqlList;
   }

   private static Map<String, List<String>> getTypeNameListByTableName(List<String> dmpFileNameList, List<String> tablenameList) {
      Map<String, List<String>> typeNameLstMap = new HashMap();
      if (null != tablenameList && tablenameList.size() != 0) {
         new ArrayList();
         List<String> createTableSqlList = createTableSql(dmpFileNameList);

         for(int i = 0; i < tablenameList.size(); ++i) {
            String tmpTableName = (String)tablenameList.get(i);
            if (StringUtils.isNotBlank(tmpTableName)) {
               typeNameLstMap.put(tmpTableName, null);
            }
         }

         for(int i = 0; i < createTableSqlList.size(); ++i) {
            List<String> typeNameLst = new ArrayList();
            String createTableSqlStr = (String)createTableSqlList.get(i);
            int tableNameStartIndex = createTableSqlStr.indexOf("TABLE") + 5;
            int tableNameEndIndex = createTableSqlStr.indexOf("(");
            String tableNameBuf = createTableSqlStr.substring(tableNameStartIndex, tableNameEndIndex);
            tableNameBuf = tableNameBuf.trim();
            String tName = tableNameBuf.replaceAll("\"", "");
            if (typeNameLstMap.containsKey(tName)) {
               int colInfoStartIndex = createTableSqlStr.indexOf("(") + 1;
               int colInfoEndIndex = createTableSqlStr.indexOf(")  PCTFREE");
               String colInfosBuf = createTableSqlStr.substring(colInfoStartIndex, colInfoEndIndex);
               colInfosBuf = colInfosBuf.trim();
               String[] colInfoArr = colInfosBuf.split(", \"");

               for(int j = 0; j < colInfoArr.length; ++j) {
                  String colInfoBuf = colInfoArr[j];
                  colInfoBuf = colInfoBuf.trim();
                  String[] colInfoBufArr = colInfoBuf.split("\" ");
                  String columnname = colInfoBufArr[0];
                  columnname = columnname.replaceAll("\"", "");
                  String colTypeBuf = colInfoBufArr[1];
                  String typename = colTypeBuf;
                  int colTypeEndIndex = colTypeBuf.indexOf("(");
                  if (colTypeEndIndex > 0) {
                     typename = colTypeBuf.substring(0, colTypeEndIndex);
                  }

                  typeNameLst.add(typename);
               }

               typeNameLstMap.put(tName, typeNameLst);
            }
         }

         return typeNameLstMap;
      } else {
         return typeNameLstMap;
      }
   }

   private static String toIntStr(byte b) {
      int i = b & 255;
      String s = "";
      s = s + i;
      return s;
   }

   private static List<Integer> gbkToDmpBtyeArr(String colValStr) {
      List<Integer> intColLst = new ArrayList();
      byte[] bs = null;

      try {
         char[] chars = colValStr.toCharArray();
         bs = colValStr.getBytes("gbk");

         for(int i = 0; i < bs.length; ++i) {
            intColLst.add(bs[i] & 255);
         }
      } catch (Exception e) {
         e.printStackTrace();
      }

      return intColLst;
   }

   private static List<Integer> nGbkToDmpBtyeArr(String colValStr) {
      List<Integer> intColLst = new ArrayList();
      byte[] bs = null;
      char[] charArray = colValStr.toCharArray();

      try {
         for(char c : charArray) {
            if (c >= 913 && c <= '￥') {
               bs = colValStr.getBytes("utf-16");

               for(int i = 0; i < bs.length; ++i) {
                  intColLst.add(bs[i] & 255);
               }

               intColLst.remove(0);
               intColLst.remove(0);
               break;
            }

            if (c >= 0 && c <= 255) {
               bs = colValStr.getBytes("gbk");

               for(int i = 0; i < bs.length; ++i) {
                  intColLst.add(0);
                  intColLst.add(bs[i] & 255);
               }
               break;
            }
         }
      } catch (Exception e) {
         e.printStackTrace();
      }

      return intColLst;
   }

   private static List<Integer> numberToDmpBtyeArr(String colValStr) {
      List<Integer> intColLst = new ArrayList();
      Boolean positiveFlg = false;
      String intpart = "";

      try {
         if (-1 == colValStr.indexOf("-")) {
            positiveFlg = true;
         } else {
            colValStr = colValStr.replace("-", "");
         }

         if (positiveFlg) {
            if ("0".equals(colValStr)) {
               intColLst.add(128);
            } else if ("".equals(colValStr)) {
               intColLst.add(30);
            } else {
               List<Integer> positiveLst = new ArrayList();
               List<Integer> decimalList = new ArrayList();
               String[] numberStrArr = colValStr.split("\\.");
               intpart = numberStrArr[0];
               if ("0".equals(intpart)) {
                  positiveLst.add(192);
               } else {
                  if (0 != intpart.length() % 2) {
                     intpart = "0" + intpart;
                  }

                  char[] positiveCharArr = intpart.toCharArray();
                  int idx = positiveCharArr.length / 2 - 1;
                  int prefixNum = 193 + idx;
                  positiveLst.add(prefixNum);

                  for(int i = 0; i < positiveCharArr.length; i += 2) {
                     positiveLst.add(Integer.valueOf(positiveCharArr[i] + "" + positiveCharArr[i + 1]) + 1);
                  }
               }

               if (numberStrArr.length < 2 || Integer.valueOf(numberStrArr[1]) == 0) {
                  while(1 == (Integer)positiveLst.get(positiveLst.size() - 1)) {
                     positiveLst.remove(positiveLst.size() - 1);
                  }
               }

               intColLst.addAll(positiveLst);
               if (numberStrArr.length > 1) {
                  String decimal = numberStrArr[1];
                  if (0 != Integer.valueOf(decimal)) {
                     if (0 != decimal.length() % 2) {
                        decimal = decimal + "0";
                     }

                     char[] decimalCharArr = decimal.toCharArray();

                     for(int i = 0; i < decimalCharArr.length; i += 2) {
                        decimalList.add(Integer.valueOf(decimalCharArr[i] + "" + decimalCharArr[i + 1]) + 1);
                     }

                     intColLst.addAll(decimalList);
                  }
               }
            }
         } else {
            List<Integer> positiveLst = new ArrayList();
            List<Integer> decimalList = new ArrayList();
            String[] numberStrArr = colValStr.split("\\.");
            intpart = numberStrArr[0];
            if ("0".equals(intpart)) {
               positiveLst.add(63);
            } else {
               if (0 != intpart.length() % 2) {
                  intpart = "0" + intpart;
               }

               char[] positiveCharArr = intpart.toCharArray();
               int idx = positiveCharArr.length / 2 - 1;
               int prefixNum = 62 - idx;
               positiveLst.add(prefixNum);

               for(int i = 0; i < positiveCharArr.length; i += 2) {
                  positiveLst.add(101 - Integer.valueOf(positiveCharArr[i] + "" + positiveCharArr[i + 1]));
               }

               if (numberStrArr.length < 2 || Integer.valueOf(numberStrArr[1]) == 0) {
                  while(101 == (Integer)positiveLst.get(positiveLst.size() - 1)) {
                     positiveLst.remove(positiveLst.size() - 1);
                  }
               }

               intColLst.addAll(positiveLst);
            }

            if (numberStrArr.length > 1) {
               String decimal = numberStrArr[1];
               if (0 != Integer.valueOf(decimal)) {
                  if (0 != decimal.length() % 2) {
                     decimal = decimal + "0";
                  }

                  char[] decimalCharArr = decimal.toCharArray();

                  for(int i = 0; i < decimalCharArr.length; i += 2) {
                     decimalList.add(101 - Integer.valueOf(decimalCharArr[i] + "" + decimalCharArr[i + 1]));
                  }

                  intColLst.addAll(decimalList);
               }
            }

            intColLst.add(102);
         }
      } catch (Exception e) {
         e.printStackTrace();
      }

      return intColLst;
   }

   private static List<Integer> longToDmpBtyeArr(String colValStr) {
      List<Integer> intColLst = new ArrayList();
      Boolean positiveFlg = false;
      Boolean isSingle = false;
      if (0 == colValStr.indexOf("-")) {
         colValStr = colValStr.replaceFirst("-", "");
      } else {
         positiveFlg = true;
      }

      int longNum = Integer.parseInt(colValStr);
      if (longNum < 10) {
         isSingle = true;
      }

      if (!positiveFlg) {
         intColLst.add(45);
      }

      if (isSingle) {
         intColLst.add(longNum + 48);
      } else if (longNum < 100) {
         intColLst.add(longNum / 10 + 48);
         intColLst.add(longNum % 10 + 48);
      } else {
         intColLst.add(longNum / 100 + 48);
         intColLst.add(longNum / 10 % 10 + 48);
         intColLst.add(longNum % 10 + 48);
      }

      return intColLst;
   }

   private static List<Integer> dateToDmpBtyeArr(String colValStr) {
      List<Integer> intColLst = new ArrayList();
      Calendar calendar = Calendar.getInstance();
      String datefmt = "yyyy-MM-dd HH:mm:ss";
      SimpleDateFormat sdf = new SimpleDateFormat(datefmt);

      try {
         Date colDate = sdf.parse(colValStr);
         calendar.setTime(colDate);
         int year = calendar.get(1);
         int month = calendar.get(2) + 1;
         int date = calendar.get(5);
         int hour24 = calendar.get(11);
         int minute = calendar.get(12);
         int second = calendar.get(13);
         String year1 = String.valueOf(year).substring(0, 2);
         String year2 = String.valueOf(year).substring(2, 4);
         intColLst.add(Integer.valueOf(year1) + 100);
         intColLst.add(Integer.valueOf(year2) + 100);
         intColLst.add(month);
         intColLst.add(date);
         intColLst.add(hour24 + 1);
         intColLst.add(minute + 1);
         intColLst.add(second + 1);
      } catch (ParseException e) {
         e.printStackTrace();
      }

      return intColLst;
   }

   private static List<Integer> timestampToDmpBtyeArr(String colValStr) {
      List<Integer> timestampIntList = new ArrayList();
      new Timestamp(System.currentTimeMillis());
      String timestampPartOfMS = "";
      String timestampPartOfDate = "";
      if (StringUtils.isNotBlank(colValStr)) {
         String[] timestampArr = colValStr.split("\\.");
         timestampPartOfDate = timestampArr[0];
         timestampIntList = dateToDmpBtyeArr(timestampPartOfDate);
         if (timestampArr.length > 1) {
            timestampPartOfMS = timestampArr[1];
            String strHex = Integer.toHexString(Integer.valueOf(timestampPartOfMS));
            if (strHex.length() % 2 != 0) {
               strHex = "0" + strHex;
            }

            char[] strHexArr = strHex.toCharArray();

            for(int i = 0; i < strHexArr.length; i += 2) {
               timestampIntList.add(Integer.valueOf(strHexArr[i] + "" + strHexArr[i + 1], 16));
            }
         }
      }

      return timestampIntList;
   }

   private static List<Integer> parsingDataByLine(List<String> colTypeList, String lineStr) {
      new StringBuffer();
      String doubleQuotation = "\"";
      List<Integer> lineIntList = new ArrayList();
      List<Integer> intColList = null;

      try {
         String[] lineStrArr = lineStr.split("#_#", -1);

         for(int i = 0; i < colTypeList.size(); ++i) {
            String colType = (String)colTypeList.get(i);
            String curColVal = lineStrArr[i];
            if (!"".equals(curColVal) && null != curColVal) {
               curColVal = curColVal.replace(doubleQuotation, "");
               List<Integer> var11 = new ArrayList();
               if (!colType.equalsIgnoreCase("VARCHAR2") && !colType.equalsIgnoreCase("CHAR")) {
                  if (!colType.equalsIgnoreCase("NVARCHAR2") && !colType.equalsIgnoreCase("NCHAR")) {
                     if (!colType.equals("NUMBER") && !colType.equalsIgnoreCase("float")) {
                        if (colType.equals("DATE")) {
                           var11 = dateToDmpBtyeArr(curColVal);
                        } else if (colType.equalsIgnoreCase("TIMESTAMP ")) {
                           var11 = timestampToDmpBtyeArr(curColVal);
                        } else if (colType.equalsIgnoreCase("LONG")) {
                           var11 = longToDmpBtyeArr(curColVal);
                        }
                     } else {
                        var11 = numberToDmpBtyeArr(curColVal);
                     }
                  } else {
                     var11 = nGbkToDmpBtyeArr(curColVal);
                  }
               } else {
                  var11 = gbkToDmpBtyeArr(curColVal);
               }

               if (0 == ((List)var11).size()) {
                  lineIntList.add(254);
                  lineIntList.add(255);
               } else {
                  lineIntList.add(((List)var11).size());
                  lineIntList.add(0);
               }

               lineIntList.addAll((Collection)var11);
            } else {
               lineIntList.add(254);
               lineIntList.add(255);
            }
         }
      } catch (Exception e) {
         e.printStackTrace();
      }

      return lineIntList;
   }

   public static void prasingDataByTableName(List<String> dmpFileNameList, String taskname, List<String> tablenameList, String tarDmpPath) {
      if (null != tablenameList && null != dmpFileNameList && dmpFileNameList.size() != 0) {
         Properties props = new Properties();

         try {
            props = PropertiesLoaderUtils.loadAllProperties("config.properties");
         } catch (IOException e) {
            e.printStackTrace();
         }

         List<String> tardmpFilePathList = new ArrayList();

         for(int i = 0; i < dmpFileNameList.size(); ++i) {
            tardmpFilePathList.add(((String)dmpFileNameList.get(i)).substring(((String)dmpFileNameList.get(i)).lastIndexOf("/") + 1, ((String)dmpFileNameList.get(i)).length()));
         }

         new String();
         Map<String, String> tablenameHexStrMap = new HashMap();

         for(int i = 0; i < tablenameList.size(); ++i) {
            String maskTableName = (String)tablenameList.get(i);
            String tablenameHexStr = tableName2HexStr((String)tablenameList.get(i));
            tablenameHexStrMap.put(tablenameHexStr, maskTableName);
         }

         Map<String, List<String>> colTypeListMap = getTypeNameListByTableName(dmpFileNameList, tablenameList);

         try {
            String path = props.getProperty("dmp_exp_table_file_path");
            int dmpFileListIndex = 0;
            String dmpFileName = (String)dmpFileNameList.get(dmpFileListIndex);
            File f = new File(dmpFileName);
            int len = (int)f.length();
            byte[] btyebufArr = new byte[1024];
            byte[] impBtyeArr = new byte[2048];
            String nextDmpStartMark = "0";
            int impBtyebufArrIndex = 0;
            Map<Integer, byte[]> headDataMap = new HashMap();
            Integer headDataIndex = 0;
            byte[] headData = new byte[2048];

            for(int i = 0; i < dmpFileNameList.size(); ++i) {
               StreamFileReader fisHead = new StreamFileReader((String)dmpFileNameList.get(headDataIndex), 2048);
               fisHead.read();
               headData = fisHead.getArray();
               headDataMap.put(headDataIndex, headData);
               headDataIndex = headDataIndex + 1;
            }

            StreamFileReader fis = new StreamFileReader(dmpFileName, 1024);
            new StringBuffer();
            new StringBuffer();
            int count00 = 0;
            boolean issys = false;
            String lastbuf16 = "";
            int i = 0;
            fis.read();
            btyebufArr = fis.getArray();
            int btyebufArrIndex = 0;
            String finishFlg = "0";
            String createTableStartMark = "0";
            StringBuffer createTableStartMarkStrBuf = new StringBuffer();
            int createTableStartMarkLen = 14;
            int createTableStartMarkIndex = 0;
            String tableNameStartFlg = "0";
            StringBuffer createTableNameStrBuf = new StringBuffer();
            String createTableStartFlg = "0";
            String isMatchTable = "0";
            String buf16Str6 = "";
            int tarFileSize = 0;
            int tarFileIndex = 0;
            String invalidDmpFlg = "0";
            String var66 = tarDmpPath + "/" + (String)tardmpFilePathList.get(tarFileIndex);
            if (tablenameList.size() == 0) {
               InputStream input = null;
               OutputStream output = null;

               for(int j = 0; j < dmpFileNameList.size(); ++j) {
                  input = new FileInputStream((String)dmpFileNameList.get(j));
                  output = new FileOutputStream(tarDmpPath + (String)tardmpFilePathList.get(j));
                  byte[] buf = new byte[1024];

                  int bytesRead;
                  while((bytesRead = input.read(buf)) > 0) {
                     output.write(buf, 0, bytesRead);
                  }
               }

               input.close();
               output.close();
               return;
            }

            FileOutputStream fileOutputStream = new FileOutputStream(var66);
            String curImpTableName = "";
            String curTableDataInsertFinishFlg = "0";
            List<String> colTypeList = null;
            String nextDmpStartMonitorData = "0";

            while(i < len) {
               if (btyebufArrIndex >= 1024) {
                  fis.read();
                  btyebufArr = fis.getArray();
                  btyebufArrIndex = 0;
               }

               byte bufbyte = btyebufArr[btyebufArrIndex];
               String buf10 = toIntStr(bufbyte);
               String buf16 = toHex(bufbyte);
               buf16Str6 = buf16Str6 + buf16;
               if (buf16Str6.length() > 12) {
                  buf16Str6 = buf16Str6.substring(2);
               }

               if ("0".equals(createTableStartFlg)) {
                  if ("43".equals(buf16)) {
                     createTableStartMark = "1";
                     createTableStartMarkIndex = 0;
                     createTableStartMarkStrBuf = new StringBuffer();
                  }

                  if ("1".equals(createTableStartMark)) {
                     createTableStartMarkStrBuf.append(buf16);
                     ++createTableStartMarkIndex;
                     if (createTableStartMarkIndex == createTableStartMarkLen) {
                        createTableStartMarkIndex = 0;
                        if ("435245415445205441424C452022".equalsIgnoreCase(createTableStartMarkStrBuf.toString())) {
                           tableNameStartFlg = "1";
                           createTableStartFlg = "1";
                        } else {
                           createTableStartMarkStrBuf = new StringBuffer();
                        }

                        createTableStartMark = "0";
                     }
                  }
               } else if ("1".equals(createTableStartFlg) && !"1".equals(isMatchTable)) {
                  if ("1".equals(tableNameStartFlg)) {
                     if ("22".equals(buf16)) {
                        tableNameStartFlg = "0";
                     } else {
                        createTableNameStrBuf.append(buf16);
                     }
                  } else if ("0".equals(tableNameStartFlg)) {
                     if (tablenameHexStrMap.containsKey(createTableNameStrBuf.toString())) {
                        isMatchTable = "1";
                        curImpTableName = (String)tablenameHexStrMap.get(createTableNameStrBuf.toString());
                        colTypeList = (List)colTypeListMap.get(curImpTableName);
                     } else {
                        createTableStartFlg = "0";
                     }

                     createTableNameStrBuf = new StringBuffer();
                  }
               }

               if ("1".equals(isMatchTable)) {
                  if (!issys) {
                     if (count00 == 5) {
                        if (!buf16.equals("00")) {
                           issys = true;
                        } else {
                           count00 = -1;
                        }
                     }

                     if (buf16.equals("00")) {
                        ++count00;
                     } else {
                        count00 = 0;
                     }
                  }

                  if (!issys) {
                     impBtyeArr[impBtyebufArrIndex] = bufbyte;
                     ++impBtyebufArrIndex;
                  } else if ("0".equals(curTableDataInsertFinishFlg)) {
                     ArrayList<Integer> tableDataList = new ArrayList();
                     String tarDmpPipePath = props.getProperty("dmp_imp_table_file_path");
                     String tarPipePathStr = tarDmpPipePath + "/" + taskname + "/" + curImpTableName + ".pipe";
                     byte[] impBtyeArr2 = Arrays.copyOf(impBtyeArr, impBtyebufArrIndex);
                     fileOutputStream.write(impBtyeArr2);
                     tarFileSize += impBtyeArr2.length;
                     impBtyeArr = new byte[1024];
                     impBtyebufArrIndex = 0;

                     try {
                        InputStreamReader fr = new InputStreamReader(new FileInputStream(tarPipePathStr), "UTF-8");
                        BufferedReader bf = new BufferedReader(fr);

                        String lineStr;
                        for(int lineCnt = 0; (lineStr = bf.readLine()) != null; createTableStartMark = "0") {
                           ++lineCnt;
                           List<Integer> lineIntList = parsingDataByLine(colTypeList, lineStr);
                           lineIntList.add(0);
                           lineIntList.add(0);
                           tableDataList.addAll(lineIntList);
                           if (0 == lineCnt % 1024) {
                              byte[] impDataBtyeArr = new byte[tableDataList.size()];
                              int otherDataSize = 0;
                              if (len - tarFileSize < tableDataList.size()) {
                                 impDataBtyeArr = new byte[len - tarFileSize];
                                 otherDataSize = len - tarFileSize;
                              }

                              int i2 = 0;

                              for(int tIdx = 0; tIdx < tableDataList.size(); ++tIdx) {
                                 impDataBtyeArr[i2] = (byte)((Integer)tableDataList.get(tIdx) & 255);
                                 ++i;
                                 ++i2;
                                 ++tarFileSize;
                                 if (tarFileSize == len) {
                                    fileOutputStream.write(impDataBtyeArr);
                                    i2 = 0;
                                    dmpFileListIndex = tarFileIndex++;
                                    fileOutputStream = new FileOutputStream(tarDmpPath + "/" + (String)tardmpFilePathList.get(tarFileIndex));
                                    tarFileSize = 0;
                                    fileOutputStream.write((byte[])headDataMap.get(tarFileIndex));
                                    tarFileSize += 2048;
                                    impDataBtyeArr = new byte[tableDataList.size() - otherDataSize];
                                    invalidDmpFlg = "1";
                                 }
                              }

                              fileOutputStream.write(impDataBtyeArr);
                              tableDataList = new ArrayList();
                              i2 = 0;
                           }

                           createTableStartFlg = "0";
                        }

                        tableDataList.add(255);
                        tableDataList.add(255);
                        byte[] impDataBtyeArr = new byte[tableDataList.size()];

                        for(int tIdx = 0; tIdx < tableDataList.size(); ++tIdx) {
                           impDataBtyeArr[tIdx] = (byte)((Integer)tableDataList.get(tIdx) & 255);
                        }

                        fileOutputStream.write(impDataBtyeArr);
                        tarFileSize += impDataBtyeArr.length;
                        bf.close();
                        fr.close();
                     } catch (IOException e) {
                        e.printStackTrace();
                     }

                     curTableDataInsertFinishFlg = "1";
                  } else if (buf16.equals("FF") && lastbuf16.equals("FF") && i > 2048) {
                     issys = false;
                     isMatchTable = "0";
                     curTableDataInsertFinishFlg = "0";
                  }
               } else {
                  impBtyeArr[impBtyebufArrIndex] = bufbyte;
                  ++impBtyebufArrIndex;
               }

               lastbuf16 = buf16;
               ++i;
               ++btyebufArrIndex;
               if (btyebufArrIndex >= 1024) {
                  byte[] impBtyeArr2 = Arrays.copyOf(impBtyeArr, impBtyebufArrIndex);
                  fileOutputStream.write(impBtyeArr2);
                  tarFileSize += impBtyeArr2.length;
                  impBtyeArr = new byte[1024];
                  int otherDataSize = 0;
                  if (len - tarFileSize < 1024) {
                     impBtyeArr = new byte[len - tarFileSize];
                     otherDataSize = len - tarFileSize;
                  }

                  if (tarFileSize == len) {
                     fileOutputStream.write(impBtyeArr);
                     dmpFileListIndex = tarFileIndex++;
                     if (tarFileIndex == dmpFileNameList.size()) {
                        break;
                     }

                     fileOutputStream = new FileOutputStream(tarDmpPath + (String)tardmpFilePathList.get(tarFileIndex));
                     tarFileSize = 0;
                     impBtyeArr = new byte[1024 - otherDataSize];
                     invalidDmpFlg = "1";
                  }

                  impBtyebufArrIndex = 0;
                  fis.read();
                  btyebufArr = fis.getArray();
                  btyebufArrIndex = 0;
               }

               if (i == len || "1".equals(invalidDmpFlg)) {
                  ++dmpFileListIndex;
                  if (dmpFileListIndex >= dmpFileNameList.size()) {
                     return;
                  }

                  dmpFileName = (String)dmpFileNameList.get(dmpFileListIndex);
                  f = new File(dmpFileName);
                  fis = new StreamFileReader(dmpFileName, 1024);
                  if (dmpFileNameList.size() - 1 == tarFileIndex) {
                     len = (int)f.length();
                  }

                  i = 0;
                  fis.read();
                  btyebufArr = fis.getArray();
                  btyebufArrIndex = 0;
                  fileOutputStream.flush();
                  invalidDmpFlg = "0";
                  nextDmpStartMonitorData = "0";
               }
            }

            byte[] impBtyeArr2 = Arrays.copyOf(impBtyeArr, impBtyebufArrIndex);
            fileOutputStream.write(impBtyeArr2);
            fileOutputStream.flush();
            fileOutputStream.close();
         } catch (Exception e) {
            e.printStackTrace();
         }

      }
   }

   public static void main(String[] args) {
      Properties props = new Properties();

      try {
         props = PropertiesLoaderUtils.loadAllProperties("config.properties");
      } catch (IOException e) {
         e.printStackTrace();
      }

      String dmppath = props.getProperty("dmp_file_path");
      List<String> dmpFileNameList = new ArrayList();

      for(int i = 0; i < 2; ++i) {
         String numStr = String.format("%02d", i + 1);
         String dmpFilePath = "test" + numStr + ".dmp";
         dmpFileNameList.add(dmppath + dmpFilePath);
      }

      List<String> tablenameList = new ArrayList();
      tablenameList.add("IP_INVPTY101");
      tablenameList.add("IP_INVPTY102");
      tablenameList.add("IP_INVPTY103");
      tablenameList.add("IP_INVPTY104");
      String tarPipePath = props.getProperty("dmp_exp_table_file_path");
      prasingDataByTableName(dmpFileNameList, "191016140654_dmp2dmptest3", tablenameList, tarPipePath);
   }
}
