package com.chenyang.nse.bussiness.tools.es;

import com.chenyang.nse.bussiness.entity.db.ColumnInfo;
import com.chenyang.nse.bussiness.tools.propertyutil.PropertyGhcaUtil;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GetMetaDataUtils {
   public static final Log LOG = LogFactory.getLog(GetMetaDataUtils.class);

   public static Set getJsonKeySet(Set jsonKeySet, String jsonStr, String parentKey) throws Exception {
      JSONObject jsonObject = JSONObject.fromObject(jsonStr);

      for(Object keyObj : jsonObject.keySet()) {
         String key = keyObj.toString();
         Object jsonValueObj = jsonObject.get(key);
         int flag = IsJsonArrayOrJsonObject(jsonValueObj);
         if (flag == 1) {
            if (!"".equals(parentKey)) {
               if (parentKey.endsWith(".")) {
                  key = parentKey + key + ".";
               } else {
                  key = parentKey + "." + key + ".";
               }
            }

            JSONObject nextLayerJsonObject = (JSONObject)jsonValueObj;
            getJsonKeySet(jsonKeySet, nextLayerJsonObject.toString(), key);
         } else if (flag == 2) {
            if ("".equals(parentKey)) {
               key = key + ".";
            }

            JSONArray nextLayerJsonArray = (JSONArray)jsonValueObj;

            for(int i = 0; i < nextLayerJsonArray.size(); ++i) {
               JSONObject nextLayerJsonObject = (JSONObject)nextLayerJsonArray.get(i);
               getJsonKeySet(jsonKeySet, nextLayerJsonObject.toString(), key);
            }
         } else if ("type".equalsIgnoreCase(key)) {
            String parentPath = "";
            String keyPath = "";
            if (!"".equals(parentKey)) {
               if (parentKey.endsWith(".")) {
                  (new StringBuilder()).append(parentKey).append(key).toString();
                  parentPath = parentKey.substring(0, parentKey.length() - 1);
               } else {
                  (new StringBuilder()).append(parentKey).append(".").append(key).toString();
                  parentPath = parentKey.substring(0, parentKey.lastIndexOf("."));
               }
            }

            parentPath = parentPath.substring(0, parentPath.lastIndexOf("."));
            if (parentPath.endsWith("properties.") || parentPath.endsWith("properties")) {
               keyPath = parentKey.substring(0, parentKey.length() - 1).replace(".mappings", "").replace(".properties", "");
               if (!keyPath.contains("match_all")) {
                  keyPath = keyPath.substring(keyPath.indexOf(".") + 1);
                  if (!keyPath.contains(PropertyGhcaUtil.copySuffix)) {
                     jsonKeySet.add(keyPath + ":" + jsonValueObj);
                  }
               }
            }
         }
      }

      return jsonKeySet;
   }

   public static Set getJsonKeySetIndex(Set jsonKeySet, String jsonStr, String parentKey) throws Exception {
      JSONObject jsonObject = JSONObject.fromObject(jsonStr);

      for(Object keyObj : jsonObject.keySet()) {
         String key = keyObj.toString();
         Object jsonValueObj = jsonObject.get(key);
         int flag = IsJsonArrayOrJsonObject(jsonValueObj);
         if (flag == 1) {
            if (!"".equals(parentKey)) {
               if (parentKey.endsWith(".")) {
                  key = parentKey + key + ".";
               } else {
                  key = parentKey + "." + key + ".";
               }
            }

            JSONObject nextLayerJsonObject = (JSONObject)jsonValueObj;
            getJsonKeySetIndex(jsonKeySet, nextLayerJsonObject.toString(), key);
         } else if (flag == 2) {
            if ("".equals(parentKey)) {
               key = key + ".";
            }

            JSONArray nextLayerJsonArray = (JSONArray)jsonValueObj;

            for(int i = 0; i < nextLayerJsonArray.size(); ++i) {
               JSONObject nextLayerJsonObject = (JSONObject)nextLayerJsonArray.get(i);
               getJsonKeySetIndex(jsonKeySet, nextLayerJsonObject.toString(), key);
            }
         } else if ("index".equalsIgnoreCase(key)) {
            String parentPath = "";
            String keyPath = "";
            if (!"".equals(parentKey)) {
               if (parentKey.endsWith(".")) {
                  (new StringBuilder()).append(parentKey).append(key).toString();
                  parentPath = parentKey.substring(0, parentKey.length() - 1);
               } else {
                  (new StringBuilder()).append(parentKey).append(".").append(key).toString();
                  parentPath = parentKey.substring(0, parentKey.lastIndexOf("."));
               }
            }

            parentPath = parentPath.substring(0, parentPath.lastIndexOf("."));
            if (parentPath.endsWith("properties.") || parentPath.endsWith("properties")) {
               keyPath = parentKey.substring(0, parentKey.length() - 1).replace(".mappings", "").replace(".properties", "");
               if (!keyPath.contains("match_all")) {
                  keyPath = keyPath.substring(keyPath.indexOf(".") + 1);
                  if (!keyPath.contains(PropertyGhcaUtil.copySuffix)) {
                     jsonKeySet.add(keyPath + ":" + jsonValueObj);
                  }
               }
            }
         }
      }

      return jsonKeySet;
   }

   public static Set getJsonKeySetIncludeCopyColumn(Set jsonKeySet, String jsonStr, String parentKey) throws Exception {
      JSONObject jsonObject = JSONObject.fromObject(jsonStr);

            for(Object keyObj : jsonObject.keySet()) {
         String key = keyObj.toString();
         Object jsonValueObj = jsonObject.get(key);
         int flag = IsJsonArrayOrJsonObject(jsonValueObj);
         if (flag == 1) {
            if (!"".equals(parentKey)) {
               if (parentKey.endsWith(".")) {
                  key = parentKey + key + ".";
               } else {
                  key = parentKey + "." + key + ".";
               }
            }

            JSONObject nextLayerJsonObject = (JSONObject)jsonValueObj;
            getJsonKeySetIncludeCopyColumn(jsonKeySet, nextLayerJsonObject.toString(), key);
         } else if (flag == 2) {
            if ("".equals(parentKey)) {
               key = key + ".";
            }

            JSONArray nextLayerJsonArray = (JSONArray)jsonValueObj;

            for(int i = 0; i < nextLayerJsonArray.size(); ++i) {
               JSONObject nextLayerJsonObject = (JSONObject)nextLayerJsonArray.get(i);
               getJsonKeySetIncludeCopyColumn(jsonKeySet, nextLayerJsonObject.toString(), key);
            }
         } else {
            String parentPath = "";
            String keyPath = "";
            if (!"".equals(parentKey)) {
               if (parentKey.endsWith(".")) {
                  (new StringBuilder()).append(parentKey).append(key).toString();
                  parentPath = parentKey.substring(0, parentKey.length() - 1);
               } else {
                  (new StringBuilder()).append(parentKey).append(".").append(key).toString();
                  parentPath = parentKey.substring(0, parentKey.lastIndexOf("."));
               }
            }

            parentPath = parentPath.substring(0, parentPath.lastIndexOf("."));
            if (parentPath.endsWith("properties.") || parentPath.endsWith("properties")) {
               keyPath = parentKey.substring(0, parentKey.length() - 1).replace(".mappings", "").replace(".properties", "");
               if (!keyPath.contains("match_all")) {
                  keyPath = keyPath.substring(keyPath.indexOf(".") + 1);
                  jsonKeySet.add(keyPath + ":" + jsonValueObj);
               }
            }
         }
      }

      return jsonKeySet;
   }

   public static void main(String[] args) {
      Set<String> jsonKeySet = new HashSet();
      String jsonStr = "{\"movies\":{\"mappings\":{\"movie\":{\"properties\":{\"director\":{\"type\":\"text\",\"fields\":{\"keyword\":{\"type\":\"keyword\",\"ignore_above\":256}}},\"genres\":{\"type\":\"text\",\"fields\":{\"keyword\":{\"type\":\"keyword\",\"ignore_above\":256}}},\"name\":{\"type\":\"text\",\"fields\":{\"keyword\":{\"type\":\"keyword\",\"ignore_above\":256}}},\"name_\":{\"type\":\"text\",\"fields\":{\"keyword\":{\"type\":\"keyword\",\"ignore_above\":256}}},\"name|\":{\"type\":\"text\",\"fields\":{\"keyword\":{\"type\":\"keyword\",\"ignore_above\":256}}},\"pserson\":{\"properties\":{\"age\":{\"type\":\"long\"},\"first\":{\"type\":\"text\",\"fields\":{\"keyword\":{\"type\":\"keyword\",\"ignore_above\":256}}},\"last\":{\"type\":\"text\",\"fields\":{\"keyword\":{\"type\":\"keyword\",\"ignore_above\":256}}},\"lastname\":{\"properties\":{\"add\":{\"type\":\"text\",\"fields\":{\"keyword\":{\"type\":\"keyword\",\"ignore_above\":256}}},\"iiiii\":{\"properties\":{\"faku\":{\"type\":\"text\",\"fields\":{\"keyword\":{\"type\":\"keyword\",\"ignore_above\":256}}}}}}}}},\"title\":{\"type\":\"text\",\"fields\":{\"keyword\":{\"type\":\"keyword\",\"ignore_above\":256}}},\"year\":{\"type\":\"long\"}}}}}}";
      Set<String> sortSet = new TreeSet<>((o1, o2) -> o1.compareTo(o2));

      try {
         getJsonKeySet(jsonKeySet, jsonStr, "");
         System.out.println(jsonKeySet.toString());
         sortSet.addAll(jsonKeySet);
         System.out.println(sortSet.toString());
      } catch (Exception e) {
         e.printStackTrace();
      }

      for(String k : sortSet) {
         System.out.println(k);
      }

   }

   public static int IsJsonArrayOrJsonObject(Object obj) {
      try {
         JSONObject nextLayerJsonObject = (JSONObject)obj;
         return 1;
      } catch (Exception var4) {
         try {
            JSONArray nextLayerJsonArray = (JSONArray)obj;
            return 2;
         } catch (Exception var3) {
            return 0;
         }
      }
   }

   public static String getJsonValueByKeyIgnoreCase(Set<String> jsonkeySet, String key, JSONObject currentJsonObject) throws Exception {
      String jsonValue = "";

      for(String jsonkey : jsonkeySet) {
         if (key.equalsIgnoreCase(jsonkey)) {
            jsonValue = currentJsonObject.getString(jsonkey);
            break;
         }
      }

      return jsonValue;
   }

   public static String getJsonOriginalKey(Set<String> jsonkeySet, String key) throws Exception {
      String originalKey = "";

      for(String jsonkey : jsonkeySet) {
         if (key.equalsIgnoreCase(jsonkey)) {
            originalKey = jsonkey;
            break;
         }
      }

      if ("".equals(originalKey)) {
         originalKey = key;
      }

      return originalKey;
   }

   public static void getJsonKeyList(List<ColumnInfo> jsonKeyList, String jsonStr, String parentKey) throws Exception {
      JSONObject jsonObject = JSONObject.fromObject(jsonStr);

            for(Object keyObj : jsonObject.keySet()) {
         String key = keyObj.toString();
         Object jsonValueObj = jsonObject.get(key);
         int flag = IsJsonArrayOrJsonObject(jsonValueObj);
         if (flag == 1) {
            if (!"".equals(parentKey)) {
               if (parentKey.endsWith(".")) {
                  key = parentKey + key + ".";
               } else {
                  key = parentKey + "." + key + ".";
               }
            }

            JSONObject nextLayerJsonObject = (JSONObject)jsonValueObj;
            getJsonKeyList(jsonKeyList, nextLayerJsonObject.toString(), key);
         } else if (flag == 2) {
            if ("".equals(parentKey)) {
               key = key + ".";
            }

            JSONArray nextLayerJsonArray = (JSONArray)jsonValueObj;

            for(int i = 0; i < nextLayerJsonArray.size(); ++i) {
               JSONObject nextLayerJsonObject = (JSONObject)nextLayerJsonArray.get(i);
               getJsonKeyList(jsonKeyList, nextLayerJsonObject.toString(), key);
            }
         } else {
            String parentPath = "";
            String keyPath = "";
            if (!"".equals(parentKey)) {
               if (parentKey.endsWith(".")) {
                  (new StringBuilder()).append(parentKey).append(key).toString();
                  parentPath = parentKey.substring(0, parentKey.length() - 1);
               } else {
                  (new StringBuilder()).append(parentKey).append(".").append(key).toString();
                  parentPath = parentKey.substring(0, parentKey.lastIndexOf("."));
               }
            }

            parentPath = parentPath.substring(0, parentPath.lastIndexOf("."));
            if (parentPath.endsWith("properties.") || parentPath.endsWith("properties")) {
               keyPath = parentKey.substring(0, parentKey.length() - 1).replace(".mappings", "").replace(".properties", "");
               if (!keyPath.contains("match_all")) {
                  keyPath = keyPath.substring(keyPath.indexOf(".") + 1);
                  ColumnInfo columnInfo = new ColumnInfo();
                  columnInfo.setColumnname(keyPath);
                  columnInfo.setTypename(jsonValueObj.toString());
                  jsonKeyList.add(columnInfo);
               }
            }
         }
      }

   }

   public static void getJsonTypeList(List<String> jsonKeyList, String jsonStr, String parentKey) throws Exception {
      JSONObject jsonObject = JSONObject.fromObject(jsonStr);

      for(Object keyObj : jsonObject.keySet()) {
         String key = keyObj.toString();
         Object jsonValueObj = jsonObject.get(key);
         int flag = IsJsonArrayOrJsonObject(jsonValueObj);
         if (flag == 1) {
            if (!"".equals(parentKey)) {
               if (parentKey.endsWith(".")) {
                  key = parentKey + key + ".";
               } else {
                  key = parentKey + "." + key + ".";
               }
            }

            String parentPath = "";
            if (!"".equals(key) && key.split("\\.").length > 1) {
               if (key.endsWith(".")) {
                  parentPath = key.substring(0, key.length() - 1);
               } else {
                  parentPath = key.substring(0, key.lastIndexOf("."));
               }

               parentPath = parentPath.substring(0, parentPath.lastIndexOf("."));
               if (parentPath.endsWith("mappings.") || parentPath.endsWith("mappings")) {
                  jsonKeyList.add(key.substring(0, key.length() - 1).split("\\.")[2]);
               }
            }

            JSONObject nextLayerJsonObject = (JSONObject)jsonValueObj;
            getJsonTypeList(jsonKeyList, nextLayerJsonObject.toString(), key);
         } else if (flag == 2) {
            if ("".equals(parentKey)) {
               key = key + ".";
            }

            JSONArray nextLayerJsonArray = (JSONArray)jsonValueObj;

            for(int i = 0; i < nextLayerJsonArray.size(); ++i) {
               JSONObject nextLayerJsonObject = (JSONObject)nextLayerJsonArray.get(i);
               getJsonTypeList(jsonKeyList, nextLayerJsonObject.toString(), key);
            }
         } else if (!"".equals(parentKey)) {
            if (parentKey.endsWith(".")) {
               (new StringBuilder()).append(parentKey).append(key).toString();
            } else {
               (new StringBuilder()).append(parentKey).append(".").append(key).toString();
            }
         }
      }

   }
}
