package com.chenyang.nse.bussiness.tools.xml;

import com.chenyang.nse.bussiness.entity.orm.table.core.TXmlProperties;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class PropertiesTool extends Thread {
   private static Properties properties;
   private static final String propertiesUrl = Thread.currentThread().getContextClassLoader().getResource("").toString().replace("file:/", "") + "config.properties";
   private static String propertiesName;

   public static void load() throws IOException {
      properties = new Properties();
      FileInputStream fis = new FileInputStream(propertiesUrl);
      Throwable var1 = null;

      try {
         properties.load(fis);
      } catch (Throwable var10) {
         var1 = var10;
         throw var10;
      } finally {
         if (fis != null) {
            if (var1 != null) {
               try {
                  fis.close();
               } catch (Throwable var9) {
                  var1.addSuppressed(var9);
               }
            } else {
               fis.close();
            }
         }

      }

   }

   public static Boolean optionProperty(String key, String value) {
      try {
         FileOutputStream fos = new FileOutputStream(propertiesUrl);
         Throwable var3 = null;

         try {
            if (properties == null) {
               load();
            }

            properties.setProperty(key, value);
            properties.store(fos, "Copyright (c) Boxcode Studio");
         } catch (Throwable var13) {
            var3 = var13;
            throw var13;
         } finally {
            if (fos != null) {
               if (var3 != null) {
                  try {
                     fos.close();
                  } catch (Throwable var12) {
                     var3.addSuppressed(var12);
                  }
               } else {
                  fos.close();
               }
            }

         }
      } catch (IOException var15) {
         System.out.println(propertiesName + " load failed");
         return false;
      }

      return true;
   }

   public static Boolean delProperty(String key) {
      try {
         FileOutputStream fos = new FileOutputStream(propertiesUrl);
         Throwable var2 = null;

         try {
            if (properties == null) {
               load();
            }

            properties.remove(key);
            properties.store(fos, "Copyright (c) Boxcode Studio");
         } catch (Throwable var12) {
            var2 = var12;
            throw var12;
         } finally {
            if (fos != null) {
               if (var2 != null) {
                  try {
                     fos.close();
                  } catch (Throwable var11) {
                     var2.addSuppressed(var11);
                  }
               } else {
                  fos.close();
               }
            }

         }
      } catch (IOException var14) {
         System.out.println(propertiesName + " load failed");
         return false;
      }

      return true;
   }

   public static Boolean updateProperty(String key, String value) {
      if (getProperty(key) == null) {
         System.out.println(propertiesName + " does not have this key");
         return false;
      } else {
         return optionProperty(key, value);
      }
   }

   public static void addProperty(String key, String value) {
      if (getProperty(key) != null) {
         delProperty(key);
      }

      optionProperty(key, value);
   }

   public static String getProperty(String key) {
      try {
         FileInputStream fis = new FileInputStream(propertiesUrl);
         Throwable var2 = null;

         try {
            if (properties == null) {
               load();
            }

            properties.load(fis);
         } catch (Throwable var12) {
            var2 = var12;
            throw var12;
         } finally {
            if (fis != null) {
               if (var2 != null) {
                  try {
                     fis.close();
                  } catch (Throwable var11) {
                     var2.addSuppressed(var11);
                  }
               } else {
                  fis.close();
               }
            }

         }
      } catch (IOException var14) {
         System.out.println(propertiesName + " load failed");
         return null;
      }

      return properties.getProperty(key);
   }

   public static List<TXmlProperties> getAllProperty() {
      List<TXmlProperties> list = new ArrayList();
      if (properties == null) {
         try {
            load();
         } catch (IOException e) {
            e.printStackTrace();
         }
      }

      for(Map.Entry e : properties.entrySet()) {
         TXmlProperties p = new TXmlProperties();
         p.setPkey(e.getKey().toString());
         p.setPvalue(e.getValue().toString());
         list.add(p);
      }

      return list;
   }

   public static boolean hasKey(String key) {
      List<String> list = new ArrayList();
      if (properties == null) {
         try {
            load();
         } catch (IOException e) {
            e.printStackTrace();
         }
      }

      for(Map.Entry e : properties.entrySet()) {
         list.add(e.getKey().toString());
      }

      return list.contains(key);
   }

   public static void main(String[] args) {
      String a = Thread.currentThread().getContextClassLoader().getResource("").toString().replace("file:/", "") + "config.properties";
      System.out.println(a.replace("file:/", "") + "config.properties");
      addProperty("tsh", "\n\t");
   }

   static {
      String[] urlArr = propertiesUrl.split("/");
      propertiesName = urlArr[urlArr.length - 1];
   }
}
