package com.chenyang.nse.bussiness.webtools.tools.ip;

import eu.bitwalker.useragentutils.UserAgent;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import org.springframework.util.StringUtils;

public class IpUtil {
   public static String getClientRealIp(HttpServletRequest request) {
      String ipAddress = request.getHeader("x-forwarded-for");
      if (ipAddress == null || ipAddress.length() == 0 || "unknown".equalsIgnoreCase(ipAddress)) {
         ipAddress = request.getHeader("Proxy-Client-IP");
      }

      if (ipAddress == null || ipAddress.length() == 0 || "unknown".equalsIgnoreCase(ipAddress)) {
         ipAddress = request.getHeader("WL-Proxy-Client-IP");
      }

      if (ipAddress == null || ipAddress.length() == 0 || "unknown".equalsIgnoreCase(ipAddress)) {
         ipAddress = request.getRemoteAddr();
         if (ipAddress.equals("127.0.0.1") || ipAddress.equals("0:0:0:0:0:0:0:1")) {
            InetAddress inet = null;

            try {
               inet = InetAddress.getLocalHost();
            } catch (UnknownHostException e) {
               e.printStackTrace();
            }

            ipAddress = inet.getHostAddress();
         }
      }

      if (ipAddress != null && ipAddress.length() > 15 && ipAddress.indexOf(",") > 0) {
         ipAddress = ipAddress.substring(0, ipAddress.indexOf(","));
      }

      return ipAddress;
   }

   public static String getOuterNetIp(HttpServletRequest request) {
      String result = "";
      BufferedReader in = null;

      try {
         URL url = new URL("http://www.icanhazip.com");
         URLConnection connection = url.openConnection();
         connection.setRequestProperty("accept", "*/*");
         connection.setRequestProperty("connection", "KeepAlive");
         connection.setRequestProperty("user-agent", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1;SV1)");
         connection.setConnectTimeout(3000);
         connection.setReadTimeout(3000);
         connection.connect();

         String line;
         for(in = new BufferedReader(new InputStreamReader(connection.getInputStream())); (line = in.readLine()) != null; result = result + line) {
         }
      } catch (Exception e) {
         e.printStackTrace();
      } finally {
         try {
            if (in != null) {
               in.close();
            }
         } catch (IOException e) {
            e.getMessage();
         }

      }

      return result;
   }

   public static String getClientHostName(HttpServletRequest request) {
      return request.getRemoteHost();
   }

   public static String getClientBrowserName(HttpServletRequest request) {
      UserAgent userAgent = UserAgent.parseUserAgentString(request.getHeader("User-Agent"));
      String os = userAgent.getOperatingSystem().getName();
      String browser = userAgent.getBrowser().getName();
      return browser;
   }

   public static String getUserAgent(HttpServletRequest request) {
      String agent = request.getHeader("User-Agent");
      if (StringUtils.hasText(agent)) {
         StringTokenizer st = new StringTokenizer(agent, ";");
         String browser = st.nextToken();
         if (browser != null && browser.length() > 20) {
            browser = browser.substring(0, 20);
         }

         return browser;
      } else {
         return null;
      }
   }
}
